// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_button/cr_button.js";import"//resources/cr_elements/cr_checkbox/cr_checkbox.js";import"//resources/cr_elements/cr_collapse/cr_collapse.js";import"//resources/cr_elements/cr_expand_button/cr_expand_button.js";import"//resources/cr_elements/cr_input/cr_input.js";import"//resources/cr_elements/cr_textarea/cr_textarea.js";import"/strings.m.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{BrowserProxy}from"./browser_proxy.js";import{LoadModelResult,OnDeviceModelRemote,PerformanceClass,SessionRemote,StreamingResponderCallbackRouter,Token}from"./on_device_model.mojom-webui.js";import{ModelPerformanceHint}from"./on_device_model_service.mojom-webui.js";import{getCss}from"./tools.css.js";import{getHtml}from"./tools.html.js";function getPerformanceClassText(performanceClass){switch(performanceClass){case PerformanceClass.kVeryLow:return"Very Low";case PerformanceClass.kLow:return"Low";case PerformanceClass.kMedium:return"Medium";case PerformanceClass.kHigh:return"High";case PerformanceClass.kVeryHigh:return"Very High";case PerformanceClass.kGpuBlocked:return"GPU blocked";case PerformanceClass.kFailedToLoadLibrary:return"Failed to load native library";default:return"Error"}}function textToInputPieces(text){const input=[];for(const piece of text.split("\n")){if(piece==="$SYSTEM"){input.push({token:Token.kSystem})}else if(piece==="$MODEL"){input.push({token:Token.kModel})}else if(piece==="$USER"){input.push({token:Token.kUser})}else if(piece==="$END"){input.push({token:Token.kEnd})}else if(input.length===0||input[input.length-1].text===undefined){input.push({text:piece})}else{input[input.length-1].text+="\n"+piece}}return input}function filePathToString(filePath){if(typeof filePath.path==="string"){return filePath.path}const decoder=new TextDecoder("utf-16");const buffer=new Uint16Array(filePath.path);return decoder.decode(buffer)}class OnDeviceInternalsToolsElement extends CrLitElement{static get is(){return"on-device-internals-tools"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{modelPath_:{type:String},error_:{type:String},imageError_:{type:String},text_:{type:String},loadModelStart_:{type:Number},currentResponse_:{type:Object},responses_:{type:Array},model_:{type:Object},performanceClassText_:{type:String},usePlatformModel_:{type:Boolean},contextExpanded_:{type:Boolean},contextLength_:{type:Number},contextText_:{type:String},topK_:{type:Number},temperature_:{type:Number},imageFile_:{type:Object},audioFile_:{type:Object},audioError_:{type:String},performanceHint_:{type:String},loadedPerformanceHint_:{type:Number}}}capabilities_={imageInput:false,audioInput:false};#contextExpanded__accessor_storage=false;get contextExpanded_(){return this.#contextExpanded__accessor_storage}set contextExpanded_(value){this.#contextExpanded__accessor_storage=value}#contextLength__accessor_storage=0;get contextLength_(){return this.#contextLength__accessor_storage}set contextLength_(value){this.#contextLength__accessor_storage=value}#contextText__accessor_storage="";get contextText_(){return this.#contextText__accessor_storage}set contextText_(value){this.#contextText__accessor_storage=value}#currentResponse__accessor_storage=null;get currentResponse_(){return this.#currentResponse__accessor_storage}set currentResponse_(value){this.#currentResponse__accessor_storage=value}#error__accessor_storage="";get error_(){return this.#error__accessor_storage}set error_(value){this.#error__accessor_storage=value}#imageError__accessor_storage="";get imageError_(){return this.#imageError__accessor_storage}set imageError_(value){this.#imageError__accessor_storage=value}loadModelDuration_=-1;#loadModelStart__accessor_storage=0;get loadModelStart_(){return this.#loadModelStart__accessor_storage}set loadModelStart_(value){this.#loadModelStart__accessor_storage=value}#modelPath__accessor_storage="";get modelPath_(){return this.#modelPath__accessor_storage}set modelPath_(value){this.#modelPath__accessor_storage=value}#model__accessor_storage=null;get model_(){return this.#model__accessor_storage}set model_(value){this.#model__accessor_storage=value}#performanceClassText__accessor_storage="Loading...";get performanceClassText_(){return this.#performanceClassText__accessor_storage}set performanceClassText_(value){this.#performanceClassText__accessor_storage=value}showPlatformModelCheckbox_=loadTimeData.getBoolean("useChromeOSModelService");#usePlatformModel__accessor_storage=false;get usePlatformModel_(){return this.#usePlatformModel__accessor_storage}set usePlatformModel_(value){this.#usePlatformModel__accessor_storage=value}#responses__accessor_storage=[];get responses_(){return this.#responses__accessor_storage}set responses_(value){this.#responses__accessor_storage=value}#temperature__accessor_storage=0;get temperature_(){return this.#temperature__accessor_storage}set temperature_(value){this.#temperature__accessor_storage=value}#text__accessor_storage="";get text_(){return this.#text__accessor_storage}set text_(value){this.#text__accessor_storage=value}#topK__accessor_storage=1;get topK_(){return this.#topK__accessor_storage}set topK_(value){this.#topK__accessor_storage=value}#imageFile__accessor_storage=null;get imageFile_(){return this.#imageFile__accessor_storage}set imageFile_(value){this.#imageFile__accessor_storage=value}#audioFile__accessor_storage=null;get audioFile_(){return this.#audioFile__accessor_storage}set audioFile_(value){this.#audioFile__accessor_storage=value}#audioError__accessor_storage="";get audioError_(){return this.#audioError__accessor_storage}set audioError_(value){this.#audioError__accessor_storage=value}#performanceHint__accessor_storage="kHighestQuality";get performanceHint_(){return this.#performanceHint__accessor_storage}set performanceHint_(value){this.#performanceHint__accessor_storage=value}#loadedPerformanceHint__accessor_storage=null;get loadedPerformanceHint_(){return this.#loadedPerformanceHint__accessor_storage}set loadedPerformanceHint_(value){this.#loadedPerformanceHint__accessor_storage=value}session_=null;proxy_=BrowserProxy.getInstance();responseRouter_=new StreamingResponderCallbackRouter;firstUpdated(){this.getPerformanceClass_();this.$.temperatureInput.inputElement.step="0.1";this.$.imageInput.addEventListener("change",this.onImageChange_.bind(this));this.$.audioInput.addEventListener("change",this.onAudioChange_.bind(this))}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("model_")||changedPrivateProperties.has("error_")){this.onModelOrErrorChanged_()}}async getPerformanceClass_(){this.performanceClassText_=getPerformanceClassText((await this.proxy_.handler.getDeviceAndPerformanceInfo()).performanceInfo.performanceClass)}onModelOrErrorChanged_(){if(this.model_!==null){this.loadModelDuration_=(new Date).getTime()-this.loadModelStart_;this.$.textInput.focus()}this.loadModelStart_=0}onLoadClick_(){const modelPathString=this.$.modelInput.value;const processedPath=modelPathString;this.onModelSelected_({path:processedPath})}async onLoadDefaultClick_(){const defaultModelPath=await this.proxy_.handler.getDefaultModelPath();if(defaultModelPath.modelPath===null){this.error_="Unable to get default model path.";return}this.onModelSelected_(defaultModelPath.modelPath)}onAddImageClick_(){this.$.imageInput.click()}onAddAudioClick_(){this.$.audioInput.click()}onRemoteImageClick_(){this.imageFile_=null;this.$.imageInput.value=""}onRemoteAudioClick_(){this.audioFile_=null;this.$.audioInput.value=""}onPerformanceHintChange_(){this.performanceHint_=this.$.performanceHintSelect.value}onServiceCrashed_(){if(this.currentResponse_){this.currentResponse_.error=true;this.addResponse_()}this.error_="Service crashed, please reload the model.";this.model_=null;this.modelPath_="";this.loadModelStart_=0;this.$.modelInput.focus()}onImageChange_(){this.imageError_="";if((this.$.imageInput.files?.length??0)>0){this.imageFile_=this.$.imageInput.files.item(0)??null}else{this.imageFile_=null}}onAudioChange_(){this.audioError_="";if((this.$.audioInput.files?.length??0)>0){this.audioFile_=this.$.audioInput.files.item(0)??null}else{this.audioFile_=null}}async onModelSelected_(modelPath){this.error_="";if(this.model_){this.model_.$.close()}if(this.model_){this.model_.$.close()}this.imageFile_=null;this.audioFile_=null;this.model_=null;this.capabilities_={imageInput:false,audioInput:false};this.loadModelStart_=(new Date).getTime();const performanceHint=ModelPerformanceHint[this.performanceHint_];const newModel=new OnDeviceModelRemote;let result;let capabilities;if(this.usePlatformModel_){const loadedData=await this.proxy_.handler.loadPlatformModel(modelPath,newModel.$.bindNewPipeAndPassReceiver());result=loadedData.result;capabilities={imageInput:false,audioInput:false}}else{const loadedData=await this.proxy_.handler.loadModel(modelPath,performanceHint,newModel.$.bindNewPipeAndPassReceiver());result=loadedData.result;capabilities=loadedData.capabilities}if(result!==LoadModelResult.kSuccess){this.error_="Unable to load model. Specify a correct and absolute path."}else{this.model_=newModel;this.capabilities_=capabilities;this.model_.onConnectionError.addListener((()=>{this.onServiceCrashed_()}));this.startNewSession_();this.modelPath_=filePathToString(modelPath);this.loadedPerformanceHint_=performanceHint}}onAddContextClick_(){if(this.session_===null){return}this.session_.append({maxTokens:0,input:{pieces:textToInputPieces(this.contextText_)}},null);this.contextLength_+=this.contextText_.split(/(\s+)/).length;this.contextText_=""}startNewSession_(){if(this.model_===null){return}this.contextLength_=0;this.session_=new SessionRemote;this.model_.startSession(this.session_.$.bindNewPipeAndPassReceiver(),{maxTokens:0,topK:this.topK_,temperature:this.temperature_,capabilities:{imageInput:this.imagesEnabled_(),audioInput:this.audioEnabled_()}})}onCancelClick_(){this.responseRouter_.$.close();this.responseRouter_=new StreamingResponderCallbackRouter;this.addResponse_()}onExecuteClick_(){this.onExecute_()}async addResponse_(){assert(this.currentResponse_);this.responses_.unshift(this.currentResponse_);this.currentResponse_=null;this.requestUpdate();await this.updateComplete;this.$.textInput.focus()}async decodeBitmap_(){const data=new Uint8Array(await this.imageFile_.arrayBuffer());if(data.byteLength<=0){return null}const handle=Mojo.createSharedBuffer(data.byteLength).handle;const buffer=new Uint8Array(handle.mapBuffer(0,data.byteLength).buffer);buffer.set(data);const bigBuffer={sharedMemory:{bufferHandle:handle,size:data.byteLength},bytes:undefined,invalidBuffer:undefined};delete bigBuffer.invalidBuffer;delete bigBuffer.bytes;const{bitmap:bitmap}=await this.proxy_.handler.decodeBitmap(bigBuffer);return bitmap}async decodeAudio_(){const audioCtx=new AudioContext({sampleRate:48e3});const arrayBuffer=await this.audioFile_.arrayBuffer();const buffer=await audioCtx.decodeAudioData(arrayBuffer);if(buffer.numberOfChannels>1){throw new Error("Multichannel audio is not supported")}return{sampleRate:buffer.sampleRate,channelCount:buffer.numberOfChannels,frameCount:buffer.length,data:Array.from(buffer.getChannelData(0))}}async onExecute_(){this.imageError_="";if(this.session_===null){return}if(!this.$.topKInput.validate()){return}if(!this.$.temperatureInput.validate()){return}const pieces=textToInputPieces(this.text_);if(this.imageFile_!==null){const bitmap=await this.decodeBitmap_();if(bitmap){pieces.unshift({bitmap:bitmap})}else{this.imageFile_=null;this.imageError_="Image is invalid";return}}if(this.audioFile_!==null){try{const audio=await this.decodeAudio_();pieces.unshift({audio:audio})}catch(error){this.audioFile_=null;this.audioError_=`Audio is invalid: ${error}`;return}}const clonedSession=new SessionRemote;this.session_.clone(clonedSession.$.bindNewPipeAndPassReceiver());clonedSession.append({maxTokens:0,input:{pieces:pieces}},null);clonedSession.generate({maxOutputTokens:0,constraint:null},this.responseRouter_.$.bindNewPipeAndPassRemote());const onResponseId=this.responseRouter_.onResponse.addListener((chunk=>{assert(this.currentResponse_);this.currentResponse_.response=(this.currentResponse_?.response+chunk.text).trimStart();this.requestUpdate()}));const onCompleteId=this.responseRouter_.onComplete.addListener((_=>{this.addResponse_();this.responseRouter_.removeListener(onResponseId);this.responseRouter_.removeListener(onCompleteId)}));this.currentResponse_={text:this.text_,response:"",responseClass:"response",retracted:false,error:false};this.text_=""}canEnterInput_(){return!this.currentResponse_&&this.model_!==null}canExecute_(){return this.canEnterInput_()&&this.text_.length>0}canUploadFile_(){return this.canEnterInput_()&&this.imageFile_===null}isLoading_(){return this.loadModelStart_!==0}imagesEnabled_(){return this.capabilities_.imageInput}audioEnabled_(){return this.capabilities_.audioInput}getModelText_(){if(this.modelPath_.length===0){return""}let text="Model loaded from "+this.modelPath_+" in "+this.loadModelDuration_+"ms ";if(this.imagesEnabled_()){text+="[images enabled]"}if(this.audioEnabled_()){text+="[audio enabled]"}if(this.loadedPerformanceHint_===ModelPerformanceHint.kFastestInference){text+="[fastest inference]"}return text}onContextExpandedChanged_(e){this.contextExpanded_=e.detail.value}onContextTextChanged_(e){this.contextText_=e.detail.value}onTextChanged_(e){this.text_=e.detail.value}onTopKChanged_(e){this.topK_=e.detail.value}onTemperatureChanged_(e){this.temperature_=e.detail.value}onUsePlatformModelChanged_(e){this.usePlatformModel_=e.detail.value}}customElements.define(OnDeviceInternalsToolsElement.is,OnDeviceInternalsToolsElement);