// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxy}from"./browser_proxy.js";import{getCss}from"./event_log.css.js";import{getHtml}from"./event_log.html.js";function convertMojoTimeToJs(mojoTime){const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaInMs=unixEpoch-windowsEpoch;const timeInMs=Number(mojoTime.internalValue)/1e3;return new Date(timeInMs-epochDeltaInMs)}export class EventLogMessage{eventTime;sourceLinkText="";sourceLinkURL="";message;constructor(eventTime,sourceFile,sourceLine,message){this.eventTime=convertMojoTimeToJs(eventTime);this.message=message;this.setSourceLink(sourceFile,sourceLine)}setSourceLink(sourceFile,sourceLine){if(!sourceFile.startsWith("../../")){this.sourceLinkText=`${sourceFile}(${sourceLine})`;return}const fileName=sourceFile.slice(sourceFile.lastIndexOf("/")+1);if(fileName.length===0){this.sourceLinkText=`${sourceFile}(${sourceLine})`;return}this.sourceLinkText=`${fileName}(${sourceLine})`;this.sourceLinkURL=`https://source.chromium.org/chromium/chromium/src/+/main:${sourceFile.slice(6)};l=${sourceLine}`}toLogDump(){return`${this.eventTime}  ${this.sourceLinkText} ${this.message}`}}export class OnDeviceInternalsEventLogElement extends CrLitElement{static get is(){return"on-device-internals-event-log"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{eventLogMessages_:{type:Array}}}#eventLogMessages__accessor_storage=[];get eventLogMessages_(){return this.#eventLogMessages__accessor_storage}set eventLogMessages_(value){this.#eventLogMessages__accessor_storage=value}connectedCallback(){super.connectedCallback();BrowserProxy.getInstance().callbackRouter.onLogMessageAdded.addListener(this.onLogMessageAdded_.bind(this))}onEventLogsDumpClick_(){const data=this.eventLogMessages_.map((message=>message.toLogDump())).join("\r\n");const blob=new Blob([data],{type:"text/json"});const url=URL.createObjectURL(blob);const filename="optimization_guide_internals_logs_dump.json";const a=document.createElement("a");a.setAttribute("href",url);a.setAttribute("download",filename);const event=new MouseEvent("click",{bubbles:true,cancelable:true,view:window});a.dispatchEvent(event)}onLogMessageAdded_(eventTime,sourceFile,sourceLine,message){this.eventLogMessages_.push(new EventLogMessage(eventTime,sourceFile,sourceLine,message));this.requestUpdate()}}customElements.define(OnDeviceInternalsEventLogElement.is,OnDeviceInternalsEventLogElement);