import '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import '//resources/cr_components/searchbox/searchbox_dropdown.js';
import '//resources/cr_elements/icons.html.js';
import '/strings.m.js';
import type { ContextualEntrypointAndCarouselElement } from '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import type { SearchboxDropdownElement } from '//resources/cr_components/searchbox/searchbox_dropdown.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteResult } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
export interface OmniboxPopupAppElement {
    $: {
        matches: SearchboxDropdownElement;
        context: ContextualEntrypointAndCarouselElement;
    };
}
declare const OmniboxPopupAppElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class OmniboxPopupAppElement extends OmniboxPopupAppElement_base {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * Whether the secondary side can be shown based on the feature state and
         * the width available to the dropdown.
         */
        canShowSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        hasSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether the app is in debug mode.
         */
        isDebug: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether matches are visible, as some may be hidden by filtering rules
         * (e.g., Gemini suggestions).
         */
        hasVisibleMatches_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isInKeywordMode_: {
            type: BooleanConstructor;
        };
        result_: {
            type: ObjectConstructor;
        };
        searchboxLayoutMode_: {
            type: StringConstructor;
        };
        showContextEntrypoint_: {
            type: BooleanConstructor;
        };
    };
    accessor canShowSecondarySide: boolean;
    accessor hasSecondarySide: boolean;
    accessor isDebug: boolean;
    protected accessor isInKeywordMode_: boolean;
    protected accessor hasVisibleMatches_: boolean;
    protected accessor result_: AutocompleteResult | null;
    protected accessor searchboxLayoutMode_: string;
    protected accessor showContextEntrypoint_: boolean;
    private callbackRouter_;
    private eventTracker_;
    private listenerIds_;
    private pageHandler_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    private computeShowContextEntrypoint_;
    private onCanShowSecondarySideChanged_;
    private onAutocompleteResultChanged_;
    private onShow_;
    protected onResultRepaint_(): void;
    private onUpdateSelection_;
    protected onHasSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onContextualEntryPointClicked_(e: CustomEvent<{
        x: number;
        y: number;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'omnibox-popup-app': OmniboxPopupAppElement;
    }
}
export {};
