// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { recordEnumeration } from '../../metrics_utils.js';
// Microseconds between windows and unix epoch.
const kWindowsToUnixEpochOffset = 11644473600000000n;
/**
 * Calendar actions. This enum must match the numbering for
 * NTPCalendarAction in enums.xml. These values are persisted
 * to logs. Entries should not be renumbered, removed or reused.
 *
 * MAX_VALUE should always be at the end to help get the current number of
 * buckets.
 */
export var CalendarAction;
(function (CalendarAction) {
    CalendarAction[CalendarAction["EXPANDED_EVENT_HEADER_CLICKED"] = 0] = "EXPANDED_EVENT_HEADER_CLICKED";
    CalendarAction[CalendarAction["DOUBLE_BOOKED_EVENT_HEADER_CLICKED"] = 1] = "DOUBLE_BOOKED_EVENT_HEADER_CLICKED";
    CalendarAction[CalendarAction["BASIC_EVENT_HEADER_CLICKED"] = 2] = "BASIC_EVENT_HEADER_CLICKED";
    CalendarAction[CalendarAction["ATTACHMENT_CLICKED"] = 3] = "ATTACHMENT_CLICKED";
    CalendarAction[CalendarAction["CONFERENCE_CALL_CLICKED"] = 4] = "CONFERENCE_CALL_CLICKED";
    CalendarAction[CalendarAction["SEE_MORE_CLICKED"] = 5] = "SEE_MORE_CLICKED";
    CalendarAction[CalendarAction["MAX_VALUE"] = 5] = "MAX_VALUE";
})(CalendarAction || (CalendarAction = {}));
export function recordCalendarAction(action, moduleName) {
    recordEnumeration(`NewTabPage.${moduleName}.UserAction`, action, CalendarAction.MAX_VALUE + 1);
}
export function toJsTimestamp(time) {
    return Number((time.internalValue - kWindowsToUnixEpochOffset) / 1000n);
}
