import './action_chips/action_chips.js';
import './iframe.js';
import './logo.js';
import '/strings.m.js';
import 'chrome://new-tab-page/shared/customize_buttons/customize_buttons.js';
import 'chrome://resources/cr_components/searchbox/searchbox.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_components/composebox/composebox.js';
import type { CustomizeButtonsElement } from 'chrome://new-tab-page/shared/customize_buttons/customize_buttons.js';
import type { ContextualUpload } from 'chrome://resources/cr_components/composebox/common.js';
import type { ComposeboxElement } from 'chrome://resources/cr_components/composebox/composebox.js';
import { ComposeboxMode } from 'chrome://resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import type { SearchboxElement } from 'chrome://resources/cr_components/searchbox/searchbox.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { SkColor } from 'chrome://resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import type { LogoElement } from './logo.js';
import type { Theme } from './new_tab_page.mojom-webui.js';
/**
 * Elements on the NTP. This enum must match the numbering for NTPElement in
 * enums.xml. These values are persisted to logs. Entries should not be
 * renumbered, removed or reused.
 */
export declare enum NtpElement {
    OTHER = 0,
    BACKGROUND = 1,
    ONE_GOOGLE_BAR = 2,
    LOGO = 3,
    REALBOX = 4,
    MOST_VISITED = 5,
    MIDDLE_SLOT_PROMO = 6,
    MODULE = 7,
    CUSTOMIZE = 8,// Obsolete
    CUSTOMIZE_BUTTON = 9,
    CUSTOMIZE_DIALOG = 10,// Obsolete
    WALLPAPER_SEARCH_BUTTON = 11,
    ACTION_CHIPS = 12,
    MAX_VALUE = 12
}
/**
 * Customize Chrome entry points. This enum must match the numbering for
 * NtpCustomizeChromeEntryPoint in enums.xml. These values are persisted to
 * logs. Entries should not be renumbered, removed or reused.
 */
export declare enum NtpCustomizeChromeEntryPoint {
    CUSTOMIZE_BUTTON = 0,
    MODULE = 1,
    URL = 2,
    WALLPAPER_SEARCH_BUTTON = 3,
    MAX_VALUE = 3
}
export declare const CUSTOMIZE_CHROME_BUTTON_ELEMENT_ID = "CustomizeButtonsHandler::kCustomizeChromeButtonElementId";
declare const AppElementBase: typeof CrLitElement & (new (...args: any[]) => import("chrome://resources/cr_components/help_bubble/help_bubble_mixin_lit.js").HelpBubbleMixinLitInterface);
export interface AppElement {
    $: {
        customizeButtons: CustomizeButtonsElement;
        oneGoogleBarClipPath: HTMLElement;
        logo: LogoElement;
        searchbox: SearchboxElement;
        composebox: ComposeboxElement;
    };
}
export declare class AppElement extends AppElementBase {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        oneGoogleBarIframeOrigin_: {
            type: StringConstructor;
        };
        oneGoogleBarIframePath_: {
            type: StringConstructor;
        };
        oneGoogleBarLoaded_: {
            type: BooleanConstructor;
        };
        theme_: {
            type: ObjectConstructor;
        };
        showCustomize_: {
            type: BooleanConstructor;
        };
        showCustomizeChromeText_: {
            type: BooleanConstructor;
        };
        showWallpaperSearch_: {
            type: BooleanConstructor;
        };
        isActionChipsVisible_: {
            type: BooleanConstructor;
        };
        isFooterVisible_: {
            type: BooleanConstructor;
        };
        selectedCustomizeDialogPage_: {
            type: StringConstructor;
        };
        showVoiceSearchOverlay_: {
            type: BooleanConstructor;
        };
        showBackgroundImage_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        backgroundImageAttribution1_: {
            type: StringConstructor;
        };
        backgroundImageAttribution2_: {
            type: StringConstructor;
        };
        backgroundImageAttributionUrl_: {
            type: StringConstructor;
        };
        colorSourceIsBaseline: {
            type: BooleanConstructor;
        };
        logoColor_: {
            type: StringConstructor;
        };
        singleColoredLogo_: {
            type: BooleanConstructor;
        };
        /**
         * Whether the secondary side can be shown based on the feature state and
         * the width available to the dropdown for the ntp searchbox.
         */
        realboxCanShowSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether the searchbox secondary side was at any point available to
         * be shown.
         */
        realboxHadSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
            notify: boolean;
        };
        composeboxCloseByClickOutside_: {
            type: BooleanConstructor;
        };
        composeboxEnabled: {
            type: BooleanConstructor;
        };
        composeButtonEnabled: {
            type: BooleanConstructor;
        };
        browserPromoType_: {
            type: StringConstructor;
        };
        browserPromoLimit_: {
            type: NumberConstructor;
        };
        browserPromoCompletedLimit_: {
            type: NumberConstructor;
        };
        showBrowserPromo_: {
            type: BooleanConstructor;
        };
        realboxShown_: {
            type: BooleanConstructor;
        };
        logoEnabled_: {
            type: BooleanConstructor;
        };
        oneGoogleBarEnabled_: {
            type: BooleanConstructor;
        };
        shortcutsEnabled_: {
            type: BooleanConstructor;
        };
        middleSlotPromoEnabled_: {
            type: BooleanConstructor;
        };
        modulesEnabled_: {
            type: BooleanConstructor;
        };
        middleSlotPromoLoaded_: {
            type: BooleanConstructor;
        };
        modulesLoadedStatus_: {
            type: NumberConstructor;
            reflect: boolean;
        };
        modulesShownToUser: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        microsoftModuleEnabled_: {
            type: BooleanConstructor;
        };
        microsoftAuthIframePath_: {
            type: StringConstructor;
        };
        ntpRealboxNextEnabled_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * In order to avoid flicker, the promo and modules are hidden until both
         * are loaded. If modules are disabled, the promo is shown as soon as it
         * is loaded.
         */
        promoAndModulesLoaded_: {
            type: BooleanConstructor;
        };
        realboxLayoutMode_: {
            type: StringConstructor;
            reflect: boolean;
        };
        searchboxCyclingPlaceholders_: {
            type: BooleanConstructor;
        };
        showComposebox_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        showLensUploadDialog_: {
            type: BooleanConstructor;
        };
        /**
         * If true, renders additional elements that were not deemed crucial to
         * to show up immediately on load.
         */
        lazyRender_: {
            type: BooleanConstructor;
        };
        scrolledToTop_: {
            type: BooleanConstructor;
        };
        wallpaperSearchButtonAnimationEnabled_: {
            type: BooleanConstructor;
        };
        wallpaperSearchButtonEnabled_: {
            type: BooleanConstructor;
        };
        showWallpaperSearchButton_: {
            type: BooleanConstructor;
        };
        /**
         * Whether the composebox has been opened at least once.
         */
        wasComposeboxOpened_: {
            type: BooleanConstructor;
        };
        ntpNextFeaturesEnabled_: {
            type: BooleanConstructor;
        };
        maxTilesBeforeShowMore_: {
            type: NumberConstructor;
        };
        searchboxInputFocused_: {
            type: BooleanConstructor;
        };
        composeboxInputFocused_: {
            type: BooleanConstructor;
        };
        /**
         * Whether the scrim is shown in Realbox Next.
         */
        showScrim_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    protected accessor oneGoogleBarIframeOrigin_: string;
    protected accessor oneGoogleBarIframePath_: string | undefined;
    protected accessor oneGoogleBarLoaded_: boolean;
    protected accessor theme_: Theme | null;
    protected accessor showCustomize_: boolean;
    protected accessor showCustomizeChromeText_: boolean;
    protected accessor showWallpaperSearch_: boolean;
    private accessor selectedCustomizeDialogPage_;
    protected accessor showVoiceSearchOverlay_: boolean;
    protected accessor showBackgroundImage_: boolean;
    protected accessor backgroundImageAttribution1_: string;
    protected accessor backgroundImageAttribution2_: string;
    protected accessor backgroundImageAttributionUrl_: string;
    protected accessor colorSourceIsBaseline: boolean;
    protected accessor logoColor_: SkColor | null;
    protected accessor singleColoredLogo_: boolean;
    accessor realboxCanShowSecondarySide: boolean;
    accessor realboxHadSecondarySide: boolean;
    protected accessor realboxShown_: boolean;
    protected accessor wasComposeboxOpened_: boolean;
    protected accessor showLensUploadDialog_: boolean;
    protected accessor showComposebox_: boolean;
    protected accessor logoEnabled_: boolean;
    protected accessor oneGoogleBarEnabled_: boolean;
    protected accessor shortcutsEnabled_: boolean;
    protected accessor middleSlotPromoEnabled_: boolean;
    protected accessor modulesEnabled_: boolean;
    protected accessor browserPromoType_: string;
    protected accessor browserPromoLimit_: number;
    protected accessor browserPromoCompletedLimit_: number;
    protected accessor showBrowserPromo_: boolean;
    private accessor middleSlotPromoLoaded_;
    private accessor modulesLoadedStatus_;
    protected accessor modulesShownToUser: boolean;
    protected accessor microsoftModuleEnabled_: boolean;
    protected accessor microsoftAuthIframePath_: string;
    protected accessor promoAndModulesLoaded_: boolean;
    protected accessor lazyRender_: boolean;
    protected accessor scrolledToTop_: boolean;
    protected accessor wallpaperSearchButtonAnimationEnabled_: boolean;
    protected accessor wallpaperSearchButtonEnabled_: boolean;
    protected accessor showWallpaperSearchButton_: boolean;
    accessor composeButtonEnabled: boolean;
    protected accessor composeboxCloseByClickOutside_: boolean;
    accessor composeboxEnabled: boolean;
    protected accessor isActionChipsVisible_: boolean;
    protected accessor isFooterVisible_: boolean;
    protected accessor ntpRealboxNextEnabled_: boolean;
    protected accessor realboxLayoutMode_: string;
    protected accessor searchboxCyclingPlaceholders_: boolean;
    protected accessor ntpNextFeaturesEnabled_: boolean;
    protected accessor maxTilesBeforeShowMore_: number;
    protected accessor searchboxInputFocused_: boolean;
    protected accessor composeboxInputFocused_: boolean;
    protected accessor showScrim_: boolean;
    private callbackRouter_;
    private pageHandler_;
    private customizeButtonsCallbackRouter_;
    private customizeButtonsHandler_;
    private backgroundManager_;
    private connectMicrosoftAuthToParentDocumentListenerId_;
    private setThemeListenerId_;
    private setCustomizeChromeSidePanelVisibilityListener_;
    private setWallpaperSearchButtonVisibilityListener_;
    private setActionChipsVisibilityListenerId_;
    private footerVisibilityUpdatedListener_;
    private eventTracker_;
    private shouldPrintPerformance_;
    private backgroundImageLoadStartEpoch_;
    private backgroundImageLoadStart_;
    private showWebstoreToastListenerId_;
    private pendingComposeboxContextFiles_;
    private pendingComposeboxText_;
    private pendingComposeboxMode_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    firstUpdated(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    private updateOneGoogleBarAppearance_;
    private computeShowCustomizeChromeText_;
    private computeBackgroundImageAttribution1_;
    private computeBackgroundImageAttribution2_;
    private computeBackgroundImageAttributionUrl_;
    private computeRealboxShown_;
    private computePromoAndModulesLoaded_;
    private onRealboxCanShowSecondarySideChanged_;
    private onLazyRendered_;
    private maybeRegisterCustomizeButtonHelpBubble_;
    protected onComposeboxInitialized_(e: CustomEvent<{
        initializeComposeboxState: (text: string, files: ContextualUpload[], mode: ComposeboxMode) => void;
    }>): void;
    protected openComposebox_(e: CustomEvent<{
        searchboxText: string;
        contextFiles: ContextualUpload[];
        mode: ComposeboxMode;
    }>): void;
    protected toggleComposebox_(): void;
    protected onComposeboxClickOutside_(): void;
    protected closeComposebox_(e: CustomEvent): void;
    protected onOpenVoiceSearch_(): void;
    protected onOpenLensSearch_(): void;
    protected onCloseLensSearch_(): void;
    protected onCustomizeClick_(): void;
    protected computeShowWallpaperSearchButton_(): boolean;
    protected onWallpaperSearchClick_(): void;
    protected onVoiceSearchOverlayClose_(): void;
    /**
     * Handles <CTRL> + <SHIFT> + <.> (also <CMD> + <SHIFT> + <.> on mac) to open
     * voice search.
     */
    private onWindowKeydown_;
    private rgbaOrInherit_;
    private computeShowBackgroundImage_;
    private onShowBackgroundImageChange_;
    private onThemeChange_;
    private onThemeLoaded_;
    private onPromoAndModulesLoadedChange_;
    /**
     * Set the #backgroundImage |path| only when different and non-empty. Reset
     * the customize dialog background selection if the dialog is closed.
     *
     * The ntp-untrusted-iframe |path| is set directly. When using a data binding
     * instead, the quick updates to the |path| result in iframe loading an error
     * page.
     */
    private updateBackgroundImagePath_;
    private computeColorSourceIsBaseline;
    private computeLogoColor_;
    private computeSingleColoredLogo_;
    /**
     * Sends the command received from the given source and origin to the browser.
     * Relays the browser response to whether or not a promo containing the given
     * command can be shown back to the source promo frame. |commandSource| and
     * |commandOrigin| are used only to send the response back to the source promo
     * frame and should not be used for anything else.
     * @param  messageData Data received from the source promo frame.
     * @param commandSource Source promo frame.
     * @param commandOrigin Origin of the source promo frame.
     */
    private canShowPromoWithBrowserCommand_;
    /**
     * Sends the command and the accompanying mouse click info received from the
     * promo of the given source and origin to the browser. Relays the execution
     * status response back to the source promo frame. |commandSource| and
     * |commandOrigin| are used only to send the execution status response back to
     * the source promo frame and should not be used for anything else.
     * @param commandData Command and mouse click info.
     * @param commandSource Source promo frame.
     * @param commandOrigin Origin of the source promo frame.
     */
    private executePromoBrowserCommand_;
    /**
     * Handles messages from the OneGoogleBar iframe. The messages that are
     * handled include show bar on load and overlay updates.
     *
     * 'overlaysUpdated' message includes the updated array of overlay rects that
     * are shown.
     */
    private handleOneGoogleBarMessage_;
    protected onMiddleSlotPromoLoaded_(): void;
    protected onModulesLoaded_(e: CustomEvent<number | null>): void;
    protected computeShowBrowserPromo_(): boolean;
    protected recordBrowserPromoMetrics_(): void;
    protected onCustomizeModule_(): void;
    private setCustomizeChromeSidePanelVisible_;
    private printPerformanceDatum_;
    /**
     * Prints performance measurements to the console. Also, installs  performance
     * observer to continuously print performance measurements after.
     */
    private printPerformance_;
    protected onWebstoreToastButtonClick_(): void;
    private onWindowClick_;
    protected isThemeDark_(): boolean;
    protected showThemeAttribution_(): boolean;
    protected onInputFocusChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onRealboxHadSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onModulesShownToUserChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-app': AppElement;
    }
}
export {};
