import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ActionChip, TabInfo } from '../action_chips.mojom-webui.js';
/**
 * The element for displaying Action Chips.
 */
export declare class ActionChipsElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    static get properties(): {
        actionChips_: {
            type: ArrayConstructor;
            state: boolean;
        };
    };
    private handler;
    private callbackRouter;
    protected accessor actionChips_: ActionChip[];
    private onActionChipChangedListenerId_;
    private delayTabUploads_;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    protected getAdditionalIconClasses_(chip: ActionChip): string;
    protected getId(chip: ActionChip): string | null;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    protected onCreateImageClick_(): void;
    protected onDeepSearchClick_(): void;
    protected onTabContextClick_(tab: TabInfo): void;
    protected handleClick_(chip: ActionChip): void;
    protected getFaviconUrl_(url: string): string;
    protected getMostRecentTabFaviconUrl_(chip: ActionChip): string;
    private onActionChipClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'ntp-action-chips': ActionChipsElement;
    }
}
