// chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';






export const ShowNtpPromosResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ShowNtpPromosResult {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kShown = 0,
  kNotShownNoPromos = 1,
  kNotShownDueToPolicy = 2,
}



export type NtpPromoHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerPendingReceiver>;

export class NtpPromoHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NtpPromoHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerPendingReceiver>;
  constructor(handle: MojoHandle|NtpPromoHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'ntp_promo.mojom.NtpPromoHandler',
        scope);
  }
}

export interface NtpPromoHandlerInterface {
  requestPromos(): void;
  onPromosShown(eligibleShown: string[], completedShown: string[]): void;
  onPromoClicked(promoId: string): void;
  snoozeSetupList(): void;
  unsnoozeSetupList(): void;
  disableSetupList(): void;
  undisableSetupList(): void;
}

export class NtpPromoHandlerRemote implements NtpPromoHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NtpPromoHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NtpPromoHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NtpPromoHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  requestPromos(): void {
    this.proxy.sendMessage(
        0,
        NtpPromoHandler_RequestPromos_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onPromosShown(
      eligibleShown: string[],
      completedShown: string[]): void {
    this.proxy.sendMessage(
        1,
        NtpPromoHandler_OnPromosShown_ParamsSpec.$,
        null,
        [
          eligibleShown,
          completedShown
        ],
        false);
  }

  onPromoClicked(
      promoId: string): void {
    this.proxy.sendMessage(
        2,
        NtpPromoHandler_OnPromoClicked_ParamsSpec.$,
        null,
        [
          promoId
        ],
        false);
  }

  snoozeSetupList(): void {
    this.proxy.sendMessage(
        3,
        NtpPromoHandler_SnoozeSetupList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  unsnoozeSetupList(): void {
    this.proxy.sendMessage(
        4,
        NtpPromoHandler_UnsnoozeSetupList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  disableSetupList(): void {
    this.proxy.sendMessage(
        5,
        NtpPromoHandler_DisableSetupList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  undisableSetupList(): void {
    this.proxy.sendMessage(
        6,
        NtpPromoHandler_UndisableSetupList_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NtpPromoHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NtpPromoHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NtpPromoHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NtpPromoHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NtpPromoHandler_RequestPromos_ParamsSpec.$,
        null,
        impl.requestPromos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NtpPromoHandler_OnPromosShown_ParamsSpec.$,
        null,
        impl.onPromosShown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NtpPromoHandler_OnPromoClicked_ParamsSpec.$,
        null,
        impl.onPromoClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NtpPromoHandler_SnoozeSetupList_ParamsSpec.$,
        null,
        impl.snoozeSetupList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NtpPromoHandler_UnsnoozeSetupList_ParamsSpec.$,
        null,
        impl.unsnoozeSetupList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NtpPromoHandler_DisableSetupList_ParamsSpec.$,
        null,
        impl.disableSetupList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NtpPromoHandler_UndisableSetupList_ParamsSpec.$,
        null,
        impl.undisableSetupList.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NtpPromoHandler {
  static get $interfaceName(): string {
    return "ntp_promo.mojom.NtpPromoHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NtpPromoHandlerRemote {
    let remote = new NtpPromoHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NtpPromoHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NtpPromoHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoHandlerRemote, NtpPromoHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  requestPromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onPromosShown: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onPromoClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  snoozeSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  unsnoozeSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  disableSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undisableSetupList: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NtpPromoHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.requestPromos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NtpPromoHandler_RequestPromos_ParamsSpec.$,
        null,
        this.requestPromos.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onPromosShown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NtpPromoHandler_OnPromosShown_ParamsSpec.$,
        null,
        this.onPromosShown.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onPromoClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NtpPromoHandler_OnPromoClicked_ParamsSpec.$,
        null,
        this.onPromoClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.snoozeSetupList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NtpPromoHandler_SnoozeSetupList_ParamsSpec.$,
        null,
        this.snoozeSetupList.createReceiverHandler(false /* expectsResponse */),
        false);
    this.unsnoozeSetupList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NtpPromoHandler_UnsnoozeSetupList_ParamsSpec.$,
        null,
        this.unsnoozeSetupList.createReceiverHandler(false /* expectsResponse */),
        false);
    this.disableSetupList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NtpPromoHandler_DisableSetupList_ParamsSpec.$,
        null,
        this.disableSetupList.createReceiverHandler(false /* expectsResponse */),
        false);
    this.undisableSetupList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NtpPromoHandler_UndisableSetupList_ParamsSpec.$,
        null,
        this.undisableSetupList.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type NtpPromoClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NtpPromoClientPendingReceiver>;

export class NtpPromoClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NtpPromoClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoClientPendingReceiver>;
  constructor(handle: MojoHandle|NtpPromoClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'ntp_promo.mojom.NtpPromoClient',
        scope);
  }
}

export interface NtpPromoClientInterface {
  setPromos(eligible: Promo[], completed: Promo[]): void;
}

export class NtpPromoClientRemote implements NtpPromoClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NtpPromoClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NtpPromoClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NtpPromoClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setPromos(
      eligible: Promo[],
      completed: Promo[]): void {
    this.proxy.sendMessage(
        0,
        NtpPromoClient_SetPromos_ParamsSpec.$,
        null,
        [
          eligible,
          completed
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NtpPromoClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NtpPromoClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoClientRemote, NtpPromoClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoClientRemote, NtpPromoClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NtpPromoClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NtpPromoClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NtpPromoClient_SetPromos_ParamsSpec.$,
        null,
        impl.setPromos.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NtpPromoClient {
  static get $interfaceName(): string {
    return "ntp_promo.mojom.NtpPromoClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NtpPromoClientRemote {
    let remote = new NtpPromoClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NtpPromoClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NtpPromoClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoClientRemote, NtpPromoClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoClientRemote, NtpPromoClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setPromos: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NtpPromoClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setPromos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NtpPromoClient_SetPromos_ParamsSpec.$,
        null,
        this.setPromos.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type NtpPromoHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerFactoryPendingReceiver>;

export class NtpPromoHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<NtpPromoHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<NtpPromoHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|NtpPromoHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'ntp_promo.mojom.NtpPromoHandlerFactory',
        scope);
  }
}

export interface NtpPromoHandlerFactoryInterface {
  createNtpPromoHandler(client: NtpPromoClientRemote, handler: NtpPromoHandlerPendingReceiver): void;
}

export class NtpPromoHandlerFactoryRemote implements NtpPromoHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<NtpPromoHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<NtpPromoHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|NtpPromoHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NtpPromoHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createNtpPromoHandler(
      client: NtpPromoClientRemote,
      handler: NtpPromoHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec.$,
        null,
        [
          client,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NtpPromoHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NtpPromoHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: NtpPromoHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NtpPromoHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec.$,
        null,
        impl.createNtpPromoHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NtpPromoHandlerFactory {
  static get $interfaceName(): string {
    return "ntp_promo.mojom.NtpPromoHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): NtpPromoHandlerFactoryRemote {
    let remote = new NtpPromoHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the NtpPromoHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NtpPromoHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    NtpPromoHandlerFactoryRemote, NtpPromoHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createNtpPromoHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NtpPromoHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createNtpPromoHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec.$,
        null,
        this.createNtpPromoHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PromosShownSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_RequestPromos_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_OnPromosShown_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_OnPromoClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_SnoozeSetupList_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_UnsnoozeSetupList_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_DisableSetupList_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandler_UndisableSetupList_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoClient_SetPromos_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PromosShownMojoType {
  eligible: string[];
  completed: string[];
}


export type PromosShown = PromosShownMojoType;
mojo.internal.Struct<PromosShownMojoType>(
    PromosShownSpec.$,
    'PromosShown',
    [
      mojo.internal.StructField<PromosShownMojoType, string[]>(
        'eligible', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromosShownMojoType, string[]>(
        'completed', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PromoMojoType {
  id: string;
  iconName: string;
  bodyText: string;
  buttonText: string;
}


export type Promo = PromoMojoType;
mojo.internal.Struct<PromoMojoType>(
    PromoSpec.$,
    'Promo',
    [
      mojo.internal.StructField<PromoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoMojoType, string>(
        'iconName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoMojoType, string>(
        'bodyText', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoMojoType, string>(
        'buttonText', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface NtpPromoHandler_RequestPromos_ParamsMojoType {
}


export type NtpPromoHandler_RequestPromos_Params = NtpPromoHandler_RequestPromos_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_RequestPromos_ParamsMojoType>(
    NtpPromoHandler_RequestPromos_ParamsSpec.$,
    'NtpPromoHandler_RequestPromos_Params',
    [
    ],
    [[0, 8],]);





export interface NtpPromoHandler_OnPromosShown_ParamsMojoType {
  eligibleShown: string[];
  completedShown: string[];
}


export type NtpPromoHandler_OnPromosShown_Params = NtpPromoHandler_OnPromosShown_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_OnPromosShown_ParamsMojoType>(
    NtpPromoHandler_OnPromosShown_ParamsSpec.$,
    'NtpPromoHandler_OnPromosShown_Params',
    [
      mojo.internal.StructField<NtpPromoHandler_OnPromosShown_ParamsMojoType, string[]>(
        'eligibleShown', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NtpPromoHandler_OnPromosShown_ParamsMojoType, string[]>(
        'completedShown', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface NtpPromoHandler_OnPromoClicked_ParamsMojoType {
  promoId: string;
}


export type NtpPromoHandler_OnPromoClicked_Params = NtpPromoHandler_OnPromoClicked_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_OnPromoClicked_ParamsMojoType>(
    NtpPromoHandler_OnPromoClicked_ParamsSpec.$,
    'NtpPromoHandler_OnPromoClicked_Params',
    [
      mojo.internal.StructField<NtpPromoHandler_OnPromoClicked_ParamsMojoType, string>(
        'promoId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface NtpPromoHandler_SnoozeSetupList_ParamsMojoType {
}


export type NtpPromoHandler_SnoozeSetupList_Params = NtpPromoHandler_SnoozeSetupList_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_SnoozeSetupList_ParamsMojoType>(
    NtpPromoHandler_SnoozeSetupList_ParamsSpec.$,
    'NtpPromoHandler_SnoozeSetupList_Params',
    [
    ],
    [[0, 8],]);





export interface NtpPromoHandler_UnsnoozeSetupList_ParamsMojoType {
}


export type NtpPromoHandler_UnsnoozeSetupList_Params = NtpPromoHandler_UnsnoozeSetupList_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_UnsnoozeSetupList_ParamsMojoType>(
    NtpPromoHandler_UnsnoozeSetupList_ParamsSpec.$,
    'NtpPromoHandler_UnsnoozeSetupList_Params',
    [
    ],
    [[0, 8],]);





export interface NtpPromoHandler_DisableSetupList_ParamsMojoType {
}


export type NtpPromoHandler_DisableSetupList_Params = NtpPromoHandler_DisableSetupList_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_DisableSetupList_ParamsMojoType>(
    NtpPromoHandler_DisableSetupList_ParamsSpec.$,
    'NtpPromoHandler_DisableSetupList_Params',
    [
    ],
    [[0, 8],]);





export interface NtpPromoHandler_UndisableSetupList_ParamsMojoType {
}


export type NtpPromoHandler_UndisableSetupList_Params = NtpPromoHandler_UndisableSetupList_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandler_UndisableSetupList_ParamsMojoType>(
    NtpPromoHandler_UndisableSetupList_ParamsSpec.$,
    'NtpPromoHandler_UndisableSetupList_Params',
    [
    ],
    [[0, 8],]);





export interface NtpPromoClient_SetPromos_ParamsMojoType {
  eligible: Promo[];
  completed: Promo[];
}


export type NtpPromoClient_SetPromos_Params = NtpPromoClient_SetPromos_ParamsMojoType;
mojo.internal.Struct<NtpPromoClient_SetPromos_ParamsMojoType>(
    NtpPromoClient_SetPromos_ParamsSpec.$,
    'NtpPromoClient_SetPromos_Params',
    [
      mojo.internal.StructField<NtpPromoClient_SetPromos_ParamsMojoType, Promo[]>(
        'eligible', 0,
        0,
        mojo.internal.Array(PromoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NtpPromoClient_SetPromos_ParamsMojoType, Promo[]>(
        'completed', 8,
        0,
        mojo.internal.Array(PromoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType {
  client: NtpPromoClientRemote;
  handler: NtpPromoHandlerPendingReceiver;
}


export type NtpPromoHandlerFactory_CreateNtpPromoHandler_Params = NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType;
mojo.internal.Struct<NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType>(
    NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsSpec.$,
    'NtpPromoHandlerFactory_CreateNtpPromoHandler_Params',
    [
      mojo.internal.StructField<NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType, NtpPromoClientRemote>(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(NtpPromoClientRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsMojoType, NtpPromoHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(NtpPromoHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



