// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{l as getTrustedHTML,h as assert,g as getCss$r,d as getCss$s,E as EventTracker,j as NewTabPageProxy,x as recordEnumeration,B as BrowserCommandProxy,K as CrAutoImgElement,W as WindowProxy,z as Command,u as recordLoadDuration,q as recordDuration,p as ParentTrustedDocumentProxy,I as I18nMixinLit,_ as CrRippleMixin,T as recordSmallCount,$ as getFaviconForPageURL,b as getCss$t,O as recordOccurrence,M as recordLogValue,e as assertNotReached,F as FocusOutlineManager,k as skColorToRgba,i as hasKeyModifiers,a0 as isMac,a1 as SUPPORTED_FILE_TYPES,L as processFile,w as recordSparseValueWithPersistentHash,Q as recordPerdecage,t as recordBoolean}from"./shared.rollup.js";export{a8 as ActionChipsApiProxyImpl,a7 as ActionChipsElement,a2 as ComposeboxElement,a5 as ComposeboxFileCarouselElement,a6 as ComposeboxFileThumbnailElement,a3 as ComposeboxProxyImpl,a4 as ContextualEntrypointAndCarouselElement,J as CustomizeButtonsElement,a9 as VoiceSearchOverlayElement}from"./shared.rollup.js";import{NtpPromoClientCallbackRouter,NtpPromoHandlerRemote,NtpPromoHandlerFactory}from"./ntp_promo.mojom-webui.js";import{css,html,CrLitElement,render}from"chrome://resources/lit/v3_0/lit.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import"chrome://new-tab-page/strings.m.js";import{AuthType}from"./ntp_microsoft_auth_shared_ui.mojom-webui.js";import{MicrosoftAuthPageHandler}from"./microsoft_auth.mojom-webui.js";import{GoogleCalendarPageHandler}from"./google_calendar.mojom-webui.js";import{OutlookCalendarPageHandler}from"./outlook_calendar.mojom-webui.js";import{RecommendationType}from"./file_suggestion.mojom-webui.js";import{DriveSuggestionHandler}from"./drive_suggestion.mojom-webui.js";import{MicrosoftFilesPageHandler}from"./microsoft_files.mojom-webui.js";import{PageHandler,ScoredURLUserAction}from"./most_relevant_tab_resumption.mojom-webui.js";import{VisitSource,FormFactor}from"./url_visit_types.mojom-webui.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{Color}from"./tab_group_types.mojom-webui.js";import{PageHandler as PageHandler$1}from"./tab_groups.mojom-webui.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{TextDirection}from"chrome://resources/mojo/mojo/public/mojom/base/text_direction.mojom-webui.js";import{MostVisitedPageCallbackRouter,MostVisitedPageHandlerRemote,MostVisitedPageHandlerFactory}from"chrome://resources/cr_components/most_visited/most_visited.mojom-webui.js";import{PageImageServiceHandler}from"chrome://resources/cr_components/page_image_service/page_image_service.mojom-webui.js";import"./action_chips.mojom-webui.js";import"./new_tab_page.mojom-webui.js";import"chrome://resources/cr_components/composebox/composebox_query.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import"chrome://resources/mojo/url/mojom/url.mojom-webui.js";import"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import"chrome://resources/cr_components/composebox/composebox.mojom-webui.js";class NtpPromoProxyImpl{callbackRouter_=new NtpPromoClientCallbackRouter;handler_=new NtpPromoHandlerRemote;constructor(){const factory=NtpPromoHandlerFactory.getRemote();factory.createNtpPromoHandler(this.callbackRouter_.$.bindNewPipeAndPassRemote(),this.handler_.$.bindNewPipeAndPassReceiver())}static getInstance(){return instance$C||(instance$C=new NtpPromoProxyImpl)}static setInstance(obj){instance$C=obj}getHandler(){return this.handler_}getCallbackRouter(){return this.callbackRouter_}}let instance$C=null;const div$3=document.createElement("div");div$3.innerHTML=getTrustedHTML`<cr-iconset name="ntp-promo" size="20">
  <svg>
    <defs>
      <g id="account_circle" viewBox="0 -960 960 960"><path d="M234-276q51-39 114-61.5T480-360q69 0 132 22.5T726-276q35-41 54.5-93T800-480q0-133-93.5-226.5T480-800q-133 0-226.5 93.5T160-480q0 59 19.5 111t54.5 93Zm246-164q-59 0-99.5-40.5T340-580q0-59 40.5-99.5T480-720q59 0 99.5 40.5T620-580q0 59-40.5 99.5T480-440Zm0 360q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q53 0 100-15.5t86-44.5q-39-29-86-44.5T480-280q-53 0-100 15.5T294-220q39 29 86 44.5T480-160Zm0-360q26 0 43-17t17-43q0-26-17-43t-43-17q-26 0-43 17t-17 43q0 26 17 43t43 17Zm0-60Zm0 360Z"></path></g>
      <g id="my_extensions" viewBox="0 -960 960 960"><path d="M216-135.869q-33.287 0-56.709-23.422-23.422-23.422-23.422-56.709v-172.304q37.609-2 63.218-28.424 25.608-26.424 25.608-63.272t-25.608-63.272q-25.609-26.424-63.218-28.424V-744q0-33.287 23.422-56.709 23.422-23.422 56.709-23.422h161.065q2.631-40.956 31.96-69.315 29.329-28.359 70.75-28.359t70.975 28.199q29.554 28.199 32.185 69.475H744q33.287 0 56.709 23.422 23.422 23.422 23.422 56.709v161.065q40.956 2.631 69.315 31.96 28.359 29.329 28.359 70.75t-28.199 70.975q-28.199 29.554-69.475 32.185V-216q0 33.287-23.422 56.709-23.422 23.422-56.709 23.422H216Zm2.87-83.001h522.26v-522.26H218.87v108.652q42.13 22.63 65.597 63.772 23.468 41.141 23.468 88.706 0 49.01-23.468 90.168Q261-348.674 218.87-327.283v108.413ZM480-480Z"></path></g>
      <g id="palette" viewBox="0 -960 960 960"><path d="M480-80q-82 0-155-31.5t-127.5-86Q143-252 111.5-325T80-480q0-83 32.5-156t88-127Q256-817 330-848.5T488-880q80 0 151 27.5t124.5 76q53.5 48.5 85 115T880-518q0 115-70 176.5T640-280h-74q-9 0-12.5 5t-3.5 11q0 12 15 34.5t15 51.5q0 50-27.5 74T480-80Zm0-400Zm-220 40q26 0 43-17t17-43q0-26-17-43t-43-17q-26 0-43 17t-17 43q0 26 17 43t43 17Zm120-160q26 0 43-17t17-43q0-26-17-43t-43-17q-26 0-43 17t-17 43q0 26 17 43t43 17Zm200 0q26 0 43-17t17-43q0-26-17-43t-43-17q-26 0-43 17t-17 43q0 26 17 43t43 17Zm120 160q26 0 43-17t17-43q0-26-17-43t-43-17q-26 0-43 17t-17 43q0 26 17 43t43 17ZM480-160q9 0 14.5-5t5.5-13q0-14-15-33t-15-57q0-42 29-67t71-25h70q66 0 113-38.5T800-518q0-121-92.5-201.5T488-800q-136 0-232 93t-96 227q0 133 93.5 226.5T480-160Z"></path></g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$3=div$3.querySelectorAll("cr-iconset");for(const iconset of iconsets$3){document.head.appendChild(iconset)}let instance$B=null;function getCss$q(){return instance$B||(instance$B=[...[],css`:host{--ntp-promo-background:var(--color-sys-surface3);--ntp-promo-background-hovered:var(--color-sys-state-hover-on-subtle);--ntp-promo-border-radius:12px;--ntp-promo-element-spacing:16px;--ntp-promo-foreground:var(--color-sys-on-surface);--ntp-promo-icon-background:var(--color-sys-tonal-container);--ntp-promo-icon-foreground:var(--color-sys-on-tonal-container);--ntp-promo-action-icon-foreground:var(--color-sys-on-surface-subtle);--ntp-promo-icon-border-radius:8px;--ntp-promo-icon-size:40px;--ntp-promo-icon-image-size:20px;--ntp-promo-padding:16px;--ntp-promo-text-line-height:20px;--ntp-promo-text-width:382px;--ntp-promo-text-width-multiple-promos:256px;--ntp-promo-spacing:8px;align-items:center;display:none;justify-content:center;margin-block-start:30px;margin-inline:40px;position:relative}#promos{align-items:center;display:flex;flex-direction:row;flex-wrap:wrap;gap:var(--ntp-promo-spacing);justify-content:center}#promo{align-items:center;align-self:stretch;background-color:var(--ntp-promo-background);border:none;border-radius:var(--ntp-promo-border-radius);color:var(--ntp-promo-foreground);cursor:pointer;display:flex;flex-direction:row;font:inherit;gap:var(--ntp-promo-element-spacing);padding:var(--ntp-promo-padding);position:relative;text-align:start}#promo:hover{background-color:var(--ntp-promo-background-hovered)}#bodyIcon{--iron-icon-height:var(--ntp-promo-icon-image-size);--iron-icon-width:var(--ntp-promo-icon-image-size);background-color:var(--ntp-promo-icon-background);border-radius:var(--ntp-promo-icon-border-radius);box-sizing:border-box;color:var(--ntp-promo-icon-foreground);display:inline-block;height:var(--ntp-promo-icon-size);margin:0;padding:calc((var(--ntp-promo-icon-size) - var(--ntp-promo-icon-image-size)) / 2);text-align:center;width:var(--ntp-promo-icon-size);flex:none}#bodyText{display:inline-block;line-height:var(--ntp-promo-text-line-height);margin-block:0;vertical-align:middle;width:var(--ntp-promo-text-width)}#bodyText.multiplePromos{width:var(--ntp-promo-text-width-multiple-promos)}#actionIcon{--iron-icon-height:var(--ntp-promo-icon-image-size);--iron-icon-width:var(--ntp-promo-icon-image-size);background-color:transparent;box-sizing:border-box;color:var(--ntp-promo-action-icon-foreground);display:inline-block;flex:none;height:var(--ntp-promo-icon-image-size);margin:0;text-align:center;width:var(--ntp-promo-icon-image-size)}#actionIcon:dir(rtl){transform:scaleX(-1)}`])}function getHtml$r(){return html`<!--_html_template_start_-->
<div id="promos">
  ${this.eligiblePromos_.map((item=>html`
    <button id="promo" @click="${this.onClick_.bind(this,item.id)}"
        aria-label="${item.buttonText}">
      <cr-icon id="bodyIcon" icon="ntp-promo:${item.iconName}"></cr-icon>
      <p id="bodyText" class="${this.getBodyTextCssClass_()}">
        ${item.bodyText}
      </p>
      <cr-icon id="actionIcon" icon="cr:chevron-right"></cr-icon>
    </button>`))}
</div>
<!--_html_template_end_-->`}class IndividualPromosElement extends CrLitElement{static get is(){return"individual-promos"}static get styles(){return getCss$q()}render(){return getHtml$r.bind(this)()}static get properties(){return{eligiblePromos_:{type:Array},maxPromos:{type:Number,attribute:true,useDefault:true}}}#eligiblePromos__accessor_storage=[];get eligiblePromos_(){return this.#eligiblePromos__accessor_storage}set eligiblePromos_(value){this.#eligiblePromos__accessor_storage=value}#maxPromos_accessor_storage=0;get maxPromos(){return this.#maxPromos_accessor_storage}set maxPromos(value){this.#maxPromos_accessor_storage=value}handler_;callbackRouter_;listenerIds_=[];notifiedShown_=false;constructor(){super();this.handler_=NtpPromoProxyImpl.getInstance().getHandler();this.callbackRouter_=NtpPromoProxyImpl.getInstance().getCallbackRouter()}connectedCallback(){super.connectedCallback();this.listenerIds_.push(this.callbackRouter_.setPromos.addListener(this.onSetPromos.bind(this)));this.handler_.requestPromos()}disconnectedCallback(){super.disconnectedCallback();for(const listenerId of this.listenerIds_){this.callbackRouter_.removeListener(listenerId)}this.listenerIds_=[]}onSetPromos(eligible){this.eligiblePromos_=eligible.slice(0,Math.min(this.maxPromos,eligible.length));if(this.eligiblePromos_.length>0){this.style.display="block"}else{this.style.display="none"}if(!this.notifiedShown_){this.notifiedShown_=true;const shown=this.eligiblePromos_.map((p=>p.id));this.handler_.onPromosShown(shown,[])}}onClick_(promoId){assert(promoId,"Button should not be able to display if no promoId.");this.handler_.onPromoClicked(promoId)}getBodyTextCssClass_(){return this.eligiblePromos_.length>1?"multiplePromos":"singlePromo"}}customElements.define(IndividualPromosElement.is,IndividualPromosElement);let instance$A=null;function getCss$p(){return instance$A||(instance$A=[...[getCss$r(),getCss$s()],css`:host{font-size:12px;max-width:537px}#promoAndDismissContainer{align-items:center;background-color:var(--color-new-tab-page-promo-background);border:solid var(--color-new-tab-page-border) 1px;border-radius:24px;box-sizing:border-box;color:var(--color-new-tab-page-primary-foreground);display:flex;flex-direction:row;height:30px;justify-content:center}#promoContainer{align-items:center;display:flex;overflow-x:hidden;padding-inline-end:8px;white-space:pre}:host([shown-middle-slot-promo-id_]) #promoContainer{padding-inline-end:2px}#promoContainer>:first-child{margin-inline-start:8px}a{color:var(--color-new-tab-page-link);cursor:pointer;text-decoration:underline}a:focus{border-radius:2px;box-shadow:var(--ntp-focus-shadow);outline:none}img{background-color:var(--color-new-tab-page-promo-image-background);border-radius:50%;height:20px;margin-inline-end:4px;pointer-events:none;width:20px}#dismissPromoButton{--cr-icon-button-icon-size:14px;--cr-icon-button-size:20px;--cr-icon-button-fill-color:var(--color-new-tab-page-primary-foreground);color:var(--color-new-tab-page-primary-foreground);margin-inline-end:4px;margin-inline-start:8px}#promoContainer>:last-child{overflow:hidden;text-overflow:ellipsis}`])}function getHtml$q(){return html`<!--_html_template_start_--><!-- Visibility is toggled in TS -->
<div id="promoAndDismissContainer" hidden>
  <!-- Promo parts are added by TS. -->
  ${this.shownMiddleSlotPromoId_?html`
    <cr-icon-button id="dismissPromoButton"
        class="icon-clear"
        aria-label="$i18n{close}"
        title="$i18n{close}"
        @click="${this.onDismissPromoButtonClick_}">
    </cr-icon-button>
  `:""}
</div>
<cr-toast id="dismissPromoButtonToast" duration="10000">
  <div id="dismissPromoButtonToastMessage">
    $i18n{undoDismissPromoButtonToast}
  </div>
  <cr-button id="undoDismissPromoButton"
      aria-label="$i18n{undoDescription}"
      @click="${this.onUndoDismissPromoButtonClick_}">
    $i18n{undo}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`}var PromoDismissAction;(function(PromoDismissAction){PromoDismissAction[PromoDismissAction["DISMISS"]=0]="DISMISS";PromoDismissAction[PromoDismissAction["RESTORE"]=1]="RESTORE";PromoDismissAction[PromoDismissAction["MAX_VALUE"]=1]="MAX_VALUE"})(PromoDismissAction||(PromoDismissAction={}));function recordPromoDismissAction(action){recordEnumeration("NewTabPage.Promos.DismissAction",action,PromoDismissAction.MAX_VALUE+1)}async function renderPromo(promo){const browserHandler=NewTabPageProxy.getInstance().handler;const promoBrowserCommandHandler=BrowserCommandProxy.getInstance().handler;const commandIds=[];function createAnchor(target){const commandIdMatch=/^command:(\d+)$/.exec(target.url);if(!commandIdMatch&&!target.url.startsWith("https://")){return null}const el=document.createElement("a");let commandId=null;if(!commandIdMatch){el.href=target.url}else{assert(commandIdMatch[1]);commandId=+commandIdMatch[1];if(!Object.values(Command).includes(commandId)){commandId=Command.kUnknownCommand}commandIds.push(commandId)}function onClick(event){if(commandId!==null){promoBrowserCommandHandler.executeCommand(commandId,{middleButton:event.button===1,altKey:event.altKey,ctrlKey:event.ctrlKey,metaKey:event.metaKey,shiftKey:event.shiftKey})}browserHandler.onPromoLinkClicked()}el.addEventListener("auxclick",onClick);el.addEventListener("click",onClick);return el}let hasContent=false;const promoContainer=document.createElement("div");promoContainer.id="promoContainer";promo.middleSlotParts.forEach((({image:image,link:link,text:text})=>{let el;if(image){el=new CrAutoImgElement;el.autoSrc=image.imageUrl.url;el.staticEncode=true;if(image.target){const anchor=createAnchor(image.target);if(anchor){anchor.appendChild(el);el=anchor}}el.classList.add("image")}else if(link){el=createAnchor(link.url)}else if(text){el=document.createElement("span")}const linkOrText=link||text;if(el&&linkOrText){el.innerText=linkOrText.text}if(el){hasContent=true;promoContainer.appendChild(el)}}));const canShow=(await Promise.all(commandIds.map((commandId=>promoBrowserCommandHandler.canExecuteCommand(commandId))))).every((({canExecute:canExecute})=>canExecute));if(hasContent&&canShow){browserHandler.onPromoRendered(WindowProxy.getInstance().now(),promo.logUrl||null);return{container:promoContainer,id:promo.id}}return null}class MiddleSlotPromoElement extends CrLitElement{static get is(){return"ntp-middle-slot-promo"}static get styles(){return getCss$p()}render(){return getHtml$q.bind(this)()}static get properties(){return{shownMiddleSlotPromoId_:{type:String,reflect:true},promo_:{type:Object}}}#shownMiddleSlotPromoId__accessor_storage="";get shownMiddleSlotPromoId_(){return this.#shownMiddleSlotPromoId__accessor_storage}set shownMiddleSlotPromoId_(value){this.#shownMiddleSlotPromoId__accessor_storage=value}#promo__accessor_storage=null;get promo_(){return this.#promo__accessor_storage}set promo_(value){this.#promo__accessor_storage=value}blocklistedMiddleSlotPromoId_="";eventTracker_=new EventTracker;pageHandler_;setPromoListenerId_=null;constructor(){super();this.pageHandler_=NewTabPageProxy.getInstance().handler}connectedCallback(){super.connectedCallback();this.setPromoListenerId_=NewTabPageProxy.getInstance().callbackRouter.setPromo.addListener((promo=>{this.promo_=promo}));this.eventTracker_.add(window,"keydown",this.onWindowKeydown_.bind(this));this.pageHandler_.updatePromoData()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll();NewTabPageProxy.getInstance().callbackRouter.removeListener(this.setPromoListenerId_)}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("promo_")){this.onPromoChange_()}}hidePromoContainer_(){this.$.promoAndDismissContainer.hidden=true;this.fire("ntp-middle-slot-promo-loaded")}onPromoChange_(){if(!this.promo_){this.hidePromoContainer_();return}renderPromo(this.promo_).then((promo=>{if(!promo){this.hidePromoContainer_();return}const promoContainer=this.shadowRoot.getElementById("promoContainer");if(promoContainer){promoContainer.remove()}if(loadTimeData.getBoolean("middleSlotPromoDismissalEnabled")){this.shownMiddleSlotPromoId_=promo.id??""}const renderedPromoContainer=promo.container;assert(renderedPromoContainer);this.$.promoAndDismissContainer.prepend(renderedPromoContainer);this.$.promoAndDismissContainer.hidden=false;this.fire("ntp-middle-slot-promo-loaded")}))}onWindowKeydown_(e){if(!this.blocklistedMiddleSlotPromoId_){return}let ctrlKeyPressed=e.ctrlKey;ctrlKeyPressed=ctrlKeyPressed||e.metaKey;if(ctrlKeyPressed&&e.key==="z"){this.onUndoDismissPromoButtonClick_()}}onDismissPromoButtonClick_(){assert(this.$.promoAndDismissContainer);this.$.promoAndDismissContainer.hidden=true;this.pageHandler_.blocklistPromo(this.shownMiddleSlotPromoId_);this.blocklistedMiddleSlotPromoId_=this.shownMiddleSlotPromoId_;this.$.dismissPromoButtonToast.show();recordPromoDismissAction(PromoDismissAction.DISMISS)}onUndoDismissPromoButtonClick_(){assert(this.$.promoAndDismissContainer);this.pageHandler_.undoBlocklistPromo(this.blocklistedMiddleSlotPromoId_);this.$.promoAndDismissContainer.hidden=false;this.$.dismissPromoButtonToast.hide();recordPromoDismissAction(PromoDismissAction.RESTORE)}}customElements.define(MiddleSlotPromoElement.is,MiddleSlotPromoElement);const div$2=document.createElement("div");div$2.innerHTML=getTrustedHTML`<cr-iconset name="modules" size="20">
  <svg>
    <defs>
      <g id="block" viewBox="0 -960 960 960">
        <path d="M480-87.87q-80.674 0-152.109-30.717T202.761-203q-53.696-53.696-84.294-125.25T87.869-480.478q0-81.674 30.598-152.489 30.598-70.816 84.294-124.392 53.695-53.576 125.13-84.174Q399.326-872.131 480-872.131q81.674 0 152.609 30.598t124.63 84.174q53.696 53.576 84.294 124.392 30.598 70.815 30.598 152.489 0 80.674-30.598 152.228T757.239-203q-53.695 53.696-124.63 84.413Q561.674-87.869 480-87.869Zm0-83q53.087 0 100.652-16.804t86.13-47.609L234.804-667.022q-30.326 39.044-47.13 86.37-16.804 47.326-16.804 100.174 0 128.804 90.282 219.206Q351.435-170.87 480-170.87Zm245.435-123.065q30.087-39.043 46.891-86.369t16.804-100.174q0-128.565-90.282-218.609Q608.565-789.13 480-789.13q-52.848 0-100.054 16.565-47.207 16.565-86.25 46.652l431.739 431.978Z">
        </path>
      </g>
      <g id="dock_to_left" viewBox="0 -960 960 960">
        <path d="M213.87-135.869q-32.421 0-55.211-22.79t-22.79-55.211v-532.26q0-32.421 22.79-55.211t55.211-22.79h532.26q32.421 0 55.211 22.79t22.79 55.211v532.26q0 32.421-22.79 55.211t-55.211 22.79H213.87Zm329.043-83.001v-522.26H218.87v522.26h324.043Z">
        </path>
      </g>
      <g id="done" viewBox="0 -960 960 960">
        <path d="M395-277.348 218.348-455l57.891-57.891L395-395.131l288.761-287.76L741.652-624 395-277.348Z">
        </path>
      </g>
      <g id="info" viewBox="0 -960 960 960">
        <path d="M440.413-284.413h79.174V-528h-79.174v243.587Zm39.376-310.804q17.244 0 29.119-11.665 11.875-11.664 11.875-28.907 0-17.244-11.665-29.119-11.664-11.875-28.907-11.875-17.244 0-29.119 11.665-11.875 11.664-11.875 28.907 0 17.244 11.665 29.119 11.664 11.875 28.907 11.875Zm.487 507.348q-81.189 0-152.621-30.618-71.432-30.618-124.991-84.177-53.559-53.559-84.177-124.949-30.618-71.391-30.618-152.845 0-81.455 30.618-152.387t84.177-124.491q53.559-53.559 124.949-84.177 71.391-30.618 152.845-30.618 81.455 0 152.387 30.618t124.491 84.177q53.559 53.559 84.177 124.716 30.618 71.156 30.618 152.344 0 81.189-30.618 152.621-30.618 71.432-84.177 124.991-53.559 53.559-124.716 84.177-71.156 30.618-152.344 30.618ZM480-170.87q129.043 0 219.087-90.043Q789.13-350.957 789.13-480t-90.043-219.087Q609.043-789.13 480-789.13t-219.087 90.043Q170.87-609.043 170.87-480t90.043 219.087Q350.957-170.87 480-170.87ZM480-480Z">
        </path>
      </g>
      <g id="logout" viewBox="0 -960 960 960">
        <path d="M180-120q-24 0-42-18t-18-42v-600q0-24 18-42t42-18h299v60H180v600h299v60H180Zm486-185-43-43 102-102H360v-60h363L621-612l43-43 176 176-174 174Z">
        </path>
      </g>
      <g id="thumb_down" viewBox="0 -960 960 960">
        <path d="M240.957-807.63h457.434v489.087L413.978-34.13l-38.293-25.776q-17.881-12.529-27.479-32.224-9.597-19.696-5.597-41.131l1-2.369 37.282-182.913H120q-34.065 0-58.533-24.468Q37-367.478 37-401.543v-42.413q0-8.582 1.5-15.748 1.5-7.165 4.978-14.404l120.435-283.066q9.196-22.869 30.685-36.663 21.489-13.793 46.359-13.793Zm378.021 83H240.957L120.478-443.956v42.413h358.218l-46.131 231.282 186.413-186.413V-724.63Zm0 367.956V-724.63v367.956Zm79.413 38.131v-83h136.587V-724.63H698.391v-83h219.587v489.087H698.391Z">
        </path>
      </g>
      <g id="tune" viewBox="0 -960 960 960">
        <path d="M454.087-136.587V-384H533.5v84h288v79.413h-288v84h-79.413Zm-315.587-84V-300h247.413v79.413H138.5Zm144-135.826v-84h-144v-79.174h144v-84h79.413v247.174H282.5Zm147.587-84v-79.174H821.5v79.174H430.087Zm144-135.587v-247.413H653.5v84h168V-660h-168v84h-79.413ZM138.5-660v-79.413h391.413V-660H138.5Z">
        </path>
      </g>
      <g id="visibility_off" viewBox="0 -960 960 960">
        <path d="m638.435-429.065-72.283-72.283q2.326-29.391-18.337-49.717t-48.38-18l-70.37-70.37q12.283-4.282 25.446-6.424Q467.674-648 480-648q70 0 119 49t49 119q0 11.848-2.141 25.489-2.142 13.641-7.424 25.446ZM777.652-289.37l-56.782-57.26q34.326-27.522 62.75-60.185 28.423-32.663 48.902-73.185-49.479-100.761-144.5-158.38Q593-696 480-696q-26 0-49.685 2.761-23.685 2.761-46.011 9.043l-64.217-64.217q38-15 78.456-21 40.457-6 81.457-6 144.435 0 264.967 78.695Q865.5-618.022 919.413-480q-22 57.478-58.978 104.935-36.978 47.456-82.783 85.695ZM765.13-87.13 639.435-213.065q-37.522 14.239-77.5 21.359-39.978 7.119-81.935 7.119-144.674 0-265.207-78.935Q94.261-342.456 40.587-480q21.76-56.522 58-104.359 36.239-47.837 83.761-86.793l-99.044-98.565 53.631-53.631 681.587 682.826L765.13-87.13ZM238.848-614.37q-34.522 28.479-63.207 60.544-28.684 32.065-47.924 73.826 49 101 144.142 158.5Q367-264 480-264q23.848 0 47.772-3.141 23.924-3.142 48.924-9.142l-45-45q-12.805 4.761-25.848 7.022Q492.804-312 480-312q-70 0-119-49t-49-119q0-12.565 3.141-25.728 3.142-13.163 5.663-25.968l-81.956-82.674Zm292.739 84.457Zm-102.935 99.587Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$2=div$2.querySelectorAll("cr-iconset");for(const iconset of iconsets$2){document.head.appendChild(iconset)}let instance$z=null;function getCss$o(){return instance$z||(instance$z=[...[getCss$s()],css`:host{--menu-item-margin:12px;display:flex;flex-direction:column;margin:8px}@media (forced-colors:active){:host{outline:var(--cr-border-hcm)}}#titleContainer{align-items:center;display:flex;height:20px;padding:12px 12px 8px 12px}#title{color:var(--color-new-tab-page-primary-foreground);font-size:13px;font-weight:normal;line-height:20px;margin-block-start:0;margin-block-end:0}#headerSpacer{flex-grow:1}#menuButton{--cr-icon-button-icon-size:20px;--cr-icon-button-fill-color:var(--color-new-tab-page-primary-foreground);--cr-icon-button-hover-background-color:var(--color-new-tab-page-control-background-hovered);margin-inline:0 -6px}#actionMenu{--cr-menu-shadow:var(--ntp-menu-shadow)}.action-menu-icon{--cr-icon-ripple-size:16px;background-color:transparent;margin-inline-start:calc(-1 * var(--menu-item-margin));margin-inline-end:var(--menu-item-margin)}#actionMenuDivider{background-color:var(--color-new-tab-page-module-context-menu-divider);border:none;height:1px;margin:8px 0}`])}function getHtml$p(){return html`<!--_html_template_start_--><div id="titleContainer">
  <h2 id="title" ?hidden="${!this.headerText}">${this.headerText}</h2>
  <div id="headerSpacer"></div>
  <slot name="title-actions"></slot>
  <cr-icon-button id="menuButton" title="${this.moreActionsText}"
      class="icon-more-vert" @click="${this.onMenuButtonClick_}">
  </cr-icon-button>
</div>

<cr-action-menu id="actionMenu"
    role-description="$i18n{moduleHeaderMoreActionsMenu}">
  ${this.menuItems.map((item=>html`
    <button id="${item.action}" class="dropdown-item"
        @click="${this.onButtonClick_}" data-action="${item.action}">
      <cr-icon class="action-menu-icon cr-icon" icon="${item.icon}"></cr-icon>
      ${item.text}
    </button>
  `))}
  ${!this.hideCustomize?html`
    <hr id="actionMenuDivider" ?hidden="${!this.showDivider_()}">
    <button id="customize-module" class="dropdown-item"
          @click="${this.onButtonClick_}" data-action="customize-module">
    <cr-icon class="action-menu-icon cr-icon" icon="modules:tune"></cr-icon>
        $i18n{modulesCustomizeButtonText}
    </button>
  `:""}
</cr-action-menu>
<!--_html_template_end_-->`}class ModuleHeaderElement extends CrLitElement{static get is(){return"ntp-module-header-v2"}static get styles(){return getCss$o()}render(){return getHtml$p.bind(this)()}static get properties(){return{headerText:{type:String},moreActionsText:{type:String},menuItems:{type:Array},hideCustomize:{type:Boolean}}}#headerText_accessor_storage=null;get headerText(){return this.#headerText_accessor_storage}set headerText(value){this.#headerText_accessor_storage=value}#menuItems_accessor_storage=[];get menuItems(){return this.#menuItems_accessor_storage}set menuItems(value){this.#menuItems_accessor_storage=value}#moreActionsText_accessor_storage="";get moreActionsText(){return this.#moreActionsText_accessor_storage}set moreActionsText(value){this.#moreActionsText_accessor_storage=value}#hideCustomize_accessor_storage=false;get hideCustomize(){return this.#hideCustomize_accessor_storage}set hideCustomize(value){this.#hideCustomize_accessor_storage=value}onButtonClick_(e){const action=e.currentTarget.dataset["action"];assert(action);e.stopPropagation();this.$.actionMenu.close();if(action==="customize-module"){this.dispatchEvent(new Event("customize-module",{bubbles:true,composed:true}))}else{this.dispatchEvent(new Event(`${action}-button-click`,{bubbles:true,composed:true}))}}onMenuButtonClick_(e){this.$.actionMenu.showAt(e.target)}showDivider_(){return this.menuItems?.length>0}}customElements.define(ModuleHeaderElement.is,ModuleHeaderElement);class ModuleDescriptor{id_;initializeCallback_;constructor(id,initializeCallback){this.id_=id;this.initializeCallback_=initializeCallback}get id(){return this.id_}async initialize(timeout,onNtpLoad=true){const loadStartTime=WindowProxy.getInstance().now();const element=await Promise.race([this.initializeCallback_(),new Promise((resolve=>{WindowProxy.getInstance().setTimeout((()=>{resolve(null)}),timeout)}))]);if(!element){return null}const loadEndTime=WindowProxy.getInstance().now();const duration=loadEndTime-loadStartTime;recordLoadDuration("NewTabPage.Modules.Loaded",loadEndTime);recordLoadDuration(`NewTabPage.Modules.Loaded.${this.id_}`,loadEndTime);recordDuration("NewTabPage.Modules.LoadDuration",duration);recordDuration(`NewTabPage.Modules.LoadDuration.${this.id_}`,duration);const histogramBase=onNtpLoad?"NewTabPage.Modules.LoadedOnNTPLoad":"NewTabPage.Modules.LoadedAfterNTPLoad";recordLoadDuration(`${histogramBase}`,loadEndTime);recordLoadDuration(`${histogramBase}.${this.id_}`,loadEndTime);return element}}let instance$y=null;function getCss$n(){return instance$y||(instance$y=[...[],css`#contents{align-items:center;background-color:var(--color-new-tab-page-module-item-background);border-radius:var(--ntp-module-item-border-radius);display:flex;flex-direction:column;gap:24px;margin:8px;padding:32px 40px}:host([format='wide']) #contents{flex-direction:row;gap:38px}@media (prefers-color-scheme:dark){#authImg{content:url(modules/authentication/icons/microsoft_auth_dark.svg)}}#headingsAndButton{align-items:center;display:flex;flex-direction:column;gap:16px}:host([format='wide']) #headingsAndButton{align-items:flex-start}#headings{text-align:center}:host([format='wide']) #headings{text-align:initial}#heading{color:var(--color-new-tab-page-primary-foreground);font-size:16px;font-weight:500;line-height:24px;margin:0}#subheading{color:var(--color-new-tab-page-secondary-foreground);font-size:var(--ntp-module-text-size);font-weight:400;line-height:var(--ntp-module-line-height);margin:0}`])}function getHtml$o(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesMicrosoftAuthName")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}">
</ntp-module-header-v2>
<div id="contents">
  <img id="authImg"
      src="modules/authentication/icons/microsoft_auth_light.svg">
  <div id="headingsAndButton">
    <div id="headings">
      <h2 id="heading">$i18n{modulesMicrosoftAuthHeading}</h2>
      <div id="subheading">$i18n{modulesMicrosoftAuthSubheading}</div>
    </div>
    <cr-button role="link" class="action-button" id="signInButton"
        @click="${this.onSignInClick_}">
      $i18n{modulesMicrosoftAuthSignIn}
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`}class MicrosoftAuthProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){if(instance$x){return instance$x}const handler=MicrosoftAuthPageHandler.getRemote();return instance$x=new MicrosoftAuthProxyImpl(handler)}static setInstance(obj){instance$x=obj}}let instance$x=null;const MicrosoftAuthModuleElementBase=I18nMixinLit(CrLitElement);class MicrosoftAuthModuleElement extends MicrosoftAuthModuleElementBase{static get is(){return"ntp-microsoft-authentication-module"}static get styles(){return getCss$n()}render(){return getHtml$o.bind(this)()}handler_;constructor(){super();this.handler_=MicrosoftAuthProxyImpl.getInstance().handler}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18n("modulesMicrosoftAuthDismiss")},{action:"disable",icon:"modules:block",text:this.i18n("modulesMicrosoftAuthDisable")}]}onDisableButtonClick_(){const disableEvent=new CustomEvent("disable-module",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("disableModuleToastMessage",loadTimeData.getString("modulesMicrosoftAuthName"))}});this.dispatchEvent(disableEvent)}onDismissButtonClick_(){this.handler_.dismissModule();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("dismissModuleToastMessage",loadTimeData.getString("modulesMicrosoftAuthName")),restoreCallback:()=>this.handler_.restoreModule()}}))}onSignInClick_(){const proxyInstance=ParentTrustedDocumentProxy.getInstance();if(proxyInstance){proxyInstance.getChildDocument().acquireTokenPopup();recordEnumeration(`NewTabPage.MicrosoftAuth.AuthStarted`,AuthType.kPopup,AuthType.MAX_VALUE+1)}}}customElements.define(MicrosoftAuthModuleElement.is,MicrosoftAuthModuleElement);async function createMicrosoftAuthElement(){const{show:show}=await MicrosoftAuthProxyImpl.getInstance().handler.shouldShowModule();if(!show){return null}else{return new MicrosoftAuthModuleElement}}const microsoftAuthModuleDescriptor=new ModuleDescriptor("microsoft_authentication",createMicrosoftAuthElement);let instance$w=null;function getCss$m(){return instance$w||(instance$w=[...[],css`:host{--cr-chip-border-radius:8px;--cr-chip-color:var(--color-chip-foreground,var(--cr-fallback-color-on-surface));--cr-chip-font-size:12px;--cr-chip-height:28px}button{--cr-icon-button-margin-start:0;--cr-icon-color:var(--color-chip-icon,var(--cr-fallback-color-primary));--cr-icon-ripple-margin:0;--cr-icon-ripple-size:16px;--cr-icon-size:contain;--iron-icon-fill-color:var(--color-chip-icon,var(--cr-fallback-color-primary));--iron-icon-height:16px;--iron-icon-width:16px;align-items:center;appearance:none;background-color:transparent;border:1px solid var(--color-chip-border,var(--cr-fallback-color-tonal-outline));border-radius:var(--cr-chip-border-radius);color:var(--cr-chip-color);cursor:pointer;font-family:inherit;display:flex;flex-direction:row;font-size:var(--cr-chip-font-size);font-weight:500;gap:4px;height:var(--cr-chip-height);overflow:hidden;padding:0 8px;position:relative;white-space:nowrap}button:not(:is([disabled],[selected])):hover{background-color:transparent;border-color:var(--color-chip-border,var(--cr-fallback-color-tonal-outline))}button:focus-visible{outline:solid 2px var(--cr-focus-outline-color);outline-offset:2px}button[disabled]{cursor:default;opacity:var(--cr-disabled-opacity)}button[selected]{--cr-icon-color:var(--color-chip-icon-selected,var(--cr-fallback-color-on-tonal-container));--iron-icon-fill-color:var(--color-chip-icon-selected,var(--cr-fallback-color-on-tonal-container));background-color:var(--color-chip-background-selected,var(--cr-fallback-color-tonal-container));border-color:var(--color-chip-background-selected,var(--cr-fallback-color-tonal-container));color:var(--color-chip-foreground-selected,var(--cr-fallback-color-on-tonal-container));padding:0 8px}#hoverLayer{display:none}button:hover #hoverLayer{background:var(--cr-hover-on-subtle-background-color);display:block;inset:0;pointer-events:none;position:absolute}#ink{--paper-ripple-opacity:1;color:var(--cr-active-neutral-on-subtle-background-color);display:block}`])}function getHtml$n(){return html`
<button id="button" ?selected="${this.selected}"
    ?disabled="${this.disabled}" aria-pressed="${this.selected}"
    role="${this.chipRole}" aria-label="${this.chipAriaLabel}">
  <div id="hoverLayer"></div>
  <slot></slot>
</button>`}const CrChipElementBase=CrRippleMixin(CrLitElement);class CrChipElement extends CrChipElementBase{static get is(){return"cr-chip"}static get styles(){return getCss$m()}render(){return getHtml$n.bind(this)()}static get properties(){return{disabled:{type:Boolean},chipAriaLabel:{type:String},chipRole:{type:String},selected:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#chipAriaLabel_accessor_storage="";get chipAriaLabel(){return this.#chipAriaLabel_accessor_storage}set chipAriaLabel(value){this.#chipAriaLabel_accessor_storage=value}#chipRole_accessor_storage="";get chipRole(){return this.#chipRole_accessor_storage}set chipRole(value){this.#chipRole_accessor_storage=value}#selected_accessor_storage=false;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}constructor(){super();this.ensureRippleOnPointerdown()}createRipple(){this.rippleContainer=this.shadowRoot.querySelector("button");return super.createRipple()}}customElements.define(CrChipElement.is,CrChipElement);let instance$v=null;function getCss$l(){return instance$v||(instance$v=[...[getCss$s(),getCss$r()],css`:host([expanded]) #header{color:var(--color-new-tab-page-primary-foreground);font-weight:500;overflow:hidden}#header{box-sizing:border-box;column-gap:4px;color:var(--color-new-tab-page-secondary-foreground);display:flex;font-size:var(--ntp-module-text-size);line-height:var(--ntp-module-line-height);padding:4px 16px;position:relative;text-decoration:none;width:100%}#header #hoverContainer{background:var(--color-new-tab-page-module-item-background-hovered);display:none;height:100%;inset:0;position:absolute;width:100%}#header:hover #hoverContainer{display:block}:host-context(.focus-outline-visible) #header:focus,#header:focus-visible{box-shadow:var(--ntp-focus-shadow);outline:none}@media (forced-colors:active){:host-context(.focus-outline-visible) #header:focus,#header:focus-visible{outline:var(--cr-border-hcm)}}#startTime{display:inline-block;flex-shrink:0;position:relative;width:56px}#title{flex-grow:1;overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap}#timeStatus{background-color:var(--color-new-tab-page-module-calendar-event-time-status-background);border-radius:100px;color:var(--color-new-tab-page-secondary-foreground);display:inline-block;flex-basis:content;flex-shrink:0;font-size:var(--ntp-module-secondary-text-size);font-weight:400;line-height:var(--ntp-module-secondary-line-height);padding:2px 8px;position:relative}.cr-icon{--cr-icon-color:var(--color-new-tab-page-secondary-foreground);--cr-icon-size:18px;height:20px;margin:0;width:20px}#expandedInfo{padding:0 16px}#location{padding:4px 0}#attachments,#attachmentList,#location{column-gap:8px;display:flex;width:100%}#location-icon{--cr-icon-image:url(modules/calendar/icons/location.svg)}#location p{color:var(--color-new-tab-page-secondary-foreground);font-size:12px;line-height:var(--ntp-module-secondary-line-height);margin:0;overflow:hidden;padding:2px 0;text-overflow:ellipsis;white-space:nowrap}#attachments{position:relative}#attachmentList.scrollable-right{mask-image:linear-gradient(to right,black calc(100% - 16px),transparent 100%)}#attachmentList.scrollable-left{mask-image:linear-gradient(to right,transparent 0,black 16px)}#attachmentList.scrollable{mask-image:linear-gradient(to right,transparent 0,black 16px,black calc(100% - 16px),transparent 100%)}#attachmentList{margin-inline-end:-4px;overflow-x:auto;overflow-y:hidden;padding:4px}#attachmentList::-webkit-scrollbar{background:transparent;height:8px}#attachmentList::-webkit-scrollbar-thumb{background:var(--color-new-tab-page-module-calendar-attachment-scrollbar-thumb);background-clip:content-box;border:solid 1.5px transparent;border-radius:100px}#attachment-icon{--cr-icon-image:url(modules/v2/calendar/icons/attachment.svg);margin:6px -4px 6px 0}#attachments cr-chip{--cr-chip-color:var(--color-new-tab-page-link);--cr-chip-border-radius:100px;--cr-chip-font-size:var(--ntp-module-secondary-text-size);--cr-chip-height:24px}#attachments cr-chip[disabled]{--cr-disabled-opacity:1;--cr-chip-color:var(--color-sys-state-disabled);--color-chip-border:var(--color-sys-neutral-outline);--cr-fallback-color-tonal-outline:var(--cr-fallback-color-neutral-outline)}#attachments img{height:14px;width:14px}.attachment-text{max-width:13ch;overflow:hidden;text-overflow:ellipsis}#conference{margin-bottom:4px;margin-top:8px}`])}function getHtml$m(){return html`<!--_html_template_start_--><a id="header" href="${this.event.url.url}" @click="${this.recordHeaderClick_}"
    title="${this.event.title}">
  <div id="hoverContainer"></div>
  <span id="startTime">${this.formattedStartTime_}</span>
  <span id="title">${this.event.title}</span>
  <span id="timeStatus" ?hidden="${!this.timeStatus_}">
    ${this.timeStatus_}
  </span>
</a>
${this.expanded?html`
  <div id="expandedInfo">
    <div id="location" ?hidden="${!this.showLocation_()}">
      <div id="location-icon" class="cr-icon"></div>
      <p>${this.event.location}</p>
    </div>
    <div id="attachments" ?hidden="${!this.showAttachments_()}">
      <div id="attachment-icon" class="cr-icon"></div>
      <div id="attachmentList" class="${this.attachmentListClass_}">
        ${this.event.attachments.map(((item,index)=>html`
          <cr-chip data-index="${index}" @click="${this.openAttachment_}"
              chip-role="link" class="attachment" title="${item.title}"
              ?disabled="${this.isAttachmentDisabled_(index)}">
            <img is="cr-auto-img" auto-src="${item.iconUrl.url}" alt="">
            <div class="attachment-text">${item.title}</div>
          </cr-chip>
        `))}
      </div>
    </div>
    <div id="conference" ?hidden="${!this.showConferenceButton_()}">
      <cr-button role="link"
          @click="${this.openVideoConference_}"
          class="action-button"
          aria-label="${this.i18n("modulesCalendarJoinMeetingButtonAcc",this.event.title)}">
        $i18n{modulesCalendarJoinMeetingButtonText}
      </cr-button>
    </div>
  </div>
`:""}
<!--_html_template_end_-->`}const kWindowsToUnixEpochOffset=11644473600000000n;var CalendarAction;(function(CalendarAction){CalendarAction[CalendarAction["EXPANDED_EVENT_HEADER_CLICKED"]=0]="EXPANDED_EVENT_HEADER_CLICKED";CalendarAction[CalendarAction["DOUBLE_BOOKED_EVENT_HEADER_CLICKED"]=1]="DOUBLE_BOOKED_EVENT_HEADER_CLICKED";CalendarAction[CalendarAction["BASIC_EVENT_HEADER_CLICKED"]=2]="BASIC_EVENT_HEADER_CLICKED";CalendarAction[CalendarAction["ATTACHMENT_CLICKED"]=3]="ATTACHMENT_CLICKED";CalendarAction[CalendarAction["CONFERENCE_CALL_CLICKED"]=4]="CONFERENCE_CALL_CLICKED";CalendarAction[CalendarAction["SEE_MORE_CLICKED"]=5]="SEE_MORE_CLICKED";CalendarAction[CalendarAction["MAX_VALUE"]=5]="MAX_VALUE"})(CalendarAction||(CalendarAction={}));function recordCalendarAction(action,moduleName){recordEnumeration(`NewTabPage.${moduleName}.UserAction`,action,CalendarAction.MAX_VALUE+1)}function toJsTimestamp(time){return Number((time.internalValue-kWindowsToUnixEpochOffset)/1000n)}const kAttachmentScrollFadeBuffer=4;const kMillisecondsInMinute=6e4;const kMinutesInHour=60;const CalendarEventElementBase=I18nMixinLit(CrLitElement);class CalendarEventElement extends CalendarEventElementBase{static get is(){return"ntp-calendar-event"}static get styles(){return getCss$l()}render(){return getHtml$m.bind(this)()}static get properties(){return{doubleBooked:{type:Boolean},event:{type:Object},expanded:{type:Boolean,reflect:true},index:{type:Number},moduleName:{type:String},attachmentListClass_:{type:String},formattedStartTime_:{type:String},timeStatus_:{type:String}}}#doubleBooked_accessor_storage=false;get doubleBooked(){return this.#doubleBooked_accessor_storage}set doubleBooked(value){this.#doubleBooked_accessor_storage=value}#event_accessor_storage={title:"",startTime:{internalValue:BigInt(0)},endTime:{internalValue:BigInt(0)},url:{url:""},attachments:[],location:null,conferenceUrl:null,isAccepted:false,hasOtherAttendee:false};get event(){return this.#event_accessor_storage}set event(value){this.#event_accessor_storage=value}#expanded_accessor_storage=false;get expanded(){return this.#expanded_accessor_storage}set expanded(value){this.#expanded_accessor_storage=value}#index_accessor_storage=-1;get index(){return this.#index_accessor_storage}set index(value){this.#index_accessor_storage=value}#moduleName_accessor_storage="";get moduleName(){return this.#moduleName_accessor_storage}set moduleName(value){this.#moduleName_accessor_storage=value}#attachmentListClass__accessor_storage="";get attachmentListClass_(){return this.#attachmentListClass__accessor_storage}set attachmentListClass_(value){this.#attachmentListClass__accessor_storage=value}#formattedStartTime__accessor_storage="";get formattedStartTime_(){return this.#formattedStartTime__accessor_storage}set formattedStartTime_(value){this.#formattedStartTime__accessor_storage=value}intersectionObserver_=null;#timeStatus__accessor_storage="";get timeStatus_(){return this.#timeStatus__accessor_storage}set timeStatus_(value){this.#timeStatus__accessor_storage=value}updated(changedProperties){if((changedProperties.has("event")||changedProperties.has("expanded"))&&(this.expanded&&this.showAttachments_())){const attachmentList=this.renderRoot.querySelector("#attachmentList");if(attachmentList&&attachmentList.children.length>1){const attachments=attachmentList.children;this.intersectionObserver_=new IntersectionObserver((()=>this.updateAttachmentListClass_()),{root:attachmentList,threshold:1});const firstAttachment=attachments[0];assert(firstAttachment);this.intersectionObserver_.observe(firstAttachment);const lastAttachment=attachments[attachments.length-1];assert(lastAttachment);this.intersectionObserver_.observe(lastAttachment)}}}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("event")){this.formattedStartTime_=this.computeFormattedStartTime_()}if(changedProperties.has("event")||changedProperties.has("expanded")){this.timeStatus_=this.computeTimeStatus_()}}computeFormattedStartTime_(){const offsetDate=toJsTimestamp(this.event.startTime);const dateObj=new Date(offsetDate);let timeStr=Intl.DateTimeFormat(undefined,{timeStyle:"short"}).format(dateObj);timeStr=timeStr.replace(" AM","am").replace(" PM","pm");return timeStr}computeTimeStatus_(){if(!this.expanded){return""}const startTime=toJsTimestamp(this.event.startTime);const now=WindowProxy.getInstance().now().valueOf();const minutesUntilMeeting=Math.round((startTime-now)/kMillisecondsInMinute);if(minutesUntilMeeting<=0){return this.i18n("modulesCalendarInProgress")}if(minutesUntilMeeting<kMinutesInHour){return this.i18n("modulesCalendarInXMin",minutesUntilMeeting.toString())}const hoursUntilMeeting=minutesUntilMeeting/kMinutesInHour;return this.i18n("modulesCalendarInXHr",Math.round(hoursUntilMeeting).toString())}isAttachmentDisabled_(index){const attachment=this.event.attachments[index];assert(attachment);return!attachment.resourceUrl?.url}openAttachment_(e){this.dispatchEvent(new Event("usage",{composed:true,bubbles:true}));recordCalendarAction(CalendarAction.ATTACHMENT_CLICKED,this.moduleName);const currentTarget=e.currentTarget;const index=Number(currentTarget.dataset["index"]);assert(this.event.attachments[index]);const resourceUrl=this.event.attachments[index].resourceUrl?.url;if(resourceUrl){WindowProxy.getInstance().navigate(resourceUrl)}}openVideoConference_(){this.dispatchEvent(new Event("usage",{composed:true,bubbles:true}));recordCalendarAction(CalendarAction.CONFERENCE_CALL_CLICKED,this.moduleName);WindowProxy.getInstance().navigate(this.event.conferenceUrl.url)}recordHeaderClick_(){this.dispatchEvent(new Event("usage",{composed:true,bubbles:true}));let action=CalendarAction.BASIC_EVENT_HEADER_CLICKED;if(this.expanded){action=CalendarAction.EXPANDED_EVENT_HEADER_CLICKED}else if(this.doubleBooked){action=CalendarAction.DOUBLE_BOOKED_EVENT_HEADER_CLICKED}recordCalendarAction(action,this.moduleName);recordSmallCount(`NewTabPage.${this.moduleName}.EventClickIndex`,this.index)}showConferenceButton_(){return!!this.event.conferenceUrl?.url}showAttachments_(){return this.event.attachments.length>0}showLocation_(){return!!this.event.location}updateAttachmentListClass_(){const attachmentList=this.renderRoot.querySelector("#attachmentList");if(!attachmentList){this.attachmentListClass_="";return}const scrollableRight=attachmentList.scrollWidth-attachmentList.scrollLeft-kAttachmentScrollFadeBuffer>attachmentList.clientWidth;const scrollableLeft=attachmentList.scrollLeft-kAttachmentScrollFadeBuffer>0;if(scrollableRight&&scrollableLeft){this.attachmentListClass_="scrollable"}else if(scrollableRight){this.attachmentListClass_="scrollable-right"}else if(scrollableLeft){this.attachmentListClass_="scrollable-left"}else{this.attachmentListClass_=""}}}customElements.define(CalendarEventElement.is,CalendarEventElement);let instance$u=null;function getCss$k(){return instance$u||(instance$u=[...[],css`:host{--calendar-event-group-gutter-size:8px;display:block;padding:0 8px}.row,.divider{background-color:var(--color-new-tab-page-module-item-background);box-sizing:border-box;display:block;width:100%}.row:first-child,.row[expanded]+.row:not([double-booked]),.row[double-booked]+.row:not([double-booked]),.row[expanded]{border-top-left-radius:12px;border-top-right-radius:12px;margin-top:8px;padding-top:var(--calendar-event-group-gutter-size)}.row:last-child,.row[double-booked]:has(+.row:not([double-booked])),.row[expanded]:has(+.row),.row:has(+.row[expanded]){border-bottom-left-radius:12px;border-bottom-right-radius:12px;margin-bottom:8px;padding-bottom:var(--calendar-event-group-gutter-size)}.row[expanded]{padding-bottom:var(--calendar-event-group-gutter-size)}.divider+.row[double-booked]{padding-top:var(--calendar-event-group-gutter-size)}.divider{padding:0 16px}hr{background:var(--color-side-panel-divider);border:none;height:1px;margin:0}#seeMore a{box-sizing:border-box;color:var(--color-new-tab-page-link);display:block;font-size:var(--ntp-module-text-size);font-weight:var(--ntp-module-see-more-font-weight);line-height:var(--ntp-module-line-height);overflow:hidden;padding:4px 16px;position:relative;text-decoration:none;width:100%}#seeMore #hoverContainer{background:var(--color-new-tab-page-module-item-background-hovered);display:none;height:100%;inset:0;position:absolute;width:100%}#seeMore:hover #hoverContainer{display:block}:host-context(.focus-outline-visible) a:focus,a:focus-visible{box-shadow:var(--ntp-focus-shadow);outline:none}@media (forced-colors:active){:host-context(.focus-outline-visible) a:focus,a:focus-visible{outline:var(--cr-border-hcm)}.row{border-color:var(--cr-border-hcm);border-style:none solid;border-width:2px}ntp-calendar-event:first-of-type,.row[double-booked]+.row,.row[expanded]+.row{border-style:solid solid none}.row:last-child,.row:has(+.row[double-booked]),.row:has(+.row[expanded]){border-style:none solid solid}.row[double-booked],.row[expanded]{border-style:solid}}`])}function getHtml$l(){return html`<!--_html_template_start_-->${this.events.map(((item,index)=>html`
  <ntp-calendar-event
      class="row"
      ?double-booked="${this.isDoubleBooked_(index)?"double-booked":""}"
      ?expanded="${this.isExpanded_(index)}"
      .event="${item}"
      .index="${index}"
      .moduleName="${this.moduleName}">
  </ntp-calendar-event>
  ${this.isExpanded_(index)&&this.hasDoubleBooked_()?html`
    <div class="divider"><hr></hr></div>
  `:""}
`))}
<div id="seeMore" class="row">
  <a href="${this.calendarLink}" @click="${this.recordSeeMoreClick_}"
      aria-label="$i18n{modulesCalendarSeeMoreAcc}">
    $i18n{modulesCalendarSeeMore}
    <div id="hoverContainer"></div>
  </a>
</div>
<!--_html_template_end_-->`}class CalendarElement extends CrLitElement{static get is(){return"ntp-calendar"}static get styles(){return getCss$k()}render(){return getHtml$l.bind(this)()}static get properties(){return{calendarLink:{type:String},events:{type:Array},moduleName:{type:String},doubleBookedIndices_:{type:Array},expandedEventIndex_:{type:Number}}}#calendarLink_accessor_storage="";get calendarLink(){return this.#calendarLink_accessor_storage}set calendarLink(value){this.#calendarLink_accessor_storage=value}#events_accessor_storage=[];get events(){return this.#events_accessor_storage}set events(value){this.#events_accessor_storage=value}#moduleName_accessor_storage="";get moduleName(){return this.#moduleName_accessor_storage}set moduleName(value){this.#moduleName_accessor_storage=value}#doubleBookedIndices__accessor_storage=[];get doubleBookedIndices_(){return this.#doubleBookedIndices__accessor_storage}set doubleBookedIndices_(value){this.#doubleBookedIndices__accessor_storage=value}#expandedEventIndex__accessor_storage=-1;get expandedEventIndex_(){return this.#expandedEventIndex__accessor_storage}set expandedEventIndex_(value){this.#expandedEventIndex__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("events")){recordSmallCount(`NewTabPage.${this.moduleName}.ShownEvents`,this.events.length);this.expandedEventIndex_=this.computeExpandedEventIndex_();if(this.expandedEventIndex_!==-1){this.sortEvents_();this.doubleBookedIndices_=this.computeDoubleBookedIndices_()}}}computeDoubleBookedIndices_(){const results=[];const expandedEvent=this.events[this.expandedEventIndex_];assert(expandedEvent);for(let i=this.expandedEventIndex_+1;i<this.events.length;i++){if(this.events[i].startTime.internalValue===expandedEvent.startTime.internalValue){results.push(i)}else{break}}return results}compareEventPriority_(eventAIndex,eventBIndex,soon){const eventA=this.events[eventAIndex];assert(eventA);const eventB=this.events[eventBIndex];assert(eventB);const eventAStartTime=toJsTimestamp(eventA.startTime);const eventBStartTime=toJsTimestamp(eventB.startTime);const eventAInProgress=eventAStartTime<=soon;const eventBInProgress=eventBStartTime<=soon;if(eventAInProgress!==eventBInProgress){return+eventBInProgress-+eventAInProgress}const eventAEndsSoon=toJsTimestamp(eventA.endTime)<=soon;const eventBEndsSoon=toJsTimestamp(eventB.endTime)<=soon;if(eventAEndsSoon!==eventBEndsSoon){return+eventAEndsSoon-+eventBEndsSoon}if(!eventAInProgress&&!eventBInProgress&&eventAStartTime!==eventBStartTime){return eventAStartTime-eventBStartTime}if(eventA.isAccepted!==eventB.isAccepted){return+eventB.isAccepted-+eventA.isAccepted}if(eventA.hasOtherAttendee!==eventB.hasOtherAttendee){return+eventB.hasOtherAttendee-+eventA.hasOtherAttendee}return eventAIndex-eventBIndex}computeExpandedEventIndex_(){const now=WindowProxy.getInstance().now();let expandableEventIndices=this.events.map(((_,i)=>i));expandableEventIndices=expandableEventIndices.filter((eventIndex=>{const expandableEvent=this.events[eventIndex];return toJsTimestamp(expandableEvent.endTime)>now}));if(expandableEventIndices.length===0){return-1}const in5Minutes=now+5*60*1e3;expandableEventIndices.sort(((a,b)=>this.compareEventPriority_(a,b,in5Minutes)));return expandableEventIndices[0]}hasDoubleBooked_(){return this.doubleBookedIndices_.length>0}isDoubleBooked_(index){return this.doubleBookedIndices_.includes(index)}isExpanded_(index){return index===this.expandedEventIndex_}recordSeeMoreClick_(){this.dispatchEvent(new Event("usage",{composed:true,bubbles:true}));recordCalendarAction(CalendarAction.SEE_MORE_CLICKED,this.moduleName)}sortEvents_(){const expandedEvent=this.events[this.expandedEventIndex_];assert(expandedEvent);const firstDoubleBookedEventIndex=this.events.findIndex((calendarEvent=>calendarEvent.startTime.internalValue===expandedEvent.startTime.internalValue));if(firstDoubleBookedEventIndex<this.expandedEventIndex_){this.events.splice(this.expandedEventIndex_,1);this.expandedEventIndex_=firstDoubleBookedEventIndex;this.events.splice(this.expandedEventIndex_,0,expandedEvent)}}}customElements.define(CalendarElement.is,CalendarElement);function getHtml$k(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="$i18n{modulesGoogleCalendarTitle}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="$i18n{modulesGoogleCalendarMoreActions}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<ntp-calendar id="calendar"
    .events="${this.events_}"
    calendar-link="https://calendar.google.com"
    module-name="GoogleCalendar">
</ntp-calendar>
${this.showInfoDialog_?html`
  <ntp-info-dialog show-on-attach
      .innerHTML="${this.i18nAdvanced("moduleGoogleCalendarInfo")}"
      @close="${this.onInfoDialogClose_}">
  </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}class GoogleCalendarProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){return instance$t||(instance$t=new GoogleCalendarProxyImpl(GoogleCalendarPageHandler.getRemote()))}static setInstance(newInstance){instance$t=newInstance}}let instance$t=null;const GoogleCalendarModuleElementBase=I18nMixinLit(CrLitElement);class GoogleCalendarModuleElement extends GoogleCalendarModuleElementBase{static get is(){return"ntp-google-calendar-module"}render(){return getHtml$k.bind(this)()}static get properties(){return{events_:{type:Object},showInfoDialog_:{type:Boolean}}}#events__accessor_storage=[];get events_(){return this.#events__accessor_storage}set events_(value){this.#events__accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}handler_;constructor(events){super();this.handler_=GoogleCalendarProxyImpl.getInstance().handler;this.events_=events}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForHoursButtonText","calendarModuleDismissHours")},{action:"disable",icon:"modules:block",text:this.i18n("modulesGoogleCalendarDisableButtonText")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}onDisableButtonClick_(){const disableEvent=new CustomEvent("disable-module",{composed:true,detail:{message:this.i18n("modulesGoogleCalendarDisableToastMessage")}});this.dispatchEvent(disableEvent)}onDismissButtonClick_(){this.handler_.dismissModule();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:this.i18n("modulesGoogleCalendarDismissToastMessage"),restoreCallback:()=>this.handler_.restoreModule()}}))}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}}customElements.define(GoogleCalendarModuleElement.is,GoogleCalendarModuleElement);async function createGoogleCalendarElement(){const{events:events}=await GoogleCalendarProxyImpl.getInstance().handler.getEvents();return events.length>0?new GoogleCalendarModuleElement(events):null}const googleCalendarDescriptor=new ModuleDescriptor("google_calendar",createGoogleCalendarElement);function getHtml$j(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="$i18n{modulesOutlookCalendarTitle}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesOutlookCalendarTitle")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}"
    @signout-button-click="${this.onSignOutButtonClick_}">
</ntp-module-header-v2>
<ntp-calendar id="outlook-calendar"
    .events="${this.events_}"
    module-name="OutlookCalendar"
    calendar-link="https://outlook.office.com/calendar/">
</ntp-calendar>
${this.showInfoDialog_?html`
   <ntp-info-dialog show-on-attach
       .innerHTML="${this.i18nAdvanced("modulesOutlookCalendarInfo")}"
       @close="${this.onInfoDialogClose_}">
   </ntp-info-dialog>
 `:""}
<!--_html_template_end_-->`}class OutlookCalendarProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){return instance$s||(instance$s=new OutlookCalendarProxyImpl(OutlookCalendarPageHandler.getRemote()))}static setInstance(newInstance){instance$s=newInstance}}let instance$s=null;const OutlookCalendarModuleElementBase=I18nMixinLit(CrLitElement);class OutlookCalendarModuleElement extends OutlookCalendarModuleElementBase{static get is(){return"ntp-outlook-calendar-module"}render(){return getHtml$j.bind(this)()}static get properties(){return{events_:{type:Object},showInfoDialog_:{type:Boolean}}}#events__accessor_storage=[];get events_(){return this.#events__accessor_storage}set events_(value){this.#events__accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}handler_;constructor(events){super();this.handler_=OutlookCalendarProxyImpl.getInstance().handler;this.events_=events}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForHoursButtonText","calendarModuleDismissHours")},{action:"disable",icon:"modules:block",text:this.i18n("modulesOutlookCalendarDisableButtonText")},{action:"signout",icon:"modules:logout",text:this.i18n("modulesMicrosoftSignOutButtonText")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}onDisableButtonClick_(){const disableEvent=new CustomEvent("disable-module",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("disableModuleToastMessage",loadTimeData.getString("modulesOutlookCalendarTitle"))}});this.dispatchEvent(disableEvent)}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}onDismissButtonClick_(){this.handler_.dismissModule();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:this.i18n("modulesOutlookCalendarDismissToastMessage"),restoreCallback:()=>this.handler_.restoreModule()}}))}onSignOutButtonClick_(){ParentTrustedDocumentProxy.getInstance()?.getChildDocument().signOut()}}customElements.define(OutlookCalendarModuleElement.is,OutlookCalendarModuleElement);async function createOutlookCalendarElement(){const{events:events}=await OutlookCalendarProxyImpl.getInstance().handler.getEvents();return events.length>0?new OutlookCalendarModuleElement(events):null}const outlookCalendarDescriptor=new ModuleDescriptor("outlook_calendar",createOutlookCalendarElement);let instance$r=null;function getCss$j(){return instance$r||(instance$r=[...[],css`cr-dialog::part(dialog){max-width:100%;position:fixed}cr-dialog [slot='body']{line-height:20px}`])}function getHtml$i(){return html`<!--_html_template_start_--><cr-dialog id="dialog" consume-keydown-event
    ?show-on-attach="${this.showOnAttach}">
  <div slot="title">$i18n{modulesTasksInfoTitle}</div>
  <div slot="body">
    <slot></slot>
  </div>
  <div slot="button-container">
    <cr-button id="closeButton" class="action-button"
        @click="${this.onCloseClick_}">
      $i18n{modulesTasksInfoClose}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}class InfoDialogElement extends CrLitElement{static get is(){return"ntp-info-dialog"}static get styles(){return getCss$j()}render(){return getHtml$i.bind(this)()}static get properties(){return{showOnAttach:{type:Boolean}}}#showOnAttach_accessor_storage=false;get showOnAttach(){return this.#showOnAttach_accessor_storage}set showOnAttach(value){this.#showOnAttach_accessor_storage=value}showModal(){this.$.dialog.showModal()}onCloseClick_(){this.$.dialog.close()}}customElements.define(InfoDialogElement.is,InfoDialogElement);let instance$q=null;function getCss$i(){return instance$q||(instance$q=[...[],css`@media (forced-colors:active){a{border-radius:var(--ntp-module-item-border-radius);outline:var(--cr-border-hcm)}.file{overflow:visible}}:host-context(.focus-outline-visible) a:focus,a:focus-visible{box-shadow:var(--ntp-focus-shadow);outline:none}#files{background-color:var(--color-new-tab-page-module-item-background);border-radius:var(--ntp-module-item-border-radius);margin:8px}.file{align-items:center;display:flex;height:56px;position:relative;text-decoration:none;overflow:hidden}.file:hover #hover-layer{background:var(--color-new-tab-page-module-item-background-hovered);display:block;inset:0;pointer-events:none;position:absolute}#hover-layer{display:none}.file:first-of-type{border-radius:var(--ntp-module-item-border-radius) var(--ntp-module-item-border-radius) 0 0;padding-top:var(--ntp-module-first-element-top-padding)}.file:last-of-type{border-radius:0 0 var(--ntp-module-item-border-radius) var(--ntp-module-item-border-radius);padding-bottom:var(--ntp-module-first-element-top-padding)}.icon-container{align-items:center;background-color:var(--color-new-tab-page-module-icon-background);border-radius:8px;display:flex;flex-shrink:0;height:var(--ntp-module-icon-size);justify-content:center;margin-inline:8px;position:relative;width:var(--ntp-module-icon-size)}.file-icon{height:24px;width:24px}.file-info{min-width:0;padding-inline-end:16px}.file-title,.file-description{overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap}.file-title{color:var(--color-new-tab-page-primary-foreground);font-size:var(--ntp-module-text-size);line-height:var(--ntp-module-line-height)}.file-description{color:var(--color-new-tab-page-secondary-foreground);font-size:var(--ntp-module-secondary-text-size);line-height:var(--ntp-module-secondary-line-height)}`])}function getHtml$h(){return html`<!--_html_template_start_--><div id="files">
  ${this.files.map(((item,index)=>html`
    <a class="file" href="${item.itemUrl.url}" data-index="${index}"
        @click="${this.onFileClick_}" title="${item.title}">
      <div id="hover-layer"></div>
      <icon-container class="icon-container">
        <img is="cr-auto-img"
          class="file-icon"
          draggable="false"
          .autoSrc="${item.iconUrl.url}">
      </icon-container>
      <div class="file-info">
        <div class="file-title">${item.title}</div>
        <div class="file-description">${item.justificationText}</div>
      </div>
    </a>
  `))}
</div>
<!--_html_template_end_-->`}class FileSuggestionElement extends CrLitElement{static get is(){return"ntp-file-suggestion"}static get styles(){return getCss$i()}render(){return getHtml$h.bind(this)()}static get properties(){return{files:{type:Array},moduleName:{type:String}}}#files_accessor_storage=[];get files(){return this.#files_accessor_storage}set files(value){this.#files_accessor_storage=value}#moduleName_accessor_storage="";get moduleName(){return this.#moduleName_accessor_storage}set moduleName(value){this.#moduleName_accessor_storage=value}onFileClick_(e){const clickFileEvent=new Event("usage",{composed:true,bubbles:true});this.dispatchEvent(clickFileEvent);const currentTarget=e.currentTarget;const index=Number(currentTarget.dataset["index"]);recordSmallCount(`NewTabPage.${this.moduleName}.FileClick`,index);const file=this.files[index];assert(file);if(file.recommendationType!==null){recordEnumeration(`NewTabPage.${this.moduleName}.RecommendationTypeClick`,file.recommendationType,RecommendationType.MAX_VALUE+1)}}}customElements.define(FileSuggestionElement.is,FileSuggestionElement);function getHtml$g(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="$i18n{modulesDriveTitleV2}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesDriveSentence")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<ntp-file-suggestion id="fileSuggestion"
    module-name="Drive"
    .files="${this.files}">
  </ntp-file-suggestion>
${this.showInfoDialog_?html`
  <ntp-info-dialog show-on-attach
      .innerHTML="${this.i18nAdvanced("modulesDriveInfo")}"
      @close="${this.onInfoDialogClose_}">
  </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}let handler=null;class FileProxy{static getHandler(){return handler||(handler=DriveSuggestionHandler.getRemote())}static setHandler(newHandler){handler=newHandler}constructor(){}}const DriveModuleElementBase=I18nMixinLit(CrLitElement);class DriveModuleElement extends DriveModuleElementBase{static get is(){return"ntp-drive-module-redesigned"}render(){return getHtml$g.bind(this)()}static get properties(){return{files:{type:Array},showInfoDialog_:{type:Boolean}}}#files_accessor_storage=[];get files(){return this.#files_accessor_storage}set files(value){this.#files_accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForHoursButtonText","fileSuggestionDismissHours")},{action:"disable",icon:"modules:block",text:this.i18n("modulesDriveDisableButtonTextV2")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}onDisableButtonClick_(){const disableEvent=new CustomEvent("disable-module",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("disableModuleToastMessage",loadTimeData.getString("modulesDriveSentence"))}});this.dispatchEvent(disableEvent)}onDismissButtonClick_(){FileProxy.getHandler().dismissModule();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("dismissModuleToastMessage",loadTimeData.getString("modulesFilesSentence")),restoreCallback:()=>FileProxy.getHandler().restoreModule()}}))}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}}customElements.define(DriveModuleElement.is,DriveModuleElement);async function createDriveElement(){const{files:files}=await FileProxy.getHandler().getFiles();if(files.length===0){return null}const element=new DriveModuleElement;element.files=files;return element}const driveModuleDescriptor=new ModuleDescriptor("drive",createDriveElement);function getHtml$f(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="$i18n{modulesMicrosoftFilesName}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesMicrosoftFilesName")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @signout-button-click="${this.onSignOutButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<!-- TODO(crbug.com/372725915): Render files and their icons. -->
<ntp-file-suggestion module-name="MicrosoftFiles"
    id="microsoft-files"
    .files="${this.files_}">
</ntp-file-suggestion>
${this.showInfoDialog_?html`
  <ntp-info-dialog show-on-attach
      .innerHTML="${this.i18nAdvanced("modulesMicrosoftFilesInfo")}"
      @close="${this.onInfoDialogClose_}">
  </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}class MicrosoftFilesProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){return instance$p||(instance$p=new MicrosoftFilesProxyImpl(MicrosoftFilesPageHandler.getRemote()))}static setInstance(newInstance){instance$p=newInstance}}let instance$p=null;const MicrosoftFilesModuleElementBase=I18nMixinLit(CrLitElement);class MicrosoftFilesModuleElement extends MicrosoftFilesModuleElementBase{static get is(){return"ntp-microsoft-files-module"}render(){return getHtml$f.bind(this)()}static get properties(){return{files_:{type:Array},showInfoDialog_:{type:Boolean}}}#files__accessor_storage=[];get files_(){return this.#files__accessor_storage}set files_(value){this.#files__accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}handler_;constructor(files){super();this.handler_=MicrosoftFilesProxyImpl.getInstance().handler;this.files_=files;this.recordFileTypesShown_(files)}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForHoursButtonText","fileSuggestionDismissHours")},{action:"disable",icon:"modules:block",text:this.i18n("modulesMicrosoftFilesDisableButtonText")},{action:"signout",icon:"modules:logout",text:this.i18n("modulesMicrosoftSignOutButtonText")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}onDisableButtonClick_(){const disableEvent=new CustomEvent("disable-module",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("disableModuleToastMessage",loadTimeData.getString("modulesMicrosoftFilesName"))}});this.dispatchEvent(disableEvent)}onDismissButtonClick_(){this.handler_.dismissModule();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:loadTimeData.getStringF("dismissModuleToastMessage",loadTimeData.getString("modulesFilesSentence")),restoreCallback:()=>this.handler_.restoreModule()}}))}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}onSignOutButtonClick_(){ParentTrustedDocumentProxy.getInstance()?.getChildDocument().signOut()}recordFileTypesShown_(files){const numOfFiles=new Map;numOfFiles.set(RecommendationType.kUsed,0);numOfFiles.set(RecommendationType.kShared,0);numOfFiles.set(RecommendationType.kTrending,0);for(let i=0;i<files.length;i++){const file=files[i];const recommendationType=file.recommendationType;if(recommendationType!==null){numOfFiles.set(recommendationType,numOfFiles.get(recommendationType)+1)}}recordSmallCount("NewTabPage.MicrosoftFiles.ShownFiles.Used",numOfFiles.get(RecommendationType.kUsed));recordSmallCount("NewTabPage.MicrosoftFiles.ShownFiles.Shared",numOfFiles.get(RecommendationType.kShared));recordSmallCount("NewTabPage.MicrosoftFiles.ShownFiles.Trending",numOfFiles.get(RecommendationType.kTrending))}}customElements.define(MicrosoftFilesModuleElement.is,MicrosoftFilesModuleElement);async function createMicrosoftFilesElement(){const{files:files}=await MicrosoftFilesProxyImpl.getInstance().handler.getFiles();return files.length>0?new MicrosoftFilesModuleElement(files):null}const microsoftFilesModuleDescriptor=new ModuleDescriptor("microsoft_files",createMicrosoftFilesElement);let instance$o=null;class ModuleRegistry{static getInstance(){return instance$o||(instance$o=new ModuleRegistry(descriptors))}static setInstance(newInstance){instance$o=newInstance}descriptors_;constructor(descriptors){this.descriptors_=descriptors}async initializeModules(timeout){const modulesIdNames=(await NewTabPageProxy.getInstance().handler.getModulesIdNames()).data;return this.initializeModulesHavingIds(modulesIdNames.map((m=>m.id)),timeout)}async initializeModulesHavingIds(modulesIds,timeout){const disabledIds=await new Promise(((resolve,_)=>{const callbackRouter=NewTabPageProxy.getInstance().callbackRouter;const listenerId=callbackRouter.setDisabledModules.addListener(((all,ids)=>{callbackRouter.removeListener(listenerId);resolve(all?this.descriptors_.map((({id:id})=>id)):ids)}));NewTabPageProxy.getInstance().handler.updateDisabledModules()}));const descriptorsMap=new Map(this.descriptors_.map((d=>[d.id,d])));const descriptors=modulesIds.filter((id=>!disabledIds.includes(id))).map((id=>descriptorsMap.get(id)));const orderedIds=(await NewTabPageProxy.getInstance().handler.getModulesOrder()).moduleIds;if(orderedIds.length>0){descriptors.sort(((a,b)=>{const aHasOrder=orderedIds.includes(a.id);const bHasOrder=orderedIds.includes(b.id);if(aHasOrder&&bHasOrder){return orderedIds.indexOf(a.id)-orderedIds.indexOf(b.id)}if(!aHasOrder&&bHasOrder){return 1}if(aHasOrder&&!bHasOrder){return-1}return 0}))}const elements=await Promise.all(descriptors.map((d=>d.initialize(timeout,true))));return elements.map(((e,i)=>({elements:e,descriptor:descriptors[i]}))).filter((m=>!!m.elements)).map((m=>({elements:Array.isArray(m.elements)?m.elements:[m.elements],descriptor:m.descriptor}))).filter((m=>m.elements.length!==0))}async initializeModuleById(id,timeout){const descriptor=this.descriptors_.find((d=>d.id===id));if(!descriptor){console.error("Missing descriptor for module id ",id);return null}const elements=await descriptor.initialize(timeout,false);if(!elements){return null}return{elements:Array.isArray(elements)?elements:[elements],descriptor:descriptor}}}const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`<cr-iconset name="tab_resumption" size="20">
  <svg>
    <defs>
      <g id="computer" viewBox="0 -960 960 960">
        <path d="M320-120v-80h80v-80H160q-33 0-56.5-23.5T80-360v-400q0-33 23.5-56.5T160-840h640q33 0 56.5 23.5T880-760v400q0 33-23.5 56.5T800-280H560v80h80v80H320ZM160-360h640v-400H160v400Zm0 0v-400 400Z">
        </path>
      </g>
      <g id="globe" viewBox="0 -960 960 960">
        <path d="M480-80q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm-40-82v-78q-33 0-56.5-23.5T360-320v-40L168-552q-3 18-5.5 36t-2.5 36q0 121 79.5 212T440-162Zm276-102q20-22 36-47.5t26.5-53q10.5-27.5 16-56.5t5.5-59q0-98-54.5-179T600-776v16q0 33-23.5 56.5T520-680h-80v80q0 17-11.5 28.5T400-560h-80v80h240q17 0 28.5 11.5T600-440v120h40q26 0 47 15.5t29 40.5Z">
        </path>
      </g>
      <g id="phone" viewBox="0 -960 960 960">
        <path d="M400-160h160v-40H400v40ZM280-40q-33 0-56.5-23.5T200-120v-720q0-33 23.5-56.5T280-920h400q33 0 56.5 23.5T760-840v720q0 33-23.5 56.5T680-40H280Zm0-200v120h400v-120H280Zm0-80h400v-400H280v400Zm0-480h400v-40H280v40Zm0 560v120-120Zm0-560v-40 40Z">
        </path>
      </g>
      <g id="tablet" viewBox="0 -960 960 960">
        <path d="M200-40q-33 0-56.5-23.5T120-120v-720q0-33 23.5-56.5T200-920h560q33 0 56.5 23.5T840-840v720q0 33-23.5 56.5T760-40H200Zm0-200v120h560v-120H200Zm200 80h160v-40H400v40ZM200-320h560v-400H200v400Zm0-480h560v-40H200v40Zm0 0v-40 40Zm0 560v120-120Z">
        </path>
      </g>
      <g id="automotive" viewBox="0 0 24 24">
        <path d="M6 19V20C6 20.2833 5.9 20.525 5.7 20.725C5.51667 20.9083 5.28333 21 5 21H4C3.71667 21 3.475 20.9083 3.275 20.725C3.09167 20.525 3 20.2833 3 20V12L5.1 6C5.2 5.7 5.375 5.45833 5.625 5.275C5.89167 5.09167 6.18333 5 6.5 5H17.5C17.8167 5 18.1 5.09167 18.35 5.275C18.6167 5.45833 18.8 5.7 18.9 6L21 12V20C21 20.2833 20.9 20.525 20.7 20.725C20.5167 20.9083 20.2833 21 20 21H19C18.7167 21 18.475 20.9083 18.275 20.725C18.0917 20.525 18 20.2833 18 20V19H6ZM5.8 10H18.2L17.15 7H6.85L5.8 10ZM5 12V17V12ZM7.5 16C7.91667 16 8.26667 15.8583 8.55 15.575C8.85 15.275 9 14.9167 9 14.5C9 14.0833 8.85 13.7333 8.55 13.45C8.26667 13.15 7.91667 13 7.5 13C7.08333 13 6.725 13.15 6.425 13.45C6.14167 13.7333 6 14.0833 6 14.5C6 14.9167 6.14167 15.275 6.425 15.575C6.725 15.8583 7.08333 16 7.5 16ZM16.5 16C16.9167 16 17.2667 15.8583 17.55 15.575C17.85 15.275 18 14.9167 18 14.5C18 14.0833 17.85 13.7333 17.55 13.45C17.2667 13.15 16.9167 13 16.5 13C16.0833 13 15.725 13.15 15.425 13.45C15.1417 13.7333 15 14.0833 15 14.5C15 14.9167 15.1417 15.275 15.425 15.575C15.725 15.8583 16.0833 16 16.5 16ZM5 17H19V12H5V17Z" fill="#444746">
        </path>
      </g>
      <g id="wearable" viewBox="0 0 14 20">
        <path d="M5.5 2H8.5C8.36667 2 8.15833 2 7.875 2C7.60833 2 7.31667 2 7 2C6.68333 2 6.38333 2 6.1 2C5.83333 2 5.63333 2 5.5 2ZM5.5 18C5.63333 18 5.83333 18 6.1 18C6.38333 18 6.68333 18 7 18C7.31667 18 7.60833 18 7.875 18C8.15833 18 8.36667 18 8.5 18H5.5ZM4 20L2.65 15.45C1.85 14.8167 1.20833 14.025 0.725 13.075C0.241667 12.125 2.38419e-07 11.1 2.38419e-07 10C2.38419e-07 8.9 0.241667 7.875 0.725 6.925C1.20833 5.975 1.85 5.18333 2.65 4.55L4 -4.76837e-07H10L11.35 4.55C12.15 5.18333 12.7917 5.975 13.275 6.925C13.7583 7.875 14 8.9 14 10C14 11.1 13.7583 12.125 13.275 13.075C12.7917 14.025 12.15 14.8167 11.35 15.45L10 20H4ZM7 15C8.38333 15 9.55833 14.5167 10.525 13.55C11.5083 12.5667 12 11.3833 12 10C12 8.61667 11.5083 7.44167 10.525 6.475C9.55833 5.49167 8.38333 5 7 5C5.61667 5 4.43333 5.49167 3.45 6.475C2.48333 7.44167 2 8.61667 2 10C2 11.3833 2.48333 12.5667 3.45 13.55C4.43333 14.5167 5.61667 15 7 15ZM5.1 3.25C5.43333 3.16667 5.75 3.1 6.05 3.05C6.36667 3 6.68333 2.975 7 2.975C7.31667 2.975 7.625 3 7.925 3.05C8.24167 3.1 8.56667 3.16667 8.9 3.25L8.5 2H5.5L5.1 3.25ZM5.5 18H8.5L8.9 16.75C8.56667 16.8333 8.24167 16.9 7.925 16.95C7.625 16.9833 7.31667 17 7 17C6.68333 17 6.36667 16.9833 6.05 16.95C5.75 16.9 5.43333 16.8333 5.1 16.75L5.5 18Z" fill="#444746">
        </path>
      </g>
      <g id="tv" viewBox="0 0 24 24">
        <path d="M8 16H10V10H11.75L14 16H16L19 8H16.5L15 12.5L13.5 8H5V10H8V16ZM5 21C4.45 21 3.975 20.8083 3.575 20.425C3.19167 20.025 3 19.55 3 19V5C3 4.45 3.19167 3.98333 3.575 3.6C3.975 3.2 4.45 3 5 3H19C19.55 3 20.0167 3.2 20.4 3.6C20.8 3.98333 21 4.45 21 5V19C21 19.55 20.8 20.025 20.4 20.425C20.0167 20.8083 19.55 21 19 21H5ZM5 19H19V5H5V19ZM5 5V19V5Z" fill="#444746">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}let instance$n=null;function getCss$h(){return instance$n||(instance$n=[...[],css`:host{align-items:center;background-position:center;background-repeat:no-repeat;border-radius:5px;display:flex;flex-shrink:0;height:36px;justify-content:center;margin-inline:0 12px;width:36px}@media (forced-colors:active){:host{forced-color-adjust:none}}`])}class PageFavicon extends CrLitElement{static get is(){return"page-favicon"}static get styles(){return getCss$h()}render(){return html``}static get properties(){return{url:{type:Object},fallbackToHost:{type:Boolean},isKnownToSync:{type:Boolean},size:{type:Number}}}#url_accessor_storage;get url(){return this.#url_accessor_storage}set url(value){this.#url_accessor_storage=value}#fallbackToHost_accessor_storage=true;get fallbackToHost(){return this.#fallbackToHost_accessor_storage}set fallbackToHost(value){this.#fallbackToHost_accessor_storage=value}#isKnownToSync_accessor_storage=false;get isKnownToSync(){return this.#isKnownToSync_accessor_storage}set isKnownToSync(value){this.#isKnownToSync_accessor_storage=value}#size_accessor_storage=16;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("url")){if(!this.url){this.style.setProperty("background-image","")}else{this.style.setProperty("background-image",getFaviconForPageURL(this.url.url,this.isKnownToSync,"",this.size,false,this.fallbackToHost))}}}}customElements.define(PageFavicon.is,PageFavicon);let instance$m=null;function getCss$g(){return instance$m||(instance$m=[...[getCss$t()],css`@media (forced-colors:active){a{border-radius:var(--ntp-module-item-border-radius);outline:var(--cr-border-hcm)}.url-visit{overflow:visible}}:host-context(.focus-outline-visible) a:focus,a:focus-visible{box-shadow:var(--ntp-focus-shadow);outline:none}#urlVisits{background-color:var(--color-new-tab-page-module-item-background);border-radius:var(--ntp-module-item-border-radius);overflow:hidden;margin:8px}.url-visit{align-items:center;display:flex;height:56px;position:relative;text-decoration:none;overflow:hidden}.url-visit:hover #hoverLayer{background:var(--color-new-tab-page-module-item-background-hovered);display:block;inset:0;pointer-events:none;position:absolute}#hoverLayer{display:none}.url-visit:first-of-type{border-radius:var(--ntp-module-item-border-radius) var(--ntp-module-item-border-radius) 0 0;padding-top:var(--ntp-module-first-element-top-padding)}.icon{background-color:var(--color-new-tab-page-module-icon-background);border-radius:8px;height:var(--ntp-module-icon-size);margin-inline:8px;position:relative;width:var(--ntp-module-icon-size)}.url-visit-info{color:var(--color-new-tab-page-secondary-foreground);min-width:0;padding-inline-end:16px;position:relative}.url-visit-title,.url-visit-domain,.url-visit-device{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.url-visit-title{color:var(--color-new-tab-page-primary-foreground);font-size:var(--ntp-module-text-size);line-height:var(--ntp-module-line-height)}.url-visit-description{display:flex;flex-direction:row;font-size:var(--ntp-module-secondary-text-size);line-height:var(--ntp-module-secondary-line-height)}.url-visit-reason{white-space:nowrap}:host([should-show-device-icon_]) .url-visit-device{flex-shrink:0;height:14px;margin-bottom:auto;margin-inline:0 4px;margin-top:auto;width:14px}cr-icon-button{--cr-icon-button-fill-color:var(--color-new-tab-page-primary-foreground);--cr-icon-button-hover-background-color:var(--color-new-tab-page-active-background);display:none;justify-content:flex-end;margin-left:auto;margin-right:16px}.url-visit:hover cr-icon-button{display:block}#seeMoreButtonContainer{padding:4px 0 8px 0}#seeMoreButtonContainer a{color:var(--color-new-tab-page-link);font-size:13px;display:block;font-weight:var(--ntp-module-see-more-font-weight);line-height:20px;padding:4px 16px 4px 16px;position:relative;text-decoration:none}#seeMoreButtonContainer:hover #hoverContainer{background:var(--color-new-tab-page-module-item-background-hovered);display:block;inset:0;pointer-events:none;position:absolute}#seeMoreButtonContainer #hoverContainer{display:none}`])}function getHtml$e(){return html`<!--_html_template_start_--><ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="${this.i18n("modulesMostRelevantTabResumptionTitle")}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesTabResumptionTitle")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissAllButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<div id="urlVisits">
  ${this.getVisibleUrlVisits_().map(((item,index)=>html`
    <a class="url-visit" href="${item.url.url}"
        @click="${this.onUrlVisitClick_}" data-index="${index}"
        title="${item.title}">
      <div id="hoverLayer"></div>
      <page-favicon class="icon" .fallbackToHost="${this.fallbackToHost_}"
                    .url="${item.url}" size="24"
                    .isKnownToSync="${item.isKnownToSync||this.allowFaviconServerFallback_}">
      </page-favicon>
      <div class="url-visit-info">
        <div class="url-visit-title">${item.title}</div>
        <div class="url-visit-description">
          <div class="url-visit-domain">${this.computeDomain_(item)}</div>
          <span class="dot"
              ?hidden="${!this.computeShouldShowDeviceName_(item)}">
            &nbsp&#8226&nbsp
          </span>
          <div class="url-visit-device"
              ?hidden="${!this.computeShouldShowDeviceName_(item)}">
            ${this.computeDeviceName_(item)}
          </div>
          <span class="dot">
            &nbsp&#8226&nbsp
          </span>
          <span class="url-visit-reason">
            ${item.decoration.displayString}
          </span>
        </div>
      </div>
      <cr-icon-button iron-icon="modules:done"
          @click="${this.onDismissButtonClick_}"
          title="$i18n{modulesHistoryDoneButton}">
      </cr-icon-button>
    </a>
  `))}
  <div id="seeMoreButtonContainer">
    <a href="chrome://history/syncedTabs"
        @click="${this.onSeeMoreButtonClick_}">
      $i18n{modulesMostRelevantTabResumptionSeeMore}
      <div id="hoverContainer"></div>
    </a>
  </div>
</div>
${this.showInfoDialog_?html`
    <ntp-info-dialog show-on-attach
        .innerHTML="${this.i18nAdvanced("modulesTabResumptionInfo")}"
        @close="${this.onInfoDialogClose_}">>
    </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}class MostRelevantTabResumptionProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){if(instance$l){return instance$l}const handler=PageHandler.getRemote();return instance$l=new MostRelevantTabResumptionProxyImpl(handler)}static setInstance(obj){instance$l=obj}}let instance$l=null;const MAX_URL_VISITS=5;let ModuleElement$1=class ModuleElement extends(I18nMixinLit(CrLitElement)){static get is(){return"ntp-most-relevant-tab-resumption"}static get styles(){return getCss$g()}render(){return getHtml$e.bind(this)()}static get properties(){return{format:{type:String,reflect:true},urlVisits:{type:Object},fallbackToHost_:{type:Boolean},shouldShowDeviceIcon_:{type:Boolean,reflect:true},showInfoDialog_:{type:Boolean},allowFaviconServerFallback_:{type:Boolean}}}#format_accessor_storage="wide";get format(){return this.#format_accessor_storage}set format(value){this.#format_accessor_storage=value}#urlVisits_accessor_storage=[];get urlVisits(){return this.#urlVisits_accessor_storage}set urlVisits(value){this.#urlVisits_accessor_storage=value}#fallbackToHost__accessor_storage=loadTimeData.getBoolean("mostRelevantTabResumptionModuleFallbackToHost");get fallbackToHost_(){return this.#fallbackToHost__accessor_storage}set fallbackToHost_(value){this.#fallbackToHost__accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}#allowFaviconServerFallback__accessor_storage=loadTimeData.getBoolean("mostRelevantTabResumptionAllowFaviconServerFallback");get allowFaviconServerFallback_(){return this.#allowFaviconServerFallback__accessor_storage}set allowFaviconServerFallback_(value){this.#allowFaviconServerFallback__accessor_storage=value}getMenuItems_(){return[{action:"dismiss",icon:"modules:thumb_down",text:this.i18n("modulesMostRelevantTabResumptionDismissAll")},{action:"disable",icon:"modules:block",text:this.i18nRecursive("","modulesDisableButtonTextV2","modulesTabResumptionTitle")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}onDisableButtonClick_(){this.fire("disable-module",{message:loadTimeData.getStringF("modulesDisableToastMessage",loadTimeData.getString("modulesThisTypeOfCardText"))})}onDismissAllButtonClick_(){MostRelevantTabResumptionProxyImpl.getInstance().handler.dismissModule(this.urlVisits);this.fire("dismiss-module-instance",{message:loadTimeData.getString("modulesTabResumptionMultiDismiss"),restoreCallback:()=>MostRelevantTabResumptionProxyImpl.getInstance().handler.restoreModule(this.urlVisits)})}onSeeMoreButtonClick_(){this.fire("usage");recordOccurrence("NewTabPage.TabResumption.SeeMoreClick")}onDismissButtonClick_(e){e.preventDefault();e.stopPropagation();const urlVisitElem=e.target.parentElement;const index=Number(urlVisitElem.dataset["index"]);const urlVisit=this.urlVisits[index];assert(urlVisit);recordSmallCount("NewTabPage.TabResumption.VisitDismissIndex",index);MostRelevantTabResumptionProxyImpl.getInstance().handler.dismissURLVisit(urlVisit);this.urlVisits=[...this.urlVisits.slice(0,index),...this.urlVisits.slice(index+1)];assert(this.urlVisits.length>=0);const eventName=this.urlVisits.length>0?"dismiss-module-element":"dismiss-module-instance";this.fire(eventName,{message:loadTimeData.getString("modulesTabResumptionSingleDismiss"),restoreCallback:()=>{recordSmallCount("NewTabPage.TabResumption.VisitRestoreIndex",index);this.urlVisits=[...this.urlVisits.slice(0,index),urlVisit,...this.urlVisits.slice(index)];MostRelevantTabResumptionProxyImpl.getInstance().handler.restoreURLVisit(urlVisit)}})}onUrlVisitClick_(e){this.fire("usage");const currentTarget=e.currentTarget;const index=Number(currentTarget.dataset["index"]);const urlVisit=this.urlVisits[index];assert(urlVisit);recordSmallCount("NewTabPage.TabResumption.ClickIndex",index);recordEnumeration("NewTabPage.TabResumption.Visit.ClickSource",urlVisit.source,VisitSource.MAX_VALUE+1);recordLogValue("NewTabPage.TabResumption.TimeElapsedSinceLastVisit",60*1e3,4*24*60*60*1e3,50,Number(urlVisit.relativeTime.microseconds/1000n));MostRelevantTabResumptionProxyImpl.getInstance().handler.recordAction(ScoredURLUserAction.kActivated,urlVisit.urlKey,urlVisit.trainingRequestId)}computeDomain_(urlVisit){let domain=new URL(urlVisit.url.url).hostname;domain=domain.replace("www.","");return domain}computeIcon_(urlVisit){switch(urlVisit.formFactor){case FormFactor.kDesktop:return"tab_resumption:computer";case FormFactor.kPhone:return"tab_resumption:phone";case FormFactor.kTablet:return"tab_resumption:tablet";case FormFactor.kAutomotive:return"tab_resumption:automotive";case FormFactor.kWearable:return"tab_resumption:wearable";case FormFactor.kTv:return"tab_resumption:tv";default:return"tab_resumption:globe"}}computeDeviceName_(urlVisit){return urlVisit.sessionName}computeShouldShowDeviceName_(urlVisit){return!!this.computeDeviceName_(urlVisit)}getVisibleUrlVisits_(){return this.urlVisits.slice(0,MAX_URL_VISITS)}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}};customElements.define(ModuleElement$1.is,ModuleElement$1);async function createElement$1(){const{urlVisits:urlVisits}=await MostRelevantTabResumptionProxyImpl.getInstance().handler.getURLVisits();if(!urlVisits||urlVisits.length===0){return null}const element=new ModuleElement$1;element.urlVisits=urlVisits;urlVisits.slice(0,MAX_URL_VISITS).forEach((urlVisit=>{MostRelevantTabResumptionProxyImpl.getInstance().handler.recordAction(ScoredURLUserAction.kSeen,urlVisit.urlKey,urlVisit.trainingRequestId)}));return element}const mostRelevantTabResumptionDescriptor=new ModuleDescriptor("tab_resumption",createElement$1);const div=document.createElement("div");div.innerHTML=getTrustedHTML`<cr-iconset name="tab_groups" size="20">
  <svg>
    <defs>
      <g id="create_new_tab_group" height="20px" viewBox="0 -960 960 960" width="20px">
        <path d="M516-384h72v-132h132v-72H588v-132h-72v132H384v72h132v132ZM312-240q-29.7 0-50.85-21.15Q240-282.3 240-312v-480q0-29.7 21.15-50.85Q282.3-864 312-864h480q29.7 0 50.85 21.15Q864-821.7 864-792v480q0 29.7-21.15 50.85Q821.7-240 792-240H312Zm0-72h480v-480H312v480ZM168-96q-29.7 0-50.85-21.15Q96-138.3 96-168v-552h72v552h552v72H168Zm144-696v480-480Z">
      </g>
      <g id="shared_tab_group" height="20px" viewBox="0 -960 960 960" width="20px">
        <path d="M96-192v-92q0-25.78 12.5-47.39T143-366q54-32 114.5-49T384-432q66 0 126.5 17T625-366q22 13 34.5 34.61T672-284v92H96Zm648 0v-92q0-42-19.5-78T672-421q39 8 75.5 21.5T817-366q22 13 34.5 34.67Q864-309.65 864-284v92H744ZM384-480q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm336-144q0 60-42 102t-102 42q-8 0-15-.5t-15-2.5q25-29 39.5-64.5T600-624q0-41-14.5-76.5T546-765q8-2 15-2.5t15-.5q60 0 102 42t42 102ZM168-264h432v-20q0-6.47-3.03-11.76-3.02-5.3-7.97-8.24-47-27-99-41.5T384-360q-54 0-106 14t-99 42q-4.95 2.83-7.98 7.91-3.02 5.09-3.02 12V-264Zm216.21-288Q414-552 435-573.21t21-51Q456-654 434.79-675t-51-21Q354-696 333-674.79t-21 51Q312-594 333.21-573t51 21ZM384-264Zm0-360Z">
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}let instance$k=null;function getCss$f(){return instance$k||(instance$k=[...[],css`:host{--icon-container-size:56px;--icon-size:16px;--cell-size:26px;--cell-inner-radius:2px;--cell-outer-radius:6px;align-items:center;border-radius:8px;display:flex;gap:4px;height:var(--icon-container-size);justify-content:center;padding:4px;width:var(--icon-container-size)}.icons-container{display:grid;grid-template-columns:repeat(2,1fr);grid-template-rows:repeat(2,1fr);gap:4px;height:100%;place-items:center;width:100%}.cell{background-color:color-mix(in srgb,var(--color-sys-surface) 60%,transparent);border-radius:var(--cell-inner-radius);height:100%;overflow:hidden;width:100%}.cell.empty{height:var(--cell-size);width:var(--cell-size)}.cell:nth-child(1){border-top-left-radius:var(--cell-outer-radius)}.cell:nth-child(2){border-top-right-radius:var(--cell-outer-radius)}.cell:nth-child(3){border-bottom-left-radius:var(--cell-outer-radius)}.cell:nth-child(4){border-bottom-right-radius:var(--cell-outer-radius)}.cell.overflow-count{align-items:center;color:var(--color-new-tab-page-secondary-foreground);display:flex;flex-direction:column;font-size:var(--ntp-module-secondary-text-size);font-style:normal;font-weight:400;height:var(--cell-size);justify-content:center;line-height:var(--ntp-module-secondary-line-height);width:var(--cell-size)}.cell.icon{background-color:var(--color-sys-surface);display:grid;height:var(--cell-size);place-items:center;width:var(--cell-size)}.cell.icon>.icon{height:var(--icon-size);width:var(--icon-size)}`])}const MAX_CELL_COUNT=4;class IconContainerElement extends CrLitElement{static get is(){return"ntp-icon-container"}static get styles(){return getCss$f()}render(){const overflowCount=this.totalTabCount-MAX_CELL_COUNT+1;const overflowCells=Array(overflowCount>1?1:0).fill(overflowCount);const faviconCells=this.faviconUrls.slice(0,MAX_CELL_COUNT-overflowCells.length);const emptyCells=Array(MAX_CELL_COUNT-faviconCells.length-overflowCells.length).fill(null);return html`
      <div class="icons-container">
        ${faviconCells.map((url=>this.renderIconCell(url)))}
        ${emptyCells.map((()=>this.renderEmptyCell()))}
        ${overflowCells.map((()=>this.renderOverflowCell(overflowCount)))}
      </div>
    `}static get properties(){return{faviconUrls:{type:Array},totalTabCount:{type:Number}}}#faviconUrls_accessor_storage=[];get faviconUrls(){return this.#faviconUrls_accessor_storage}set faviconUrls(value){this.#faviconUrls_accessor_storage=value}#totalTabCount_accessor_storage=0;get totalTabCount(){return this.#totalTabCount_accessor_storage}set totalTabCount(value){this.#totalTabCount_accessor_storage=value}renderEmptyCell(){return html`<div class="cell empty"></div>`}renderIconCell(url){return html`
      <div class="cell icon">
        <div class="icon"
            style="background-image: ${getFaviconForPageURL(url,false)};">
        </div>
      </div>
    `}renderOverflowCell(count){return html`
      <div class="cell overflow-count" aria-hidden="true">
        ${count<=99?html`+${count}`:"99+"}
      </div>
    `}}customElements.define(IconContainerElement.is,IconContainerElement);class PluralStringProxyImpl{getPluralString(messageName,itemCount){return sendWithPromise("getPluralString",messageName,itemCount)}getPluralStringTupleWithComma(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithComma",messageName1,itemCount1,messageName2,itemCount2)}getPluralStringTupleWithPeriods(messageName1,itemCount1,messageName2,itemCount2){return sendWithPromise("getPluralStringTupleWithPeriods",messageName1,itemCount1,messageName2,itemCount2)}static getInstance(){return instance$j||(instance$j=new PluralStringProxyImpl)}static setInstance(obj){instance$j=obj}}let instance$j=null;let instance$i=null;function getCss$e(){return instance$i||(instance$i=[...[getCss$t(),getCss$s()],css`:host{height:100%;width:100%}@media (forced-colors:active){.tab-group{border-radius:var(--ntp-module-item-border-radius);outline:var(--cr-border-hcm);overflow:visible}}:host-context(.focus-outline-visible) cr-button:focus,cr-button:focus-visible{box-shadow:var(--ntp-focus-shadow);outline:none}#tabGroups{align-items:flex-start;align-self:stretch;background-color:var(--color-new-tab-page-module-item-background);border-radius:var(--ntp-module-item-border-radius);container-type:inline-size;display:flex;flex-direction:column;margin:8px}#tabGroupsContainer{width:100%}.tab-group{--cr-hover-background-color:var(--color-new-tab-page-module-item-background-hovered);background:transparent;border:0;border-radius:0;display:block;height:auto;margin:0;padding:4px 16px 4px 8px;position:relative}.row-content{display:flex;align-items:center;gap:16px}#zeroTabGroupsContainer{align-items:center;align-self:stretch;border-radius:12px;display:flex;flex-direction:column;gap:24px;justify-content:center;padding:32px 40px;position:relative}@container (max-width:312px){#zeroTabGroupsContainer{padding:8px 40px 32px}}#zeroTabGroupsImageContainer{align-items:center;background-color:var(--color-sys-surface5);border-radius:8px;display:flex;flex-direction:column;justify-content:flex-end;padding:40px 22px 0 22px;overflow:hidden}.zero-tab-groups-image{display:none;width:236px;height:93px;flex-shrink:0;transform:translateY(4px)}@media (prefers-color-scheme:light){#zeroTabGroupsImageLight{display:block}}@media (prefers-color-scheme:dark){#zeroTabGroupsImageDark{display:block}}#zeroTabGroupsContentContainer{display:flex;flex-direction:column;align-items:center;gap:16px;align-self:stretch}#zeroTabGroupsTextContainer{align-items:center;align-self:stretch;display:flex;flex-direction:column;gap:4px}#zeroTabGroupsTitle{color:var(--color-sys-on-surface);font-size:16px;font-style:normal;font-weight:500;line-height:24px;align-self:stretch;text-align:center}#zeroTabGroupsText{color:var(--color-sys-on-surface-subtle);font-size:13px;font-style:normal;font-weight:400;line-height:20px;text-align:center}#createNewTabGroupButton{--cr-hover-background-color:var(--color-new-tab-page-button-background-hovered);--cr-button-text-color:var(--color-new-tab-page-button-foreground);--cr-button-background-color:var(--color-new-tab-page-button-background);display:flex;height:36px;padding:8px 16px;align-items:center;gap:8px;border-radius:var(--corner-radii-fully-round,100px);border:none}cr-icon{width:20px;height:20px;flex-shrink:0}#createNewTabGroupButtonIcon{color:var(--color-new-tab-page-button-foreground)}.tab-group:first-of-type{border-radius:var(--ntp-module-item-border-radius) var(--ntp-module-item-border-radius) 0 0;padding-top:calc(var(--ntp-module-first-element-top-padding) + 4px)}.tab-group-info{display:flex;flex-direction:column;align-items:stretch;flex:1 1 0;min-width:0;gap:4px}.color-dot{width:14px;height:14px;border-radius:50%;flex-shrink:0}.tab-group-title-row{display:flex;align-items:center;gap:6px}.tab-group-title-row,.tab-group-description{overflow:hidden;position:relative;text-overflow:ellipsis;white-space:nowrap}.tab-group-title{align-self:stretch;color:var(--color-new-tab-page-primary-foreground);font-size:var(--ntp-module-text-size);font-style:normal;height:20px;line-height:var(--ntp-module-line-height);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.tab-group-description{color:var(--color-new-tab-page-secondary-foreground);font-size:var(--ntp-module-secondary-text-size);font-weight:400;line-height:var(--ntp-module-secondary-line-height)}#footer{display:flex;flex-direction:column}#divider{padding:4px 0;position:relative}#divider::before{content:'';position:absolute;left:0;right:0;top:50%;height:1px;background:var(--color-new-tab-page-module-background)}#createNewTabGroupFooterButton{--cr-hover-background-color:var(--color-new-tab-page-module-item-background-hovered);background:transparent;border:0;display:block;height:auto;padding-block-end:12px;border-radius:0 0 var(--ntp-module-item-border-radius) var(--ntp-module-item-border-radius)}#createNewTabGroupFooterButton>.row-content{gap:8px}#createNewTabGroupIcon,#sharedTabGroupIcon{color:var(--color-new-tab-page-secondary-foreground)}`])}function getHtml$d(){return html`<!--_html_template_start_--><ntp-module-header-v2
    header-text="${this.i18n("modulesTabGroupsTitle")}"
    .menuItems="${this.getMenuItems_()}"
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesTabGroupsTitle")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<div id="tabGroups">
  ${this.showZeroState?html`
    <div id="zeroTabGroupsContainer" class="tab-groups">
      <div id="zeroTabGroupsImageContainer">
        <img id="zeroTabGroupsImageLight" class="zero-tab-groups-image"
            src="modules/tab_groups/icons/chrome_tab_groups_light.svg">
        <img id="zeroTabGroupsImageDark" class="zero-tab-groups-image"
            src="modules/tab_groups/icons/chrome_tab_groups_dark.svg">
      </div>
      <div id="zeroTabGroupsContentContainer">
        <div id="zeroTabGroupsTextContainer">
          <div id="zeroTabGroupsTitle">
            ${this.i18n("modulesTabGroupsZeroStateTitle")}
          </div>
          <div id="zeroTabGroupsText">
            ${this.i18n("modulesTabGroupsZeroStateText")}
          </div>
        </div>
        <div id="zeroTabGroupsCreateNewTabGroup">
          <cr-button id="createNewTabGroupButton" class="create-new-tab-group"
              @click="${()=>this.onCreateNewTabGroupClick_(true)}">
            <cr-icon id="createNewTabGroupButtonIcon"
                icon="tab_groups:create_new_tab_group" slot="prefix-icon">
            </cr-icon>
            <div id="createNewTabGroupButtonText">
              ${this.i18n("modulesTabGroupsCreateNewTabGroup")}
            </div>
          </cr-button>
        </div>
      </div>
    </div>
  `:html`
    <div id="tabGroupsContainer">
      ${this.getTabGroups_().map(((item,index)=>html`
        <cr-button class="tab-group"
            @click="${()=>this.onTabGroupClick_(item.id,index)}"
            aria-label="${this.ariaLabels.get(item.id)}">
          <div class="row-content">
            <ntp-icon-container class="icon-container"
                .style="background-color: var(${this.computeTabGroupColor_(item.color)})"
                .faviconUrls="${this.getFaviconUrls_(item.faviconUrls)}"
                .totalTabCount="${item.totalTabCount}">
            </ntp-icon-container>
            <div class="tab-group-info">
              <div class="tab-group-title-row">
                <div class="color-dot"
                    style="background-color: var(${this.computeTabGroupDotColor_(item.color)})">
                </div>
                <div class="tab-group-title">${item.title}</div>
              </div>
              <div class="tab-group-description">${this.computeDescription_(item.updateTime,item.deviceName)}</div>
            </div>
            ${item.isSharedTabGroup?html`
              <cr-icon id="sharedTabGroupIcon"
                  icon="tab_groups:shared_tab_group" slot="icon">
              </cr-icon>
            `:""}
          </div>
        </cr-button>
      `))}
      <div id="footer">
        <div id="divider"></div>
        <cr-button id="createNewTabGroupFooterButton"
            class="create-new-tab-group"
            @click="${()=>this.onCreateNewTabGroupClick_(false)}">
          <div class="row-content">
            <cr-icon id="createNewTabGroupIcon"
                icon="tab_groups:create_new_tab_group" slot="icon">
            </cr-icon>
            <div id="createNewTabGroupText" class="tab-group-title">
              ${this.i18n("modulesTabGroupsCreateNewTabGroup")}
            </div>
          </div>
        </cr-button>
      </div>
    </div>
  `}
</div>
${this.showInfoDialog?html`
  <ntp-info-dialog show-on-attach
      .innerHTML="${this.i18nAdvanced("modulesTabGroupsInfo")}"
      @close="${this.onInfoDialogClose_}">
  </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}class TabGroupsProxyImpl{handler;constructor(handler){this.handler=handler}static getInstance(){return instance$h||(instance$h=new TabGroupsProxyImpl(PageHandler$1.getRemote()))}static setInstance(newInstance){instance$h=newInstance}}let instance$h=null;const MAX_TAB_GROUPS=4;const COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_PREFIX="--color-new-tab-page-module-tab-groups-";const COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_DOT_PREFIX="--color-new-tab-page-module-tab-groups-dot-";const ModuleElementBase=I18nMixinLit(CrLitElement);function colorIdToString(colorPrefix,id){const colorMap=new Map([[Color.kGrey,"grey"],[Color.kBlue,"blue"],[Color.kRed,"red"],[Color.kYellow,"yellow"],[Color.kGreen,"green"],[Color.kPink,"pink"],[Color.kPurple,"purple"],[Color.kCyan,"cyan"],[Color.kOrange,"orange"]]);assert(colorMap.has(id));return colorPrefix+colorMap.get(id)}class ModuleElement extends ModuleElementBase{static get is(){return"ntp-tab-groups"}static get styles(){return getCss$e()}render(){return getHtml$d.bind(this)()}static get properties(){return{ariaLabels:{type:Object},tabGroups:{type:Object},showInfoDialog:{type:Boolean}}}#ariaLabels_accessor_storage=new Map;get ariaLabels(){return this.#ariaLabels_accessor_storage}set ariaLabels(value){this.#ariaLabels_accessor_storage=value}#tabGroups_accessor_storage=[];get tabGroups(){return this.#tabGroups_accessor_storage}set tabGroups(value){this.#tabGroups_accessor_storage=value}#showInfoDialog_accessor_storage=false;get showInfoDialog(){return this.#showInfoDialog_accessor_storage}set showInfoDialog(value){this.#showInfoDialog_accessor_storage=value}showZeroState=false;handler_;constructor(){super();this.handler_=TabGroupsProxyImpl.getInstance().handler}async updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("tabGroups")){const entries=await Promise.all(this.tabGroups.map((async group=>{const label=await this.computeTabGroupButtonAriaLabel_(group);return[group.id,label]})));this.ariaLabels=new Map(entries)}}computeDescription_(time,device){return device&&device.length>0?`${time} • ${device.trim()}`:time}computeTabGroupColor_(color){return colorIdToString(COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_PREFIX,color)}computeTabGroupDotColor_(color){return colorIdToString(COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_DOT_PREFIX,color)}async computeTabGroupButtonAriaLabel_(group){const totalTabsStr=await PluralStringProxyImpl.getInstance().getPluralString("modulesTabGroupsTabsText",group.totalTabCount);const description=this.computeDescription_(group.updateTime,group.deviceName);const sharedStr=group.isSharedTabGroup?"shared":"";return[totalTabsStr,group.title,description,sharedStr].filter(Boolean).join(" ")}getMenuItems_(){return[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForHoursButtonText","tabGroupsModuleDismissHours")},{action:"disable",icon:"modules:block",text:this.i18nRecursive("","modulesDisableButtonTextV2","modulesTabGroupsTitle")},{action:"info",icon:"modules:info",text:this.i18n("moduleInfoButtonTitle")}]}getTabGroups_(){return this.tabGroups.slice(0,MAX_TAB_GROUPS)}getFaviconUrls_(objects){return objects.map((obj=>obj.url))}onDisableButtonClick_(){this.fire("disable-module",{message:this.i18n("modulesTabGroupsDisableToastMessage")})}onDismissButtonClick_(){this.handler_.dismissModule();this.fire("dismiss-module-instance",{message:this.i18n("modulesTabGroupsDismissToastMessage"),restoreCallback:()=>this.handler_.restoreModule()})}onInfoButtonClick_(){this.showInfoDialog=true}onInfoDialogClose_(){this.showInfoDialog=false}onCreateNewTabGroupClick_(fromZeroStateCard){const histogram="NewTabPage.TabGroups.CreateNewTabGroup";recordOccurrence(histogram);recordOccurrence(`${histogram}.${fromZeroStateCard?"ZeroState":"SteadyState"}`);this.handler_.createNewTabGroup()}onTabGroupClick_(id,index){recordSmallCount("NewTabPage.TabGroups.ClickTabGroupIndex",index);this.handler_.openTabGroup(id)}}customElements.define(ModuleElement.is,ModuleElement);async function createElement(){const{tabGroups:tabGroups,showZeroState:showZeroState}=await TabGroupsProxyImpl.getInstance().handler.getTabGroups();if(!tabGroups){return null}if(!showZeroState&&tabGroups.length===0){return null}const element=new ModuleElement;element.tabGroups=tabGroups;element.showZeroState=showZeroState;return element}const tabGroupsDescriptor=new ModuleDescriptor("tab_groups",createElement);const descriptors=[];descriptors.push(mostRelevantTabResumptionDescriptor);descriptors.push(driveModuleDescriptor);descriptors.push(googleCalendarDescriptor);descriptors.push(microsoftAuthModuleDescriptor);descriptors.push(outlookCalendarDescriptor);descriptors.push(microsoftFilesModuleDescriptor);descriptors.push(tabGroupsDescriptor);async function counterfactualLoad(){if(!loadTimeData.getBoolean("modulesEnabled")&&loadTimeData.getBoolean("modulesLoadEnabled")){const modules=await ModuleRegistry.getInstance().initializeModules(loadTimeData.getInteger("modulesLoadTimeout"));if(modules){NewTabPageProxy.getInstance().handler.onModulesLoadedWithData(modules.map((module=>module.descriptor.id)))}}}counterfactualLoad();let instance$g=null;function getCss$d(){return instance$g||(instance$g=[...[],css`:host{--cr-toast-background:var(--color-toast-background,var(--cr-fallback-color-inverse-surface));--cr-toast-button-color:var(--color-toast-button,var(--cr-fallback-color-inverse-primary));--cr-toast-text-color:var(--color-toast-foreground,var(--cr-fallback-color-inverse-on-surface));--cr-focus-outline-color:var(--cr-focus-outline-inverse-color)}:host{align-items:center;background:var(--cr-toast-background);border-radius:8px;bottom:0;box-shadow:0 2px 4px 0 rgba(0,0,0,0.28);box-sizing:border-box;display:flex;line-height:20px;margin:24px;max-width:var(--cr-toast-max-width,568px);min-height:52px;min-width:288px;opacity:0;padding:0 16px;position:fixed;transform:translateY(100px);transition:opacity 300ms,transform 300ms;visibility:hidden;z-index:1}:host-context([dir=ltr]){left:0}:host-context([dir=rtl]){right:0}:host([open]){opacity:1;transform:translateY(0);visibility:visible}:host(:not([open])) ::slotted(*){display:none}:host ::slotted(*){color:var(--cr-toast-text-color)}:host ::slotted(cr-button){background-color:transparent !important;border:none !important;color:var(--cr-toast-button-color) !important;margin-inline-start:32px !important;min-width:52px !important;padding:8px !important}:host ::slotted(cr-button:hover){background-color:transparent !important}::slotted(cr-button:last-of-type){margin-inline-end:-8px}`])}function getHtml$c(){return html`<slot></slot>`}class CrToastElement extends CrLitElement{static get is(){return"cr-toast"}static get styles(){return getCss$d()}render(){return getHtml$c.bind(this)()}static get properties(){return{duration:{type:Number},open:{type:Boolean,reflect:true}}}#duration_accessor_storage=0;get duration(){return this.#duration_accessor_storage}set duration(value){this.#duration_accessor_storage=value}#open_accessor_storage=false;get open(){return this.#open_accessor_storage}set open(value){this.#open_accessor_storage=value}hideTimeoutId_=null;constructor(){super();this.addEventListener("focusin",this.clearTimeout_);this.addEventListener("focusout",this.resetAutoHide_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("duration")||changedProperties.has("open")){this.resetAutoHide_()}}clearTimeout_(){if(this.hideTimeoutId_!==null){window.clearTimeout(this.hideTimeoutId_);this.hideTimeoutId_=null}}resetAutoHide_(){this.clearTimeout_();if(this.open&&this.duration!==0){this.hideTimeoutId_=window.setTimeout((()=>{this.hide()}),this.duration)}}async show(){const shouldResetAutohide=this.open;this.removeAttribute("role");this.open=true;await this.updateComplete;this.setAttribute("role","alert");if(shouldResetAutohide){this.resetAutoHide_()}}async hide(){this.open=false;await this.updateComplete}}customElements.define(CrToastElement.is,CrToastElement);let instance$f=null;function getCss$c(){return instance$f||(instance$f=[...[getCss$r()],css`#content{display:flex;flex:1}.collapsible{overflow:hidden;text-overflow:ellipsis}span{white-space:pre}.elided-text{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}`])}function getHtml$b(){return html`
<cr-toast id="toast" .duration="${this.duration}">
  <div id="content" class="elided-text"></div>
  <slot id="slotted"></slot>
</cr-toast>`}let toastManagerInstance=null;function setInstance(instance){assert(!instance||!toastManagerInstance);toastManagerInstance=instance}class CrToastManagerElement extends CrLitElement{static get is(){return"cr-toast-manager"}static get styles(){return getCss$c()}render(){return getHtml$b.bind(this)()}static get properties(){return{duration:{type:Number}}}#duration_accessor_storage=0;get duration(){return this.#duration_accessor_storage}set duration(value){this.#duration_accessor_storage=value}get isToastOpen(){return this.$.toast.open}get slottedHidden(){return this.$.slotted.hidden}connectedCallback(){super.connectedCallback();setInstance(this)}disconnectedCallback(){super.disconnectedCallback();setInstance(null)}show(label,hideSlotted=false){this.$.content.textContent=label;this.showInternal_(hideSlotted)}showForStringPieces(pieces,hideSlotted=false){const content=this.$.content;content.textContent="";pieces.forEach((function(p){if(p.value.length===0){return}const span=document.createElement("span");span.textContent=p.value;if(p.collapsible){span.classList.add("collapsible")}content.appendChild(span)}));this.showInternal_(hideSlotted)}showInternal_(hideSlotted){this.$.slotted.hidden=hideSlotted;this.$.toast.show()}hide(){this.$.toast.hide()}}customElements.define(CrToastManagerElement.is,CrToastManagerElement);let instance$e=null;function getCss$b(){return instance$e||(instance$e=[...[getCss$r()],css`:host{display:block;position:absolute;outline:none;z-index:1002;user-select:none;cursor:default}#tooltip{display:block;outline:none;font-size:10px;line-height:1;background-color:var(--paper-tooltip-background,#616161);color:var(--paper-tooltip-text-color,white);padding:8px;border-radius:2px}@keyframes keyFrameFadeInOpacity{0%{opacity:0}100%{opacity:var(--paper-tooltip-opacity,0.9)}}@keyframes keyFrameFadeOutOpacity{0%{opacity:var(--paper-tooltip-opacity,0.9)}100%{opacity:0}}.fade-in-animation{opacity:0;animation-delay:var(--paper-tooltip-delay-in,500ms);animation-name:keyFrameFadeInOpacity;animation-iteration-count:1;animation-timing-function:ease-in;animation-duration:var(--paper-tooltip-duration-in,500ms);animation-fill-mode:forwards}.fade-out-animation{opacity:var(--paper-tooltip-opacity,0.9);animation-delay:var(--paper-tooltip-delay-out,0ms);animation-name:keyFrameFadeOutOpacity;animation-iteration-count:1;animation-timing-function:ease-in;animation-duration:var(--paper-tooltip-duration-out,500ms);animation-fill-mode:forwards}#tooltipOffsetFiller{position:absolute;:host([position="top"]) &{top:100%}:host([position="bottom"]) &{bottom:100%}:host([position="left"]) &{left:100%}:host([position="right"]) &{right:100%}:host(:is([position="top"],[position="bottom"])) &{left:0;height:var(--cr-tooltip-offset);width:100%}:host(:is([position="left"],[position="right"])) &{top:0;height:100%;width:var(--cr-tooltip-offset)}}`])}function getHtml$a(){return html`
    <div id="tooltip" hidden part="tooltip">
      <slot></slot>
    </div>
    <div id="tooltipOffsetFiller"></div>`}var TooltipPosition;(function(TooltipPosition){TooltipPosition["TOP"]="top";TooltipPosition["BOTTOM"]="bottom";TooltipPosition["LEFT"]="left";TooltipPosition["RIGHT"]="right"})(TooltipPosition||(TooltipPosition={}));class CrTooltipElement extends CrLitElement{static get is(){return"cr-tooltip"}static get styles(){return getCss$b()}render(){return getHtml$a.bind(this)()}static get properties(){return{for:{type:String},manualMode:{type:Boolean},position:{type:String,reflect:true},fitToVisibleBounds:{type:Boolean},offset:{type:Number},animationDelay:{type:Number},hideDelay:{type:Number}}}#animationDelay_accessor_storage=500;get animationDelay(){return this.#animationDelay_accessor_storage}set animationDelay(value){this.#animationDelay_accessor_storage=value}#fitToVisibleBounds_accessor_storage=false;get fitToVisibleBounds(){return this.#fitToVisibleBounds_accessor_storage}set fitToVisibleBounds(value){this.#fitToVisibleBounds_accessor_storage=value}#hideDelay_accessor_storage=600;get hideDelay(){return this.#hideDelay_accessor_storage}set hideDelay(value){this.#hideDelay_accessor_storage=value}#for_accessor_storage="";get for(){return this.#for_accessor_storage}set for(value){this.#for_accessor_storage=value}#manualMode_accessor_storage=false;get manualMode(){return this.#manualMode_accessor_storage}set manualMode(value){this.#manualMode_accessor_storage=value}#offset_accessor_storage=14;get offset(){return this.#offset_accessor_storage}set offset(value){this.#offset_accessor_storage=value}#position_accessor_storage=TooltipPosition.BOTTOM;get position(){return this.#position_accessor_storage}set position(value){this.#position_accessor_storage=value}animationPlaying_=false;showing_=false;manualTarget_;target_=null;tracker_=new EventTracker;hideTimeout_=null;connectedCallback(){super.connectedCallback();this.findTarget_()}disconnectedCallback(){if(!this.manualMode){this.removeListeners_()}this.resetHideTimeout_()}firstUpdated(changedProperties){super.firstUpdated(changedProperties);this.addEventListener("animationend",(()=>this.onAnimationEnd_()))}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("animationDelay")){this.style.setProperty("--paper-tooltip-delay-in",`${this.animationDelay}ms`)}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("for")){this.findTarget_()}if(changedProperties.has("manualMode")){if(this.manualMode){this.removeListeners_()}else{this.addListeners_()}}if(changedProperties.has("offset")){this.style.setProperty("--cr-tooltip-offset",`${this.offset}px`)}}get target(){if(this.manualTarget_){return this.manualTarget_}const ownerRoot=this.getRootNode();if(this.for){return ownerRoot.querySelector(`#${this.for}`)}const parentNode=this.parentNode;return!!parentNode&&parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?ownerRoot.host:parentNode}set target(target){this.manualTarget_=target;this.findTarget_()}show(){this.resetHideTimeout_();if(this.showing_){return}if(!!this.textContent&&this.textContent.trim()===""){const children=this.shadowRoot.querySelector("slot").assignedElements();const hasNonEmptyChild=Array.from(children).some((el=>!!el.textContent&&el.textContent.trim()!==""));if(!hasNonEmptyChild){return}}this.showing_=true;this.$.tooltip.hidden=false;this.$.tooltip.classList.remove("fade-out-animation");this.updatePosition();this.animationPlaying_=true;this.$.tooltip.classList.add("fade-in-animation")}hide(){if(!this.showing_){return}if(this.animationPlaying_){this.showing_=false;this.$.tooltip.classList.remove("fade-in-animation","fade-out-animation");this.$.tooltip.hidden=true;return}this.$.tooltip.classList.remove("fade-in-animation");this.$.tooltip.classList.add("fade-out-animation");this.showing_=false;this.animationPlaying_=true}queueHide_(){this.resetHideTimeout_();this.hideTimeout_=setTimeout((()=>{this.hide();this.hideTimeout_=null}),this.hideDelay)}resetHideTimeout_(){if(this.hideTimeout_!==null){clearTimeout(this.hideTimeout_);this.hideTimeout_=null}}updatePosition(){if(!this.target_){return}const offsetParent=this.offsetParent||this.composedOffsetParent_();if(!offsetParent){return}const offset=this.offset;const parentRect=offsetParent.getBoundingClientRect();const targetRect=this.target_.getBoundingClientRect();const tooltipRect=this.$.tooltip.getBoundingClientRect();const horizontalCenterOffset=(targetRect.width-tooltipRect.width)/2;const verticalCenterOffset=(targetRect.height-tooltipRect.height)/2;const targetLeft=targetRect.left-parentRect.left;const targetTop=targetRect.top-parentRect.top;let tooltipLeft;let tooltipTop;switch(this.position){case TooltipPosition.TOP:tooltipLeft=targetLeft+horizontalCenterOffset;tooltipTop=targetTop-tooltipRect.height-offset;break;case TooltipPosition.BOTTOM:tooltipLeft=targetLeft+horizontalCenterOffset;tooltipTop=targetTop+targetRect.height+offset;break;case TooltipPosition.LEFT:tooltipLeft=targetLeft-tooltipRect.width-offset;tooltipTop=targetTop+verticalCenterOffset;break;case TooltipPosition.RIGHT:tooltipLeft=targetLeft+targetRect.width+offset;tooltipTop=targetTop+verticalCenterOffset;break}if(this.fitToVisibleBounds){if(parentRect.left+tooltipLeft+tooltipRect.width>window.innerWidth){this.style.right="0px";this.style.left="auto"}else{this.style.left=Math.max(0,tooltipLeft)+"px";this.style.right="auto"}if(parentRect.top+tooltipTop+tooltipRect.height>window.innerHeight){this.style.bottom=parentRect.height-targetTop+offset+"px";this.style.top="auto"}else{this.style.top=Math.max(-parentRect.top,tooltipTop)+"px";this.style.bottom="auto"}}else{this.style.left=tooltipLeft+"px";this.style.top=tooltipTop+"px"}}findTarget_(){if(!this.manualMode){this.removeListeners_()}this.target_=this.target;if(!this.manualMode){this.addListeners_()}}onAnimationEnd_(){this.animationPlaying_=false;if(!this.showing_){this.$.tooltip.classList.remove("fade-out-animation");this.$.tooltip.hidden=true}}addListeners_(){if(this.target_){this.tracker_.add(this.target_,"pointerenter",(()=>this.show()));this.tracker_.add(this.target_,"focus",(()=>this.show()));this.tracker_.add(this.target_,"pointerleave",(()=>this.queueHide_()));this.tracker_.add(this.target_,"blur",(()=>this.hide()));this.tracker_.add(this.target_,"click",(()=>this.hide()))}this.tracker_.add(this.$.tooltip,"animationend",(()=>this.onAnimationEnd_()));this.tracker_.add(this,"pointerenter",(()=>this.show()));this.tracker_.add(this,"pointerleave",(()=>this.queueHide_()))}removeListeners_(){this.tracker_.removeAll()}composedOffsetParent_(){if(this.computedStyleMap().get("display").value==="none"){return null}for(let ancestor=flatTreeParent(this);ancestor!==null;ancestor=flatTreeParent(ancestor)){if(!(ancestor instanceof Element)){continue}const style=ancestor.computedStyleMap();if(style.get("display").value==="none"){return null}if(style.get("display").value==="contents"){continue}if(style.get("position").value!=="static"){return ancestor}if(ancestor.tagName==="BODY"){return ancestor}}return null;function flatTreeParent(element){if(element.assignedSlot){return element.assignedSlot}if(element.parentNode instanceof ShadowRoot){return element.parentNode.host}return element.parentElement}}}customElements.define(CrTooltipElement.is,CrTooltipElement);let instance$d=null;function getCss$a(){return instance$d||(instance$d=[...[getCss$t()],css`:host{display:flex}cr-icon{--iron-icon-width:var(--cr-icon-size);--iron-icon-height:var(--cr-icon-size);--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color,var(--google-grey-700))}@media (prefers-color-scheme:dark){cr-icon{--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color,var(--google-grey-500))}}`])}function getHtml$9(){return html`
<cr-icon id="indicator" tabindex="0" aria-label="${this.iconAriaLabel}"
    aria-describedby="tooltip" icon="${this.iconClass}" role="img">
</cr-icon>
<cr-tooltip id="tooltip"
    for="indicator" position="${this.tooltipPosition}"
    fit-to-visible-bounds part="tooltip">
  <slot name="tooltip-text">${this.tooltipText}</slot>
</cr-tooltip>`}class CrTooltipIconElement extends CrLitElement{static get is(){return"cr-tooltip-icon"}static get styles(){return getCss$a()}render(){return getHtml$9.bind(this)()}static get properties(){return{iconAriaLabel:{type:String},iconClass:{type:String},tooltipText:{type:String},tooltipPosition:{type:String}}}#iconAriaLabel_accessor_storage="";get iconAriaLabel(){return this.#iconAriaLabel_accessor_storage}set iconAriaLabel(value){this.#iconAriaLabel_accessor_storage=value}#iconClass_accessor_storage="";get iconClass(){return this.#iconClass_accessor_storage}set iconClass(value){this.#iconClass_accessor_storage=value}#tooltipText_accessor_storage="";get tooltipText(){return this.#tooltipText_accessor_storage}set tooltipText(value){this.#tooltipText_accessor_storage=value}#tooltipPosition_accessor_storage="top";get tooltipPosition(){return this.#tooltipPosition_accessor_storage}set tooltipPosition(value){this.#tooltipPosition_accessor_storage=value}getFocusableElement(){return this.$.indicator}}customElements.define(CrTooltipIconElement.is,CrTooltipIconElement);let instance$c=null;function getCss$9(){return instance$c||(instance$c=[...[getCss$r()],css``])}function getHtml$8(){return html`
<cr-tooltip-icon ?hidden="${!this.getIndicatorVisible_()}"
    tooltip-text="${this.getIndicatorTooltip_()}"
    icon-class="${this.getIndicatorIcon_()}"
    icon-aria-label="${this.iconAriaLabel}">
</cr-tooltip-icon>`}var CrPolicyIndicatorType;(function(CrPolicyIndicatorType){CrPolicyIndicatorType["DEVICE_POLICY"]="devicePolicy";CrPolicyIndicatorType["EXTENSION"]="extension";CrPolicyIndicatorType["NONE"]="none";CrPolicyIndicatorType["OWNER"]="owner";CrPolicyIndicatorType["PRIMARY_USER"]="primary_user";CrPolicyIndicatorType["RECOMMENDED"]="recommended";CrPolicyIndicatorType["USER_POLICY"]="userPolicy";CrPolicyIndicatorType["PARENT"]="parent";CrPolicyIndicatorType["CHILD_RESTRICTION"]="childRestriction"})(CrPolicyIndicatorType||(CrPolicyIndicatorType={}));class CrPolicyIndicatorElement extends CrLitElement{static get is(){return"cr-policy-indicator"}static get styles(){return getCss$9()}render(){return getHtml$8.bind(this)()}static get properties(){return{iconAriaLabel:{type:String},indicatorType:{type:String},indicatorSourceName:{type:String}}}#iconAriaLabel_accessor_storage="";get iconAriaLabel(){return this.#iconAriaLabel_accessor_storage}set iconAriaLabel(value){this.#iconAriaLabel_accessor_storage=value}#indicatorType_accessor_storage=CrPolicyIndicatorType.NONE;get indicatorType(){return this.#indicatorType_accessor_storage}set indicatorType(value){this.#indicatorType_accessor_storage=value}#indicatorSourceName_accessor_storage="";get indicatorSourceName(){return this.#indicatorSourceName_accessor_storage}set indicatorSourceName(value){this.#indicatorSourceName_accessor_storage=value}getIndicatorVisible_(){return this.indicatorType!==CrPolicyIndicatorType.NONE}getIndicatorIcon_(){switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return"cr:extension";case CrPolicyIndicatorType.NONE:return"";case CrPolicyIndicatorType.PRIMARY_USER:return"cr:group";case CrPolicyIndicatorType.OWNER:return"cr:person";case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:case CrPolicyIndicatorType.RECOMMENDED:return"cr20:domain";case CrPolicyIndicatorType.PARENT:case CrPolicyIndicatorType.CHILD_RESTRICTION:return"cr20:kite";default:assertNotReached()}}getIndicatorTooltip_(){if(!window.CrPolicyStrings){return""}const CrPolicyStrings=window.CrPolicyStrings;switch(this.indicatorType){case CrPolicyIndicatorType.EXTENSION:return this.indicatorSourceName.length>0?CrPolicyStrings.controlledSettingExtension.replace("$1",this.indicatorSourceName):CrPolicyStrings.controlledSettingExtensionWithoutName;case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:return CrPolicyStrings.controlledSettingPolicy;case CrPolicyIndicatorType.RECOMMENDED:return CrPolicyStrings.controlledSettingRecommendedDiffers;case CrPolicyIndicatorType.PARENT:return CrPolicyStrings.controlledSettingParent;case CrPolicyIndicatorType.CHILD_RESTRICTION:return CrPolicyStrings.controlledSettingChildRestriction}return""}}customElements.define(CrPolicyIndicatorElement.is,CrPolicyIndicatorElement);({$:mojo.internal.Enum()});var TileSource;(function(TileSource){TileSource[TileSource["MIN_VALUE"]=0]="MIN_VALUE";TileSource[TileSource["MAX_VALUE"]=6]="MAX_VALUE";TileSource[TileSource["TOP_SITES"]=0]="TOP_SITES";TileSource[TileSource["POPULAR"]=1]="POPULAR";TileSource[TileSource["POPULAR_BAKED_IN"]=2]="POPULAR_BAKED_IN";TileSource[TileSource["CUSTOM_LINKS"]=3]="CUSTOM_LINKS";TileSource[TileSource["ALLOWLIST"]=4]="ALLOWLIST";TileSource[TileSource["HOMEPAGE"]=5]="HOMEPAGE";TileSource[TileSource["ENTERPRISE_SHORTCUTS"]=6]="ENTERPRISE_SHORTCUTS"})(TileSource||(TileSource={}));class MostVisitedBrowserProxy{handler;callbackRouter;constructor(handler,callbackRouter){this.handler=handler;this.callbackRouter=callbackRouter}static getInstance(){if(instance$b){return instance$b}const callbackRouter=new MostVisitedPageCallbackRouter;const handler=new MostVisitedPageHandlerRemote;const factory=MostVisitedPageHandlerFactory.getRemote();factory.createPageHandler(callbackRouter.$.bindNewPipeAndPassRemote(),handler.$.bindNewPipeAndPassReceiver());instance$b=new MostVisitedBrowserProxy(handler,callbackRouter);return instance$b}static setInstance(obj){instance$b=obj}}let instance$b=null;let instance$a=null;function getCss$8(){return instance$a||(instance$a=[...[getCss$r(),getCss$s()],css`:host{--cr-tooltip-icon-fill-color:var(--cr-fallback-color-on-surface-subtle);--icon-button-color-active:var(--google-grey-700);--icon-button-color:var(--google-grey-600);--icon-size:48px;--managed-tile-background-color:var(--cr-fallback-color-neutral-container);--tile-background-color:rgb(229,231,232);--tile-hover-color:rgba(var(--google-grey-900-rgb),.1);--tile-size:112px;--title-height:32px}@media (prefers-color-scheme:dark){:host{--tile-background-color:var(--google-grey-100)}}:host([is-dark_]){--icon-button-color-active:var(--google-grey-300);--icon-button-color:white;--tile-hover-color:rgba(255,255,255,.1)}#container{--content-width:calc(var(--column-count) * var(--tile-size) + 1px);display:flex;flex-wrap:wrap;height:calc(var(--row-count) * var(--tile-size));justify-content:center;margin-bottom:8px;opacity:0;overflow:hidden;padding:2px;transition:opacity 300ms ease-in-out;width:calc(var(--content-width) + 12px)}:host([visible_]) #container{opacity:1}#addShortcutIcon,#showMoreIcon,#showLessIcon,.query-tile-icon{-webkit-mask-repeat:no-repeat;-webkit-mask-size:100%;height:24px;width:24px}.tile-icon-container{background-color:var(--add-shortcut-background-color,var(--tile-background-color));margin-inline-start:auto;margin-inline-end:auto}#addShortcutIcon{-webkit-mask-image:url(chrome://resources/images/add.svg);background-color:var(--add-shortcut-foreground-color,var(--google-grey-900))}#showMoreIcon{-webkit-mask-image:url(chrome://resources/cr_components/most_visited/expand_content.svg);background-color:var(--add-shortcut-foreground-color,var(--google-grey-900))}#showLessIcon{-webkit-mask-image:url(chrome://resources/cr_components/most_visited/collapse_content.svg);background-color:var(--add-shortcut-foreground-color,var(--google-grey-900))}.query-tile-icon{-webkit-mask-image:url(chrome://resources/images/icon_search.svg);background-color:var(--google-grey-700)}@media (forced-colors:active){#addShortcutIcon,#showMoreIcon,#showLessIcon,.query-tile-icon{background-color:ButtonText}}:host([use-white-tile-icon_]) #addShortcutIcon,:host([use-white-tile-icon_]) #showMoreIcon,:host([use-white-tile-icon_]) #showLessIcon{background-color:white}:host([use-white-tile-icon_]) .query-tile-icon{background-color:var(--google-grey-400)}.tile,#addShortcut,#showMore,#showLess{-webkit-tap-highlight-color:transparent;align-items:center;border-radius:4px;box-sizing:border-box;cursor:pointer;display:flex;flex-direction:column;height:var(--tile-size);opacity:1;outline:none;position:relative;text-decoration:none;transition-duration:300ms;transition-property:left,top;transition-timing-function:ease-in-out;user-select:none;width:var(--tile-size)}.tile a{border-radius:4px;display:inline-block;height:100%;outline:none;position:absolute;touch-action:none;width:100%}:host-context(.focus-outline-visible) .tile a:focus,:host-context(.focus-outline-visible) #addShortcut:focus,:host-context(.focus-outline-visible) #showMore:focus,:host-context(.focus-outline-visible) #showLess:focus{box-shadow:var(--most-visited-focus-shadow)}@media (forced-colors:active){:host-context(.focus-outline-visible) .tile a:focus,:host-context(.focus-outline-visible) #addShortcut:focus,:host-context(.focus-outline-visible) #showMore:focus,:host-context(.focus-outline-visible) #showLess:focus{outline:var(--cr-focus-outline-hcm)}}#addShortcut,#showMore,#showLess{background-color:transparent;border:none;box-shadow:none;justify-content:unset;padding:0}:host(:not([reordering_])) .tile:hover,:host(:not([reordering_])) #addShortcut:hover,:host(:not([reordering_])) #showMore:hover,:host(:not([reordering_])) #showLess:hover,.force-hover{background-color:var(--tile-hover-color)}.tile-icon{align-items:center;background-color:var(--tile-background-color);border-radius:50%;display:flex;flex-shrink:0;height:var(--icon-size);justify-content:center;margin-top:16px;width:var(--icon-size)}.tile-icon img{height:24px;width:24px}.managed-tile-icon{align-items:center;background-color:var(--managed-tile-background-color);border-radius:50%;display:flex;flex-shrink:0;height:24px;justify-content:center;left:68px;position:absolute;top:40px;width:24px}cr-policy-indicator{--cr-icon-size:16px}.tile-title{align-items:center;border-radius:calc(var(--title-height) / 2 + 2px);color:var(--most-visited-text-color);display:flex;height:var(--title-height);line-height:calc(var(--title-height) / 2);margin-top:6px;padding:2px 8px;width:88px}.tile-title span{font-weight:400;overflow:hidden;text-align:center;text-overflow:ellipsis;text-shadow:var(--most-visited-text-shadow);white-space:nowrap;width:100%}.tile[query-tile] .tile-title span{-webkit-box-orient:vertical;-webkit-line-clamp:2;display:-webkit-box;white-space:initial}.title-rtl{direction:rtl}.title-ltr{direction:ltr}.tile.dragging{background-color:var(--tile-hover-color);transition-property:none;z-index:2}cr-icon-button{--cr-icon-button-fill-color:var(--icon-button-color);--cr-icon-button-size:28px;--cr-icon-button-transition:none;margin:4px 2px;opacity:0;position:absolute;right:0;top:0;transition:opacity 100ms ease-in-out}:host-context([dir=rtl]) cr-icon-button{left:0;right:unset}:host(:not([reordering_])) .tile:hover cr-icon-button,.force-hover cr-icon-button{opacity:1;transition-delay:400ms}:host(:not([reordering_])) cr-icon-button:active,:host-context(.focus-outline-visible):host(:not([reordering_])) cr-icon-button:focus,:host(:not([reordering_])) cr-icon-button:hover{--cr-icon-button-fill-color:var(--icon-button-color-active);opacity:1;transition-delay:0s}#dialogContent{height:160px}#dialogContent:has(#policySubtitleContainer:not([hidden])){height:196px}#policySubtitleContainer{--iron-icon-height:20px;--iron-icon-width:20px;gap:10px;display:flex;margin-bottom:16px}`])}function getHtml$7(){return html`<!--_html_template_start_-->
<div id="container" ?hidden="${!this.visible_}"
    .style="--tile-background-color: ${this.getBackgroundColorStyle_()};
            --column-count: ${this.columnCount_};
            --row-count: ${this.rowCount_};">
  ${this.tiles_.map(((item,index)=>html`
    <div class="tile" ?query-tile="${item.isQueryTile}"
      ?hidden="${this.isHidden_(index)}"
      title="${item.title}" @dragstart="${this.onDragStart_}"
      @touchstart="${this.onTouchStart_}" @click="${this.onTileClick_}"
      @mouseenter="${this.onTileHover_}" @mouseleave="${this.onTileExit_}"
      @mousedown="${this.onTileMouseDown_}" @keydown="${this.onTileKeyDown_}"
      draggable="true" data-index="${index}">
      <a href="${item.url.url}" aria-label="${item.title}"
          draggable="false">
      </a>
      <cr-icon-button id="actionMenuButton" class="icon-more-vert"
          title="${this.getMoreActionText_(item.title)}"
          @click="${this.onTileActionButtonClick_}" tabindex="0"
          ?hidden="${!this.customLinksEnabled_&&!this.isFromEnterpriseShortcut_(item.source)}"
          data-index="${index}"></cr-icon-button>
      <cr-icon-button id="removeButton" class="icon-clear"
          title="${this.i18n("linkRemove")}"
          @click="${this.onTileRemoveButtonClick_}" tabindex="0"
          ?hidden="${this.customLinksEnabled_||this.isFromEnterpriseShortcut_(item.source)}"
          data-index="${index}"></cr-icon-button>
      <div class="tile-icon">
        <img src="${this.getFaviconUrl_(item.url)}" draggable="false"
            ?hidden="${item.isQueryTile}" alt=""></img>
        <div class="query-tile-icon" draggable="false"
            ?hidden="${!item.isQueryTile}"></div>
        <div class="managed-tile-icon"
          ?hidden="${!this.isFromEnterpriseShortcut_(item.source)}">
          <cr-policy-indicator indicator-type="userPolicy">
          </cr-policy-indicator>
        </div>
      </div>
      <div class="tile-title ${this.getTileTitleDirectionClass_(item)}">
        <span>${item.title}</span>
      </div>
    </div>
  `))}
  <cr-button id="addShortcut" tabindex="0" @click="${this.onAdd_}"
      ?hidden="${!this.showAdd_}" @keydown="${this.onAddShortcutKeyDown_}"
      aria-label="${this.i18n("addLinkTitle")}"
      title="${this.i18n("addLinkTitle")}" noink>
    <div class="tile-icon tile-icon-container">
      <div id="addShortcutIcon" draggable="false"></div>
    </div>
    <div class="tile-title">
      <span>${this.i18n("addLinkTitle")}</span>
    </div>
  </cr-button>
  <div>
    <cr-button id="showMore" tabindex="0" @click="${this.onShowMoreClick_}"
        ?hidden="${!this.showShowMore_}" @keydown="${this.onShowMoreKeyDown_}"
        aria-label="${this.i18n("showMore")}"
        title="${this.i18n("showMore")}" noink>
      <div class="tile-icon tile-icon-container">
        <div id="showMoreIcon" draggable="false"></div>
      </div>
      <div class="tile-title">
        <span>${this.i18n("showMore")}</span>
      </div>
    </cr-button>
    <cr-button id="showLess" tabindex="0" @click="${this.onShowLessClick_}"
        ?hidden="${!this.showShowLess_}" @keydown="${this.onShowLessKeyDown_}"
        aria-label="${this.i18n("showLess")}"
        title="${this.i18n("showLess")}" noink>
      <div class="tile-icon tile-icon-container">
        <div id="showLessIcon" draggable="false"></div>
      </div>
      <div class="tile-title">
        <span>${this.i18n("showLess")}</span>
      </div>
    </cr-button>
  </div>
  <cr-dialog id="dialog" @close="${this.onDialogClose_}">
    <div slot="title">${this.dialogTitle_}</div>
    <div slot="body" id="dialogContent">
      ${this.isFromEnterpriseShortcut_(this.dialogSource_)?html`
        <div id="policySubtitleContainer">
          <cr-icon icon="cr:domain"></cr-icon>
          <span class="secondary">
            ${this.i18n("enterpriseShortcutSubtitle")}
          </span>
        </div>`:""}
      <cr-input id="dialogInputName" label="${this.i18n("nameField")}"
          .value="${this.dialogTileTitle_}"
          ?readonly="${this.dialogIsReadonly_}"
          spellcheck="false" autofocus
          @value-changed="${this.onDialogTileNameChange_}">
      </cr-input>
      <cr-input id="dialogInputUrl" label="${this.i18n("urlField")}"
          .value="${this.dialogTileUrl_}"
          ?invalid="${this.dialogTileUrlInvalid_}"
          .errorMessage="${this.dialogTileUrlError_}" spellcheck="false"
          type="url" @blur="${this.onDialogTileUrlBlur_}"
          @value-changed="${this.onDialogTileUrlChange_}"
          ?readonly="${this.dialogIsReadonly_||this.isFromEnterpriseShortcut_(this.dialogSource_)}">
      </cr-input>
    </div>
    <div slot="button-container">
      <cr-button class="cancel-button" @click="${this.onDialogCancel_}"
          ?hidden="${this.dialogIsReadonly_}">
        ${this.i18n("linkCancel")}
      </cr-button>
      <cr-button class="action-button" @click="${this.onSave_}"
          ?disabled="${this.dialogSaveDisabled_}">
        ${this.i18n("linkDone")}
      </cr-button>
    </div>
  </cr-dialog>
  <cr-action-menu id="actionMenu">
    <button id="actionMenuViewOrEdit" class="dropdown-item"
        @click="${this.onViewOrEdit_}">
      ${this.actionMenuViewOrEditTitle_}
    </button>
    <button id="actionMenuRemove" class="dropdown-item"
        @click="${this.onRemove_}"
        ?disabled="${this.actionMenuRemoveDisabled_}">
      ${this.i18n("linkRemove")}
    </button>
  </cr-action-menu>
</div>
<cr-toast-manager id="toastManager" duration="10000">
  <cr-button id="undo" aria-label="${this.i18n("undoDescription")}"
      @click="${this.onUndoClick_}">
    ${this.i18n("undo")}
  </cr-button>
  <cr-button id="restore"
      aria-label="${this.getRestoreButtonText_()}"
      @click="${this.onRestoreDefaultsClick_}">
    ${this.getRestoreButtonText_()}
  </cr-button>
</cr-toast-manager>
<!--_html_template_end_-->`}class MostVisitedWindowProxy{matchMedia(query){return window.matchMedia(query)}now(){return Date.now()}static getInstance(){return instance$9||(instance$9=new MostVisitedWindowProxy)}static setInstance(obj){instance$9=obj}}let instance$9=null;const MAX_TILES_DEFAULT=8;const MAX_TILES_FOR_CUSTOM_LINKS=10;const MAX_TILES_FOR_ENTERPRISE_SHORTCUTS=10;function resetTilePosition(tile){tile.style.position="";tile.style.left="";tile.style.top=""}function setTilePosition(tile,{x:x,y:y}){tile.style.position="fixed";tile.style.left=`${x}px`;tile.style.top=`${y}px`}function getHitIndex(rects,x,y){return rects.findIndex((r=>x>=r.left&&x<=r.right&&y>=r.top&&y<=r.bottom))}function normalizeUrl(urlString){try{const url=new URL(urlString.includes("://")?urlString:`https://${urlString}/`);if(["http:","https:"].includes(url.protocol)){return url}}catch(e){}return null}const MostVisitedElementBase=I18nMixinLit(CrLitElement);class MostVisitedElement extends MostVisitedElementBase{static get is(){return"cr-most-visited"}static get styles(){return getCss$8()}render(){return getHtml$7.bind(this)()}static get properties(){return{theme:{type:Object},singleRow:{type:Boolean},reflowOnOverflow:{type:Boolean},useWhiteTileIcon_:{type:Boolean,reflect:true},columnCount_:{type:Number,state:true},rowCount_:{type:Number,state:true},customLinksEnabled_:{type:Boolean,reflect:true},enterpriseShortcutsEnabled_:{type:Boolean,reflect:true},dialogTileTitle_:{type:String,state:true},dialogTileUrl_:{type:String,state:true},dialogTileUrlInvalid_:{type:Boolean,state:true},dialogTitle_:{type:String,state:true},dialogSaveDisabled_:{type:Boolean,state:true},dialogShortcutAlreadyExists_:{type:Boolean,state:true},dialogTileUrlError_:{type:String,state:true},dialogIsReadonly_:{type:Boolean,state:true},dialogSource_:{type:Number,state:true},info_:{type:Object,state:true},actionMenuRemoveDisabled_:{type:Boolean,state:true},actionMenuViewOrEditTitle_:{type:String,state:true},isDark_:{type:Boolean,reflect:true},reordering_:{type:Boolean,reflect:true},maxTiles_:{type:Number,state:true},maxVisibleTiles_:{type:Number,state:true},showAdd_:{type:Boolean,state:true},showToastButtons_:{type:Boolean,state:true},maxVisibleColumnCount_:{type:Number,state:true},tiles_:{type:Array,state:true},toastContent_:{type:String,state:true},toastSource_:{type:Number,state:true},expandableTilesEnabled:{type:Boolean,reflect:true},maxTilesBeforeShowMore:{type:Number,reflect:true},showAll_:{type:Boolean,state:true},showShowMore_:{type:Boolean,state:true},showShowLess_:{type:Boolean,state:true},visible_:{type:Boolean,reflect:true}}}#theme_accessor_storage=null;get theme(){return this.#theme_accessor_storage}set theme(value){this.#theme_accessor_storage=value}#reflowOnOverflow_accessor_storage=false;get reflowOnOverflow(){return this.#reflowOnOverflow_accessor_storage}set reflowOnOverflow(value){this.#reflowOnOverflow_accessor_storage=value}#singleRow_accessor_storage=false;get singleRow(){return this.#singleRow_accessor_storage}set singleRow(value){this.#singleRow_accessor_storage=value}#expandableTilesEnabled_accessor_storage=false;get expandableTilesEnabled(){return this.#expandableTilesEnabled_accessor_storage}set expandableTilesEnabled(value){this.#expandableTilesEnabled_accessor_storage=value}#maxTilesBeforeShowMore_accessor_storage=0;get maxTilesBeforeShowMore(){return this.#maxTilesBeforeShowMore_accessor_storage}set maxTilesBeforeShowMore(value){this.#maxTilesBeforeShowMore_accessor_storage=value}#showAll__accessor_storage=false;get showAll_(){return this.#showAll__accessor_storage}set showAll_(value){this.#showAll__accessor_storage=value}#showShowMore__accessor_storage=false;get showShowMore_(){return this.#showShowMore__accessor_storage}set showShowMore_(value){this.#showShowMore__accessor_storage=value}#showShowLess__accessor_storage=false;get showShowLess_(){return this.#showShowLess__accessor_storage}set showShowLess_(value){this.#showShowLess__accessor_storage=value}#useWhiteTileIcon__accessor_storage=false;get useWhiteTileIcon_(){return this.#useWhiteTileIcon__accessor_storage}set useWhiteTileIcon_(value){this.#useWhiteTileIcon__accessor_storage=value}#columnCount__accessor_storage=3;get columnCount_(){return this.#columnCount__accessor_storage}set columnCount_(value){this.#columnCount__accessor_storage=value}#rowCount__accessor_storage=1;get rowCount_(){return this.#rowCount__accessor_storage}set rowCount_(value){this.#rowCount__accessor_storage=value}#customLinksEnabled__accessor_storage=false;get customLinksEnabled_(){return this.#customLinksEnabled__accessor_storage}set customLinksEnabled_(value){this.#customLinksEnabled__accessor_storage=value}#enterpriseShortcutsEnabled__accessor_storage=false;get enterpriseShortcutsEnabled_(){return this.#enterpriseShortcutsEnabled__accessor_storage}set enterpriseShortcutsEnabled_(value){this.#enterpriseShortcutsEnabled__accessor_storage=value}#dialogTileTitle__accessor_storage="";get dialogTileTitle_(){return this.#dialogTileTitle__accessor_storage}set dialogTileTitle_(value){this.#dialogTileTitle__accessor_storage=value}#dialogTileUrl__accessor_storage="";get dialogTileUrl_(){return this.#dialogTileUrl__accessor_storage}set dialogTileUrl_(value){this.#dialogTileUrl__accessor_storage=value}#dialogTileUrlInvalid__accessor_storage=false;get dialogTileUrlInvalid_(){return this.#dialogTileUrlInvalid__accessor_storage}set dialogTileUrlInvalid_(value){this.#dialogTileUrlInvalid__accessor_storage=value}#dialogTitle__accessor_storage="";get dialogTitle_(){return this.#dialogTitle__accessor_storage}set dialogTitle_(value){this.#dialogTitle__accessor_storage=value}#dialogSaveDisabled__accessor_storage=true;get dialogSaveDisabled_(){return this.#dialogSaveDisabled__accessor_storage}set dialogSaveDisabled_(value){this.#dialogSaveDisabled__accessor_storage=value}#dialogShortcutAlreadyExists__accessor_storage=false;get dialogShortcutAlreadyExists_(){return this.#dialogShortcutAlreadyExists__accessor_storage}set dialogShortcutAlreadyExists_(value){this.#dialogShortcutAlreadyExists__accessor_storage=value}#dialogTileUrlError__accessor_storage="";get dialogTileUrlError_(){return this.#dialogTileUrlError__accessor_storage}set dialogTileUrlError_(value){this.#dialogTileUrlError__accessor_storage=value}#dialogIsReadonly__accessor_storage=false;get dialogIsReadonly_(){return this.#dialogIsReadonly__accessor_storage}set dialogIsReadonly_(value){this.#dialogIsReadonly__accessor_storage=value}#dialogSource__accessor_storage=TileSource.CUSTOM_LINKS;get dialogSource_(){return this.#dialogSource__accessor_storage}set dialogSource_(value){this.#dialogSource__accessor_storage=value}#actionMenuRemoveDisabled__accessor_storage=false;get actionMenuRemoveDisabled_(){return this.#actionMenuRemoveDisabled__accessor_storage}set actionMenuRemoveDisabled_(value){this.#actionMenuRemoveDisabled__accessor_storage=value}#actionMenuViewOrEditTitle__accessor_storage="";get actionMenuViewOrEditTitle_(){return this.#actionMenuViewOrEditTitle__accessor_storage}set actionMenuViewOrEditTitle_(value){this.#actionMenuViewOrEditTitle__accessor_storage=value}#isDark__accessor_storage=false;get isDark_(){return this.#isDark__accessor_storage}set isDark_(value){this.#isDark__accessor_storage=value}#reordering__accessor_storage=false;get reordering_(){return this.#reordering__accessor_storage}set reordering_(value){this.#reordering__accessor_storage=value}#maxTiles__accessor_storage=0;get maxTiles_(){return this.#maxTiles__accessor_storage}set maxTiles_(value){this.#maxTiles__accessor_storage=value}#maxVisibleTiles__accessor_storage=0;get maxVisibleTiles_(){return this.#maxVisibleTiles__accessor_storage}set maxVisibleTiles_(value){this.#maxVisibleTiles__accessor_storage=value}#showAdd__accessor_storage=false;get showAdd_(){return this.#showAdd__accessor_storage}set showAdd_(value){this.#showAdd__accessor_storage=value}#maxVisibleColumnCount__accessor_storage=0;get maxVisibleColumnCount_(){return this.#maxVisibleColumnCount__accessor_storage}set maxVisibleColumnCount_(value){this.#maxVisibleColumnCount__accessor_storage=value}#tiles__accessor_storage=[];get tiles_(){return this.#tiles__accessor_storage}set tiles_(value){this.#tiles__accessor_storage=value}#toastSource__accessor_storage=TileSource.CUSTOM_LINKS;get toastSource_(){return this.#toastSource__accessor_storage}set toastSource_(value){this.#toastSource__accessor_storage=value}#visible__accessor_storage=false;get visible_(){return this.#visible__accessor_storage}set visible_(value){this.#visible__accessor_storage=value}adding_=false;callbackRouter_;pageHandler_;windowProxy_;actionMenuTargetIndex_=-1;dragOffset_;tileRects_=[];isRtl_=false;mediaEventTracker_;eventTracker_;boundOnDocumentKeyDown_=_e=>null;prefetchTimer_=null;preconnectTimer_=null;dragImage_;#info__accessor_storage=null;get info_(){return this.#info__accessor_storage}set info_(value){this.#info__accessor_storage=value}get tileElements_(){return Array.from(this.shadowRoot.querySelectorAll(".tile:not([hidden])"))}constructor(){performance.mark("most-visited-creation-start");super();this.callbackRouter_=MostVisitedBrowserProxy.getInstance().callbackRouter;this.pageHandler_=MostVisitedBrowserProxy.getInstance().handler;this.windowProxy_=MostVisitedWindowProxy.getInstance();this.dragOffset_=null;this.dragImage_=new Image(1,1);this.dragImage_.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAA"+"ABAAEAAAICTAEAOw==";this.mediaEventTracker_=new EventTracker;this.eventTracker_=new EventTracker}connectedCallback(){super.connectedCallback();this.isRtl_=window.getComputedStyle(this)["direction"]==="rtl";this.onSingleRowChange_();this.callbackRouter_.setMostVisitedInfo.addListener((info=>{performance.measure("most-visited-mojo","most-visited-mojo-start");this.info_=info}));this.pageHandler_.getMostVisitedExpandedState().then((({isExpanded:isExpanded})=>{this.showAll_=isExpanded}));performance.mark("most-visited-mojo-start");this.eventTracker_.add(document,"visibilitychange",(()=>{if(document.visibilityState==="visible"){this.pageHandler_.updateMostVisitedInfo()}}));this.pageHandler_.updateMostVisitedInfo();FocusOutlineManager.forDocument(document)}disconnectedCallback(){super.disconnectedCallback();this.mediaEventTracker_.removeAll();this.eventTracker_.removeAll();this.ownerDocument.removeEventListener("keydown",this.boundOnDocumentKeyDown_)}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedProperties.has("theme")){this.useWhiteTileIcon_=this.computeUseWhiteTileIcon_();this.isDark_=this.computeIsDark_()}if(changedPrivateProperties.has("info_")&&this.info_!==null){this.visible_=this.info_.visible;this.customLinksEnabled_=this.info_.customLinksEnabled;this.enterpriseShortcutsEnabled_=this.info_.enterpriseShortcutsEnabled;this.maxTiles_=(this.customLinksEnabled_?MAX_TILES_FOR_CUSTOM_LINKS:MAX_TILES_DEFAULT)+(this.enterpriseShortcutsEnabled_?MAX_TILES_FOR_ENTERPRISE_SHORTCUTS:0);this.tiles_=this.info_.tiles.slice(0,this.maxTiles_)}this.showShowMore_=this.computeShowShowMore_();this.showShowLess_=this.computeShowShowLess_();this.showAdd_=this.computeShowAdd_();this.columnCount_=this.computeColumnCount_();this.rowCount_=this.computeRowCount_();if(changedPrivateProperties.has("tiles_")||changedPrivateProperties.has("dialogTileUrl_")){this.dialogShortcutAlreadyExists_=this.computeDialogShortcutAlreadyExists_()}if(changedPrivateProperties.has("dialogShortcutAlreadyExists_")){this.dialogTileUrlError_=this.computeDialogTileUrlError_()}if(changedPrivateProperties.has("dialogTitle_")||changedPrivateProperties.has("dialogTileUrl_")){this.dialogSaveDisabled_=this.computeDialogSaveDisabled_()}}firstUpdated(){this.boundOnDocumentKeyDown_=e=>this.onDocumentKeyDown_(e);this.ownerDocument.addEventListener("keydown",this.boundOnDocumentKeyDown_);performance.measure("most-visited-creation","most-visited-creation-start")}updated(changedProperties){super.updated(changedProperties);this.maxVisibleTiles_=this.computeMaxVisibleTiles_();const changedPrivateProperties=changedProperties;if(changedProperties.has("singleRow")){this.onSingleRowChange_()}if(changedPrivateProperties.has("tiles_")){if(this.tiles_.length>0){this.onTilesRendered_()}}}getBackgroundColorStyle_(){const skColor=this.theme?this.theme.backgroundColor:null;return skColor?skColorToRgba(skColor):"inherit"}enableForceHover_(index){this.tileElements_[index].classList.add("force-hover")}clearForceHover_(){const forceHover=this.shadowRoot.querySelector(".force-hover");if(forceHover){forceHover.classList.remove("force-hover")}}computeColumnCount_(){const shortcutCount=this.tiles_?this.tiles_.length:0;const canShowAdd=this.expandableTilesEnabled?this.showAdd_:this.maxTiles_>shortcutCount;const canShowShowMore=this.expandableTilesEnabled&&this.showShowMore_;const canShowShowLess=this.expandableTilesEnabled&&this.showShowLess_;const visibleShortcutCount=canShowShowMore?this.maxTilesBeforeShowMore+1:shortcutCount;const totalTileCount=visibleShortcutCount+(canShowAdd?1:0)+(canShowShowMore||canShowShowLess?1:0);const columnCount=totalTileCount<=this.maxVisibleColumnCount_?totalTileCount:Math.min(this.maxVisibleColumnCount_,Math.ceil(totalTileCount/(this.singleRow?1:2)));return columnCount||3}computeRowCount_(){if(this.columnCount_===0){return 0}if(this.reflowOnOverflow&&this.tiles_){const visibleShortcutCount=this.expandableTilesEnabled&&this.showShowMore_?this.maxTilesBeforeShowMore+1:this.tiles_.length;return Math.ceil((visibleShortcutCount+(this.showAdd_?1:0)+(this.showShowMore_||this.showShowLess_?1:0))/this.columnCount_)}if(this.singleRow){return 1}const shortcutCount=this.tiles_?this.tiles_.length:0;return this.columnCount_<=shortcutCount?2:1}computeMaxVisibleTiles_(){if(this.expandableTilesEnabled&&this.showShowMore_){return this.maxTilesBeforeShowMore+1}if(this.reflowOnOverflow){return this.maxTiles_}return this.columnCount_*this.rowCount_}computeShowAdd_(){if(this.showShowMore_){return false}if(!this.customLinksEnabled_){return false}const customLinkTilesCount=this.tiles_.filter((tile=>!this.isFromEnterpriseShortcut_(tile.source))).length;return this.tiles_.length<(this.expandableTilesEnabled&&this.showAll_?this.maxTiles_:this.maxVisibleTiles_)&&customLinkTilesCount<MAX_TILES_FOR_CUSTOM_LINKS}computeShowShowMore_(){return this.expandableTilesEnabled&&!this.showAll_&&this.tiles_&&this.tiles_.length>this.maxTilesBeforeShowMore}computeShowShowLess_(){return this.expandableTilesEnabled&&this.showAll_&&this.tiles_&&this.tiles_.length>this.maxTilesBeforeShowMore}async onShowMoreClick_(){this.showAll_=true;this.pageHandler_.setMostVisitedExpandedState(this.showAll_);await this.updateComplete;this.tileFocus_(this.maxTilesBeforeShowMore+1)}async onShowLessClick_(){this.showAll_=false;this.pageHandler_.setMostVisitedExpandedState(this.showAll_);await this.updateComplete;this.$.showMore.focus()}computeDialogSaveDisabled_(){return!this.dialogTileUrl_.trim()||normalizeUrl(this.dialogTileUrl_)===null||this.dialogShortcutAlreadyExists_}computeDialogShortcutAlreadyExists_(){const dialogTileHref=(normalizeUrl(this.dialogTileUrl_)||{}).href;if(!dialogTileHref){return false}if(this.dialogSource_===TileSource.ENTERPRISE_SHORTCUTS){return false}return(this.tiles_||[]).some((({url:{url:url}},index)=>{if(index===this.actionMenuTargetIndex_){return false}const otherUrl=normalizeUrl(url);return otherUrl&&otherUrl.href===dialogTileHref&&this.tiles_[index].source!==TileSource.ENTERPRISE_SHORTCUTS}))}computeDialogTileUrlError_(){return loadTimeData.getString(this.dialogShortcutAlreadyExists_?"shortcutAlreadyExists":"invalidUrl")}computeIsDark_(){return this.theme?this.theme.isDark:false}computeUseWhiteTileIcon_(){return this.theme?this.theme.useWhiteTileIcon:false}dragEnd_(){if(!this.customLinksEnabled_&&!this.enterpriseShortcutsEnabled_){this.reordering_=false;return}this.dragOffset_=null;const dragElement=this.shadowRoot.querySelector(".tile.dragging");const droppedElement=this.shadowRoot.querySelector(".tile.dropped");if(!dragElement&&!droppedElement){this.reordering_=false;return}if(dragElement){dragElement.classList.remove("dragging");this.tileElements_.forEach((el=>resetTilePosition(el)));resetTilePosition(this.$.addShortcut);resetTilePosition(this.$.showMore);resetTilePosition(this.$.showLess)}else if(droppedElement){droppedElement.classList.remove("dropped")}}drop_(x,y){if(!this.customLinksEnabled_&&!this.enterpriseShortcutsEnabled_){return}const dragElement=this.shadowRoot.querySelector(".tile.dragging");if(!dragElement){return}const dragIndex=Number(dragElement.dataset["index"]);const dropIndex=getHitIndex(this.tileRects_,x,y);if(dragIndex!==dropIndex&&dropIndex>-1){const dragTile=this.tiles_[dragIndex];assert(dragTile);const dropTile=this.tiles_[dropIndex];assert(dropTile);if(this.isFromEnterpriseShortcut_(dragTile.source)!==this.isFromEnterpriseShortcut_(dropTile.source)){return}const[draggingTile]=this.tiles_.splice(dragIndex,1);assert(draggingTile);this.tiles_.splice(dropIndex,0,draggingTile);this.requestUpdate();let newDropIndex=dropIndex;if(!this.isFromEnterpriseShortcut_(draggingTile.source)){newDropIndex-=this.tiles_.filter((t=>this.isFromEnterpriseShortcut_(t.source))).length}this.pageHandler_.reorderMostVisitedTile(draggingTile,newDropIndex);dragElement.classList.remove("dragging");dragElement.classList.add("dropped");this.tileElements_.forEach((el=>resetTilePosition(el)));resetTilePosition(this.$.addShortcut);resetTilePosition(this.$.showMore);resetTilePosition(this.$.showLess)}}dragOver_(x,y){const dragElement=this.shadowRoot.querySelector(".tile.dragging");if(!dragElement){this.reordering_=false;return}const dragIndex=Number(dragElement.dataset["index"]);setTilePosition(dragElement,{x:x-this.dragOffset_.x,y:y-this.dragOffset_.y});let dropIndex=getHitIndex(this.tileRects_,x,y);if(dropIndex>-1){const dragTile=this.tiles_[dragIndex];const dropTile=this.tiles_[dropIndex];if(this.isFromEnterpriseShortcut_(dragTile.source)!==this.isFromEnterpriseShortcut_(dropTile.source)){dropIndex=-1}}this.tileElements_.forEach(((element,i)=>{let positionIndex;if(i===dragIndex){return}else if(dropIndex===-1){positionIndex=i}else if(dragIndex<dropIndex&&dragIndex<=i&&i<=dropIndex){positionIndex=i-1}else if(dragIndex>dropIndex&&dragIndex>=i&&i>=dropIndex){positionIndex=i+1}else{positionIndex=i}setTilePosition(element,this.tileRects_[positionIndex])}))}dragStart_(dragElement,x,y){this.clearForceHover_();dragElement.classList.add("dragging");const dragElementRect=dragElement.getBoundingClientRect();this.dragOffset_={x:x-dragElementRect.x,y:y-dragElementRect.y};const visibleElements=this.tileElements_;const numTiles=visibleElements.length;if(this.showAdd_){visibleElements.push(this.$.addShortcut)}if(this.showShowMore_){visibleElements.push(this.$.showMore)}if(this.showShowLess_){visibleElements.push(this.$.showLess)}const allRects=visibleElements.map((t=>t.getBoundingClientRect()));this.tileRects_=allRects.slice(0,numTiles);visibleElements.forEach(((el,i)=>{setTilePosition(el,allRects[i])}));this.reordering_=true}getFaviconUrl_(url){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","24");faviconUrl.searchParams.set("scaleFactor","1x");faviconUrl.searchParams.set("showFallbackMonogram","");faviconUrl.searchParams.set("pageUrl",url.url);return faviconUrl.href}getRestoreButtonText_(){return loadTimeData.getString(this.isFromEnterpriseShortcut_(this.toastSource_)?"restoreDefaultEnterpriseShortcuts":this.customLinksEnabled_?"restoreDefaultLinks":"restoreThumbnailsShort")}getTileTitleDirectionClass_(tile){return tile.titleDirection===TextDirection.RIGHT_TO_LEFT?"title-rtl":"title-ltr"}isHidden_(index){if(this.reflowOnOverflow&&!this.showShowMore_){return false}return index>=this.maxVisibleTiles_}onSingleRowChange_(){if(!this.isConnected){return}this.mediaEventTracker_.removeAll();const queryLists=[];const updateCount=()=>{const index=queryLists.findIndex((listener=>listener.matches));this.maxVisibleColumnCount_=3+(index>-1?queryLists.length-index:0)};const maxColumnCount=this.singleRow?10:5;for(let i=maxColumnCount;i>=4;i--){const query=`(min-width: ${112*(i+1)}px)`;const queryList=this.windowProxy_.matchMedia(query);this.mediaEventTracker_.add(queryList,"change",updateCount);queryLists.push(queryList)}updateCount()}onAdd_(){this.dialogIsReadonly_=false;this.dialogSource_=TileSource.CUSTOM_LINKS;this.dialogTitle_=loadTimeData.getString("addLinkTitle");this.dialogTileTitle_="";this.dialogTileUrl_="";this.dialogTileUrlInvalid_=false;this.adding_=true;this.$.dialog.showModal()}onAddShortcutKeyDown_(e){if(hasKeyModifiers(e)){return}if(!this.tiles_||this.tiles_.length===0){return}const backKey=this.isRtl_?"ArrowRight":"ArrowLeft";if(e.key===backKey||e.key==="ArrowUp"){this.tileFocus_(this.tiles_.length-1)}const advanceKey=this.isRtl_?"ArrowLeft":"ArrowRight";if(e.key===advanceKey||e.key==="ArrowDown"){if(this.showShowLess_){this.$.showLess.focus()}}}onShowMoreKeyDown_(e){if(hasKeyModifiers(e)){return}const backKey=this.isRtl_?"ArrowRight":"ArrowLeft";if(e.key===backKey||e.key==="ArrowUp"){this.tileFocus_(this.maxTilesBeforeShowMore)}}onShowLessKeyDown_(e){if(hasKeyModifiers(e)){return}const backKey=this.isRtl_?"ArrowRight":"ArrowLeft";if(e.key===backKey||e.key==="ArrowUp"){if(this.showAdd_){this.$.addShortcut.focus()}else{this.tileFocus_(this.tiles_.length-1)}}}onDialogCancel_(){this.actionMenuTargetIndex_=-1;this.$.dialog.cancel()}onDialogClose_(){this.dialogTileUrl_="";if(this.adding_){this.$.addShortcut.focus()}this.adding_=false}onDialogTileUrlBlur_(){if(this.dialogTileUrl_.length>0&&(normalizeUrl(this.dialogTileUrl_)===null||this.dialogShortcutAlreadyExists_)){this.dialogTileUrlInvalid_=true}}onDialogTileUrlChange_(e){this.dialogTileUrl_=e.target.value;this.dialogTileUrlInvalid_=false}onDialogTileNameChange_(e){this.dialogTileTitle_=e.target.value}onDocumentKeyDown_(e){if(e.altKey||e.shiftKey){return}const modifier=isMac?e.metaKey&&!e.ctrlKey:e.ctrlKey&&!e.metaKey;if(modifier&&e.key==="z"){e.preventDefault();this.onUndoClick_()}}onDragStart_(e){const item=this.tiles_[this.getCurrentTargetIndex_(e)];assert(item);if(!this.customLinksEnabled_&&!this.isFromEnterpriseShortcut_(item.source)){return}if(e.dataTransfer){e.dataTransfer.setDragImage(this.dragImage_,0,0)}this.dragStart_(e.target,e.x,e.y);const dragOver=e=>{e.preventDefault();e.dataTransfer.dropEffect="move";this.dragOver_(e.x,e.y)};const drop=e=>{this.drop_(e.x,e.y);const dropIndex=getHitIndex(this.tileRects_,e.x,e.y);if(dropIndex!==-1){this.enableForceHover_(dropIndex)}};this.ownerDocument.addEventListener("dragover",dragOver);this.ownerDocument.addEventListener("drop",drop);this.ownerDocument.addEventListener("dragend",(_=>{this.ownerDocument.removeEventListener("dragover",dragOver);this.ownerDocument.removeEventListener("drop",drop);this.dragEnd_();this.addEventListener("pointermove",(()=>{this.clearForceHover_();this.reordering_=false}),{once:true})}),{once:true})}onViewOrEdit_(){this.$.actionMenu.close();const tile=this.tiles_[this.actionMenuTargetIndex_];const isReadonly=!tile.allowUserEdit;this.dialogIsReadonly_=isReadonly;this.dialogSource_=tile.source;this.dialogTitle_=loadTimeData.getString(isReadonly?"viewLinkTitle":"editLinkTitle");this.dialogTileTitle_=tile.title;this.dialogTileUrl_=tile.url.url;this.dialogTileUrlInvalid_=false;this.$.dialog.showModal()}onRestoreDefaultsClick_(){if(!this.$.toastManager.isToastOpen||this.$.toastManager.slottedHidden){return}this.$.toastManager.hide();this.pageHandler_.restoreMostVisitedDefaults(this.toastSource_)}async onRemove_(){this.$.actionMenu.close();await this.tileRemove_(this.actionMenuTargetIndex_);this.actionMenuTargetIndex_=-1}async onSave_(){if(this.dialogIsReadonly_){this.$.dialog.close();return}const newUrl={url:normalizeUrl(this.dialogTileUrl_).href};this.$.dialog.close();let newTitle=this.dialogTileTitle_.trim();if(newTitle.length===0){newTitle=this.dialogTileUrl_}if(this.adding_){const{success:success}=await this.pageHandler_.addMostVisitedTile(newUrl,newTitle);this.toast_(success?"linkAddedMsg":"linkCantCreate",success,TileSource.TOP_SITES)}else{const oldTile=this.tiles_[this.actionMenuTargetIndex_];if(oldTile.url.url!==newUrl.url||oldTile.title!==newTitle){const{success:success}=await this.pageHandler_.updateMostVisitedTile(oldTile,newUrl,newTitle);this.toast_(success?"linkEditedMsg":"linkCantEdit",success,oldTile.source)}this.actionMenuTargetIndex_=-1}}getCurrentTargetIndex_(e){const target=e.currentTarget;return Number(target.dataset["index"])}onTileActionButtonClick_(e){e.preventDefault();this.actionMenuTargetIndex_=this.getCurrentTargetIndex_(e);const item=this.tiles_[this.getCurrentTargetIndex_(e)];assert(item);this.actionMenuRemoveDisabled_=!item.allowUserDelete;this.actionMenuViewOrEditTitle_=loadTimeData.getString(item.allowUserEdit?"editLinkTitle":"viewLink");this.$.actionMenu.showAt(e.target)}onTileRemoveButtonClick_(e){e.preventDefault();this.tileRemove_(this.getCurrentTargetIndex_(e))}onTileClick_(e){if(e.defaultPrevented){return}e.preventDefault();const index=this.getCurrentTargetIndex_(e);const item=this.tiles_[index];this.pageHandler_.onMostVisitedTileNavigation(item,index,e.button||0,e.altKey,e.ctrlKey,e.metaKey,e.shiftKey)}onTileKeyDown_(e){if(hasKeyModifiers(e)){return}if(e.key!=="ArrowLeft"&&e.key!=="ArrowRight"&&e.key!=="ArrowUp"&&e.key!=="ArrowDown"&&e.key!=="Delete"){return}const index=this.getCurrentTargetIndex_(e);if(e.key==="Delete"){this.tileRemove_(index);return}const advanceKey=this.isRtl_?"ArrowLeft":"ArrowRight";const delta=e.key===advanceKey||e.key==="ArrowDown"?1:-1;const newIndex=Math.max(0,index+delta);if(this.showShowMore_&&newIndex===this.maxTilesBeforeShowMore+1){this.$.showMore.focus()}else{this.tileFocus_(newIndex)}}onTileHover_(e){if(e.defaultPrevented){return}const item=this.tiles_[this.getCurrentTargetIndex_(e)];assert(item);if(loadTimeData.getBoolean("prerenderOnPressEnabled")&&loadTimeData.getInteger("preconnectStartTimeThreshold")>=0){this.preconnectTimer_=setTimeout((()=>{this.pageHandler_.preconnectMostVisitedTile(item)}),loadTimeData.getInteger("preconnectStartTimeThreshold"))}if(loadTimeData.getBoolean("prefetchTriggerEnabled")&&loadTimeData.getInteger("prefetchStartTimeThreshold")>=0){this.prefetchTimer_=setTimeout((()=>{this.pageHandler_.prefetchMostVisitedTile(item)}),loadTimeData.getInteger("prefetchStartTimeThreshold"))}}onTileMouseDown_(e){if(e.defaultPrevented){return}if(loadTimeData.getBoolean("prerenderOnPressEnabled")){const item=this.tiles_[this.getCurrentTargetIndex_(e)];assert(item);if(loadTimeData.getBoolean("prefetchTriggerEnabled")){this.pageHandler_.prefetchMostVisitedTile(item)}this.pageHandler_.prerenderMostVisitedTile(item)}}onTileExit_(e){if(e.defaultPrevented){return}if(this.prefetchTimer_){clearTimeout(this.prefetchTimer_)}if(this.preconnectTimer_){clearTimeout(this.preconnectTimer_)}if(loadTimeData.getBoolean("prerenderOnPressEnabled")){this.pageHandler_.cancelPrerender()}}onUndoClick_(){if(!this.$.toastManager.isToastOpen||this.$.toastManager.slottedHidden){return}this.$.toastManager.hide();this.pageHandler_.undoMostVisitedTileAction(this.toastSource_)}onTouchStart_(e){if(this.reordering_){return}const item=this.tiles_[this.getCurrentTargetIndex_(e)];assert(item);if(!this.customLinksEnabled_&&!this.isFromEnterpriseShortcut_(item.source)){return}const tileElement=e.composedPath().find((el=>el.classList&&el.classList.contains("tile")));if(!tileElement){return}const{clientX:clientX,clientY:clientY}=e.changedTouches[0];this.dragStart_(tileElement,clientX,clientY);const touchMove=e=>{const{clientX:clientX,clientY:clientY}=e.changedTouches[0];this.dragOver_(clientX,clientY)};const touchEnd=e=>{this.ownerDocument.removeEventListener("touchmove",touchMove);tileElement.removeEventListener("touchend",touchEnd);tileElement.removeEventListener("touchcancel",touchEnd);const{clientX:clientX,clientY:clientY}=e.changedTouches[0];this.drop_(clientX,clientY);this.dragEnd_();this.reordering_=false};this.ownerDocument.addEventListener("touchmove",touchMove);tileElement.addEventListener("touchend",touchEnd,{once:true});tileElement.addEventListener("touchcancel",touchEnd,{once:true})}tileFocus_(index){if(index<0){return}const tileElements=this.tileElements_;if(index<tileElements.length){tileElements[index].querySelector("a").focus()}else if(this.showAdd_&&index===tileElements.length){this.$.addShortcut.focus()}else if(this.showShowLess_&&index===tileElements.length){this.$.showLess.focus()}}toast_(msgId,showButtons,source){this.toastSource_=source;this.$.toastManager.show(loadTimeData.getString(msgId),!showButtons)}async tileRemove_(index){const tile=this.tiles_[index];this.pageHandler_.deleteMostVisitedTile(tile);this.toast_("linkRemovedMsg",this.customLinksEnabled_||this.enterpriseShortcutsEnabled_||!tile.isQueryTile,tile.source);await this.updateComplete;this.tileFocus_(index)}onTilesRendered_(){performance.measure("most-visited-rendered");assert(this.maxVisibleTiles_>0);this.pageHandler_.onMostVisitedTilesRendered(this.tiles_.slice(0,this.maxVisibleTiles_),this.windowProxy_.now())}getMoreActionText_(title){return loadTimeData.getString("shortcutMoreActions")?loadTimeData.getStringF("shortcutMoreActions",title):""}isFromEnterpriseShortcut_(source){return source===TileSource.ENTERPRISE_SHORTCUTS}}customElements.define(MostVisitedElement.is,MostVisitedElement);class PageImageServiceBrowserProxy{handler;constructor(handler){this.handler=handler}static getInstance(){return instance$8||(instance$8=new PageImageServiceBrowserProxy(PageImageServiceHandler.getRemote()))}static setInstance(obj){instance$8=obj}}let instance$8=null;let instance$7=null;function getCss$7(){return instance$7||(instance$7=[...[],css`:host{display:none}`])}function getHtml$6(){return html`<!--_html_template_start_--><form id="fileForm"
      .action="${this.uploadFileAction_}"
      enctype="multipart/form-data"
      method="POST">
  <input id="fileInput"
         name="encoded_image"
         type="file"
         .accept="${this.supportedFileTypes_}"
         @change="${this.handleFileInputChange_}"></input>
</form>
<form id="urlForm"
      .action="${this.uploadUrlAction_}"
      method="GET">
  <input name="url" .value="${this.uploadUrl_}"></input>
  <input name="ep" .value="${this.uploadUrlEntrypoint_}"></input>
  <input name="hl" .value="${this.language_}"></input>
  <input name="st" .value="${this.startTime_}"><input>
  <input name="cd" .value="${this.clientData_}"><input>
  <input name="re" .value="${this.renderingEnvironment_}"></input>
  <input name="s" .value="${this.chromiumSurface_}"></input>
</form>
<!-- Hit a simple gen204 on Lens' servers to prewarm DNS lookup and thus
     decrease latency. -->
<iframe src="https://lens.google.com/gen204" style="display:none;" alt="">
</iframe>
<!--_html_template_end_-->`}const SCOTTY_UPLOAD_FILE_ACTION="https://lens.google.com/upload";const DIRECT_UPLOAD_FILE_ACTION="https://lens.google.com/v3/upload";const UPLOAD_FILE_ENTRYPOINT="cntpubb";const UPLOAD_BY_URL_ACTION="https://lens.google.com/uploadbyurl";const UPLOAD_URL_ENTRYPOINT="cntpubu";const RENDERING_ENVIRONMENT="df";const CHROMIUM_SURFACE="4";const MAX_URL_LENGTH=2e3;const MAX_FILE_SIZE_BYTES=20*1024*1024;var LensErrorType;(function(LensErrorType){LensErrorType[LensErrorType["MULTIPLE_FILES"]=0]="MULTIPLE_FILES";LensErrorType[LensErrorType["NO_FILE"]=1]="NO_FILE";LensErrorType[LensErrorType["FILE_TYPE"]=2]="FILE_TYPE";LensErrorType[LensErrorType["FILE_SIZE"]=3]="FILE_SIZE";LensErrorType[LensErrorType["INVALID_SCHEME"]=4]="INVALID_SCHEME";LensErrorType[LensErrorType["INVALID_URL"]=5]="INVALID_URL";LensErrorType[LensErrorType["LENGTH_TOO_GREAT"]=6]="LENGTH_TOO_GREAT"})(LensErrorType||(LensErrorType={}));var LensSubmitType;(function(LensSubmitType){LensSubmitType[LensSubmitType["FILE"]=0]="FILE";LensSubmitType[LensSubmitType["URL"]=1]="URL"})(LensSubmitType||(LensSubmitType={}));class LensFormElement extends CrLitElement{static get is(){return"ntp-lens-form"}static get styles(){return getCss$7()}render(){return getHtml$6.bind(this)()}static get properties(){return{supportedFileTypes_:{type:String},renderingEnvironment_:{type:String},chromiumSurface_:{type:String},uploadFileAction_:{type:String},uploadUrlAction_:{type:String},uploadUrl_:{type:String},uploadUrlEntrypoint_:{type:String},language_:{type:String},clientData_:{type:String},startTime_:{type:String}}}#supportedFileTypes__accessor_storage=SUPPORTED_FILE_TYPES.join(",");get supportedFileTypes_(){return this.#supportedFileTypes__accessor_storage}set supportedFileTypes_(value){this.#supportedFileTypes__accessor_storage=value}#renderingEnvironment__accessor_storage=RENDERING_ENVIRONMENT;get renderingEnvironment_(){return this.#renderingEnvironment__accessor_storage}set renderingEnvironment_(value){this.#renderingEnvironment__accessor_storage=value}#chromiumSurface__accessor_storage=CHROMIUM_SURFACE;get chromiumSurface_(){return this.#chromiumSurface__accessor_storage}set chromiumSurface_(value){this.#chromiumSurface__accessor_storage=value}#language__accessor_storage=window.navigator.language;get language_(){return this.#language__accessor_storage}set language_(value){this.#language__accessor_storage=value}#uploadFileAction__accessor_storage=SCOTTY_UPLOAD_FILE_ACTION;get uploadFileAction_(){return this.#uploadFileAction__accessor_storage}set uploadFileAction_(value){this.#uploadFileAction__accessor_storage=value}#uploadUrlAction__accessor_storage=UPLOAD_BY_URL_ACTION;get uploadUrlAction_(){return this.#uploadUrlAction__accessor_storage}set uploadUrlAction_(value){this.#uploadUrlAction__accessor_storage=value}#uploadUrl__accessor_storage="";get uploadUrl_(){return this.#uploadUrl__accessor_storage}set uploadUrl_(value){this.#uploadUrl__accessor_storage=value}#uploadUrlEntrypoint__accessor_storage=UPLOAD_URL_ENTRYPOINT;get uploadUrlEntrypoint_(){return this.#uploadUrlEntrypoint__accessor_storage}set uploadUrlEntrypoint_(value){this.#uploadUrlEntrypoint__accessor_storage=value}#startTime__accessor_storage=null;get startTime_(){return this.#startTime__accessor_storage}set startTime_(value){this.#startTime__accessor_storage=value}#clientData__accessor_storage=loadTimeData.getString("searchboxLensVariations");get clientData_(){return this.#clientData__accessor_storage}set clientData_(value){this.#clientData__accessor_storage=value}openSystemFilePicker(){this.$.fileInput.click()}handleFileInputChange_(){const fileList=this.$.fileInput.files;if(fileList){this.submitFileList(fileList)}}submitFileList(files){if(files.length>1){this.dispatchError_(LensErrorType.MULTIPLE_FILES);return}const file=files[0];if(!file){this.dispatchError_(LensErrorType.NO_FILE);return}return this.submitFile_(file)}async submitFile_(file){if(!SUPPORTED_FILE_TYPES.includes(file.type)){this.dispatchError_(LensErrorType.FILE_TYPE);return}if(file.size>MAX_FILE_SIZE_BYTES){this.dispatchError_(LensErrorType.FILE_SIZE);return}this.uploadFileAction_=DIRECT_UPLOAD_FILE_ACTION;this.startTime_=Date.now().toString();let processedFile={processedFile:file};processedFile=await processFile(file);const dataTransfer=new DataTransfer;dataTransfer.items.add(processedFile.processedFile);this.$.fileInput.files=dataTransfer.files;const action=new URL(this.uploadFileAction_);action.searchParams.set("ep",UPLOAD_FILE_ENTRYPOINT);action.searchParams.set("hl",this.language_);action.searchParams.set("st",this.startTime_.toString());action.searchParams.set("cd",this.clientData_);action.searchParams.set("re",RENDERING_ENVIRONMENT);action.searchParams.set("s",CHROMIUM_SURFACE);action.searchParams.set("vph",processedFile.imageHeight?processedFile.imageHeight.toString():"");action.searchParams.set("vpw",processedFile.imageWidth?processedFile.imageWidth.toString():"");this.uploadFileAction_=action.toString();await this.updateComplete;this.dispatchLoading_(LensSubmitType.FILE);this.$.fileForm.submit()}async submitUrl(urlString){if(!urlString.startsWith("http://")&&!urlString.startsWith("https://")){this.dispatchError_(LensErrorType.INVALID_SCHEME);return}let encodedUri;try{encodedUri=encodeURI(urlString);new URL(urlString)}catch(e){this.dispatchError_(LensErrorType.INVALID_URL);return}if(encodedUri.length>MAX_URL_LENGTH){this.dispatchError_(LensErrorType.LENGTH_TOO_GREAT);return}this.uploadUrl_=encodedUri;this.startTime_=Date.now().toString();await this.updateComplete;this.dispatchLoading_(LensSubmitType.URL);this.$.urlForm.submit()}dispatchLoading_(submitType){this.dispatchEvent(new CustomEvent("loading",{bubbles:false,composed:false,detail:submitType}))}dispatchError_(errorType){this.dispatchEvent(new CustomEvent("error",{bubbles:false,composed:false,detail:errorType}))}}customElements.define(LensFormElement.is,LensFormElement);let instance$6=null;function getCss$6(){return instance$6||(instance$6=[...[],css`.spinner{--cr-spinner-size:28px;mask-image:url(//resources/images/throbber_small.svg);mask-position:center;mask-repeat:no-repeat;mask-size:var(--cr-spinner-size) var(--cr-spinner-size);background-color:var(--cr-spinner-color,var(--google-blue-500));height:var(--cr-spinner-size);width:var(--cr-spinner-size)}@media (prefers-color-scheme:dark){.spinner{background-color:var(--cr-spinner-color,var(--google-blue-300))}}`])}let instance$5=null;function getCss$5(){return instance$5||(instance$5=[...[getCss$s(),getCss$6()],css`:host{--upload-dialog-background:var(--color-new-tab-page-background-override);--upload-dialog-divider-line-border-top:1px solid var(--google-grey-200);--upload-dialog-divider-line-or-label-color:var(--color-new-tab-page-secondary-foreground);--upload-dialog-drag-drop-background:var(--google-grey-50);--upload-dialog-drag-drop-border:1px dashed var(--google-grey-400);--upload-dialog-drag-drop-error-background-color:var(--google-red-50);--upload-dialog-drag-drop-title-color:var(--color-new-tab-page-secondary-foreground);--upload-dialog-drag-drop-upload-text-color:var(--google-blue-700);--upload-dialog-error-message-color:var(--google-red-800);--upload-dialog-input-box-background:var(--color-new-tab-page-background-override);--upload-dialog-input-box-border-color:var(--google-grey-300);--upload-dialog-input-box-color:var(--google-grey-800);--upload-dialog-input-box-placeholder-color:var(--google-grey-700);--upload-dialog-input-submit-background:var(--color-new-tab-page-background-override);--upload-dialog-input-submit-border-color:var(--google-grey-300);--upload-dialog-input-submit-color:var(--google-blue-600);--upload-dialog-shadow:var(--cr-elevation-3);--upload-dialog-title-color:var(--google-grey-800);font-family:inherit;width:100%}:host([is-dragging_]),:host([is-loading_]){--upload-dialog-drag-drop-background:var(--google-blue-50)}@media (prefers-color-scheme:dark){:host{--upload-dialog-background:var(--google-grey-850);--upload-dialog-divider-line-border-top:1px solid var(--google-grey-800);--upload-dialog-drag-drop-background:rgba(var(--google-grey-900-rgb),.68);--upload-dialog-drag-drop-border:1px dashed var(--google-grey-800);--upload-dialog-drag-drop-error-background-color:var(--google-red-300);--upload-dialog-drag-drop-upload-text-color:var(--google-blue-300);--upload-dialog-error-message-color:var(--google-grey-900);--upload-dialog-input-box-background:transparent;--upload-dialog-input-box-border-color:var(--google-grey-800);--upload-dialog-input-box-color:var(--google-grey-100);--upload-dialog-input-box-placeholder-color:var(--google-grey-300);--upload-dialog-input-submit-background:transparent;--upload-dialog-input-submit-border-color:var(--google-grey-800);--upload-dialog-input-submit-color:var(--google-blue-300);--upload-dialog-title-color:var(--google-grey-100)}:host([is-dragging_]),:host([is-loading_]){--upload-dialog-drag-drop-background:rgba(var(--google-blue-300-rgb),.24);--upload-dialog-drag-drop-border:1px dashed var(--google-blue-300);--upload-dialog-drag-drop-title-color:var(--google-blue-300)}}#dialog{background:var(--upload-dialog-background);border-radius:22px;box-shadow:var(--upload-dialog-shadow);box-sizing:border-box;left:unset;padding:20px;position:relative;right:unset}:host-context([dir='rtl']) #closeButton{left:20px;right:initial}#closeButton{--cr-icon-button-fill-color:var(--color-new-tab-page-overlay-secondary-foreground);align-self:flex-end;cursor:pointer;display:flex;position:absolute;right:20px;top:15px}#title{color:var(--upload-dialog-title-color);font-size:16px;letter-spacing:0.1px;line-height:28px;margin-bottom:14px;text-align:center}#dragDropArea{background:var(--upload-dialog-drag-drop-background);border:var(--upload-dialog-drag-drop-border);border-radius:8px;box-sizing:border-box;display:flex;flex-direction:column;flex-grow:1;height:280px;padding:20px;position:relative;width:100%}#dragDropError{align-items:center;background-color:var(--upload-dialog-drag-drop-error-background-color);border-top-left-radius:8px;border-top-right-radius:8px;justify-content:space-between;left:0;position:absolute;right:0;top:0}#dragDropErrorMessage{color:var(--upload-dialog-error-message-color);flex:1;font-size:12px;padding:5px;text-align:center}.drag-drop-title-container{align-items:center;display:inline-flex;flex-direction:row;flex-grow:1;justify-content:center}#dragDropIllustration{background:url(icons/drag_drop_illustration.svg) no-repeat center;display:inline-flex;height:45px;margin-inline-end:18px;vertical-align:middle;width:59px}.drag-drop-title{color:var(--upload-dialog-drag-drop-title-color);font-size:16px;line-height:25px;max-width:300px}#dragText{display:inline-block;margin-inline-end:4px}#uploadText{color:var(--upload-dialog-drag-drop-upload-text-color);cursor:pointer;display:inline-block;white-space:nowrap}#uploadText:focus,#uploadText:hover{text-decoration:underline}@media (forced-colors:active){#uploadText{color:LinkText}}#urlUploadContainer{box-sizing:border-box;display:flex;flex-direction:column;width:100%}#sectionDivider{align-items:center;display:flex}.divider-line{border-top:var(--upload-dialog-divider-line-border-top);flex-grow:1;height:0}#orLabel{color:var(--upload-dialog-divider-line-or-label-color);cursor:default;flex-shrink:0;font-size:14px;margin-inline-end:20px;margin-inline-start:20px}#inputContainer{display:flex;margin-top:14px}#inputBox{background:var(--upload-dialog-input-box-background);border:1px solid var(--upload-dialog-input-box-border-color);border-radius:36px;color:var(--upload-dialog-input-box-color);display:inline-flex;flex-grow:1;font-size:14px;height:40px;outline:none;padding:0 24px;width:100%}#inputBox::placeholder{color:var(--upload-dialog-input-box-placeholder-color)}#inputBox:hover{--upload-dialog-input-box-border-color:var(--google-grey-800)}#inputBox:focus{--upload-dialog-input-box-border-color:var(--google-blue-700)}#inputBox:active{--upload-dialog-input-box-border-color:var(--google-blue-700)}@media (prefers-color-scheme:dark){#inputBox:hover{--upload-dialog-input-box-border-color:var(--google-grey-700)}#inputBox:focus{--upload-dialog-input-box-border-color:var(--google-blue-300)}#inputBox:active{--upload-dialog-input-box-border-color:var(--google-blue-300)}}#inputSubmit{align-items:center;background:var(--upload-dialog-input-submit-background);border:1px solid var(--upload-dialog-input-submit-border-color);border-radius:32px;color:var(--upload-dialog-input-submit-color);cursor:pointer;display:inline-flex;flex-shrink:0;font-size:14px;justify-content:center;letter-spacing:0.25px;margin-inline-start:8px;outline:0;padding:8px 24px}#inputSubmit:hover{--upload-dialog-input-submit-background:rgba(var(--google-blue-700-rgb),0.08);--upload-dialog-input-submit-border-color:var(--google-grey-300);--upload-dialog-input-submit-color:var(--google-blue-600)}#inputSubmit:focus{--upload-dialog-input-submit-background:rgba(var(--google-blue-700-rgb),0.08);--upload-dialog-input-submit-border-color:var(--google-blue-700);--upload-dialog-input-submit-color:var(--google-blue-600)}#inputSubmit:active{--upload-dialog-input-submit-background:rgba(var(--google-blue-700-rgb),0.14);--upload-dialog-input-submit-border-color:var(--google-grey-300);--upload-dialog-input-submit-color:var(--google-blue-600)}@media (prefers-color-scheme:dark){#inputSubmit:hover{--upload-dialog-input-submit-background:rgba(var(--google-blue-300-rgb),0.04);--upload-dialog-input-submit-border-color:var(--google-grey-800);--upload-dialog-input-submit-color:var(--google-blue-100)}#inputSubmit:focus{--upload-dialog-input-submit-background:rgba(var(--google-blue-300-rgb),0.12);--upload-dialog-input-submit-border-color:var(--google-blue-100);--upload-dialog-input-submit-color:var(--google-blue-100)}#inputSubmit:active{--upload-dialog-input-submit-background:rgba(var(--google-blue-300-rgb),0.10);--upload-dialog-input-submit-border-color:var(--google-grey-800);--upload-dialog-input-submit-color:var(--google-blue-100)}}#loadingContainer,#offlineContainer{align-items:center;display:flex;flex-direction:column;flex-grow:1;justify-content:center}#loadingContainer .spinner{margin-bottom:12px}#offlineTitle{color:var(--upload-dialog-title-color);text-align:center}#offlineImage{background:url(icons/offline_dialog.svg) no-repeat center;height:51px;margin-bottom:24px;width:55px}#offlineSubtitle{color:var(--upload-dialog-drag-drop-title-color);font-size:16px;margin-top:6px}#offlineRetryButton{margin-top:21px}`])}function getHtml$5(){return html`<!--_html_template_start_--><div id="dialog" ?hidden="${this.isHidden_}" tabindex="-1"
    lang="$i18n{language}" role="dialog" aria-modal="true"
    @focusout="${this.onFocusOut_}">
  <ntp-lens-form id="lensForm" @loading="${this.handleFormLoading_}"
      @error="${this.handleFormError_}">
  </ntp-lens-form>
  <div id="container">
    <cr-icon-button id="closeButton" class="icon-clear"
        title="$i18n{lensSearchUploadDialogCloseButtonLabel}"
        @click="${this.onCloseButtonClick_}"
        @keydown="${this.onCloseButtonKeydown_}">
    </cr-icon-button>
    <div id="title">$i18n{lensSearchUploadDialogTitle}</div>
    <div id="dragDropArea" @dragenter="${this.onDragEnter_}"
        @dragover="${this.onDragOver_}" @dragleave="${this.onDragLeave_}"
        @drop="${this.onDrop_}">
      <!-- Error state -->
      ${this.isError_?html`
        <div id="dragDropError">
          <div id="dragDropErrorMessage">${this.getErrorString_()}</div>
        </div>
      `:""}
      <!-- Normal state -->
      ${this.isNormalOrError_?html`
        <div class="drag-drop-title-container">
          <div id="dragDropIllustration"></div>
          <div class="drag-drop-title">
            <span id="dragText">$i18n{lensSearchUploadDialogDragTitle}</span>
            <span tabindex="0" role="button" id="uploadText"
                @click="${this.onUploadFileClick_}"
                @keydown="${this.onUploadFileKeyDown_}"
                @touchend="${this.onUploadFileTouchEnd_}">
              $i18n{lensSearchUploadDialogUploadFileTitle}
            </span>
          </div>
        </div>
        <div id="urlUploadContainer">
          <div id="sectionDivider">
            <div class="divider-line"></div>
            <div id="orLabel">$i18n{lensSearchUploadDialogOrText}</div>
            <div class="divider-line"></div>
          </div>
          <div id="inputContainer">
            <input id="inputBox" autocomplete="false" autocorrect="false"
                placeholder="$i18n{lensSearchUploadDialogTextPlaceholder}"
                text="text" .value="${this.uploadUrl_}"
                @input="${this.onInputBoxInput_}"
                @keydown="${this.onUrlKeyDown_}">
            <div id="inputSubmit" tabindex="0" role="button"
                @click="${this.onSubmitUrl_}"
                @keydown="${this.onInputSubmitKeyDown_}">
              $i18n{lensSearchUploadDialogSearchButtonLabel}
            </div>
          </div>
        </div>
      `:""}
      <!-- Dragging state -->
      ${this.isDragging_?html`
        <div class="drag-drop-title-container">
          <div class="drag-drop-title">
            $i18n{lensSearchUploadDialogDragDropTitle}
          </div>
        </div>
      `:""}
      <!-- Loading state -->
      ${this.isLoading_?html`
        <div id="loadingContainer">
          <div class="spinner"></div>
          <div class="drag-drop-title">
            $i18n{lensSearchUploadDialogLoadingText}
          </div>
        </div>
      `:""}
      <!-- Offline state -->
      ${this.isOffline_?html`
        <div id="offlineContainer">
          <div id="offlineImage"></div>
          <div id="offlineTitle" class="drag-drop-title">
            $i18n{lensSearchUploadDialogOfflineText}
          </div>
          <div id="offlineSubtitle">
            $i18n{lensSearchUploadDialogOfflineSubtitleText}
          </div>
          <cr-button id="offlineRetryButton" class="action-button"
              @click="${this.onOfflineRetryButtonClick_}"
              @keydown="${this.onOfflineRetryButtonKeydown_}">
            $i18n{lensSearchUploadDialogOfflineButtonLabel}
          </cr-button>
        </div>
      `:""}
    </div>
  </div>
</div>
<!--_html_template_end_-->`}var DialogState;(function(DialogState){DialogState[DialogState["HIDDEN"]=0]="HIDDEN";DialogState[DialogState["NORMAL"]=1]="NORMAL";DialogState[DialogState["DRAGGING"]=2]="DRAGGING";DialogState[DialogState["LOADING"]=3]="LOADING";DialogState[DialogState["ERROR"]=4]="ERROR";DialogState[DialogState["OFFLINE"]=5]="OFFLINE"})(DialogState||(DialogState={}));var LensErrorMessage;(function(LensErrorMessage){LensErrorMessage[LensErrorMessage["NONE"]=0]="NONE";LensErrorMessage[LensErrorMessage["FILE_TYPE"]=1]="FILE_TYPE";LensErrorMessage[LensErrorMessage["FILE_SIZE"]=2]="FILE_SIZE";LensErrorMessage[LensErrorMessage["MULTIPLE_FILES"]=3]="MULTIPLE_FILES";LensErrorMessage[LensErrorMessage["SCHEME"]=4]="SCHEME";LensErrorMessage[LensErrorMessage["CONFORMANCE"]=5]="CONFORMANCE";LensErrorMessage[LensErrorMessage["MULTIPLE_URLS"]=6]="MULTIPLE_URLS"})(LensErrorMessage||(LensErrorMessage={}));const EventKeys={ENTER:"Enter",ESCAPE:"Escape",SPACE:" ",TAB:"Tab"};var LensUploadDialogAction;(function(LensUploadDialogAction){LensUploadDialogAction[LensUploadDialogAction["URL_SUBMITTED"]=0]="URL_SUBMITTED";LensUploadDialogAction[LensUploadDialogAction["FILE_SUBMITTED"]=1]="FILE_SUBMITTED";LensUploadDialogAction[LensUploadDialogAction["IMAGE_DROPPED"]=2]="IMAGE_DROPPED";LensUploadDialogAction[LensUploadDialogAction["DIALOG_OPENED"]=3]="DIALOG_OPENED";LensUploadDialogAction[LensUploadDialogAction["DIALOG_CLOSED"]=4]="DIALOG_CLOSED";LensUploadDialogAction[LensUploadDialogAction["ERROR_SHOWN"]=5]="ERROR_SHOWN";LensUploadDialogAction[LensUploadDialogAction["MAX_VALUE"]=5]="MAX_VALUE"})(LensUploadDialogAction||(LensUploadDialogAction={}));var LensUploadDialogError;(function(LensUploadDialogError){LensUploadDialogError[LensUploadDialogError["FILE_SIZE"]=0]="FILE_SIZE";LensUploadDialogError[LensUploadDialogError["FILE_TYPE"]=1]="FILE_TYPE";LensUploadDialogError[LensUploadDialogError["MULTIPLE_FILES"]=2]="MULTIPLE_FILES";LensUploadDialogError[LensUploadDialogError["MULTIPLE_URLS"]=3]="MULTIPLE_URLS";LensUploadDialogError[LensUploadDialogError["LENGTH_TOO_GREAT"]=4]="LENGTH_TOO_GREAT";LensUploadDialogError[LensUploadDialogError["INVALID_SCHEME"]=5]="INVALID_SCHEME";LensUploadDialogError[LensUploadDialogError["INVALID_URL"]=6]="INVALID_URL";LensUploadDialogError[LensUploadDialogError["NETWORK_ERROR"]=7]="NETWORK_ERROR";LensUploadDialogError[LensUploadDialogError["MAX_VALUE"]=7]="MAX_VALUE"})(LensUploadDialogError||(LensUploadDialogError={}));function recordLensUploadDialogAction(action){recordEnumeration("NewTabPage.Lens.UploadDialog.DialogAction",action,LensUploadDialogAction.MAX_VALUE+1)}function recordLensUploadDialogError(action){recordEnumeration("NewTabPage.Lens.UploadDialog.DialogError",action,LensUploadDialogError.MAX_VALUE+1)}const LensUploadDialogElementBase=I18nMixinLit(CrLitElement);class LensUploadDialogElement extends LensUploadDialogElementBase{static get is(){return"ntp-lens-upload-dialog"}static get styles(){return getCss$5()}render(){return getHtml$5.bind(this)()}static get properties(){return{dialogState_:{type:Number},lensErrorMessage_:{type:Number},isHidden_:{type:Boolean},isNormalOrError_:{type:Boolean},isDragging_:{type:Boolean,reflect:true},isLoading_:{type:Boolean,reflect:true},isError_:{type:Boolean},isOffline_:{type:Boolean},uploadUrl_:{type:String}}}#isHidden__accessor_storage=false;get isHidden_(){return this.#isHidden__accessor_storage}set isHidden_(value){this.#isHidden__accessor_storage=value}#isError__accessor_storage=false;get isError_(){return this.#isError__accessor_storage}set isError_(value){this.#isError__accessor_storage=value}#isNormalOrError__accessor_storage=false;get isNormalOrError_(){return this.#isNormalOrError__accessor_storage}set isNormalOrError_(value){this.#isNormalOrError__accessor_storage=value}#isDragging__accessor_storage=false;get isDragging_(){return this.#isDragging__accessor_storage}set isDragging_(value){this.#isDragging__accessor_storage=value}#isLoading__accessor_storage=false;get isLoading_(){return this.#isLoading__accessor_storage}set isLoading_(value){this.#isLoading__accessor_storage=value}#isOffline__accessor_storage=false;get isOffline_(){return this.#isOffline__accessor_storage}set isOffline_(value){this.#isOffline__accessor_storage=value}#dialogState__accessor_storage=DialogState.HIDDEN;get dialogState_(){return this.#dialogState__accessor_storage}set dialogState_(value){this.#dialogState__accessor_storage=value}#lensErrorMessage__accessor_storage=LensErrorMessage.NONE;get lensErrorMessage_(){return this.#lensErrorMessage__accessor_storage}set lensErrorMessage_(value){this.#lensErrorMessage__accessor_storage=value}outsideHandlerAttached_=false;#uploadUrl__accessor_storage="";get uploadUrl_(){return this.#uploadUrl__accessor_storage}set uploadUrl_(value){this.#uploadUrl__accessor_storage=value}dragCount=0;willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("dialogState_")){this.isHidden_=this.computeIsHidden_();this.isNormalOrError_=this.computeIsNormalOrError_();this.isDragging_=this.computeIsDragging_();this.isLoading_=this.computeIsLoading_();this.isError_=this.computeIsError_();this.isOffline_=this.computeIsOffline_()}}computeIsHidden_(){return this.dialogState_===DialogState.HIDDEN}computeIsNormalOrError_(){return this.dialogState_===DialogState.NORMAL||this.dialogState_===DialogState.ERROR}computeIsDragging_(){return this.dialogState_===DialogState.DRAGGING}computeIsLoading_(){return this.dialogState_===DialogState.LOADING}computeIsError_(){return this.dialogState_===DialogState.ERROR}computeIsOffline_(){return this.dialogState_===DialogState.OFFLINE}connectedCallback(){super.connectedCallback();this.openDialog()}disconnectedCallback(){super.disconnectedCallback();this.detachOutsideHandler_()}openDialog(){this.setOnlineState_();this.updateComplete.then((()=>{this.attachOutsideHandler_();if(this.isOffline_){this.shadowRoot.getElementById("offlineRetryButton").focus()}else{this.shadowRoot.getElementById("uploadText").focus()}}));recordLensUploadDialogAction(LensUploadDialogAction.DIALOG_OPENED)}closeDialog(){if(this.isHidden_){return}this.dialogState_=DialogState.HIDDEN;this.detachOutsideHandler_();this.dispatchEvent(new Event("close-lens-search"));recordLensUploadDialogAction(LensUploadDialogAction.DIALOG_CLOSED)}getErrorString_(){switch(this.lensErrorMessage_){case LensErrorMessage.FILE_TYPE:return this.i18n("lensSearchUploadDialogErrorFileType");case LensErrorMessage.FILE_SIZE:return this.i18n("lensSearchUploadDialogErrorFileSize");case LensErrorMessage.MULTIPLE_FILES:return this.i18n("lensSearchUploadDialogErrorMultipleFiles");case LensErrorMessage.SCHEME:return this.i18n("lensSearchUploadDialogValidationErrorScheme");case LensErrorMessage.CONFORMANCE:return this.i18n("lensSearchUploadDialogValidationErrorConformance");case LensErrorMessage.MULTIPLE_URLS:return this.i18n("lensSearchUploadDialogErrorMultipleUrls");default:return""}}setOnlineState_(){this.dialogState_=WindowProxy.getInstance().onLine?DialogState.NORMAL:DialogState.OFFLINE}outsideKeyHandler_=event=>{if(event.key===EventKeys.ESCAPE){this.closeDialog()}};attachOutsideHandler_(){if(!this.outsideHandlerAttached_){document.addEventListener("keydown",this.outsideKeyHandler_);this.outsideHandlerAttached_=true}}detachOutsideHandler_(){if(this.outsideHandlerAttached_){document.removeEventListener("keydown",this.outsideKeyHandler_);this.outsideHandlerAttached_=false}}onCloseButtonKeydown_(event){if(event.key===EventKeys.TAB&&(this.isDragging_||this.isLoading_)){event.preventDefault()}else if(event.key===EventKeys.TAB&&event.shiftKey){event.preventDefault();if(this.isNormalOrError_){this.shadowRoot.getElementById("inputSubmit").focus()}else if(this.isOffline_){this.shadowRoot.getElementById("offlineRetryButton").focus()}}}onOfflineRetryButtonKeydown_(event){if(event.key===EventKeys.TAB&&!event.shiftKey){event.preventDefault();this.$.closeButton.focus()}}onCloseButtonClick_(){this.closeDialog()}onOfflineRetryButtonClick_(){this.setOnlineState_()}onUploadFileKeyDown_(event){if(event.key===EventKeys.ENTER||event.key===EventKeys.SPACE){this.$.lensForm.openSystemFilePicker()}}onUploadFileClick_(){this.$.lensForm.openSystemFilePicker()}onUploadFileTouchEnd_(e){e.stopPropagation()}handleFormLoading_(event){this.dialogState_=DialogState.LOADING;switch(event.detail){case LensSubmitType.FILE:recordLensUploadDialogAction(LensUploadDialogAction.FILE_SUBMITTED);break;case LensSubmitType.URL:recordLensUploadDialogAction(LensUploadDialogAction.URL_SUBMITTED);break}}handleFormError_(event){switch(event.detail){case LensErrorType.MULTIPLE_FILES:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.MULTIPLE_FILES;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.MULTIPLE_FILES);break;case LensErrorType.NO_FILE:this.dialogState_=DialogState.NORMAL;this.lensErrorMessage_=LensErrorMessage.NONE;break;case LensErrorType.FILE_TYPE:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.FILE_TYPE;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.FILE_TYPE);break;case LensErrorType.FILE_SIZE:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.FILE_SIZE;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.FILE_SIZE);break;case LensErrorType.INVALID_SCHEME:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.SCHEME;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.INVALID_SCHEME);break;case LensErrorType.INVALID_URL:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.CONFORMANCE;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.INVALID_URL);break;case LensErrorType.LENGTH_TOO_GREAT:this.dialogState_=DialogState.ERROR;this.lensErrorMessage_=LensErrorMessage.CONFORMANCE;recordLensUploadDialogAction(LensUploadDialogAction.ERROR_SHOWN);recordLensUploadDialogError(LensUploadDialogError.LENGTH_TOO_GREAT);break;default:this.dialogState_=DialogState.NORMAL;this.lensErrorMessage_=LensErrorMessage.NONE}}onUrlKeyDown_(event){if(event.key===EventKeys.ENTER){event.preventDefault();this.onSubmitUrl_()}}onInputSubmitKeyDown_(event){if(event.key===EventKeys.ENTER||event.key===EventKeys.SPACE){this.onSubmitUrl_()}else if(event.key===EventKeys.TAB&&!event.shiftKey){event.preventDefault();this.$.closeButton.focus()}}onSubmitUrl_(){const url=this.uploadUrl_.trim();if(url.length>0){this.$.lensForm.submitUrl(url)}}onDragEnter_(e){e.preventDefault();this.dragCount+=1;if(this.dragCount===1){this.dialogState_=DialogState.DRAGGING}}onDragOver_(e){e.preventDefault()}onDragLeave_(e){e.preventDefault();this.dragCount-=1;if(this.dragCount===0){this.dialogState_=DialogState.NORMAL}}onDrop_(e){e.preventDefault();this.dragCount=0;if(e.dataTransfer){this.$.lensForm.submitFileList(e.dataTransfer.files);recordLensUploadDialogAction(LensUploadDialogAction.IMAGE_DROPPED)}}onFocusOut_(event){if(this.dragCount===1){return}const outsideDialog=document.hasFocus()&&(!event.relatedTarget||!this.$.dialog.contains(event.relatedTarget));if(outsideDialog){this.closeDialog()}}onInputBoxInput_(e){this.uploadUrl_=e.target.value}}customElements.define(LensUploadDialogElement.is,LensUploadDialogElement);let instance$4=null;function getCss$4(){return instance$4||(instance$4=[...[],css`:host{background-color:var(--color-new-tab-page-module-background);border:none;border-radius:var(--ntp-module-border-radius);box-sizing:border-box;display:block;height:fit-content;overflow:visible;position:relative}#impressionProbe{height:27px;pointer-events:none;position:absolute;width:100%}#moduleElement{align-items:center;background:var(--color-new-tab-page-module-background);border-radius:var(--ntp-module-border-radius);display:flex;height:100%;justify-content:center}`])}function getHtml$4(){return html`<!--_html_template_start_--><div id="impressionProbe"></div>
<div id="moduleElement">
  <slot id="slot"></slot>
</div>
<!--_html_template_end_-->`}class ModuleWrapperElement extends CrLitElement{static get is(){return"ntp-module-wrapper"}static get styles(){return getCss$4()}static get properties(){return{module:{type:Object}}}#module_accessor_storage=null;get module(){return this.#module_accessor_storage}set module(value){this.#module_accessor_storage=value}eventTracker_=new EventTracker;render(){if(this.module){render(this.module.element,this,{host:this})}return getHtml$4.bind(this)()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}firstUpdated(){assert(this.module);if(!this.module.initialized){this.module.initialized=true;this.initModuleInstance_()}if(!this.module.impressed){const headerObserver=new IntersectionObserver((entries=>{assert(entries.length>0);const observerEntry=entries[0];if(observerEntry.intersectionRatio>=1){headerObserver.disconnect();assert(this.module);const time=WindowProxy.getInstance().now();recordLoadDuration("NewTabPage.Modules.Impression",time);recordLoadDuration(`NewTabPage.Modules.Impression.${this.module.descriptor.id}`,time);this.module.impressed=true;this.dispatchEvent(new Event("detect-impression"));this.module.element.dispatchEvent(new Event("detect-impression"))}}),{threshold:1});headerObserver.observe(this.$.impressionProbe)}}initModuleInstance_(){assert(this.module);this.module.element.addEventListener("usage",(e=>{e.stopPropagation();assert(this.module);NewTabPageProxy.getInstance().handler.onModuleUsed(this.module.descriptor.id);recordOccurrence("NewTabPage.Modules.Usage");recordOccurrence(`NewTabPage.Modules.Usage.${this.module.descriptor.id}`)}),{once:true});this.module.element.addEventListener("menu-button-click",(e=>{e.stopPropagation();assert(this.module);NewTabPageProxy.getInstance().handler.onModuleUsed(this.module.descriptor.id)}),{once:true});this.module.element.addEventListener("info-button-click",(()=>{assert(this.module);recordSparseValueWithPersistentHash("NewTabPage.Modules.InfoButtonClicked",this.module.descriptor.id)}),{once:true});this.module.element.addEventListener("mouseover",(()=>{assert(this.module);recordSparseValueWithPersistentHash("NewTabPage.Modules.Hover",this.module.descriptor.id)}),{capture:true,once:true});let intersectionPerdecage=0;const moduleObserver=new IntersectionObserver((entries=>{assert(entries.length>0);const observerEntry=entries[0];intersectionPerdecage=Math.floor(Math.max(intersectionPerdecage,observerEntry.intersectionRatio*10))}),{threshold:[.1,.2,.3,.4,.5,.6,.7,.8,.9,1]});this.eventTracker_.add(window,"pagehide",(()=>{assert(this.module);recordPerdecage("NewTabPage.Modules.ImpressionRatio",intersectionPerdecage);recordPerdecage(`NewTabPage.Modules.ImpressionRatio.${this.module.descriptor.id}`,intersectionPerdecage)}));moduleObserver.observe(this)}}customElements.define(ModuleWrapperElement.is,ModuleWrapperElement);let instance$3=null;function getCss$3(){return instance$3||(instance$3=[...[getCss$r()],css`#container{display:flex;flex-flow:row wrap;gap:var(--container-gap);justify-content:center;margin-top:8px;max-width:var(--container-max-width,inherit)}#undoToastMessage{flex-grow:1}`])}function getHtml$3(){return html`<!--_html_template_start_--><div id="container">
  ${this.moduleInstances_.map((item=>html`
    <ntp-module-wrapper .module="${item}"
        ?hidden="${this.moduleDisabled_(item)}"
        @disable-module="${this.onDisableModule_}"
        @dismiss-module-element="${this.onDismissModuleElement_}"
        @dismiss-module-instance="${this.onDismissModuleInstance_}">
    </ntp-module-wrapper>
  `))}
</div>
<cr-toast id="undoToast" duration="10000">
  <div id="undoToastMessage">${this.undoData_?.message||""}</div>
  ${this.undoData_?.undo?html`
    <cr-button id="undoButton"
        aria-label="$i18n{undoDescription}"
        @click="${this.onUndoButtonClick_}">
      $i18n{undo}
    </cr-button>
  `:""}
</cr-toast>
<!--_html_template_end_-->`}const SUPPORTED_MODULE_WIDTHS=[{name:"narrow",value:312},{name:"medium",value:360},{name:"wide",value:728}];const CONTAINER_GAP_WIDTH=8;const MARGIN_WIDTH=48;const METRIC_NAME_MODULE_DISABLED="NewTabPage.Modules.Disabled";function createModuleInstances(module){return module.elements.map((element=>({element:element,descriptor:module.descriptor,initialized:false,impressed:false})))}class ModulesElement extends CrLitElement{static get is(){return"ntp-modules"}static get styles(){return getCss$3()}static get properties(){return{modulesShownToUser:{type:Boolean,notify:true},moduleInstances_:{type:Array},disabledModules_:{type:Object},undoData_:{type:Object}}}#modulesShownToUser_accessor_storage=false;get modulesShownToUser(){return this.#modulesShownToUser_accessor_storage}set modulesShownToUser(value){this.#modulesShownToUser_accessor_storage=value}waitToLoadModules_=loadTimeData.getBoolean("waitToLoadModules");#moduleInstances__accessor_storage=[];get moduleInstances_(){return this.#moduleInstances__accessor_storage}set moduleInstances_(value){this.#moduleInstances__accessor_storage=value}#disabledModules__accessor_storage={all:true,ids:[]};get disabledModules_(){return this.#disabledModules__accessor_storage}set disabledModules_(value){this.#disabledModules__accessor_storage=value}#undoData__accessor_storage=null;get undoData_(){return this.#undoData__accessor_storage}set undoData_(value){this.#undoData__accessor_storage=value}maxColumnCount_=loadTimeData.getInteger("modulesMaxColumnCount");availableWidth_=0;containerMaxWidth_=0;eventTracker_=new EventTracker;setDisabledModulesListenerId_=null;setModulesLoadableListenerId_=null;availableModulesIds_=null;moduleLoadPromise_=null;modulesReloadable_=loadTimeData.getBoolean("modulesReloadable");render(){return getHtml$3.bind(this)()}connectedCallback(){super.connectedCallback();const widths=new Set;for(let i=0;i<SUPPORTED_MODULE_WIDTHS.length;i++){const namedWidth=SUPPORTED_MODULE_WIDTHS[i];for(let u=1;u<=this.maxColumnCount_-i;u++){const width=namedWidth.value*u+CONTAINER_GAP_WIDTH*(u-1);if(width<=this.containerMaxWidth_){widths.add(width)}}}const thresholds=[...widths];thresholds.sort(((i,j)=>i-j));const queries=[];for(let i=1;i<thresholds.length-1;i++){queries.push({maxWidth:thresholds[i+1]-1,query:`(min-width: ${thresholds[i]+2*MARGIN_WIDTH}px) and (max-width: ${thresholds[i+1]-1+2*MARGIN_WIDTH}px)`})}queries.splice(0,0,{maxWidth:thresholds[0],query:`(max-width: ${thresholds[0]-1+2*MARGIN_WIDTH}px)`});queries.push({maxWidth:thresholds[thresholds.length-1],query:`(min-width: ${thresholds[thresholds.length-1]+2*MARGIN_WIDTH}px)`});queries.forEach((details=>{const query=WindowProxy.getInstance().matchMedia(details.query);this.eventTracker_.add(query,"change",(e=>{if(e.matches){this.updateContainerAndChildrenStyles_(details.maxWidth)}}))}));this.eventTracker_.add(window,"keydown",this.onWindowKeydown_.bind(this));this.setDisabledModulesListenerId_=this.callbackRouter_.setDisabledModules.addListener(((all,ids)=>{this.disabledModules_={all:all,ids:ids}}));this.pageHandler_.updateDisabledModules();this.setModulesLoadableListenerId_=this.callbackRouter_.setModulesLoadable.addListener((()=>{if(this.waitToLoadModules_){this.waitToLoadModules_=false;this.moduleLoadPromise_=this.loadModules_()}else if(this.modulesReloadable_){this.handleModuleEnablement_(this.disabledModules_)}}));if(this.waitToLoadModules_){this.pageHandler_.updateModulesLoadable()}else{this.moduleLoadPromise_=this.loadModules_()}}disconnectedCallback(){super.disconnectedCallback();assert(this.setDisabledModulesListenerId_);this.callbackRouter_.removeListener(this.setDisabledModulesListenerId_);assert(this.setModulesLoadableListenerId_);this.callbackRouter_.removeListener(this.setModulesLoadableListenerId_);this.eventTracker_.removeAll()}firstUpdated(){this.style.setProperty("--container-gap",`${CONTAINER_GAP_WIDTH}px`);assert(SUPPORTED_MODULE_WIDTHS[0]);this.containerMaxWidth_=this.maxColumnCount_*SUPPORTED_MODULE_WIDTHS[0].value+(this.maxColumnCount_-1)*CONTAINER_GAP_WIDTH}updated(changedProperties){super.updated(changedProperties);this.availableWidth_=Math.min(document.body.clientWidth-2*MARGIN_WIDTH,this.containerMaxWidth_)}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("moduleInstances_")||changedProperties.has("disabledModules_")){this.updateContainerAndChildrenStyles_(this.availableWidth_)}}get pageHandler_(){return NewTabPageProxy.getInstance().handler}get callbackRouter_(){return NewTabPageProxy.getInstance().callbackRouter}moduleDisabled_(instance){return this.disabledModules_.all||this.disabledModules_.ids.includes(instance.descriptor.id)}async loadModules_(){const modulesIdNames=(await this.pageHandler_.getModulesIdNames()).data;const modules=await ModuleRegistry.getInstance().initializeModulesHavingIds(modulesIdNames.map((m=>m.id)),loadTimeData.getInteger("modulesLoadTimeout"));if(modules.length>0){this.pageHandler_.onModulesLoadedWithData(modules.map((module=>module.descriptor.id)));this.moduleInstances_=modules.map((module=>createModuleInstances(module))).flat()}this.recordInitialLoadMetrics_(modules,modulesIdNames);this.dispatchEvent(new CustomEvent("modules-loaded",{detail:modules.length}))}recordInitialLoadMetrics_(modules,modulesIdNames){recordSmallCount("NewTabPage.Modules.LoadedModulesCount",modules.length);modulesIdNames.forEach((({id:id})=>{recordBoolean(`NewTabPage.Modules.EnabledOnNTPLoad.${id}`,!this.disabledModules_.all&&!this.disabledModules_.ids.includes(id))}));recordSmallCount("NewTabPage.Modules.InstanceCount",this.moduleInstances_.length);recordBoolean("NewTabPage.Modules.VisibleOnNTPLoad",!this.disabledModules_.all);this.recordModuleLoadedWithModules_(true)}recordModuleLoadedWithModules_(onNtpLoad){const moduleDescriptorIds=[...new Set(this.moduleInstances_.map((instance=>instance.descriptor.id)))];const histogramBase=onNtpLoad?"NewTabPage.Modules.LoadedWith":"NewTabPage.Modules.ReloadedWith";for(const moduleDescriptorId of moduleDescriptorIds){moduleDescriptorIds.forEach((id=>{if(id!==moduleDescriptorId){recordSparseValueWithPersistentHash(`${histogramBase}.${moduleDescriptorId}`,id)}}))}}async handleModuleEnablement_(disabledModules){if(this.moduleLoadPromise_){await this.moduleLoadPromise_}if(!this.availableModulesIds_){const modulesIdNames=(await this.pageHandler_.getModulesIdNames()).data;this.availableModulesIds_=new Set(modulesIdNames.map((m=>m.id)))}const disabledModuleIds=disabledModules.ids;const newlyEnabledModuleIds=[...this.availableModulesIds_.difference(new Set(disabledModuleIds.concat(this.moduleInstances_.map((m=>m.descriptor.id)))))];if(newlyEnabledModuleIds.length===0){return}const newModuleInstances=[];while(newlyEnabledModuleIds.length>0){const moduleId=newlyEnabledModuleIds.shift();const module=await ModuleRegistry.getInstance().initializeModuleById(moduleId,loadTimeData.getInteger("modulesLoadTimeout"));if(module){newModuleInstances.push(...createModuleInstances(module))}}if(newModuleInstances.length>0){newModuleInstances.push(...this.moduleInstances_);const orderedIds=(await this.pageHandler_.getModulesOrder()).moduleIds;if(orderedIds&&orderedIds.length>0){newModuleInstances.sort(((a,b)=>{const aId=a.descriptor.id;const bId=b.descriptor.id;const aHasOrder=orderedIds.includes(aId);const bHasOrder=orderedIds.includes(bId);if(aHasOrder&&bHasOrder){return orderedIds.indexOf(aId)-orderedIds.indexOf(bId)}return+bHasOrder-+aHasOrder}))}this.moduleInstances_=newModuleInstances;recordSmallCount("NewTabPage.Modules.ReloadedModulesCount",this.moduleInstances_.length);this.recordModuleLoadedWithModules_(false)}}updateContainerAndChildrenStyles_(availableWidth){const visibleModuleInstances=this.disabledModules_.all?[]:this.moduleInstances_.filter((instance=>!this.disabledModules_.ids.includes(instance.descriptor.id)));this.modulesShownToUser=visibleModuleInstances.length!==0;if(visibleModuleInstances.length===0){return}this.style.setProperty("--container-max-width",`${availableWidth}px`);const clamp=(min,val,max)=>Math.max(min,Math.min(val,max));const rowMaxInstanceCount=clamp(1,Math.floor((availableWidth+CONTAINER_GAP_WIDTH)/(CONTAINER_GAP_WIDTH+SUPPORTED_MODULE_WIDTHS[0].value)),this.maxColumnCount_);let index=0;while(index<visibleModuleInstances.length){const instances=visibleModuleInstances.slice(index,index+rowMaxInstanceCount);let namedWidth=SUPPORTED_MODULE_WIDTHS[0];for(let i=1;i<SUPPORTED_MODULE_WIDTHS.length;i++){const moduleWidth=SUPPORTED_MODULE_WIDTHS[i];assert(moduleWidth);if(Math.floor((availableWidth-CONTAINER_GAP_WIDTH*(instances.length-1))/moduleWidth.value)<instances.length){break}namedWidth=moduleWidth}instances.slice(0,instances.length).forEach((instance=>{instance.element.setAttribute("format",namedWidth.name);instance.element.style.width=`${namedWidth.value}px`}));index+=instances.length}}onDisableModule_(e){const moduleWrapper=e.target.parentNode;assert(moduleWrapper);const module=moduleWrapper.module;assert(module);const id=module.descriptor.id;const restoreCallback=e.detail.restoreCallback;this.undoData_={message:e.detail.message,undo:()=>{if(restoreCallback){restoreCallback()}this.pageHandler_.setModuleDisabled(id,false);recordSparseValueWithPersistentHash("NewTabPage.Modules.Enabled",id);recordSparseValueWithPersistentHash("NewTabPage.Modules.Enabled.Toast",id)}};this.pageHandler_.setModuleDisabled(id,true);this.$.undoToast.show();recordSparseValueWithPersistentHash(METRIC_NAME_MODULE_DISABLED,id);recordSparseValueWithPersistentHash(`${METRIC_NAME_MODULE_DISABLED}.ModuleRequest`,id)}onDismissModuleInstance_(e){const wrapper=e.target.parentNode;const index=Array.from(wrapper.parentNode.children).indexOf(wrapper);const module=this.moduleInstances_[index];assert(module);this.moduleInstances_=this.moduleInstances_.toSpliced(index,1);const restoreCallback=e.detail.restoreCallback;this.undoData_={message:e.detail.message,undo:restoreCallback?()=>{this.moduleInstances_=this.moduleInstances_.toSpliced(index,0,module);restoreCallback();recordOccurrence("NewTabPage.Modules.Restored");recordOccurrence(`NewTabPage.Modules.Restored.${module.descriptor.id}`)}:undefined};this.$.undoToast.show();this.pageHandler_.onDismissModule(module.descriptor.id)}onDismissModuleElement_(e){const restoreCallback=e.detail.restoreCallback;this.undoData_={message:e.detail.message,undo:restoreCallback?()=>{restoreCallback()}:undefined};this.$.undoToast.show()}onUndoButtonClick_(){if(!this.undoData_){return}this.undoData_.undo();this.$.undoToast.hide();this.undoData_=null}onWindowKeydown_(e){let ctrlKeyPressed=e.ctrlKey;ctrlKeyPressed=ctrlKeyPressed||e.metaKey;if(ctrlKeyPressed&&e.key==="z"){this.onUndoButtonClick_()}}}customElements.define(ModulesElement.is,ModulesElement);let instance$2=null;function getCss$2(){return instance$2||(instance$2=[...[getCss$t()],css`:host{--setup-list-foreground:var(--color-sys-on-surface);--setup-list-icon-foreground:var(--color-sys-on-tonal-container);--setup-list-action-icon-foreground:var(--color-sys-on-surface-subtle);--setup-list-completed-foreground:var(--color-sys-state-disabled);--setup-list-completed-icon-background:var(--color-sys-tertiary-container);--setup-list-completed-icon-foreground:var(--color-sys-on-surface-subtle);--setup-list-element-spacing:16px;--setup-list-icon-background:var(--color-sys-tonal-container);--setup-list-icon-border-radius:8px;--setup-list-icon-size:40px;--setup-list-icon-image-size:20px;--setup-list-padding:12px;--setup-list-padding-end:16px;--setup-list-text-line-height:20px;--setup-list-text-width:370px;display:flex}#backing{align-items:center;background-color:transparent;border:none;color:var(--setup-list-foreground);cursor:pointer;display:flex;flex-grow:1;font:inherit;gap:var(--setup-list-element-spacing);padding:var(--setup-list-padding);padding-inline-end:var(--setup-list-padding-end);text-align:start}#backing.pending:hover{background-color:var(--color-new-tab-page-control-background-hovered)}#bodyIcon{--iron-icon-height:var(--setup-list-icon-image-size);--iron-icon-width:var(--setup-list-icon-image-size);background-color:var(--setup-list-icon-background);border-radius:var(--setup-list-icon-border-radius);box-sizing:border-box;color:var(--setup-list-icon-foreground);display:inline-block;height:var(--setup-list-icon-size);margin:0;padding:calc((var(--setup-list-icon-size) - var(--setup-list-icon-image-size)) / 2);text-align:center;width:var(--setup-list-icon-size)}.completed #bodyIcon{background-color:var(--setup-list-completed-icon-background);color:var(--setup-list-completed-icon-foreground)}#bodyText{display:inline-block;line-height:var(--setup-list-text-line-height);margin-block:0;width:var(--setup-list-text-width);vertical-align:middle}.completed #bodyText{color:var(--setup-list-completed-foreground)}#actionIcon{--iron-icon-height:var(--setup-list-icon-image-size);--iron-icon-width:var(--setup-list-icon-image-size);background-color:transparent;box-sizing:border-box;color:var(--setup-list-action-icon-foreground);display:inline-block;height:var(--setup-list-icon-image-size);margin:0;text-align:center;width:var(--setup-list-icon-image-size)}#actionIcon:dir(rtl){transform:scaleX(-1)}.completed #actionIcon{color:var(--setup-list-completed-foreground)}`])}function getHtml$2(){return html`<!--_html_template_start_-->
<button id="backing" @click="${this.onClick_}"
    class="${this.completed?"completed":"pending"}"
    ?disabled="${this.completed}"
    aria-label="${this.actionButtonText}" ?aria-disabled="${this.completed}"
    >
  <cr-icon id="bodyIcon" class="${this.completed?"completed":""}"
    icon="${this.completed?"cr:check":"ntp-promo:"+this.bodyIconName}">
  </cr-icon>
  <p id="bodyText">${this.bodyText}</p>
  <cr-icon id="actionIcon" icon="cr:chevron-right"></cr-icon>
</button>
<!--_html_template_end_-->`}class SetupListItemElement extends CrLitElement{static get is(){return"setup-list-item"}static get styles(){return getCss$2()}render(){return getHtml$2.bind(this)()}static get properties(){return{actionButtonText:{type:String,reflect:true,useDefault:true},bodyIconName:{type:String,reflect:true,useDefault:true},bodyText:{type:String,reflect:true,useDefault:true},completed:{type:Boolean,reflect:true,useDefault:true},promoId:{type:String,reflect:true,useDefault:true}}}#actionButtonText_accessor_storage="";get actionButtonText(){return this.#actionButtonText_accessor_storage}set actionButtonText(value){this.#actionButtonText_accessor_storage=value}#bodyIconName_accessor_storage="";get bodyIconName(){return this.#bodyIconName_accessor_storage}set bodyIconName(value){this.#bodyIconName_accessor_storage=value}#bodyText_accessor_storage="";get bodyText(){return this.#bodyText_accessor_storage}set bodyText(value){this.#bodyText_accessor_storage=value}#completed_accessor_storage=false;get completed(){return this.#completed_accessor_storage}set completed(value){this.#completed_accessor_storage=value}#promoId_accessor_storage="";get promoId(){return this.#promoId_accessor_storage}set promoId(value){this.#promoId_accessor_storage=value}onClick_(){const event=new CustomEvent("ntp-promo-click",{composed:true,bubbles:true,detail:this.promoId});this.dispatchEvent(event)}}customElements.define(SetupListItemElement.is,SetupListItemElement);let instance$1=null;function getCss$1(){return instance$1||(instance$1=[...[getCss$t()],css`:host{--setup-list-background:var(--color-sys-surface);--setup-list-border-radius:12px;--setup-list-item-spacing:12px;--setup-list-margin:8px;--setup-list-separator-color:var(--color-sys-base-container);--setup-list-separator-size:1px}#promos{background-color:var(--setup-list-background);border:none;border-radius:var(--setup-list-border-radius);margin:var(--setup-list-margin);overflow:hidden}setup-list-item{border-block-end:var(--setup-list-separator-size) solid var(--setup-list-separator-color)}setup-list-item:last-child{border-block-end:none}`])}function getHtml$1(){return html`<!--_html_template_start_-->
<ntp-module-header-v2
    id="moduleHeaderElementV2"
    header-text="${this.i18n("modulesSetupListTitle")}"
    .menuItems="${[{action:"dismiss",icon:"modules:visibility_off",text:this.i18nRecursive("","modulesDismissForDaysButtonText","setupListModuleDismissDays")},{action:"disable",icon:"modules:block",text:this.i18nRecursive("","modulesDisableButtonTextV2","modulesSetupListTitle")}]}"
    hide-customize
    more-actions-text="${this.i18nRecursive("","modulesMoreActions","modulesSetupListTitle")}"
    @disable-button-click="${this.onDisableButtonClick_}"
    @dismiss-button-click="${this.onDismissButtonClick_}"
    @info-button-click="${this.onInfoButtonClick_}">
</ntp-module-header-v2>
<div id="promos" @ntp-promo-click="${this.onPromoClick_}">
  ${this.eligiblePromos_.map((item=>html`
    <setup-list-item
        body-icon-name="${item.iconName}"
        body-text="${item.bodyText}"
        action-button-text="${item.buttonText}"
        promo-id="${item.id}">
    </setup-list-item>
  `))}
  ${this.completedPromos_.map((item=>html`
    <setup-list-item
        completed="true"
        body-text="${item.bodyText}"
        promo-id="${item.id}">
    </setup-list-item>
  `))}
</div>
${this.showInfoDialog_?html`
    <ntp-info-dialog show-on-attach
        .innerHTML="${this.i18nAdvanced("modulesSetupListInfo")}"
        @close="${this.onInfoDialogClose_}">>
    </ntp-info-dialog>
`:""}
<!--_html_template_end_-->`}class SetupListElement extends(I18nMixinLit(CrLitElement)){static get is(){return"setup-list"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{maxPromos:{type:Number,attribute:true,useDefault:true},maxCompletedPromos:{type:Number,attribute:true,useDefault:true},completedPromos_:{type:Array},eligiblePromos_:{type:Array},showInfoDialog_:{type:Boolean},allowFaviconServerFallback_:{type:Boolean}}}#maxPromos_accessor_storage=0;get maxPromos(){return this.#maxPromos_accessor_storage}set maxPromos(value){this.#maxPromos_accessor_storage=value}#maxCompletedPromos_accessor_storage=0;get maxCompletedPromos(){return this.#maxCompletedPromos_accessor_storage}set maxCompletedPromos(value){this.#maxCompletedPromos_accessor_storage=value}#completedPromos__accessor_storage=[];get completedPromos_(){return this.#completedPromos__accessor_storage}set completedPromos_(value){this.#completedPromos__accessor_storage=value}#eligiblePromos__accessor_storage=[];get eligiblePromos_(){return this.#eligiblePromos__accessor_storage}set eligiblePromos_(value){this.#eligiblePromos__accessor_storage=value}#showInfoDialog__accessor_storage=false;get showInfoDialog_(){return this.#showInfoDialog__accessor_storage}set showInfoDialog_(value){this.#showInfoDialog__accessor_storage=value}handler_;callbackRouter_;listenerIds_=[];notifiedShown_=false;constructor(){super();this.handler_=NtpPromoProxyImpl.getInstance().getHandler();this.callbackRouter_=NtpPromoProxyImpl.getInstance().getCallbackRouter()}connectedCallback(){super.connectedCallback();this.listenerIds_.push(this.callbackRouter_.setPromos.addListener(this.onSetPromos.bind(this)));this.handler_.requestPromos()}disconnectedCallback(){super.disconnectedCallback();for(const listenerId of this.listenerIds_){this.callbackRouter_.removeListener(listenerId)}this.listenerIds_=[]}onSetPromos(eligible,completed){this.completedPromos_=completed.slice(0,this.maxCompletedPromos);const maxEligible=this.maxPromos-this.completedPromos_.length;this.eligiblePromos_=eligible.slice(0,maxEligible);const hasPromos=this.completedPromos_.length!==0||this.eligiblePromos_.length!==0;const readyEvent=new CustomEvent("module-ready",{bubbles:true,composed:true,detail:hasPromos});this.dispatchEvent(readyEvent);if(!this.notifiedShown_){this.notifiedShown_=true;const eligible=this.eligiblePromos_.map((promo=>promo.id));const completed=this.completedPromos_.map((promo=>promo.id));this.handler_.onPromosShown(eligible,completed)}}onPromoClick_(e){const promoId=e.detail;assert(promoId,"Entry should never have empty promo ID.");this.handler_.onPromoClicked(promoId)}onDisableButtonClick_(){this.handler_.disableSetupList();const disableEvent=new CustomEvent("disable-module",{bubbles:true,composed:true,detail:{message:this.i18nRecursive("","modulesSetupListDisableToastMessage","modulesSetupListTitle"),restoreCallback:()=>this.handler_.undisableSetupList()}});this.dispatchEvent(disableEvent)}onDismissButtonClick_(){this.handler_.snoozeSetupList();this.dispatchEvent(new CustomEvent("dismiss-module-instance",{bubbles:true,composed:true,detail:{message:this.i18nRecursive("","modulesSetupListDismissToastMessage","modulesSetupListTitle"),restoreCallback:()=>this.handler_.unsnoozeSetupList()}}))}onInfoButtonClick_(){this.showInfoDialog_=true}onInfoDialogClose_(){this.showInfoDialog_=false}}customElements.define(SetupListElement.is,SetupListElement);let instance=null;function getCss(){return instance||(instance=[...[getCss$r()],css`#container{display:flex;flex-flow:row wrap;gap:var(--container-gap);justify-content:center;margin-block-start:30px;max-width:var(--container-max-width,inherit)}#moduleElement{align-items:center;background:var(--color-new-tab-page-module-background);border:none;border-radius:var(--ntp-module-border-radius);box-sizing:border-box;display:flex;height:fit-content;justify-content:center;overflow:visible;position:relative}#undoToastMessage{flex-grow:1}`])}function getHtml(){return html`<!--_html_template_start_-->
<div id="container"
    ?hidden="${this.isModuleHidden_()}"
    @module-ready="${this.onModuleReady_}"
    @disable-module="${this.onHideModule_}"
    @dismiss-module-instance="${this.onHideModule_}">
  <div id="moduleElement">
    <setup-list id="setupList" maxPromos="${this.maxPromos}"
        maxCompletedPromos="${this.maxCompletedPromos}">
    </setup-list>
  </div>
</div>
<cr-toast id="undoToast" duration="10000">
  <div id="undoToastMessage">${this.undoData_?.message||""}</div>
  ${this.undoData_?.undo?html`
    <cr-button id="undoButton" aria-label="$i18n{undoDescription}"
        @click="${this.onUndoButtonClick_}">
      $i18n{undo}
    </cr-button>
  `:""}
</cr-toast>
<!--_html_template_end_-->`}class SetupListModuleWrapperElement extends CrLitElement{static get is(){return"setup-list-module-wrapper"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{moduleHidden_:{type:Boolean},moduleReady_:{type:Boolean},undoData_:{type:Object},maxPromos:{type:Number,attribute:true,useDefault:true},maxCompletedPromos:{type:Number,attribute:true,useDefault:true}}}#maxPromos_accessor_storage=0;get maxPromos(){return this.#maxPromos_accessor_storage}set maxPromos(value){this.#maxPromos_accessor_storage=value}#maxCompletedPromos_accessor_storage=0;get maxCompletedPromos(){return this.#maxCompletedPromos_accessor_storage}set maxCompletedPromos(value){this.#maxCompletedPromos_accessor_storage=value}#moduleHidden__accessor_storage=false;get moduleHidden_(){return this.#moduleHidden__accessor_storage}set moduleHidden_(value){this.#moduleHidden__accessor_storage=value}#moduleReady__accessor_storage=false;get moduleReady_(){return this.#moduleReady__accessor_storage}set moduleReady_(value){this.#moduleReady__accessor_storage=value}#undoData__accessor_storage=null;get undoData_(){return this.#undoData__accessor_storage}set undoData_(value){this.#undoData__accessor_storage=value}eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();this.eventTracker_.add(window,"keydown",this.onWindowKeydown_.bind(this))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}onHideModule_(e){this.moduleHidden_=true;const restoreCallback=e.detail.restoreCallback;this.undoData_={message:e.detail.message,undo:()=>{this.moduleHidden_=false;if(restoreCallback){restoreCallback()}}};this.$.undoToast.show()}onModuleReady_(e){this.moduleReady_=e.detail}isModuleHidden_(){return!this.moduleReady_||this.moduleHidden_}onUndoButtonClick_(){if(!this.undoData_){return}this.undoData_.undo();this.$.undoToast.hide();this.undoData_=null}onWindowKeydown_(e){let ctrlKeyPressed=e.ctrlKey;ctrlKeyPressed=ctrlKeyPressed||e.metaKey;if(ctrlKeyPressed&&e.key==="z"){this.onUndoButtonClick_()}}}customElements.define(SetupListModuleWrapperElement.is,SetupListModuleWrapperElement);export{COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_DOT_PREFIX,COLOR_NEW_TAB_PAGE_MODULE_TAB_GROUPS_PREFIX,CalendarAction,CalendarElement,CalendarEventElement,DriveModuleElement as DriveModuleV2Element,FileProxy,FileSuggestionElement,GoogleCalendarModuleElement,GoogleCalendarProxyImpl,IconContainerElement,IndividualPromosElement,InfoDialogElement,LensErrorType,LensFormElement,LensSubmitType,LensUploadDialogAction,LensUploadDialogElement,LensUploadDialogError,MicrosoftAuthModuleElement,MicrosoftAuthProxyImpl,MicrosoftFilesModuleElement,MicrosoftFilesProxyImpl,MiddleSlotPromoElement,ModuleDescriptor,ModuleHeaderElement as ModuleHeaderElementV2,ModuleRegistry,ModuleWrapperElement,ModulesElement,ModuleElement$1 as MostRelevantTabResumptionModuleElement,MostRelevantTabResumptionProxyImpl,PluralStringProxyImpl as NTPPluralStringProxyImpl,NtpPromoProxyImpl,OutlookCalendarModuleElement,OutlookCalendarProxyImpl,PageImageServiceBrowserProxy,ParentTrustedDocumentProxy,PromoDismissAction,SUPPORTED_MODULE_WIDTHS,SetupListElement,SetupListItemElement,SetupListModuleWrapperElement,ModuleElement as TabGroupsModuleElement,TabGroupsProxyImpl,colorIdToString,counterfactualLoad,driveModuleDescriptor,googleCalendarDescriptor,microsoftAuthModuleDescriptor,microsoftFilesModuleDescriptor,mostRelevantTabResumptionDescriptor,outlookCalendarDescriptor,tabGroupsDescriptor};