// services/media_session/public/mojom/media_session.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec,
  TimeTicks as mojoBase_mojom_TimeTicks
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  SizeSpec as gfx_mojom_SizeSpec,
  Size as gfx_mojom_Size
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const MediaPlaybackStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaPlaybackState {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kPaused = 0,
  kPlaying = 1,
}

export const MediaSessionActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaSessionAction {

  MIN_VALUE = 0,
  MAX_VALUE = 20,
  kPlay = 0,
  kPause = 1,
  kPreviousTrack = 2,
  kNextTrack = 3,
  kSeekBackward = 4,
  kSeekForward = 5,
  kSkipAd = 6,
  kStop = 7,
  kSeekTo = 8,
  kScrubTo = 9,
  kEnterPictureInPicture = 10,
  kExitPictureInPicture = 11,
  kSwitchAudioDevice = 12,
  kToggleMicrophone = 13,
  kToggleCamera = 14,
  kHangUp = 15,
  kRaise = 16,
  kSetMute = 17,
  kPreviousSlide = 18,
  kNextSlide = 19,
  kEnterAutoPictureInPicture = 20,
}

export const MediaSessionImageTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaSessionImageType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kArtwork = 0,
  kSourceIcon = 1,
  kChapter = 2,
}

export const MediaPictureInPictureStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaPictureInPictureState {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kNotInPictureInPicture = 0,
  kInPictureInPicture = 1,
}

export const MediaAudioVideoStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaAudioVideoState {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kDeprecatedUnknown = 0,
  kAudioOnly = 1,
  kAudioVideo = 2,
  kVideoOnly = 3,
}

export const MediaImageBitmapColorTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaImageBitmapColorType {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kRGBA_8888 = 0,
  kBGRA_8888 = 1,
}

export const MicrophoneStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MicrophoneState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kMuted = 1,
  kUnmuted = 2,
}

export const CameraStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CameraState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnknown = 0,
  kTurnedOn = 1,
  kTurnedOff = 2,
}



export type MediaSessionObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaSessionObserverPendingReceiver>;

export class MediaSessionObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaSessionObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaSessionObserverPendingReceiver>;
  constructor(handle: MojoHandle|MediaSessionObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaSessionObserver',
        scope);
  }
}

export interface MediaSessionObserverInterface {
  mediaSessionInfoChanged(info: MediaSessionInfo): void;
  mediaSessionMetadataChanged(metadata: (MediaMetadata | null)): void;
  mediaSessionActionsChanged(action: MediaSessionAction[]): void;
  mediaSessionImagesChanged(images: {[key in MediaSessionImageType]?: MediaImage[]}): void;
  mediaSessionPositionChanged(position: (MediaPosition | null)): void;
}

export class MediaSessionObserverRemote implements MediaSessionObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaSessionObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaSessionObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaSessionObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  mediaSessionInfoChanged(
      info: MediaSessionInfo): void {
    this.proxy.sendMessage(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  mediaSessionMetadataChanged(
      metadata: (MediaMetadata | null)): void {
    this.proxy.sendMessage(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  mediaSessionActionsChanged(
      action: MediaSessionAction[]): void {
    this.proxy.sendMessage(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  mediaSessionImagesChanged(
      images: {[key in MediaSessionImageType]?: MediaImage[]}): void {
    this.proxy.sendMessage(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        [
          images
        ],
        false);
  }

  mediaSessionPositionChanged(
      position: (MediaPosition | null)): void {
    this.proxy.sendMessage(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaSessionObserverRemote, MediaSessionObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaSessionObserverRemote, MediaSessionObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaSessionObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        impl.mediaSessionImagesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSessionObserver {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaSessionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaSessionObserverRemote {
    let remote = new MediaSessionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaSessionObserverRemote, MediaSessionObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaSessionObserverRemote, MediaSessionObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  mediaSessionInfoChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionMetadataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionActionsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionImagesChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionPositionChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionImagesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        this.mediaSessionImagesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MediaSessionPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaSessionPendingReceiver>;

export class MediaSessionPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaSession> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaSessionPendingReceiver>;
  constructor(handle: MojoHandle|MediaSessionPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaSession',
        scope);
  }
}

export interface MediaSessionInterface {
  getMediaSessionInfo(): Promise<{
        info: MediaSessionInfo, }>;
  getDebugInfo(): Promise<{
        info: MediaSessionDebugInfo, }>;
  startDucking(): void;
  stopDucking(): void;
  suspend(suspendType: MediaSession_SuspendType): void;
  resume(suspendType: MediaSession_SuspendType): void;
  addObserver(observer: MediaSessionObserverRemote): void;
  previousTrack(): void;
  nextTrack(): void;
  seek(seekTime: mojoBase_mojom_TimeDelta): void;
  stop(suspendType: MediaSession_SuspendType): void;
  skipAd(): void;
  getMediaImageBitmap(image: MediaImage, minimumSizePx: number, desiredSizePx: number): Promise<{
        image: (MediaImageBitmap | null), }>;
  seekTo(seekTime: mojoBase_mojom_TimeDelta): void;
  scrubTo(seekTime: mojoBase_mojom_TimeDelta): void;
  enterPictureInPicture(): void;
  exitPictureInPicture(): void;
  setAudioSinkId(id: (string | null)): void;
  toggleMicrophone(): void;
  toggleCamera(): void;
  hangUp(): void;
  raise(): void;
  setMute(mute: boolean): void;
  requestMediaRemoting(): void;
  previousSlide(): void;
  nextSlide(): void;
  enterAutoPictureInPicture(): void;
  getVisibility(): Promise<{
        hasSufficientlyVisibleVideo: boolean, }>;
}

export class MediaSessionRemote implements MediaSessionInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaSessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaSessionPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaSessionPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getMediaSessionInfo(): Promise<{
        info: MediaSessionInfo, }> {
    return this.proxy.sendMessage(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getDebugInfo(): Promise<{
        info: MediaSessionDebugInfo, }> {
    return this.proxy.sendMessage(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  startDucking(): void {
    this.proxy.sendMessage(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  stopDucking(): void {
    this.proxy.sendMessage(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  suspend(
      suspendType: MediaSession_SuspendType): void {
    this.proxy.sendMessage(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  resume(
      suspendType: MediaSession_SuspendType): void {
    this.proxy.sendMessage(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  addObserver(
      observer: MediaSessionObserverRemote): void {
    this.proxy.sendMessage(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  previousTrack(): void {
    this.proxy.sendMessage(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  nextTrack(): void {
    this.proxy.sendMessage(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  seek(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  stop(
      suspendType: MediaSession_SuspendType): void {
    this.proxy.sendMessage(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  skipAd(): void {
    this.proxy.sendMessage(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getMediaImageBitmap(
      image: MediaImage,
      minimumSizePx: number,
      desiredSizePx: number): Promise<{
        image: (MediaImageBitmap | null), }> {
    return this.proxy.sendMessage(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        [
          image,
          minimumSizePx,
          desiredSizePx
        ],
        false);
  }

  seekTo(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  scrubTo(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  enterPictureInPicture(): void {
    this.proxy.sendMessage(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  exitPictureInPicture(): void {
    this.proxy.sendMessage(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setAudioSinkId(
      id: (string | null)): void {
    this.proxy.sendMessage(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  toggleMicrophone(): void {
    this.proxy.sendMessage(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  toggleCamera(): void {
    this.proxy.sendMessage(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  hangUp(): void {
    this.proxy.sendMessage(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  raise(): void {
    this.proxy.sendMessage(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setMute(
      mute: boolean): void {
    this.proxy.sendMessage(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  requestMediaRemoting(): void {
    this.proxy.sendMessage(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  previousSlide(): void {
    this.proxy.sendMessage(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  nextSlide(): void {
    this.proxy.sendMessage(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  enterAutoPictureInPicture(): void {
    this.proxy.sendMessage(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getVisibility(): Promise<{
        hasSufficientlyVisibleVideo: boolean, }> {
    return this.proxy.sendMessage(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaSessionRemote, MediaSessionPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaSessionRemote, MediaSessionPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaSessionInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        impl.getMediaSessionInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        impl.getDebugInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        impl.startDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        impl.stopDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        impl.getMediaImageBitmap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        impl.previousSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        impl.nextSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        impl.getVisibility.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSession {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaSessionRemote {
    let remote = new MediaSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}
export const MediaSession_SuspendTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaSession_SuspendType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kSystem = 0,
  kUI = 1,
  kContent = 2,
}

/**
 * An object which receives request messages for the MediaSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaSessionRemote, MediaSessionPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaSessionRemote, MediaSessionPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getMediaSessionInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDebugInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startDucking: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stopDucking: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  suspend: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resume: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  previousTrack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  nextTrack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  seek: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stop: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  skipAd: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getMediaImageBitmap: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  seekTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  scrubTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  enterPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  exitPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAudioSinkId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleMicrophone: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleCamera: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hangUp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  raise: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMute: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestMediaRemoting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  previousSlide: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  nextSlide: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  enterAutoPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getVisibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getMediaSessionInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        this.getMediaSessionInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDebugInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        this.getDebugInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        this.startDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stopDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        this.stopDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getMediaImageBitmap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        this.getMediaImageBitmap.createReceiverHandler(true /* expectsResponse */),
        false);
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    this.previousSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        this.previousSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    this.nextSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        this.nextSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        this.getVisibility.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const MediaImageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ChapterInformationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaImageBitmapSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaPositionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const RemotePlaybackMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionDebugInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetMediaSessionInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetMediaSessionInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetDebugInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetDebugInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_StartDucking_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_StopDucking_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_Suspend_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_Resume_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_AddObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_PreviousTrack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_NextTrack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_Seek_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_Stop_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_SkipAd_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetMediaImageBitmap_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetMediaImageBitmap_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_SeekTo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_ScrubTo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_EnterPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_ExitPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_SetAudioSinkId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_ToggleMicrophone_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_ToggleCamera_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_HangUp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_Raise_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_SetMute_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_RequestMediaRemoting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_PreviousSlide_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_NextSlide_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_EnterAutoPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetVisibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaSession_GetVisibility_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface MediaImageMojoType {
  src: url_mojom_Url;
  type: mojoBase_mojom_String16;
  sizes: gfx_mojom_Size[];
}


export type MediaImage = MediaImageMojoType;
mojo.internal.Struct<MediaImageMojoType>(
    MediaImageSpec.$,
    'MediaImage',
    [
      mojo.internal.StructField<MediaImageMojoType, url_mojom_Url>(
        'src', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaImageMojoType, mojoBase_mojom_String16>(
        'type', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaImageMojoType, gfx_mojom_Size[]>(
        'sizes', 16,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ChapterInformationMojoType {
  title: mojoBase_mojom_String16;
  startTime: mojoBase_mojom_TimeDelta;
  artwork: MediaImage[];
}


export type ChapterInformation = ChapterInformationMojoType;
mojo.internal.Struct<ChapterInformationMojoType>(
    ChapterInformationSpec.$,
    'ChapterInformation',
    [
      mojo.internal.StructField<ChapterInformationMojoType, mojoBase_mojom_String16>(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChapterInformationMojoType, mojoBase_mojom_TimeDelta>(
        'startTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ChapterInformationMojoType, MediaImage[]>(
        'artwork', 16,
        0,
        mojo.internal.Array(MediaImageSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface MediaMetadataMojoType {
  title: mojoBase_mojom_String16;
  artist: mojoBase_mojom_String16;
  album: mojoBase_mojom_String16;
  sourceTitle: mojoBase_mojom_String16;
  chapters: (ChapterInformation[] | null);
}


export type MediaMetadata = MediaMetadataMojoType;
mojo.internal.Struct<MediaMetadataMojoType>(
    MediaMetadataSpec.$,
    'MediaMetadata',
    [
      mojo.internal.StructField<MediaMetadataMojoType, mojoBase_mojom_String16>(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaMetadataMojoType, mojoBase_mojom_String16>(
        'artist', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaMetadataMojoType, mojoBase_mojom_String16>(
        'album', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaMetadataMojoType, mojoBase_mojom_String16>(
        'sourceTitle', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaMetadataMojoType, ChapterInformation[]>(
        'chapters', 32,
        0,
        mojo.internal.Array(ChapterInformationSpec.$, false),
        null,
        true /* nullable */,
        21,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],[21, 48],]);





export interface MediaImageBitmapMojoType {
  width: number;
  height: number;
  pixelData: number[];
  colorType: MediaImageBitmapColorType;
}


export type MediaImageBitmap = MediaImageBitmapMojoType;
mojo.internal.Struct<MediaImageBitmapMojoType>(
    MediaImageBitmapSpec.$,
    'MediaImageBitmap',
    [
      mojo.internal.StructField<MediaImageBitmapMojoType, number>(
        'width', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaImageBitmapMojoType, number>(
        'height', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaImageBitmapMojoType, number[]>(
        'pixelData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaImageBitmapMojoType, MediaImageBitmapColorType>(
        'colorType', 16,
        0,
        MediaImageBitmapColorTypeSpec.$,
        0,
        false /* nullable */,
        5,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],[5, 32],]);





export interface MediaPositionMojoType {
  playbackRate: number;
  duration: mojoBase_mojom_TimeDelta;
  position: mojoBase_mojom_TimeDelta;
  lastUpdatedTime: mojoBase_mojom_TimeTicks;
  endOfMedia: boolean;
}


export type MediaPosition = MediaPositionMojoType;
mojo.internal.Struct<MediaPositionMojoType>(
    MediaPositionSpec.$,
    'MediaPosition',
    [
      mojo.internal.StructField<MediaPositionMojoType, number>(
        'playbackRate', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaPositionMojoType, mojoBase_mojom_TimeDelta>(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaPositionMojoType, mojoBase_mojom_TimeDelta>(
        'position', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaPositionMojoType, mojoBase_mojom_TimeTicks>(
        'lastUpdatedTime', 24,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaPositionMojoType, boolean>(
        'endOfMedia', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        13,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],[13, 48],]);





export interface RemotePlaybackMetadataMojoType {
  videoCodec: string;
  audioCodec: string;
  remotePlaybackDisabled: boolean;
  remotePlaybackStarted: boolean;
  isEncryptedMedia: boolean;
  unusedField: (string | null);
}


export type RemotePlaybackMetadata = RemotePlaybackMetadataMojoType;
mojo.internal.Struct<RemotePlaybackMetadataMojoType>(
    RemotePlaybackMetadataSpec.$,
    'RemotePlaybackMetadata',
    [
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, string>(
        'videoCodec', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, string>(
        'audioCodec', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, boolean>(
        'remotePlaybackDisabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, boolean>(
        'remotePlaybackStarted', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        17,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, string>(
        'unusedField', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        17,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<RemotePlaybackMetadataMojoType, boolean>(
        'isEncryptedMedia', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        18,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],[17, 40],[18, 40],]);




export const MediaSessionInfo_SessionStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum MediaSessionInfo_SessionState {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kActive = 0,
  kDucking = 1,
  kSuspended = 2,
  kInactive = 3,
}


export interface MediaSessionInfoMojoType {
  state: MediaSessionInfo_SessionState;
  forceDuck: boolean;
  isControllable: boolean;
  preferStopForGainFocusLoss: boolean;
  deprecatedIsSensitive: boolean;
  muted: boolean;
  hasPresentation: boolean;
  hideMetadata: boolean;
  ignoreForActiveSession: boolean;
  meetsVisibilityThreshold: boolean;
  canEnterBrowserInitiatedAutopip: boolean;
  playbackState: MediaPlaybackState;
  pictureInPictureState: MediaPictureInPictureState;
  deprecatedAudioVideoState: MediaAudioVideoState;
  microphoneState: MicrophoneState;
  audioSinkId: (string | null);
  audioVideoStates: (MediaAudioVideoState[] | null);
  cameraState: CameraState;
  remotePlaybackMetadata: (RemotePlaybackMetadata | null);
}


export type MediaSessionInfo = MediaSessionInfoMojoType;
mojo.internal.Struct<MediaSessionInfoMojoType>(
    MediaSessionInfoSpec.$,
    'MediaSessionInfo',
    [
      mojo.internal.StructField<MediaSessionInfoMojoType, MediaSessionInfo_SessionState>(
        'state', 0,
        0,
        MediaSessionInfo_SessionStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'forceDuck', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, MediaPlaybackState>(
        'playbackState', 8,
        0,
        MediaPlaybackStateSpec.$,
        0,
        false /* nullable */,
        1,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'isControllable', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        2,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'preferStopForGainFocusLoss', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        4,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'deprecatedIsSensitive', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, MediaPictureInPictureState>(
        'pictureInPictureState', 12,
        0,
        MediaPictureInPictureStateSpec.$,
        0,
        false /* nullable */,
        7,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, MediaAudioVideoState>(
        'deprecatedAudioVideoState', 16,
        0,
        MediaAudioVideoStateSpec.$,
        0,
        false /* nullable */,
        8,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, string>(
        'audioSinkId', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        9,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, MediaAudioVideoState[]>(
        'audioVideoStates', 32,
        0,
        mojo.internal.Array(MediaAudioVideoStateSpec.$, false),
        null,
        true /* nullable */,
        10,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, MicrophoneState>(
        'microphoneState', 20,
        0,
        MicrophoneStateSpec.$,
        0,
        false /* nullable */,
        11,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, CameraState>(
        'cameraState', 40,
        0,
        CameraStateSpec.$,
        0,
        false /* nullable */,
        11,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'muted', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        12,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'hasPresentation', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        14,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, RemotePlaybackMetadata>(
        'remotePlaybackMetadata', 48,
        0,
        RemotePlaybackMetadataSpec.$,
        null,
        true /* nullable */,
        15,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'hideMetadata', 4,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        16,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'ignoreForActiveSession', 4,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        20,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'meetsVisibilityThreshold', 5,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        21,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionInfoMojoType, boolean>(
        'canEnterBrowserInitiatedAutopip', 5,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        24,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],[1, 24],[2, 24],[4, 24],[6, 24],[7, 24],[8, 32],[9, 40],[10, 48],[11, 56],[12, 56],[14, 56],[15, 64],[16, 64],[20, 64],[21, 64],[24, 64],]);





export interface MediaSessionDebugInfoMojoType {
  name: string;
  owner: string;
  state: string;
}


export type MediaSessionDebugInfo = MediaSessionDebugInfoMojoType;
mojo.internal.Struct<MediaSessionDebugInfoMojoType>(
    MediaSessionDebugInfoSpec.$,
    'MediaSessionDebugInfo',
    [
      mojo.internal.StructField<MediaSessionDebugInfoMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionDebugInfoMojoType, string>(
        'owner', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSessionDebugInfoMojoType, string>(
        'state', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface MediaSessionObserver_MediaSessionInfoChanged_ParamsMojoType {
  info: MediaSessionInfo;
}


export type MediaSessionObserver_MediaSessionInfoChanged_Params = MediaSessionObserver_MediaSessionInfoChanged_ParamsMojoType;
mojo.internal.Struct<MediaSessionObserver_MediaSessionInfoChanged_ParamsMojoType>(
    MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField<MediaSessionObserver_MediaSessionInfoChanged_ParamsMojoType, MediaSessionInfo>(
        'info', 0,
        0,
        MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSessionObserver_MediaSessionMetadataChanged_ParamsMojoType {
  metadata: (MediaMetadata | null);
}


export type MediaSessionObserver_MediaSessionMetadataChanged_Params = MediaSessionObserver_MediaSessionMetadataChanged_ParamsMojoType;
mojo.internal.Struct<MediaSessionObserver_MediaSessionMetadataChanged_ParamsMojoType>(
    MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField<MediaSessionObserver_MediaSessionMetadataChanged_ParamsMojoType, MediaMetadata>(
        'metadata', 0,
        0,
        MediaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSessionObserver_MediaSessionActionsChanged_ParamsMojoType {
  action: MediaSessionAction[];
}


export type MediaSessionObserver_MediaSessionActionsChanged_Params = MediaSessionObserver_MediaSessionActionsChanged_ParamsMojoType;
mojo.internal.Struct<MediaSessionObserver_MediaSessionActionsChanged_ParamsMojoType>(
    MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField<MediaSessionObserver_MediaSessionActionsChanged_ParamsMojoType, MediaSessionAction[]>(
        'action', 0,
        0,
        mojo.internal.Array(MediaSessionActionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSessionObserver_MediaSessionImagesChanged_ParamsMojoType {
  images: {[key in MediaSessionImageType]?: MediaImage[]};
}


export type MediaSessionObserver_MediaSessionImagesChanged_Params = MediaSessionObserver_MediaSessionImagesChanged_ParamsMojoType;
mojo.internal.Struct<MediaSessionObserver_MediaSessionImagesChanged_ParamsMojoType>(
    MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionImagesChanged_Params',
    [
      mojo.internal.StructField<MediaSessionObserver_MediaSessionImagesChanged_ParamsMojoType, {[key in MediaSessionImageType]?: MediaImage[]}>(
        'images', 0,
        0,
        mojo.internal.Map(MediaSessionImageTypeSpec.$, mojo.internal.Array(MediaImageSpec.$, false), false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSessionObserver_MediaSessionPositionChanged_ParamsMojoType {
  position: (MediaPosition | null);
}


export type MediaSessionObserver_MediaSessionPositionChanged_Params = MediaSessionObserver_MediaSessionPositionChanged_ParamsMojoType;
mojo.internal.Struct<MediaSessionObserver_MediaSessionPositionChanged_ParamsMojoType>(
    MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField<MediaSessionObserver_MediaSessionPositionChanged_ParamsMojoType, MediaPosition>(
        'position', 0,
        0,
        MediaPositionSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_GetMediaSessionInfo_ParamsMojoType {
}


export type MediaSession_GetMediaSessionInfo_Params = MediaSession_GetMediaSessionInfo_ParamsMojoType;
mojo.internal.Struct<MediaSession_GetMediaSessionInfo_ParamsMojoType>(
    MediaSession_GetMediaSessionInfo_ParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_GetMediaSessionInfo_ResponseParamsMojoType {
  info: MediaSessionInfo;
}


export type MediaSession_GetMediaSessionInfo_ResponseParams = MediaSession_GetMediaSessionInfo_ResponseParamsMojoType;
mojo.internal.Struct<MediaSession_GetMediaSessionInfo_ResponseParamsMojoType>(
    MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_ResponseParams',
    [
      mojo.internal.StructField<MediaSession_GetMediaSessionInfo_ResponseParamsMojoType, MediaSessionInfo>(
        'info', 0,
        0,
        MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_GetDebugInfo_ParamsMojoType {
}


export type MediaSession_GetDebugInfo_Params = MediaSession_GetDebugInfo_ParamsMojoType;
mojo.internal.Struct<MediaSession_GetDebugInfo_ParamsMojoType>(
    MediaSession_GetDebugInfo_ParamsSpec.$,
    'MediaSession_GetDebugInfo_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_GetDebugInfo_ResponseParamsMojoType {
  info: MediaSessionDebugInfo;
}


export type MediaSession_GetDebugInfo_ResponseParams = MediaSession_GetDebugInfo_ResponseParamsMojoType;
mojo.internal.Struct<MediaSession_GetDebugInfo_ResponseParamsMojoType>(
    MediaSession_GetDebugInfo_ResponseParamsSpec.$,
    'MediaSession_GetDebugInfo_ResponseParams',
    [
      mojo.internal.StructField<MediaSession_GetDebugInfo_ResponseParamsMojoType, MediaSessionDebugInfo>(
        'info', 0,
        0,
        MediaSessionDebugInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_StartDucking_ParamsMojoType {
}


export type MediaSession_StartDucking_Params = MediaSession_StartDucking_ParamsMojoType;
mojo.internal.Struct<MediaSession_StartDucking_ParamsMojoType>(
    MediaSession_StartDucking_ParamsSpec.$,
    'MediaSession_StartDucking_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_StopDucking_ParamsMojoType {
}


export type MediaSession_StopDucking_Params = MediaSession_StopDucking_ParamsMojoType;
mojo.internal.Struct<MediaSession_StopDucking_ParamsMojoType>(
    MediaSession_StopDucking_ParamsSpec.$,
    'MediaSession_StopDucking_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_Suspend_ParamsMojoType {
  suspendType: MediaSession_SuspendType;
}


export type MediaSession_Suspend_Params = MediaSession_Suspend_ParamsMojoType;
mojo.internal.Struct<MediaSession_Suspend_ParamsMojoType>(
    MediaSession_Suspend_ParamsSpec.$,
    'MediaSession_Suspend_Params',
    [
      mojo.internal.StructField<MediaSession_Suspend_ParamsMojoType, MediaSession_SuspendType>(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_Resume_ParamsMojoType {
  suspendType: MediaSession_SuspendType;
}


export type MediaSession_Resume_Params = MediaSession_Resume_ParamsMojoType;
mojo.internal.Struct<MediaSession_Resume_ParamsMojoType>(
    MediaSession_Resume_ParamsSpec.$,
    'MediaSession_Resume_Params',
    [
      mojo.internal.StructField<MediaSession_Resume_ParamsMojoType, MediaSession_SuspendType>(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_AddObserver_ParamsMojoType {
  observer: MediaSessionObserverRemote;
}


export type MediaSession_AddObserver_Params = MediaSession_AddObserver_ParamsMojoType;
mojo.internal.Struct<MediaSession_AddObserver_ParamsMojoType>(
    MediaSession_AddObserver_ParamsSpec.$,
    'MediaSession_AddObserver_Params',
    [
      mojo.internal.StructField<MediaSession_AddObserver_ParamsMojoType, MediaSessionObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(MediaSessionObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_PreviousTrack_ParamsMojoType {
}


export type MediaSession_PreviousTrack_Params = MediaSession_PreviousTrack_ParamsMojoType;
mojo.internal.Struct<MediaSession_PreviousTrack_ParamsMojoType>(
    MediaSession_PreviousTrack_ParamsSpec.$,
    'MediaSession_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_NextTrack_ParamsMojoType {
}


export type MediaSession_NextTrack_Params = MediaSession_NextTrack_ParamsMojoType;
mojo.internal.Struct<MediaSession_NextTrack_ParamsMojoType>(
    MediaSession_NextTrack_ParamsSpec.$,
    'MediaSession_NextTrack_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_Seek_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaSession_Seek_Params = MediaSession_Seek_ParamsMojoType;
mojo.internal.Struct<MediaSession_Seek_ParamsMojoType>(
    MediaSession_Seek_ParamsSpec.$,
    'MediaSession_Seek_Params',
    [
      mojo.internal.StructField<MediaSession_Seek_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_Stop_ParamsMojoType {
  suspendType: MediaSession_SuspendType;
}


export type MediaSession_Stop_Params = MediaSession_Stop_ParamsMojoType;
mojo.internal.Struct<MediaSession_Stop_ParamsMojoType>(
    MediaSession_Stop_ParamsSpec.$,
    'MediaSession_Stop_Params',
    [
      mojo.internal.StructField<MediaSession_Stop_ParamsMojoType, MediaSession_SuspendType>(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_SkipAd_ParamsMojoType {
}


export type MediaSession_SkipAd_Params = MediaSession_SkipAd_ParamsMojoType;
mojo.internal.Struct<MediaSession_SkipAd_ParamsMojoType>(
    MediaSession_SkipAd_ParamsSpec.$,
    'MediaSession_SkipAd_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_GetMediaImageBitmap_ParamsMojoType {
  image: MediaImage;
  minimumSizePx: number;
  desiredSizePx: number;
}


export type MediaSession_GetMediaImageBitmap_Params = MediaSession_GetMediaImageBitmap_ParamsMojoType;
mojo.internal.Struct<MediaSession_GetMediaImageBitmap_ParamsMojoType>(
    MediaSession_GetMediaImageBitmap_ParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_Params',
    [
      mojo.internal.StructField<MediaSession_GetMediaImageBitmap_ParamsMojoType, MediaImage>(
        'image', 0,
        0,
        MediaImageSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSession_GetMediaImageBitmap_ParamsMojoType, number>(
        'minimumSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaSession_GetMediaImageBitmap_ParamsMojoType, number>(
        'desiredSizePx', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MediaSession_GetMediaImageBitmap_ResponseParamsMojoType {
  image: (MediaImageBitmap | null);
}


export type MediaSession_GetMediaImageBitmap_ResponseParams = MediaSession_GetMediaImageBitmap_ResponseParamsMojoType;
mojo.internal.Struct<MediaSession_GetMediaImageBitmap_ResponseParamsMojoType>(
    MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_ResponseParams',
    [
      mojo.internal.StructField<MediaSession_GetMediaImageBitmap_ResponseParamsMojoType, MediaImageBitmap>(
        'image', 0,
        0,
        MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_SeekTo_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaSession_SeekTo_Params = MediaSession_SeekTo_ParamsMojoType;
mojo.internal.Struct<MediaSession_SeekTo_ParamsMojoType>(
    MediaSession_SeekTo_ParamsSpec.$,
    'MediaSession_SeekTo_Params',
    [
      mojo.internal.StructField<MediaSession_SeekTo_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_ScrubTo_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaSession_ScrubTo_Params = MediaSession_ScrubTo_ParamsMojoType;
mojo.internal.Struct<MediaSession_ScrubTo_ParamsMojoType>(
    MediaSession_ScrubTo_ParamsSpec.$,
    'MediaSession_ScrubTo_Params',
    [
      mojo.internal.StructField<MediaSession_ScrubTo_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_EnterPictureInPicture_ParamsMojoType {
}


export type MediaSession_EnterPictureInPicture_Params = MediaSession_EnterPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaSession_EnterPictureInPicture_ParamsMojoType>(
    MediaSession_EnterPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_ExitPictureInPicture_ParamsMojoType {
}


export type MediaSession_ExitPictureInPicture_Params = MediaSession_ExitPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaSession_ExitPictureInPicture_ParamsMojoType>(
    MediaSession_ExitPictureInPicture_ParamsSpec.$,
    'MediaSession_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_SetAudioSinkId_ParamsMojoType {
  id: (string | null);
}


export type MediaSession_SetAudioSinkId_Params = MediaSession_SetAudioSinkId_ParamsMojoType;
mojo.internal.Struct<MediaSession_SetAudioSinkId_ParamsMojoType>(
    MediaSession_SetAudioSinkId_ParamsSpec.$,
    'MediaSession_SetAudioSinkId_Params',
    [
      mojo.internal.StructField<MediaSession_SetAudioSinkId_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_ToggleMicrophone_ParamsMojoType {
}


export type MediaSession_ToggleMicrophone_Params = MediaSession_ToggleMicrophone_ParamsMojoType;
mojo.internal.Struct<MediaSession_ToggleMicrophone_ParamsMojoType>(
    MediaSession_ToggleMicrophone_ParamsSpec.$,
    'MediaSession_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_ToggleCamera_ParamsMojoType {
}


export type MediaSession_ToggleCamera_Params = MediaSession_ToggleCamera_ParamsMojoType;
mojo.internal.Struct<MediaSession_ToggleCamera_ParamsMojoType>(
    MediaSession_ToggleCamera_ParamsSpec.$,
    'MediaSession_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_HangUp_ParamsMojoType {
}


export type MediaSession_HangUp_Params = MediaSession_HangUp_ParamsMojoType;
mojo.internal.Struct<MediaSession_HangUp_ParamsMojoType>(
    MediaSession_HangUp_ParamsSpec.$,
    'MediaSession_HangUp_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_Raise_ParamsMojoType {
}


export type MediaSession_Raise_Params = MediaSession_Raise_ParamsMojoType;
mojo.internal.Struct<MediaSession_Raise_ParamsMojoType>(
    MediaSession_Raise_ParamsSpec.$,
    'MediaSession_Raise_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_SetMute_ParamsMojoType {
  mute: boolean;
}


export type MediaSession_SetMute_Params = MediaSession_SetMute_ParamsMojoType;
mojo.internal.Struct<MediaSession_SetMute_ParamsMojoType>(
    MediaSession_SetMute_ParamsSpec.$,
    'MediaSession_SetMute_Params',
    [
      mojo.internal.StructField<MediaSession_SetMute_ParamsMojoType, boolean>(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaSession_RequestMediaRemoting_ParamsMojoType {
}


export type MediaSession_RequestMediaRemoting_Params = MediaSession_RequestMediaRemoting_ParamsMojoType;
mojo.internal.Struct<MediaSession_RequestMediaRemoting_ParamsMojoType>(
    MediaSession_RequestMediaRemoting_ParamsSpec.$,
    'MediaSession_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_PreviousSlide_ParamsMojoType {
}


export type MediaSession_PreviousSlide_Params = MediaSession_PreviousSlide_ParamsMojoType;
mojo.internal.Struct<MediaSession_PreviousSlide_ParamsMojoType>(
    MediaSession_PreviousSlide_ParamsSpec.$,
    'MediaSession_PreviousSlide_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_NextSlide_ParamsMojoType {
}


export type MediaSession_NextSlide_Params = MediaSession_NextSlide_ParamsMojoType;
mojo.internal.Struct<MediaSession_NextSlide_ParamsMojoType>(
    MediaSession_NextSlide_ParamsSpec.$,
    'MediaSession_NextSlide_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_EnterAutoPictureInPicture_ParamsMojoType {
}


export type MediaSession_EnterAutoPictureInPicture_Params = MediaSession_EnterAutoPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaSession_EnterAutoPictureInPicture_ParamsMojoType>(
    MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_GetVisibility_ParamsMojoType {
}


export type MediaSession_GetVisibility_Params = MediaSession_GetVisibility_ParamsMojoType;
mojo.internal.Struct<MediaSession_GetVisibility_ParamsMojoType>(
    MediaSession_GetVisibility_ParamsSpec.$,
    'MediaSession_GetVisibility_Params',
    [
    ],
    [[0, 8],]);





export interface MediaSession_GetVisibility_ResponseParamsMojoType {
  hasSufficientlyVisibleVideo: boolean;
}


export type MediaSession_GetVisibility_ResponseParams = MediaSession_GetVisibility_ResponseParamsMojoType;
mojo.internal.Struct<MediaSession_GetVisibility_ResponseParamsMojoType>(
    MediaSession_GetVisibility_ResponseParamsSpec.$,
    'MediaSession_GetVisibility_ResponseParams',
    [
      mojo.internal.StructField<MediaSession_GetVisibility_ResponseParamsMojoType, boolean>(
        'hasSufficientlyVisibleVideo', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



