// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_spinner_style.css.js";import{Authenticator}from"chrome://chrome-signin/gaia_auth_host/authenticator.js";import{WebUiListenerMixin}from"chrome://resources/cr_elements/web_ui_listener_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./inline_login_app.html.js";import{InlineLoginBrowserProxyImpl}from"./inline_login_browser_proxy.js";const InlineLoginAppElementBase=WebUiListenerMixin(PolymerElement);export class InlineLoginAppElement extends InlineLoginAppElementBase{static get is(){return"inline-login-app"}static get template(){return getTemplate()}static get properties(){return{loading_:{type:Boolean,value:true},verifyingAccount_:{type:Boolean,value:false},authenticator_:{type:Object,value:null}}}isLoginPrimaryAccount_=false;browserProxy_=InlineLoginBrowserProxyImpl.getInstance();ready(){super.ready();this.authenticator_=new Authenticator(this.$.signinFrame);this.addAuthenticatorListeners_();this.browserProxy_.initialize()}connectedCallback(){super.connectedCallback();this.addWebUiListener("load-authenticator",(data=>this.loadAuthenticator_(data)));this.addWebUiListener("send-lst-fetch-results",(arg=>this.sendLstFetchResults_(arg)));this.addWebUiListener("close-dialog",(()=>this.closeDialog_()))}addAuthenticatorListeners_(){assert(this.authenticator_);this.authenticator_.addEventListener("dropLink",(e=>this.onDropLink_(e)));this.authenticator_.addEventListener("newWindow",(e=>this.onNewWindow_(e)));this.authenticator_.addEventListener("ready",(()=>this.onAuthReady_()));this.authenticator_.addEventListener("resize",(e=>this.onResize_(e)));this.authenticator_.addEventListener("authCompleted",(e=>this.onAuthCompleted_(e)));this.authenticator_.addEventListener("showIncognito",(()=>this.onShowIncognito_()))}onDropLink_(e){window.location.href=e.detail}onNewWindow_(e){window.open(e.detail.targetUrl,"_blank");e.detail.window.discard()}onAuthReady_(){this.loading_=false;if(this.isLoginPrimaryAccount_){this.browserProxy_.recordAction("Signin_SigninPage_Shown")}this.browserProxy_.authenticatorReady()}onResize_(e){this.browserProxy_.switchToFullTab(e.detail)}onAuthCompleted_(e){this.verifyingAccount_=true;const credentials=e.detail;this.browserProxy_.completeLogin(credentials)}onShowIncognito_(){this.browserProxy_.showIncognito()}loadAuthenticator_(data){assert(this.authenticator_);this.authenticator_.load(data.authMode,data);this.loading_=true;this.isLoginPrimaryAccount_=data.isLoginPrimaryAccount;this.dispatchEvent(new CustomEvent("switch-view-notify-for-testing"))}sendLstFetchResults_(arg){this.browserProxy_.lstFetchResults(arg)}isSpinnerActive_(loading,verifyingAccount){return loading||verifyingAccount}closeDialog_(){this.browserProxy_.dialogClose()}setAuthenticatorForTest(authenticator){this.authenticator_=authenticator;this.addAuthenticatorListeners_()}}customElements.define(InlineLoginAppElement.is,InlineLoginAppElement);