import type { PageHandlerRemote } from 'chrome://resources/cr_components/history/history.mojom-webui.js';
import { PageCallbackRouter } from 'chrome://resources/cr_components/history/history.mojom-webui.js';
import type { ForeignSession } from './externs.js';
export type RemoveVisitsRequest = Array<{
    url: string;
    timestamps: number[];
}>;
/**
 * @fileoverview Defines a singleton object, history.BrowserService, which
 * provides access to chrome.send APIs.
 */
export interface BrowserService {
    handler: PageHandlerRemote;
    callbackRouter: PageCallbackRouter;
    getForeignSessions(): Promise<ForeignSession[]>;
    openForeignSessionAllTabs(sessionTag: string): void;
    openForeignSessionTab(sessionTag: string, tabId: number, e: MouseEvent): void;
    deleteForeignSession(sessionTag: string): void;
    recordHistogram(histogram: string, value: number, max: number): void;
    recordBooleanHistogram(histogram: string, value: boolean): void;
    recordAction(action: string): void;
    recordTime(histogram: string, time: number): void;
    recordLongTime(histogram: string, time: number): void;
    recordSigninPendingOffered(): void;
    navigateToUrl(url: string, target: string, e: MouseEvent): void;
    otherDevicesInitialized(): void;
    startTurnOnSyncFlow(): void;
}
export declare class BrowserServiceImpl implements BrowserService {
    handler: PageHandlerRemote;
    callbackRouter: PageCallbackRouter;
    constructor(handler: PageHandlerRemote, callbackRouter: PageCallbackRouter);
    static getInstance(): BrowserService;
    static setInstance(obj: BrowserService): void;
    getForeignSessions(): Promise<any>;
    openForeignSessionAllTabs(sessionTag: string): void;
    openForeignSessionTab(sessionTag: string, tabId: number, e: MouseEvent): void;
    deleteForeignSession(sessionTag: string): void;
    recordHistogram(histogram: string, value: number, max: number): void;
    recordBooleanHistogram(histogram: string, value: boolean): void;
    /**
     * Record an action in UMA.
     * @param action The name of the action to be logged.
     */
    recordAction(action: string): void;
    recordTime(histogram: string, time: number): void;
    recordLongTime(histogram: string, time: number): void;
    recordSigninPendingOffered(): void;
    navigateToUrl(url: string, target: string, e: MouseEvent): void;
    otherDevicesInitialized(): void;
    startTurnOnSyncFlow(): void;
}
