import type { BrowserProxyImpl } from './browser_proxy.js';
import { PanelStateKind, ProfileReadyState, WebUiState } from './glic.mojom-webui.js';
import type { ApiHostEmbedder } from './glic_api_impl/glic_api_host.js';
import { WebClientState } from './glic_api_impl/glic_api_host.js';
import type { PageType, WebviewDelegate } from './webview.js';
interface StateDescriptor {
    onEnter?: () => void;
    onExit?: () => void;
    reloadOnOpen?: boolean;
}
export declare enum WebClientUnresponsiveState {
    ENTERED_FROM_WEBVIEW_EVENT = 0,
    ENTERED_FROM_CUSTOM_HEARTBEAT = 1,
    ALREADY_ON_FROM_WEBVIEW_EVENT = 2,
    ALREADY_ON_FROM_CUSTOM_HEARTBEAT = 3,
    EXITED = 4,
    MAX_VALUE = 4
}
export declare enum LoadingStage {
    NOT_LOADING = 0,
    AWAITING_PROFILE_READY = 1,
    AWAITING_COOKIE_SYNC = 2,
    LOADING_WEB_CLIENT = 3,
    AWAITING_NOTIFY_PANEL_WILL_OPEN = 4,
    MAX_VALUE = 4
}
export declare class GlicAppController implements WebviewDelegate, ApiHostEmbedder {
    loadingTimer: number | undefined;
    private simulateNoConnection;
    private guestResizeEnabled;
    private defaultWidth;
    private defaultHeight;
    private lastWidth;
    private lastHeight;
    private webview?;
    private webviewPersistentState;
    private profileReadyState;
    private profileReadyInitialState;
    private enteredUnresponsiveTimestampMs?;
    private loadingStage;
    private loadingStageStartTimestampMs?;
    private panelStateKind;
    state: WebUiState | undefined;
    private earliestLoadingDismissTime;
    browserProxy: BrowserProxyImpl;
    constructor(browserProxy: BrowserProxyImpl);
    webviewUnresponsive(): void;
    trackUnresponsiveState(newState: WebClientUnresponsiveState): void;
    webviewError(reason: string): void;
    webviewPageCommit(type: PageType): void;
    webviewDeniedByAdmin(): void;
    private setState;
    private stateDescriptor;
    readonly states: Map<WebUiState, StateDescriptor>;
    private cancelTimeout;
    private beginLoad;
    private trackLoadingStageStart;
    private trackLoadingStageEnd;
    private getLoadingStage;
    private load;
    private showLoading;
    private holdLoading;
    private finishLoading;
    private showPanel;
    private destroyWebview;
    private online;
    private offline;
    private installDebugButton;
    onGuestResizeRequest(request: {
        width: number;
        height: number;
    }): void;
    enableDragResize(enabled: boolean): void;
    webClientReady(): void;
    webClientStateChanged(state: WebClientState): void;
    showDebug(): void;
    close(): void;
    reload(): void;
    private openProfilePicker;
    private signIn;
    updatePageState(panelStateKind: PanelStateKind): void;
    intentToShow(): void;
    setProfileReadyState(state: ProfileReadyState): void;
    openDisabledByAdminLink(): void;
    isOnline(): boolean;
}
export {};
