import type { AllRequestTypes, AllRequestTypesWithoutReturn, RequestRequestType, RequestResponseType, TransferableException } from './request_types.js';
export declare interface RequestMessage {
    senderId: string;
    glicRequest: true;
    type: string;
    requestId?: number;
    requestPayload: any;
}
declare interface ResponseMessage {
    senderId: string;
    type: string;
    responseId: number;
    responsePayload?: any;
    exception?: TransferableException;
}
declare interface PostMessageSender {
    postMessage(message: any, targetOrigin: string, transfer?: Transferable[]): void;
}
export declare function newSenderId(): string;
export declare class ResponseExtras {
    transfers: Transferable[];
    addTransfer(...transfers: Transferable[]): void;
}
declare class MessageLogger {
    protected prefix: string;
    loggingEnabled: boolean;
    loggingPrefix: string;
    constructor(senderId: string, prefix: string);
    setLoggingEnabled(v: boolean): void;
    shouldLogMessage(requestType: string): boolean;
    maybeLogMessage(requestType: string, message: string, payload: any): void;
}
export declare class PostMessageRequestSender extends MessageLogger {
    private messageSender;
    private remoteOrigin;
    private senderId;
    requestId: number;
    responseHandlers: Map<number, (response: ResponseMessage) => void>;
    onDestroy: () => void;
    constructor(messageSender: PostMessageSender, remoteOrigin: string, senderId: string, logPrefix: string);
    destroy(): void;
    private onMessage;
    requestWithResponse<T extends keyof AllRequestTypes>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): Promise<RequestResponseType<T>>;
    requestNoResponse<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
}
/** Interface for handling postMessage requests. */
export interface PostMessageRequestHandler {
    /**
     * Handles a 'raw' request.
     * If this throws an exception, it will be sent back in the response. This
     * supports built-in error types like Error, as well as ErrorWithReasonImpl.
     *
     * @param type The request type, from request_types.ts.
     * @param payload The payload, from request_types.ts.
     * @returns The response to be returned to the client.
     */
    handleRawRequest(type: string, payload: any, extras: ResponseExtras): Promise<{
        /** The payload of the response. */
        payload: any;
    } | undefined>;
    /** Called when each request is received. */
    onRequestReceived(type: string): void;
    /** Called when a request handler throws an exception. */
    onRequestHandlerException(type: string): void;
    /**
     * Called when a request response is sent (will not be called if
     * `onRequestHandlerException()` is called.).
     */
    onRequestCompleted(type: string): void;
}
export declare class PostMessageRequestReceiver extends MessageLogger {
    private embeddedOrigin;
    private postMessageSender;
    private handler;
    private onDestroy;
    constructor(embeddedOrigin: string, senderId: string, postMessageSender: PostMessageSender, handler: PostMessageRequestHandler, logPrefix: string);
    destroy(): void;
    onMessage(event: MessageEvent): Promise<void>;
}
export {};
