import type { BrowserProxy } from '../browser_proxy.js';
import type { CaptureRegionObserver, CaptureRegionResult as CaptureRegionResultMojo, PinCandidate as PinCandidateMojo, PinCandidatesObserver, WebClientHandlerInterface, WebClientInitialState } from '../glic.mojom-webui.js';
import { CaptureRegionErrorReason as CaptureRegionErrorReasonMojo, CaptureRegionObserverReceiver, PinCandidatesObserverReceiver } from '../glic.mojom-webui.js';
import type { GetPinCandidatesOptions } from '../glic_api/glic_api.js';
import type { ObservableValueReadOnly } from '../observable.js';
import type { PostMessageRequestHandler } from './post_message_transport.js';
import { PostMessageRequestSender, ResponseExtras } from './post_message_transport.js';
import type { AllRequestTypesWithoutReturn, AllRequestTypesWithReturn, RequestRequestType, RequestResponseType, WebClientRequestTypes } from './request_types.js';
export declare enum WebClientState {
    UNINITIALIZED = 0,
    RESPONSIVE = 1,
    UNRESPONSIVE = 2,
    ERROR = 3
}
declare enum PanelOpenState {
    OPEN = 0,
    CLOSED = 1
}
export declare enum DetailedWebClientState {
    BOOTSTRAP_PENDING = 0,
    WEB_CLIENT_NOT_CREATED = 1,
    WEB_CLIENT_INITIALIZE_FAILED = 2,
    WEB_CLIENT_NOT_INITIALIZED = 3,
    TEMPORARY_UNRESPONSIVE = 4,
    PERMANENT_UNRESPONSIVE = 5,
    RESPONSIVE = 6,
    RESPONSIVE_INACTIVE = 7,
    UNRESPONSIVE_INACTIVE = 8,
    MOJO_PIPE_CLOSED_UNEXPECTEDLY = 9,
    MAX_VALUE = 9
}
export interface ApiHostEmbedder {
    onGuestResizeRequest(size: {
        width: number;
        height: number;
    }): void;
    enableDragResize(enabled: boolean): void;
    webClientReady(): void;
}
type IsGatedRequest<T extends keyof WebClientRequestTypes> = 'backgroundAllowed' extends keyof WebClientRequestTypes[T] ? false : true;
type UngatedWebClientRequestTypes = {
    [Property in keyof WebClientRequestTypes as IsGatedRequest<Property> extends true ? never : Property]: true;
};
declare class CaptureRegionObserverImpl implements CaptureRegionObserver {
    private sender;
    private handler;
    observationId: number;
    receiver?: CaptureRegionObserverReceiver;
    constructor(sender: GatedSender, handler: WebClientHandlerInterface, observationId: number);
    destroy(): void;
    private connectToSource;
    onUpdate(result: CaptureRegionResultMojo | null, reason: CaptureRegionErrorReasonMojo | null): void;
}
declare class PinCandidatesObserverImpl implements PinCandidatesObserver {
    private sender;
    private handler;
    private options;
    observationId: number;
    receiver?: PinCandidatesObserverReceiver;
    constructor(sender: GatedSender, handler: WebClientHandlerInterface, options: GetPinCandidatesOptions, observationId: number);
    disconnectFromSource(): void;
    connectToSource(): void;
    onPinCandidatesChanged(candidates: PinCandidateMojo[]): void;
}
/**
 * The host side of the Glic API.
 *
 * Its primary job is to route calls between the client (over postMessage) and
 * the browser (over Mojo).
 */
export declare class GlicApiHost implements PostMessageRequestHandler {
    private browserProxy;
    private windowProxy;
    private embeddedOrigin;
    private senderId;
    private messageHandler;
    private readonly postMessageReceiver;
    sender: GatedSender;
    private enableApiActivationGating;
    panelIsActive: boolean;
    private handler;
    private bootstrapPingIntervalId;
    private webClientErrorTimer;
    private webClientState;
    private waitingOnPanelWillOpenValue;
    private clientActiveObs;
    private panelOpenState;
    private instanceIsActive;
    private hasShownDebuggerAttachedWarning;
    private loggingEnabled;
    detailedWebClientState: DetailedWebClientState;
    pinCandidatesObserver?: PinCandidatesObserverImpl;
    captureRegionObserver?: CaptureRegionObserverImpl;
    constructor(browserProxy: BrowserProxy, windowProxy: WindowProxy, embeddedOrigin: string, embedder: ApiHostEmbedder);
    destroy(): void;
    setInitialState(initialState: WebClientInitialState): void;
    updateSenderActive(): void;
    shouldGateRequests(): boolean;
    contentLoaded(): void;
    waitingOnPanelWillOpen(): boolean;
    setWaitingOnPanelWillOpen(value: boolean): void;
    panelOpenStateChanged(state: PanelOpenState): void;
    setInstanceIsActive(instanceIsActive: boolean): void;
    private isClientActive;
    webClientInitialized(): void;
    webClientInitializeFailed(): void;
    setWebClientState(state: WebClientState): void;
    getWebClientState(): ObservableValueReadOnly<WebClientState>;
    getDetailedWebClientState(): DetailedWebClientState;
    bootstrapPing(): void;
    stopBootstrapPing(): void;
    responsiveCheckLoop(): Promise<void>;
    private shouldAllowUnresponsiveClient;
    startWebClientErrorTimer(): void;
    openLinkInPopup(url: string, initialWidth: number, initialHeight: number): void;
    openLinkInNewTab(url: string): Promise<void>;
    shouldAllowMediaPermissionRequest(): Promise<boolean>;
    shouldAllowGeolocationPermissionRequest(): Promise<boolean>;
    handleRawRequest(type: string, payload: any, extras: ResponseExtras): Promise<{
        payload: any;
    } | undefined>;
    onRequestReceived(type: string): void;
    onRequestHandlerException(type: string): void;
    onRequestCompleted(type: string): void;
    reportRequestCountEvent(requestType: string, event: GlicRequestEvent): void;
}
export declare class GatedSender {
    private sender;
    private sequenceNumber;
    private messageQueue;
    private keyedMessages;
    private shouldGateRequests;
    constructor(sender: PostMessageRequestSender);
    isGating(): boolean;
    getRawSender(): PostMessageRequestSender;
    destroy(): void;
    setGating(shouldGateRequests: boolean): void;
    sendWhenActive<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    sendIfActiveOrDrop<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    sendLatestWhenActive<T extends keyof AllRequestTypesWithoutReturn>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[], additionalKey?: string): void;
    requestNoResponse<T extends keyof Omit<UngatedWebClientRequestTypes, keyof AllRequestTypesWithReturn>>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): void;
    requestWithResponse<T extends keyof UngatedWebClientRequestTypes>(requestType: T, request: RequestRequestType<T>, transfer?: Transferable[]): Promise<RequestResponseType<T>>;
}
declare enum GlicRequestEvent {
    REQUEST_RECEIVED = 0,
    RESPONSE_SENT = 1,
    REQUEST_HANDLER_EXCEPTION = 2,
    REQUEST_RECEIVED_WHILE_HIDDEN = 3,
    MAX_VALUE = 3
}
export {};
