import { FreWebUiState } from './glic_fre.mojom-webui.js';
export declare enum FreResultType {
    ACCEPT = 0,
    DISMISS = 1,
    REJECT = 2
}
export interface FreResult {
    type: FreResultType;
}
interface FreControllerOptions {
    partitionString?: string;
    shouldSizeForDialog?: boolean;
    onClose?: () => void;
}
interface StateDescriptor {
    onEnter?: () => void;
    onExit?: () => void;
}
export declare class FreAppController {
    state: FreWebUiState;
    loadingTimer: number | undefined;
    private webview;
    private webviewEventTracker;
    private glicRequestHeaderInjector;
    private freHandler;
    private earliestLoadingDismissTime;
    private useReloadTimeout;
    private freContainer;
    private webviewContainer;
    private partitionString;
    private shouldSizeForDialog;
    private onCloseCallback?;
    constructor(options?: FreControllerOptions);
    onLoadCommit(e: any): void;
    onContentLoad(): void;
    onNewWindow(e: any): void;
    online(): void;
    offline(): void;
    reload(): void;
    private showPanel;
    setState(newState: FreWebUiState): void;
    readonly states: Map<FreWebUiState, StateDescriptor>;
    cancelTimeout(): void;
    beginLoading(): Promise<void>;
    showLoading(): void;
    holdLoading(): void;
    finishLoading(): void;
    onSizeChanged(e: any): void;
    private createWebview;
    private reasonStringToEnum;
    private onLoadAbort;
    private panelIdToEnum;
    destroyWebview(): void;
    private dismissFre;
    private acceptFre;
    private rejectFre;
}
export {};
