// chrome/browser/ui/webui/downloads/downloads.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const DangerTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DangerType {

  MIN_VALUE = 0,
  MAX_VALUE = 17,
  kNoApplicableDangerType = 0,
  kDangerousFile = 1,
  kDangerousUrl = 2,
  kDangerousContent = 3,
  kCookieTheft = 4,
  kUncommonContent = 5,
  kDangerousHost = 6,
  kPotentiallyUnwanted = 7,
  kAsyncScanning = 8,
  kAsyncLocalPasswordScanning = 9,
  kBlockedPasswordProtected = 10,
  kBlockedTooLarge = 11,
  kSensitiveContentWarning = 12,
  kSensitiveContentBlock = 13,
  kDeepScannedFailed = 14,
  kDeepScannedSafe = 15,
  kDeepScannedOpenedDangerous = 16,
  kBlockedScanFailed = 17,
}

export const TailoredWarningTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum TailoredWarningType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNoApplicableTailoredWarningType = 0,
  kCookieTheft = 1,
  kSuspiciousArchive = 2,
}

export const StateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum State {

  MIN_VALUE = 0,
  MAX_VALUE = 9,
  kInProgress = 0,
  kCancelled = 1,
  kComplete = 2,
  kPaused = 3,
  kDangerous = 4,
  kInterrupted = 5,
  kInsecure = 6,
  kAsyncScanning = 7,
  kPromptForScanning = 8,
  kPromptForLocalPasswordScanning = 9,
}

export const SafeBrowsingStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SafeBrowsingState {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kNoSafeBrowsing = 0,
  kStandardProtection = 1,
  kEnhancedProtection = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'downloads.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "downloads.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'downloads.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getDownloads(searchTerms: string[]): void;
  openFileRequiringGesture(id: string): void;
  drag(id: string): void;
  saveSuspiciousRequiringGesture(id: string): void;
  recordOpenBypassWarningDialog(id: string): void;
  saveDangerousFromDialogRequiringGesture(id: string): void;
  recordCancelBypassWarningDialog(id: string): void;
  discardDangerous(id: string): void;
  retryDownload(id: string): void;
  show(id: string): void;
  pause(id: string): void;
  resume(id: string): void;
  remove(id: string): void;
  undo(): void;
  cancel(id: string): void;
  clearAll(): void;
  openDownloadsFolderRequiringGesture(): void;
  openEsbSettings(): void;
  logEsbPromotionRowViewed(): void;
  openDuringScanningRequiringGesture(id: string): void;
  reviewDangerousRequiringGesture(id: string): void;
  deepScan(id: string): void;
  bypassDeepScanRequiringGesture(id: string): void;
  isEligibleForEsbPromo(): Promise<{
        result: boolean, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getDownloads(
      searchTerms: string[]): void {
    this.proxy.sendMessage(
        0,
        PageHandler_GetDownloads_ParamsSpec.$,
        null,
        [
          searchTerms
        ],
        false);
  }

  openFileRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        1,
        PageHandler_OpenFileRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  drag(
      id: string): void {
    this.proxy.sendMessage(
        2,
        PageHandler_Drag_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  saveSuspiciousRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        3,
        PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  recordOpenBypassWarningDialog(
      id: string): void {
    this.proxy.sendMessage(
        4,
        PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  saveDangerousFromDialogRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        5,
        PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  recordCancelBypassWarningDialog(
      id: string): void {
    this.proxy.sendMessage(
        6,
        PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  discardDangerous(
      id: string): void {
    this.proxy.sendMessage(
        7,
        PageHandler_DiscardDangerous_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  retryDownload(
      id: string): void {
    this.proxy.sendMessage(
        8,
        PageHandler_RetryDownload_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  show(
      id: string): void {
    this.proxy.sendMessage(
        9,
        PageHandler_Show_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  pause(
      id: string): void {
    this.proxy.sendMessage(
        10,
        PageHandler_Pause_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  resume(
      id: string): void {
    this.proxy.sendMessage(
        11,
        PageHandler_Resume_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  remove(
      id: string): void {
    this.proxy.sendMessage(
        12,
        PageHandler_Remove_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  undo(): void {
    this.proxy.sendMessage(
        13,
        PageHandler_Undo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  cancel(
      id: string): void {
    this.proxy.sendMessage(
        14,
        PageHandler_Cancel_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  clearAll(): void {
    this.proxy.sendMessage(
        15,
        PageHandler_ClearAll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openDownloadsFolderRequiringGesture(): void {
    this.proxy.sendMessage(
        16,
        PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openEsbSettings(): void {
    this.proxy.sendMessage(
        17,
        PageHandler_OpenEsbSettings_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  logEsbPromotionRowViewed(): void {
    this.proxy.sendMessage(
        18,
        PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openDuringScanningRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        19,
        PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  reviewDangerousRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        20,
        PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  deepScan(
      id: string): void {
    this.proxy.sendMessage(
        21,
        PageHandler_DeepScan_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  bypassDeepScanRequiringGesture(
      id: string): void {
    this.proxy.sendMessage(
        22,
        PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  isEligibleForEsbPromo(): Promise<{
        result: boolean, }> {
    return this.proxy.sendMessage(
        23,
        PageHandler_IsEligibleForEsbPromo_ParamsSpec.$,
        PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetDownloads_ParamsSpec.$,
        null,
        impl.getDownloads.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_OpenFileRequiringGesture_ParamsSpec.$,
        null,
        impl.openFileRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_Drag_ParamsSpec.$,
        null,
        impl.drag.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$,
        null,
        impl.saveSuspiciousRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$,
        null,
        impl.recordOpenBypassWarningDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$,
        null,
        impl.saveDangerousFromDialogRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$,
        null,
        impl.recordCancelBypassWarningDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_DiscardDangerous_ParamsSpec.$,
        null,
        impl.discardDangerous.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_RetryDownload_ParamsSpec.$,
        null,
        impl.retryDownload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_Show_ParamsSpec.$,
        null,
        impl.show.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_Remove_ParamsSpec.$,
        null,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_Undo_ParamsSpec.$,
        null,
        impl.undo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_ClearAll_ParamsSpec.$,
        null,
        impl.clearAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$,
        null,
        impl.openDownloadsFolderRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_OpenEsbSettings_ParamsSpec.$,
        null,
        impl.openEsbSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$,
        null,
        impl.logEsbPromotionRowViewed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$,
        null,
        impl.openDuringScanningRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$,
        null,
        impl.reviewDangerousRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        PageHandler_DeepScan_ParamsSpec.$,
        null,
        impl.deepScan.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$,
        null,
        impl.bypassDeepScanRequiringGesture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        PageHandler_IsEligibleForEsbPromo_ParamsSpec.$,
        PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$,
        impl.isEligibleForEsbPromo.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "downloads.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getDownloads: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openFileRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  drag: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  saveSuspiciousRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordOpenBypassWarningDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  saveDangerousFromDialogRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordCancelBypassWarningDialog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  discardDangerous: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  retryDownload: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  show: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  pause: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resume: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  remove: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  cancel: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearAll: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openDownloadsFolderRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openEsbSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  logEsbPromotionRowViewed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openDuringScanningRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  reviewDangerousRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deepScan: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  bypassDeepScanRequiringGesture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isEligibleForEsbPromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getDownloads =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetDownloads_ParamsSpec.$,
        null,
        this.getDownloads.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openFileRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_OpenFileRequiringGesture_ParamsSpec.$,
        null,
        this.openFileRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.drag =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_Drag_ParamsSpec.$,
        null,
        this.drag.createReceiverHandler(false /* expectsResponse */),
        false);
    this.saveSuspiciousRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$,
        null,
        this.saveSuspiciousRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordOpenBypassWarningDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$,
        null,
        this.recordOpenBypassWarningDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.saveDangerousFromDialogRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$,
        null,
        this.saveDangerousFromDialogRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordCancelBypassWarningDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$,
        null,
        this.recordCancelBypassWarningDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.discardDangerous =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_DiscardDangerous_ParamsSpec.$,
        null,
        this.discardDangerous.createReceiverHandler(false /* expectsResponse */),
        false);
    this.retryDownload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_RetryDownload_ParamsSpec.$,
        null,
        this.retryDownload.createReceiverHandler(false /* expectsResponse */),
        false);
    this.show =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_Show_ParamsSpec.$,
        null,
        this.show.createReceiverHandler(false /* expectsResponse */),
        false);
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_Remove_ParamsSpec.$,
        null,
        this.remove.createReceiverHandler(false /* expectsResponse */),
        false);
    this.undo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_Undo_ParamsSpec.$,
        null,
        this.undo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_ClearAll_ParamsSpec.$,
        null,
        this.clearAll.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openDownloadsFolderRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$,
        null,
        this.openDownloadsFolderRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openEsbSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_OpenEsbSettings_ParamsSpec.$,
        null,
        this.openEsbSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.logEsbPromotionRowViewed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$,
        null,
        this.logEsbPromotionRowViewed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openDuringScanningRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$,
        null,
        this.openDuringScanningRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.reviewDangerousRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$,
        null,
        this.reviewDangerousRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.deepScan =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        PageHandler_DeepScan_ParamsSpec.$,
        null,
        this.deepScan.createReceiverHandler(false /* expectsResponse */),
        false);
    this.bypassDeepScanRequiringGesture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$,
        null,
        this.bypassDeepScanRequiringGesture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.isEligibleForEsbPromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        PageHandler_IsEligibleForEsbPromo_ParamsSpec.$,
        PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$,
        this.isEligibleForEsbPromo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'downloads.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  removeItem(index: number): void;
  updateItem(index: number, data: Data): void;
  insertItems(index: number, items: Data[]): void;
  clearAll(): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  removeItem(
      index: number): void {
    this.proxy.sendMessage(
        0,
        Page_RemoveItem_ParamsSpec.$,
        null,
        [
          index
        ],
        false);
  }

  updateItem(
      index: number,
      data: Data): void {
    this.proxy.sendMessage(
        1,
        Page_UpdateItem_ParamsSpec.$,
        null,
        [
          index,
          data
        ],
        false);
  }

  insertItems(
      index: number,
      items: Data[]): void {
    this.proxy.sendMessage(
        2,
        Page_InsertItems_ParamsSpec.$,
        null,
        [
          index,
          items
        ],
        false);
  }

  clearAll(): void {
    this.proxy.sendMessage(
        3,
        Page_ClearAll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_RemoveItem_ParamsSpec.$,
        null,
        impl.removeItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_UpdateItem_ParamsSpec.$,
        null,
        impl.updateItem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_InsertItems_ParamsSpec.$,
        null,
        impl.insertItems.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_ClearAll_ParamsSpec.$,
        null,
        impl.clearAll.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "downloads.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  removeItem: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateItem: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  insertItems: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  clearAll: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.removeItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_RemoveItem_ParamsSpec.$,
        null,
        this.removeItem.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateItem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_UpdateItem_ParamsSpec.$,
        null,
        this.updateItem.createReceiverHandler(false /* expectsResponse */),
        false);
    this.insertItems =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_InsertItems_ParamsSpec.$,
        null,
        this.insertItems.createReceiverHandler(false /* expectsResponse */),
        false);
    this.clearAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_ClearAll_ParamsSpec.$,
        null,
        this.clearAll.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const DataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDownloads_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenFileRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Drag_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordOpenBypassWarningDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordCancelBypassWarningDialog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DiscardDangerous_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RetryDownload_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Show_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Pause_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Resume_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Remove_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Undo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Cancel_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClearAll_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenEsbSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LogEsbPromotionRowViewed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReviewDangerousRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_DeepScan_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_BypassDeepScanRequiringGesture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsEligibleForEsbPromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_RemoveItem_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_UpdateItem_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_InsertItems_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ClearAll_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface DataMojoType {
  fileExternallyRemoved: boolean;
  isDangerous: boolean;
  isInsecure: boolean;
  isReviewable: boolean;
  otr: boolean;
  resume: boolean;
  retry: boolean;
  hasSafeBrowsingVerdict: boolean;
  percent: number;
  started: number;
  dangerType: DangerType;
  total: bigint;
  byExtId: string;
  byExtName: string;
  tailoredWarningType: TailoredWarningType;
  state: State;
  dateString: string;
  fileName: string;
  filePath: string;
  fileUrl: string;
  id: string;
  lastReasonText: string;
  progressStatusText: string;
  showInFolderText: string;
  sinceString: string;
  displayInitiatorOrigin: mojoBase_mojom_String16;
  url: (url_mojom_Url | null);
  displayUrl: mojoBase_mojom_String16;
  safeBrowsingState: SafeBrowsingState;
}


export type Data = DataMojoType;
mojo.internal.Struct<DataMojoType>(
    DataSpec.$,
    'Data',
    [
      mojo.internal.StructField<DataMojoType, boolean>(
        'fileExternallyRemoved', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'isDangerous', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'isInsecure', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'isReviewable', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'otr', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'resume', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'retry', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, number>(
        'percent', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, number>(
        'started', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, bigint>(
        'total', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'byExtId', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'byExtName', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, DangerType>(
        'dangerType', 12,
        0,
        DangerTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, TailoredWarningType>(
        'tailoredWarningType', 40,
        0,
        TailoredWarningTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'dateString', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'fileName', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'filePath', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'fileUrl', 72,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'id', 80,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'lastReasonText', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'progressStatusText', 96,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'showInFolderText', 104,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, string>(
        'sinceString', 112,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, State>(
        'state', 44,
        0,
        StateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, mojoBase_mojom_String16>(
        'displayInitiatorOrigin', 120,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, url_mojom_Url>(
        'url', 128,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, mojoBase_mojom_String16>(
        'displayUrl', 136,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, SafeBrowsingState>(
        'safeBrowsingState', 144,
        0,
        SafeBrowsingStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DataMojoType, boolean>(
        'hasSafeBrowsingVerdict', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 160],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetDownloads_ParamsMojoType {
  searchTerms: string[];
}


export type PageHandler_GetDownloads_Params = PageHandler_GetDownloads_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDownloads_ParamsMojoType>(
    PageHandler_GetDownloads_ParamsSpec.$,
    'PageHandler_GetDownloads_Params',
    [
      mojo.internal.StructField<PageHandler_GetDownloads_ParamsMojoType, string[]>(
        'searchTerms', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenFileRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_OpenFileRequiringGesture_Params = PageHandler_OpenFileRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenFileRequiringGesture_ParamsMojoType>(
    PageHandler_OpenFileRequiringGesture_ParamsSpec.$,
    'PageHandler_OpenFileRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_OpenFileRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Drag_ParamsMojoType {
  id: string;
}


export type PageHandler_Drag_Params = PageHandler_Drag_ParamsMojoType;
mojo.internal.Struct<PageHandler_Drag_ParamsMojoType>(
    PageHandler_Drag_ParamsSpec.$,
    'PageHandler_Drag_Params',
    [
      mojo.internal.StructField<PageHandler_Drag_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SaveSuspiciousRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_SaveSuspiciousRequiringGesture_Params = PageHandler_SaveSuspiciousRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_SaveSuspiciousRequiringGesture_ParamsMojoType>(
    PageHandler_SaveSuspiciousRequiringGesture_ParamsSpec.$,
    'PageHandler_SaveSuspiciousRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_SaveSuspiciousRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordOpenBypassWarningDialog_ParamsMojoType {
  id: string;
}


export type PageHandler_RecordOpenBypassWarningDialog_Params = PageHandler_RecordOpenBypassWarningDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordOpenBypassWarningDialog_ParamsMojoType>(
    PageHandler_RecordOpenBypassWarningDialog_ParamsSpec.$,
    'PageHandler_RecordOpenBypassWarningDialog_Params',
    [
      mojo.internal.StructField<PageHandler_RecordOpenBypassWarningDialog_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_SaveDangerousFromDialogRequiringGesture_Params = PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsMojoType>(
    PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsSpec.$,
    'PageHandler_SaveDangerousFromDialogRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_SaveDangerousFromDialogRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordCancelBypassWarningDialog_ParamsMojoType {
  id: string;
}


export type PageHandler_RecordCancelBypassWarningDialog_Params = PageHandler_RecordCancelBypassWarningDialog_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordCancelBypassWarningDialog_ParamsMojoType>(
    PageHandler_RecordCancelBypassWarningDialog_ParamsSpec.$,
    'PageHandler_RecordCancelBypassWarningDialog_Params',
    [
      mojo.internal.StructField<PageHandler_RecordCancelBypassWarningDialog_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DiscardDangerous_ParamsMojoType {
  id: string;
}


export type PageHandler_DiscardDangerous_Params = PageHandler_DiscardDangerous_ParamsMojoType;
mojo.internal.Struct<PageHandler_DiscardDangerous_ParamsMojoType>(
    PageHandler_DiscardDangerous_ParamsSpec.$,
    'PageHandler_DiscardDangerous_Params',
    [
      mojo.internal.StructField<PageHandler_DiscardDangerous_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RetryDownload_ParamsMojoType {
  id: string;
}


export type PageHandler_RetryDownload_Params = PageHandler_RetryDownload_ParamsMojoType;
mojo.internal.Struct<PageHandler_RetryDownload_ParamsMojoType>(
    PageHandler_RetryDownload_ParamsSpec.$,
    'PageHandler_RetryDownload_Params',
    [
      mojo.internal.StructField<PageHandler_RetryDownload_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Show_ParamsMojoType {
  id: string;
}


export type PageHandler_Show_Params = PageHandler_Show_ParamsMojoType;
mojo.internal.Struct<PageHandler_Show_ParamsMojoType>(
    PageHandler_Show_ParamsSpec.$,
    'PageHandler_Show_Params',
    [
      mojo.internal.StructField<PageHandler_Show_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Pause_ParamsMojoType {
  id: string;
}


export type PageHandler_Pause_Params = PageHandler_Pause_ParamsMojoType;
mojo.internal.Struct<PageHandler_Pause_ParamsMojoType>(
    PageHandler_Pause_ParamsSpec.$,
    'PageHandler_Pause_Params',
    [
      mojo.internal.StructField<PageHandler_Pause_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Resume_ParamsMojoType {
  id: string;
}


export type PageHandler_Resume_Params = PageHandler_Resume_ParamsMojoType;
mojo.internal.Struct<PageHandler_Resume_ParamsMojoType>(
    PageHandler_Resume_ParamsSpec.$,
    'PageHandler_Resume_Params',
    [
      mojo.internal.StructField<PageHandler_Resume_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Remove_ParamsMojoType {
  id: string;
}


export type PageHandler_Remove_Params = PageHandler_Remove_ParamsMojoType;
mojo.internal.Struct<PageHandler_Remove_ParamsMojoType>(
    PageHandler_Remove_ParamsSpec.$,
    'PageHandler_Remove_Params',
    [
      mojo.internal.StructField<PageHandler_Remove_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Undo_ParamsMojoType {
}


export type PageHandler_Undo_Params = PageHandler_Undo_ParamsMojoType;
mojo.internal.Struct<PageHandler_Undo_ParamsMojoType>(
    PageHandler_Undo_ParamsSpec.$,
    'PageHandler_Undo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_Cancel_ParamsMojoType {
  id: string;
}


export type PageHandler_Cancel_Params = PageHandler_Cancel_ParamsMojoType;
mojo.internal.Struct<PageHandler_Cancel_ParamsMojoType>(
    PageHandler_Cancel_ParamsSpec.$,
    'PageHandler_Cancel_Params',
    [
      mojo.internal.StructField<PageHandler_Cancel_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ClearAll_ParamsMojoType {
}


export type PageHandler_ClearAll_Params = PageHandler_ClearAll_ParamsMojoType;
mojo.internal.Struct<PageHandler_ClearAll_ParamsMojoType>(
    PageHandler_ClearAll_ParamsSpec.$,
    'PageHandler_ClearAll_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenDownloadsFolderRequiringGesture_ParamsMojoType {
}


export type PageHandler_OpenDownloadsFolderRequiringGesture_Params = PageHandler_OpenDownloadsFolderRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenDownloadsFolderRequiringGesture_ParamsMojoType>(
    PageHandler_OpenDownloadsFolderRequiringGesture_ParamsSpec.$,
    'PageHandler_OpenDownloadsFolderRequiringGesture_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenEsbSettings_ParamsMojoType {
}


export type PageHandler_OpenEsbSettings_Params = PageHandler_OpenEsbSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenEsbSettings_ParamsMojoType>(
    PageHandler_OpenEsbSettings_ParamsSpec.$,
    'PageHandler_OpenEsbSettings_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_LogEsbPromotionRowViewed_ParamsMojoType {
}


export type PageHandler_LogEsbPromotionRowViewed_Params = PageHandler_LogEsbPromotionRowViewed_ParamsMojoType;
mojo.internal.Struct<PageHandler_LogEsbPromotionRowViewed_ParamsMojoType>(
    PageHandler_LogEsbPromotionRowViewed_ParamsSpec.$,
    'PageHandler_LogEsbPromotionRowViewed_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenDuringScanningRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_OpenDuringScanningRequiringGesture_Params = PageHandler_OpenDuringScanningRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenDuringScanningRequiringGesture_ParamsMojoType>(
    PageHandler_OpenDuringScanningRequiringGesture_ParamsSpec.$,
    'PageHandler_OpenDuringScanningRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_OpenDuringScanningRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ReviewDangerousRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_ReviewDangerousRequiringGesture_Params = PageHandler_ReviewDangerousRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_ReviewDangerousRequiringGesture_ParamsMojoType>(
    PageHandler_ReviewDangerousRequiringGesture_ParamsSpec.$,
    'PageHandler_ReviewDangerousRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_ReviewDangerousRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_DeepScan_ParamsMojoType {
  id: string;
}


export type PageHandler_DeepScan_Params = PageHandler_DeepScan_ParamsMojoType;
mojo.internal.Struct<PageHandler_DeepScan_ParamsMojoType>(
    PageHandler_DeepScan_ParamsSpec.$,
    'PageHandler_DeepScan_Params',
    [
      mojo.internal.StructField<PageHandler_DeepScan_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_BypassDeepScanRequiringGesture_ParamsMojoType {
  id: string;
}


export type PageHandler_BypassDeepScanRequiringGesture_Params = PageHandler_BypassDeepScanRequiringGesture_ParamsMojoType;
mojo.internal.Struct<PageHandler_BypassDeepScanRequiringGesture_ParamsMojoType>(
    PageHandler_BypassDeepScanRequiringGesture_ParamsSpec.$,
    'PageHandler_BypassDeepScanRequiringGesture_Params',
    [
      mojo.internal.StructField<PageHandler_BypassDeepScanRequiringGesture_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_IsEligibleForEsbPromo_ParamsMojoType {
}


export type PageHandler_IsEligibleForEsbPromo_Params = PageHandler_IsEligibleForEsbPromo_ParamsMojoType;
mojo.internal.Struct<PageHandler_IsEligibleForEsbPromo_ParamsMojoType>(
    PageHandler_IsEligibleForEsbPromo_ParamsSpec.$,
    'PageHandler_IsEligibleForEsbPromo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_IsEligibleForEsbPromo_ResponseParamsMojoType {
  result: boolean;
}


export type PageHandler_IsEligibleForEsbPromo_ResponseParams = PageHandler_IsEligibleForEsbPromo_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_IsEligibleForEsbPromo_ResponseParamsMojoType>(
    PageHandler_IsEligibleForEsbPromo_ResponseParamsSpec.$,
    'PageHandler_IsEligibleForEsbPromo_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_IsEligibleForEsbPromo_ResponseParamsMojoType, boolean>(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_RemoveItem_ParamsMojoType {
  index: number;
}


export type Page_RemoveItem_Params = Page_RemoveItem_ParamsMojoType;
mojo.internal.Struct<Page_RemoveItem_ParamsMojoType>(
    Page_RemoveItem_ParamsSpec.$,
    'Page_RemoveItem_Params',
    [
      mojo.internal.StructField<Page_RemoveItem_ParamsMojoType, number>(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_UpdateItem_ParamsMojoType {
  index: number;
  data: Data;
}


export type Page_UpdateItem_Params = Page_UpdateItem_ParamsMojoType;
mojo.internal.Struct<Page_UpdateItem_ParamsMojoType>(
    Page_UpdateItem_ParamsSpec.$,
    'Page_UpdateItem_Params',
    [
      mojo.internal.StructField<Page_UpdateItem_ParamsMojoType, number>(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_UpdateItem_ParamsMojoType, Data>(
        'data', 8,
        0,
        DataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_InsertItems_ParamsMojoType {
  index: number;
  items: Data[];
}


export type Page_InsertItems_Params = Page_InsertItems_ParamsMojoType;
mojo.internal.Struct<Page_InsertItems_ParamsMojoType>(
    Page_InsertItems_ParamsSpec.$,
    'Page_InsertItems_Params',
    [
      mojo.internal.StructField<Page_InsertItems_ParamsMojoType, number>(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_InsertItems_ParamsMojoType, Data[]>(
        'items', 8,
        0,
        mojo.internal.Array(DataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_ClearAll_ParamsMojoType {
}


export type Page_ClearAll_Params = Page_ClearAll_ParamsMojoType;
mojo.internal.Struct<Page_ClearAll_ParamsMojoType>(
    Page_ClearAll_ParamsSpec.$,
    'Page_ClearAll_Params',
    [
    ],
    [[0, 8],]);



