// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export const SortedTableMixinLit = (superClass) => {
    class SortedTableMixinLit extends superClass {
        static get properties() {
            return {
                /**
                 * The current sort key, used for computing the appropriate sort
                 * function.
                 */
                sortKey: { type: String },
                /**
                 * True if sorting in reverse, used for computing the appropriate
                 * sort function.
                 */
                sortReverse: { type: Boolean },
            };
        }
        #sortKey_accessor_storage = '';
        get sortKey() { return this.#sortKey_accessor_storage; }
        set sortKey(value) { this.#sortKey_accessor_storage = value; }
        #sortReverse_accessor_storage = false;
        get sortReverse() { return this.#sortReverse_accessor_storage; }
        set sortReverse(value) { this.#sortReverse_accessor_storage = value; }
        /**
         * Invoked when a header is clicked, sets a new sort key and updates
         * element styles to present the new sort key.
         */
        onSortClick(e) {
            // Remove the presentation style on the old sort header.
            const oldElement = this.shadowRoot.querySelector('.sort-column, .sort-column-reverse');
            if (oldElement) {
                oldElement.classList.remove('sort-column');
                oldElement.classList.remove('sort-column-reverse');
            }
            const target = e.currentTarget;
            const newSortKey = target.dataset['sortKey'];
            if (newSortKey === this.sortKey) {
                this.sortReverse = !this.sortReverse;
            }
            else {
                this.sortKey = newSortKey;
            }
            // Update the sort key and the styles on the new sort header.
            const newClass = this.sortReverse ? 'sort-column-reverse' : 'sort-column';
            target.classList.add(newClass);
        }
    }
    return SortedTableMixinLit;
};
