import './icons.html.js';
import '/strings.m.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ConfigurableParams } from './compose.mojom-webui.js';
export interface ComposeTextareaElement {
    $: {
        editButtonContainer: HTMLElement;
        editButton: HTMLElement;
        tooShortError: HTMLElement;
        tooLongError: HTMLElement;
        input: HTMLTextAreaElement;
        readonlyText: HTMLElement;
    };
}
export declare class ComposeTextareaElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        allowExitingReadonlyMode: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        inputParams: ObjectConstructor;
        readonly: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        invalidInput_: {
            type: BooleanConstructor;
            value: boolean;
            reflectToAttribute: boolean;
        };
        tooLong_: {
            type: BooleanConstructor;
            value: boolean;
        };
        tooShort_: {
            type: BooleanConstructor;
            value: boolean;
        };
        value: {
            type: StringConstructor;
            notify: boolean;
        };
    };
    allowExitingReadonlyMode: boolean;
    private animator_;
    inputParams: ConfigurableParams;
    readonly: boolean;
    private invalidInput_;
    private tooLong_;
    private tooShort_;
    private placeholderText_;
    value: string;
    constructor();
    ready(): void;
    focusInput(): void;
    focusEditButton(): void;
    private onEditClick_;
    scrollInputToTop(): void;
    private shouldShowEditIcon_;
    private onChangeTextArea_;
    transitionToEditable(): void;
    transitionToReadonly(fromHeight?: number): void;
    transitionToEditing(bodyHeight: number): void;
    transitionToResult(bodyHeight: number): void;
    validate(): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'compose-textarea': ComposeTextareaElement;
    }
}
