import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import 'chrome://resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import type { CrActionMenuElement } from '//resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrLazyRenderLitElement } from '//resources/cr_elements/cr_lazy_render/cr_lazy_render_lit.js';
import type { CrUrlListItemElement } from '//resources/cr_elements/cr_url_list_item/cr_url_list_item.js';
import type { Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Url } from 'chrome://resources/mojo/url/mojom/url.mojom-webui.js';
export type ComparisonTableListItemClickEvent = CustomEvent<{
    uuid: Uuid;
}>;
export type ComparisonTableListItemRenameEvent = CustomEvent<{
    uuid: Uuid;
    name: string;
}>;
export type ComparisonTableListItemDeleteEvent = CustomEvent<{
    uuid: Uuid;
}>;
export type ComparisonTableListItemCheckboxChangeEvent = CustomEvent<{
    uuid: Uuid;
    checked: boolean;
}>;
export interface ComparisonTableListItemElement {
    $: {
        item: CrUrlListItemElement;
        menu: CrLazyRenderLitElement<CrActionMenuElement>;
        numItems: HTMLElement;
    };
}
export declare class ComparisonTableListItemElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        hasCheckbox: {
            type: BooleanConstructor;
        };
        imageUrl_: {
            type: ObjectConstructor;
        };
        isMenuOpen_: {
            type: BooleanConstructor;
        };
        isRenaming_: {
            type: BooleanConstructor;
        };
        name: {
            type: StringConstructor;
        };
        numItemsString_: {
            type: StringConstructor;
        };
        tableUrl_: {
            type: ObjectConstructor;
        };
        urls: {
            type: ArrayConstructor;
        };
        uuid: {
            type: ObjectConstructor;
        };
    };
    accessor hasCheckbox: boolean;
    accessor name: string;
    accessor urls: Url[];
    accessor uuid: Uuid;
    protected accessor imageUrl_: Url | null;
    protected accessor isMenuOpen_: boolean;
    protected accessor isRenaming_: boolean;
    protected accessor numItemsString_: string;
    protected accessor tableUrl_: Url;
    private pluralStringProxy_;
    private productSpecificationsProxy_;
    private shoppingApi_;
    connectedCallback(): Promise<void>;
    updated(changedProperties: PropertyValues<this>): void;
    protected getTitle_(): string;
    protected getFaviconUrl_(): string;
    protected updateNumItemsString_(): Promise<void>;
    protected updateImage_(): Promise<void>;
    protected onClick_(event: MouseEvent): void;
    protected onContextMenu_(event: MouseEvent): void;
    protected onShowContextMenuClick_(event: MouseEvent): void;
    protected onOpenInNewTabClick_(): void;
    protected onOpenInNewWindowClick_(): void;
    protected onRenameClick_(): Promise<void>;
    protected onDeleteClick_(): void;
    protected onRenameInputBlur_(): void;
    protected onRenameInputKeyDown_(event: KeyboardEvent): void;
    protected onCheckboxChange_(event: Event): void;
    private get trailingIconButton_();
    private get input_();
    private get checkbox_();
}
declare global {
    interface HTMLElementTagNameMap {
        'comparison-table-list-item': ComparisonTableListItemElement;
    }
}
