/**
 * @fileoverview The 'certificate-subpage' component is designed to show a
 * subpage. This subpage contains:
 *
 *   - header text
 *   - one or more lists of certs
 *   - a back button for navigating back to the previous page
 *
 * This component is used in the new Certificate Management UI in
 * ./certificate_manager.ts.
 */
import '/strings.m.js';
import './certificate_list.js';
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/cr_icons.css.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { CertificateSource } from './certificate_manager.mojom-webui.js';
import { Page } from './navigation.js';
export interface CertificateSubpageElement {
    $: {
        backButton: HTMLElement;
    };
}
export declare class SubpageCertificateList {
    headerText: string;
    certSource: CertificateSource;
    certMetadataEditable?: boolean;
    hideExport?: boolean;
    showImport?: boolean;
    showImportAndBind?: boolean;
    hideIfEmpty?: boolean;
    hideHeader?: boolean;
}
declare const CertificateSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class CertificateSubpageElement extends CertificateSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        subpageTitle: StringConstructor;
        subpageCertLists: {
            type: ArrayConstructor;
            value: () => never[];
        };
        navigateBackTarget: typeof Page;
    };
    subpageTitle: string;
    subpageCertLists: SubpageCertificateList[];
    navigateBackTarget: Page;
    navigateBackSource: Page;
    setInitialFocus(): void;
    private onBackButtonClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'certificate-subpage': CertificateSubpageElement;
    }
}
export {};
