import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-page-host-style cr-shared-style certificate-manager-style">#importOsCerts{margin-inline-start:auto}.enterprise-icon{padding-inline-start:5px}</style>

<div class="cr-centered-card-container">
  <h2 class="page-title">$i18n{certificateManagerV2LocalCerts}</h2>
  $i18n{certificateManagerV2LocalCertsDescription}

  
    <h3 class="section-title">$i18n{certificateManagerV2Platform}</h3>
    <div class="card">
      <div class="cr-row">
        <div class="cr-padded-text">
          <div>
            $i18n{certificateManagerV2PlatformCertsToggleLabel}
          </div>
          <div id="numSystemCerts" class="cr-secondary-text">
            [[numSystemCertsString_]]
          </div>
        </div>
        <cr-toggle id="importOsCerts"
            aria-label="$i18n{certificateManagerV2PlatformCertsToggleLabel}"
            checked="[[importOsCertsEnabled_]]"
            disabled$="[[importOsCertsEnabledManaged_]]"
            on-change="onOsCertsToggleChanged_"></cr-toggle>
        </cr-toggle>

        <cr-icon id="importOsCertsManagedIcon" icon="cr:domain"
            class="enterprise-icon" hidden$="[[!importOsCertsEnabledManaged_]]">
        </cr-icon>
      </div>
      <cr-link-row id="viewOsImportedCerts" class="hr"
          label="$i18n{certificateManagerV2PlatformCertsViewLink}"
          on-click="onPlatformCertsLinkRowClick_"
          hidden$="[[!showViewOsCertsLinkRow_]]">
      </cr-link-row>

      
        <cr-link-row external id="manageOsImportedCerts" class="hr"
            label="$i18n{certificateManagerV2PlatformCertsManageLink}"
            on-click="onManageCertsExternal_"
            button-aria-description="$i18n{certificateManagerV2PlatformCertsManageLinkAriaDescription}"
            hidden$="[[!importOsCertsEnabled_]]">
        </cr-link-row>
      
    </div>
  

  <template is="dom-if" if="[[showCustomSection_(certManagementMetadata_)]]">
    <div id="customCertsSection">
      <h3 class="section-title">$i18n{certificateManagerV2CustomCertsTitle}</h3>
      <template is="dom-if" if="[[showPolicySection_(certManagementMetadata_) || showUserSection_(certManagementMetadata_)]]">
        <div class="card">
          <template is="dom-if" if="[[showPolicySection_(certManagementMetadata_)]]">
            <cr-link-row id="adminCertsInstalledLinkRow"
                start-icon="cr:domain"
                label="$i18n{certificateManagerV2AdminCertsTitle}"
                sub-label="[[numPolicyCertsString_]]"
                on-click="onAdminCertsInstalledLinkRowClick_">
            </cr-link-row>
          </template>
          <template is="dom-if" if="[[showUserSection_(certManagementMetadata_)]]">
            <div id="userCertsSection">
              <cr-link-row id="userCertsInstalledLinkRow"
                    start-icon="cr:person"
                    label="$i18n{certificateManagerV2UserCertsTitle}"
                    sub-label="[[numUserCertsString_]]"
                    on-click="onUserCertsInstalledLinkRowClick_">
              </cr-link-row>
            </div>
          </template>
        </div>
      </template>
    </div>
  </template>
</div>

<!--_html_template_end_-->`;
}