// chrome/browser/resources/certificate_manager/certificate_manager.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';






export const CertificateSourceSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CertificateSource {

  MIN_VALUE = 1,
  MAX_VALUE = 12,
  kChromeRootStore = 1,
  kPlatformClientCert = 2,
  kEnterpriseTrustedCerts = 3,
  kEnterpriseIntermediateCerts = 4,
  kEnterpriseDistrustedCerts = 5,
  kPlatformUserTrustedCerts = 6,
  kPlatformUserIntermediateCerts = 7,
  kPlatformUserDistrustedCerts = 8,
  kProvisionedClientCert = 9,
  kUserTrustedCerts = 10,
  kUserIntermediateCerts = 11,
  kUserDistrustedCerts = 12,
}

export const SuccessResultSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum SuccessResult {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kSuccess = 0,
}



export type CertificateManagerPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CertificateManagerPageHandlerFactoryPendingReceiver>;

export class CertificateManagerPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CertificateManagerPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<CertificateManagerPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|CertificateManagerPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'certificate_manager.mojom.CertificateManagerPageHandlerFactory',
        scope);
  }
}

export interface CertificateManagerPageHandlerFactoryInterface {
  createCertificateManagerPageHandler(page: CertificateManagerPageRemote, handler: CertificateManagerPageHandlerPendingReceiver): void;
}

export class CertificateManagerPageHandlerFactoryRemote implements CertificateManagerPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CertificateManagerPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CertificateManagerPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CertificateManagerPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertificateManagerPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createCertificateManagerPageHandler(
      page: CertificateManagerPageRemote,
      handler: CertificateManagerPageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertificateManagerPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageHandlerFactoryRemote, CertificateManagerPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageHandlerFactoryRemote, CertificateManagerPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CertificateManagerPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertificateManagerPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$,
        null,
        impl.createCertificateManagerPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertificateManagerPageHandlerFactory {
  static get $interfaceName(): string {
    return "certificate_manager.mojom.CertificateManagerPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CertificateManagerPageHandlerFactoryRemote {
    let remote = new CertificateManagerPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CertificateManagerPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageHandlerFactoryRemote, CertificateManagerPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageHandlerFactoryRemote, CertificateManagerPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createCertificateManagerPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertificateManagerPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createCertificateManagerPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$,
        null,
        this.createCertificateManagerPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CertificateManagerPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CertificateManagerPageHandlerPendingReceiver>;

export class CertificateManagerPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CertificateManagerPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<CertificateManagerPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|CertificateManagerPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'certificate_manager.mojom.CertificateManagerPageHandler',
        scope);
  }
}

export interface CertificateManagerPageHandlerInterface {
  getCertificates(source: CertificateSource): Promise<{
        certs: SummaryCertInfo[], }>;
  getCertManagementMetadata(): Promise<{
        metadata: CertManagementMetadata, }>;
  viewCertificate(source: CertificateSource, sha256HashHex: string): void;
  exportCertificates(source: CertificateSource): void;
  importCertificate(source: CertificateSource): Promise<{
        result: (ActionResult | null), }>;
  importAndBindCertificate(source: CertificateSource): Promise<{
        result: (ActionResult | null), }>;
  deleteCertificate(source: CertificateSource, displayName: string, sha256HashHex: string): Promise<{
        result: (ActionResult | null), }>;
  showNativeManageCertificates(): void;
  setIncludeSystemTrustStore(include: boolean): void;
}

export class CertificateManagerPageHandlerRemote implements CertificateManagerPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CertificateManagerPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CertificateManagerPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CertificateManagerPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertificateManagerPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getCertificates(
      source: CertificateSource): Promise<{
        certs: SummaryCertInfo[], }> {
    return this.proxy.sendMessage(
        0,
        CertificateManagerPageHandler_GetCertificates_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$,
        [
          source
        ],
        false);
  }

  getCertManagementMetadata(): Promise<{
        metadata: CertManagementMetadata, }> {
    return this.proxy.sendMessage(
        1,
        CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  viewCertificate(
      source: CertificateSource,
      sha256HashHex: string): void {
    this.proxy.sendMessage(
        2,
        CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$,
        null,
        [
          source,
          sha256HashHex
        ],
        false);
  }

  exportCertificates(
      source: CertificateSource): void {
    this.proxy.sendMessage(
        3,
        CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$,
        null,
        [
          source
        ],
        false);
  }

  importCertificate(
      source: CertificateSource): Promise<{
        result: (ActionResult | null), }> {
    return this.proxy.sendMessage(
        4,
        CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$,
        [
          source
        ],
        false);
  }

  importAndBindCertificate(
      source: CertificateSource): Promise<{
        result: (ActionResult | null), }> {
    return this.proxy.sendMessage(
        5,
        CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$,
        [
          source
        ],
        false);
  }

  deleteCertificate(
      source: CertificateSource,
      displayName: string,
      sha256HashHex: string): Promise<{
        result: (ActionResult | null), }> {
    return this.proxy.sendMessage(
        6,
        CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$,
        [
          source,
          displayName,
          sha256HashHex
        ],
        false);
  }

  showNativeManageCertificates(): void {
    this.proxy.sendMessage(
        7,
        CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setIncludeSystemTrustStore(
      include: boolean): void {
    this.proxy.sendMessage(
        8,
        CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$,
        null,
        [
          include
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertificateManagerPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageHandlerRemote, CertificateManagerPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageHandlerRemote, CertificateManagerPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CertificateManagerPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertificateManagerPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPageHandler_GetCertificates_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$,
        impl.getCertificates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$,
        impl.getCertManagementMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$,
        null,
        impl.viewCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$,
        null,
        impl.exportCertificates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$,
        impl.importCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$,
        impl.importAndBindCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$,
        impl.deleteCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsSpec.$,
        null,
        impl.showNativeManageCertificates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$,
        null,
        impl.setIncludeSystemTrustStore.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertificateManagerPageHandler {
  static get $interfaceName(): string {
    return "certificate_manager.mojom.CertificateManagerPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CertificateManagerPageHandlerRemote {
    let remote = new CertificateManagerPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CertificateManagerPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageHandlerRemote, CertificateManagerPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageHandlerRemote, CertificateManagerPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getCertificates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getCertManagementMetadata: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  viewCertificate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  exportCertificates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  importCertificate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  importAndBindCertificate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteCertificate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showNativeManageCertificates: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setIncludeSystemTrustStore: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertificateManagerPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getCertificates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPageHandler_GetCertificates_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$,
        this.getCertificates.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getCertManagementMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$,
        CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$,
        this.getCertManagementMetadata.createReceiverHandler(true /* expectsResponse */),
        false);
    this.viewCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$,
        null,
        this.viewCertificate.createReceiverHandler(false /* expectsResponse */),
        false);
    this.exportCertificates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$,
        null,
        this.exportCertificates.createReceiverHandler(false /* expectsResponse */),
        false);
    this.importCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$,
        this.importCertificate.createReceiverHandler(true /* expectsResponse */),
        false);
    this.importAndBindCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$,
        this.importAndBindCertificate.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$,
        CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$,
        this.deleteCertificate.createReceiverHandler(true /* expectsResponse */),
        false);
    this.showNativeManageCertificates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsSpec.$,
        null,
        this.showNativeManageCertificates.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setIncludeSystemTrustStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$,
        null,
        this.setIncludeSystemTrustStore.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CertificateManagerPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CertificateManagerPagePendingReceiver>;

export class CertificateManagerPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CertificateManagerPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<CertificateManagerPagePendingReceiver>;
  constructor(handle: MojoHandle|CertificateManagerPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'certificate_manager.mojom.CertificateManagerPage',
        scope);
  }
}

export interface CertificateManagerPageInterface {
  askForImportPassword(): Promise<{
        password: (string | null), }>;
  askForConfirmation(title: string, message: string): Promise<{
        confirmed: boolean, }>;
  triggerReload(sources: CertificateSource[]): void;
  triggerMetadataUpdate(): void;
}

export class CertificateManagerPageRemote implements CertificateManagerPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CertificateManagerPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CertificateManagerPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CertificateManagerPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertificateManagerPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  askForImportPassword(): Promise<{
        password: (string | null), }> {
    return this.proxy.sendMessage(
        0,
        CertificateManagerPage_AskForImportPassword_ParamsSpec.$,
        CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  askForConfirmation(
      title: string,
      message: string): Promise<{
        confirmed: boolean, }> {
    return this.proxy.sendMessage(
        1,
        CertificateManagerPage_AskForConfirmation_ParamsSpec.$,
        CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$,
        [
          title,
          message
        ],
        false);
  }

  triggerReload(
      sources: CertificateSource[]): void {
    this.proxy.sendMessage(
        2,
        CertificateManagerPage_TriggerReload_ParamsSpec.$,
        null,
        [
          sources
        ],
        false);
  }

  triggerMetadataUpdate(): void {
    this.proxy.sendMessage(
        3,
        CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CertificateManagerPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertificateManagerPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageRemote, CertificateManagerPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageRemote, CertificateManagerPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CertificateManagerPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertificateManagerPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPage_AskForImportPassword_ParamsSpec.$,
        CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$,
        impl.askForImportPassword.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CertificateManagerPage_AskForConfirmation_ParamsSpec.$,
        CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$,
        impl.askForConfirmation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CertificateManagerPage_TriggerReload_ParamsSpec.$,
        null,
        impl.triggerReload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$,
        null,
        impl.triggerMetadataUpdate.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertificateManagerPage {
  static get $interfaceName(): string {
    return "certificate_manager.mojom.CertificateManagerPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CertificateManagerPageRemote {
    let remote = new CertificateManagerPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CertificateManagerPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertificateManagerPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CertificateManagerPageRemote, CertificateManagerPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CertificateManagerPageRemote, CertificateManagerPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  askForImportPassword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  askForConfirmation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  triggerReload: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  triggerMetadataUpdate: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertificateManagerPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.askForImportPassword =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertificateManagerPage_AskForImportPassword_ParamsSpec.$,
        CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$,
        this.askForImportPassword.createReceiverHandler(true /* expectsResponse */),
        false);
    this.askForConfirmation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CertificateManagerPage_AskForConfirmation_ParamsSpec.$,
        CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$,
        this.askForConfirmation.createReceiverHandler(true /* expectsResponse */),
        false);
    this.triggerReload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CertificateManagerPage_TriggerReload_ParamsSpec.$,
        null,
        this.triggerReload.createReceiverHandler(false /* expectsResponse */),
        false);
    this.triggerMetadataUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$,
        null,
        this.triggerMetadataUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const SummaryCertInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertManagementMetadataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_GetCertificates_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ViewCertificate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ExportCertificates_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ImportCertificate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_DeleteCertificate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_AskForImportPassword_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_AskForImportPassword_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_AskForConfirmation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_AskForConfirmation_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_TriggerReload_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ActionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface SummaryCertInfoMojoType {
  sha256hashHex: string;
  displayName: string;
  isDeletable: boolean;
}


export type SummaryCertInfo = SummaryCertInfoMojoType;
mojo.internal.Struct<SummaryCertInfoMojoType>(
    SummaryCertInfoSpec.$,
    'SummaryCertInfo',
    [
      mojo.internal.StructField<SummaryCertInfoMojoType, string>(
        'sha256hashHex', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SummaryCertInfoMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SummaryCertInfoMojoType, boolean>(
        'isDeletable', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface CertManagementMetadataMojoType {
  includeSystemTrustStore: boolean;
  isIncludeSystemTrustStoreManaged: boolean;
  showUserCertsUi: boolean;
  numUserAddedSystemCerts: number;
  numPolicyCerts: number;
  numUserCerts: number;
}


export type CertManagementMetadata = CertManagementMetadataMojoType;
mojo.internal.Struct<CertManagementMetadataMojoType>(
    CertManagementMetadataSpec.$,
    'CertManagementMetadata',
    [
      mojo.internal.StructField<CertManagementMetadataMojoType, boolean>(
        'includeSystemTrustStore', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertManagementMetadataMojoType, number>(
        'numUserAddedSystemCerts', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertManagementMetadataMojoType, boolean>(
        'isIncludeSystemTrustStoreManaged', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertManagementMetadataMojoType, number>(
        'numPolicyCerts', 2,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertManagementMetadataMojoType, number>(
        'numUserCerts', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertManagementMetadataMojoType, boolean>(
        'showUserCertsUi', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsMojoType {
  page: CertificateManagerPageRemote;
  handler: CertificateManagerPageHandlerPendingReceiver;
}


export type CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params = CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsMojoType>(
    CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsSpec.$,
    'CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsMojoType, CertificateManagerPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(CertificateManagerPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateManagerPageHandlerFactory_CreateCertificateManagerPageHandler_ParamsMojoType, CertificateManagerPageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(CertificateManagerPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPageHandler_GetCertificates_ParamsMojoType {
  source: CertificateSource;
}


export type CertificateManagerPageHandler_GetCertificates_Params = CertificateManagerPageHandler_GetCertificates_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_GetCertificates_ParamsMojoType>(
    CertificateManagerPageHandler_GetCertificates_ParamsSpec.$,
    'CertificateManagerPageHandler_GetCertificates_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_GetCertificates_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_GetCertificates_ResponseParamsMojoType {
  certs: SummaryCertInfo[];
}


export type CertificateManagerPageHandler_GetCertificates_ResponseParams = CertificateManagerPageHandler_GetCertificates_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_GetCertificates_ResponseParamsMojoType>(
    CertificateManagerPageHandler_GetCertificates_ResponseParamsSpec.$,
    'CertificateManagerPageHandler_GetCertificates_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_GetCertificates_ResponseParamsMojoType, SummaryCertInfo[]>(
        'certs', 0,
        0,
        mojo.internal.Array(SummaryCertInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_GetCertManagementMetadata_ParamsMojoType {
}


export type CertificateManagerPageHandler_GetCertManagementMetadata_Params = CertificateManagerPageHandler_GetCertManagementMetadata_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_GetCertManagementMetadata_ParamsMojoType>(
    CertificateManagerPageHandler_GetCertManagementMetadata_ParamsSpec.$,
    'CertificateManagerPageHandler_GetCertManagementMetadata_Params',
    [
    ],
    [[0, 8],]);





export interface CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsMojoType {
  metadata: CertManagementMetadata;
}


export type CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams = CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsMojoType>(
    CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsSpec.$,
    'CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_GetCertManagementMetadata_ResponseParamsMojoType, CertManagementMetadata>(
        'metadata', 0,
        0,
        CertManagementMetadataSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_ViewCertificate_ParamsMojoType {
  source: CertificateSource;
  sha256HashHex: string;
}


export type CertificateManagerPageHandler_ViewCertificate_Params = CertificateManagerPageHandler_ViewCertificate_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ViewCertificate_ParamsMojoType>(
    CertificateManagerPageHandler_ViewCertificate_ParamsSpec.$,
    'CertificateManagerPageHandler_ViewCertificate_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ViewCertificate_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateManagerPageHandler_ViewCertificate_ParamsMojoType, string>(
        'sha256HashHex', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPageHandler_ExportCertificates_ParamsMojoType {
  source: CertificateSource;
}


export type CertificateManagerPageHandler_ExportCertificates_Params = CertificateManagerPageHandler_ExportCertificates_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ExportCertificates_ParamsMojoType>(
    CertificateManagerPageHandler_ExportCertificates_ParamsSpec.$,
    'CertificateManagerPageHandler_ExportCertificates_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ExportCertificates_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_ImportCertificate_ParamsMojoType {
  source: CertificateSource;
}


export type CertificateManagerPageHandler_ImportCertificate_Params = CertificateManagerPageHandler_ImportCertificate_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ImportCertificate_ParamsMojoType>(
    CertificateManagerPageHandler_ImportCertificate_ParamsSpec.$,
    'CertificateManagerPageHandler_ImportCertificate_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ImportCertificate_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_ImportCertificate_ResponseParamsMojoType {
  result: (ActionResult | null);
}


export type CertificateManagerPageHandler_ImportCertificate_ResponseParams = CertificateManagerPageHandler_ImportCertificate_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ImportCertificate_ResponseParamsMojoType>(
    CertificateManagerPageHandler_ImportCertificate_ResponseParamsSpec.$,
    'CertificateManagerPageHandler_ImportCertificate_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ImportCertificate_ResponseParamsMojoType, ActionResult>(
        'result', 0,
        0,
        ActionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPageHandler_ImportAndBindCertificate_ParamsMojoType {
  source: CertificateSource;
}


export type CertificateManagerPageHandler_ImportAndBindCertificate_Params = CertificateManagerPageHandler_ImportAndBindCertificate_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ImportAndBindCertificate_ParamsMojoType>(
    CertificateManagerPageHandler_ImportAndBindCertificate_ParamsSpec.$,
    'CertificateManagerPageHandler_ImportAndBindCertificate_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ImportAndBindCertificate_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsMojoType {
  result: (ActionResult | null);
}


export type CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams = CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsMojoType>(
    CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsSpec.$,
    'CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_ImportAndBindCertificate_ResponseParamsMojoType, ActionResult>(
        'result', 0,
        0,
        ActionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType {
  source: CertificateSource;
  displayName: string;
  sha256HashHex: string;
}


export type CertificateManagerPageHandler_DeleteCertificate_Params = CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType>(
    CertificateManagerPageHandler_DeleteCertificate_ParamsSpec.$,
    'CertificateManagerPageHandler_DeleteCertificate_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType, CertificateSource>(
        'source', 0,
        0,
        CertificateSourceSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType, string>(
        'displayName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateManagerPageHandler_DeleteCertificate_ParamsMojoType, string>(
        'sha256HashHex', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface CertificateManagerPageHandler_DeleteCertificate_ResponseParamsMojoType {
  result: (ActionResult | null);
}


export type CertificateManagerPageHandler_DeleteCertificate_ResponseParams = CertificateManagerPageHandler_DeleteCertificate_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_DeleteCertificate_ResponseParamsMojoType>(
    CertificateManagerPageHandler_DeleteCertificate_ResponseParamsSpec.$,
    'CertificateManagerPageHandler_DeleteCertificate_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_DeleteCertificate_ResponseParamsMojoType, ActionResult>(
        'result', 0,
        0,
        ActionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsMojoType {
}


export type CertificateManagerPageHandler_ShowNativeManageCertificates_Params = CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsMojoType>(
    CertificateManagerPageHandler_ShowNativeManageCertificates_ParamsSpec.$,
    'CertificateManagerPageHandler_ShowNativeManageCertificates_Params',
    [
    ],
    [[0, 8],]);





export interface CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsMojoType {
  include: boolean;
}


export type CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params = CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsMojoType>(
    CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsSpec.$,
    'CertificateManagerPageHandler_SetIncludeSystemTrustStore_Params',
    [
      mojo.internal.StructField<CertificateManagerPageHandler_SetIncludeSystemTrustStore_ParamsMojoType, boolean>(
        'include', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPage_AskForImportPassword_ParamsMojoType {
}


export type CertificateManagerPage_AskForImportPassword_Params = CertificateManagerPage_AskForImportPassword_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_AskForImportPassword_ParamsMojoType>(
    CertificateManagerPage_AskForImportPassword_ParamsSpec.$,
    'CertificateManagerPage_AskForImportPassword_Params',
    [
    ],
    [[0, 8],]);





export interface CertificateManagerPage_AskForImportPassword_ResponseParamsMojoType {
  password: (string | null);
}


export type CertificateManagerPage_AskForImportPassword_ResponseParams = CertificateManagerPage_AskForImportPassword_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_AskForImportPassword_ResponseParamsMojoType>(
    CertificateManagerPage_AskForImportPassword_ResponseParamsSpec.$,
    'CertificateManagerPage_AskForImportPassword_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPage_AskForImportPassword_ResponseParamsMojoType, string>(
        'password', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPage_AskForConfirmation_ParamsMojoType {
  title: string;
  message: string;
}


export type CertificateManagerPage_AskForConfirmation_Params = CertificateManagerPage_AskForConfirmation_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_AskForConfirmation_ParamsMojoType>(
    CertificateManagerPage_AskForConfirmation_ParamsSpec.$,
    'CertificateManagerPage_AskForConfirmation_Params',
    [
      mojo.internal.StructField<CertificateManagerPage_AskForConfirmation_ParamsMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CertificateManagerPage_AskForConfirmation_ParamsMojoType, string>(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CertificateManagerPage_AskForConfirmation_ResponseParamsMojoType {
  confirmed: boolean;
}


export type CertificateManagerPage_AskForConfirmation_ResponseParams = CertificateManagerPage_AskForConfirmation_ResponseParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_AskForConfirmation_ResponseParamsMojoType>(
    CertificateManagerPage_AskForConfirmation_ResponseParamsSpec.$,
    'CertificateManagerPage_AskForConfirmation_ResponseParams',
    [
      mojo.internal.StructField<CertificateManagerPage_AskForConfirmation_ResponseParamsMojoType, boolean>(
        'confirmed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPage_TriggerReload_ParamsMojoType {
  sources: CertificateSource[];
}


export type CertificateManagerPage_TriggerReload_Params = CertificateManagerPage_TriggerReload_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_TriggerReload_ParamsMojoType>(
    CertificateManagerPage_TriggerReload_ParamsSpec.$,
    'CertificateManagerPage_TriggerReload_Params',
    [
      mojo.internal.StructField<CertificateManagerPage_TriggerReload_ParamsMojoType, CertificateSource[]>(
        'sources', 0,
        0,
        mojo.internal.Array(CertificateSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CertificateManagerPage_TriggerMetadataUpdate_ParamsMojoType {
}


export type CertificateManagerPage_TriggerMetadataUpdate_Params = CertificateManagerPage_TriggerMetadataUpdate_ParamsMojoType;
mojo.internal.Struct<CertificateManagerPage_TriggerMetadataUpdate_ParamsMojoType>(
    CertificateManagerPage_TriggerMetadataUpdate_ParamsSpec.$,
    'CertificateManagerPage_TriggerMetadataUpdate_Params',
    [
    ],
    [[0, 8],]);



mojo.internal.Union(
    ActionResultSpec.$, 'ActionResult',
    {
      'error': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'success': {
        'ordinal': 1,
        'type': SuccessResultSpec.$,
      },
    });

export interface ActionResult {
  error?: string,
  success?: SuccessResult,
}

export enum ActionResultFieldTags {
  ERROR,
  SUCCESS,
}

export function whichActionResult(u: ActionResult): ActionResultFieldTags {
  if (u.error !== null && u.error !== undefined) {
    return ActionResultFieldTags.ERROR;
  }
  if (u.success !== null && u.success !== undefined) {
    return ActionResultFieldTags.SUCCESS;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
