// chrome/browser/resources/certificate_manager/certificate_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace certificate_manager::mojom {

class CertificateManagerPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class CertificateManagerPageHandlerFactoryStub;

class CertificateManagerPageHandlerFactoryRequestValidator;


class CertificateManagerPageHandlerFactory
    : public CertificateManagerPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "certificate_manager.mojom.CertificateManagerPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertificateManagerPageHandlerFactoryInterfaceBase;
  using Proxy_ = CertificateManagerPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertificateManagerPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CertificateManagerPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateCertificateManagerPageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCertificateManagerPageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertificateManagerPageHandlerFactory() = default;

  virtual void CreateCertificateManagerPageHandler(::mojo::PendingRemote<CertificateManagerPage> page, ::mojo::PendingReceiver<CertificateManagerPageHandler> handler) = 0;
};

class CertificateManagerPageHandlerProxy;

template <typename ImplRefTraits>
class CertificateManagerPageHandlerStub;

class CertificateManagerPageHandlerRequestValidator;
class CertificateManagerPageHandlerResponseValidator;


class CertificateManagerPageHandler
    : public CertificateManagerPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "certificate_manager.mojom.CertificateManagerPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertificateManagerPageHandlerInterfaceBase;
  using Proxy_ = CertificateManagerPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertificateManagerPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CertificateManagerPageHandlerRequestValidator;
  using ResponseValidator_ = CertificateManagerPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetCertificatesMinVersion = 0,
    kGetCertManagementMetadataMinVersion = 0,
    kViewCertificateMinVersion = 0,
    kExportCertificatesMinVersion = 0,
    kImportCertificateMinVersion = 0,
    kImportAndBindCertificateMinVersion = 0,
    kDeleteCertificateMinVersion = 0,
    kShowNativeManageCertificatesMinVersion = 0,
    kSetIncludeSystemTrustStoreMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetCertificates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCertManagementMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ViewCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExportCertificates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ImportAndBindCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowNativeManageCertificates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIncludeSystemTrustStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertificateManagerPageHandler() = default;

  using GetCertificatesCallback = base::OnceCallback<void(std::vector<SummaryCertInfoPtr>)>;
  using GetCertificatesMojoCallback = base::OnceCallback<void(std::vector<SummaryCertInfoPtr>)>;

  virtual void GetCertificates(CertificateSource source, GetCertificatesCallback callback) = 0;

  using GetCertManagementMetadataCallback = base::OnceCallback<void(CertManagementMetadataPtr)>;
  using GetCertManagementMetadataMojoCallback = base::OnceCallback<void(CertManagementMetadataPtr)>;

  virtual void GetCertManagementMetadata(GetCertManagementMetadataCallback callback) = 0;

  virtual void ViewCertificate(CertificateSource source, const std::string& sha256_hash_hex) = 0;

  virtual void ExportCertificates(CertificateSource source) = 0;

  using ImportCertificateCallback = base::OnceCallback<void(ActionResultPtr)>;
  using ImportCertificateMojoCallback = base::OnceCallback<void(ActionResultPtr)>;

  virtual void ImportCertificate(CertificateSource source, ImportCertificateCallback callback) = 0;

  using ImportAndBindCertificateCallback = base::OnceCallback<void(ActionResultPtr)>;
  using ImportAndBindCertificateMojoCallback = base::OnceCallback<void(ActionResultPtr)>;

  virtual void ImportAndBindCertificate(CertificateSource source, ImportAndBindCertificateCallback callback) = 0;

  using DeleteCertificateCallback = base::OnceCallback<void(ActionResultPtr)>;
  using DeleteCertificateMojoCallback = base::OnceCallback<void(ActionResultPtr)>;

  virtual void DeleteCertificate(CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, DeleteCertificateCallback callback) = 0;

  virtual void ShowNativeManageCertificates() = 0;

  virtual void SetIncludeSystemTrustStore(bool include) = 0;
};

class CertificateManagerPageProxy;

template <typename ImplRefTraits>
class CertificateManagerPageStub;

class CertificateManagerPageRequestValidator;
class CertificateManagerPageResponseValidator;


class CertificateManagerPage
    : public CertificateManagerPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "certificate_manager.mojom.CertificateManagerPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertificateManagerPageInterfaceBase;
  using Proxy_ = CertificateManagerPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertificateManagerPageStub<ImplRefTraits>;

  using RequestValidator_ = CertificateManagerPageRequestValidator;
  using ResponseValidator_ = CertificateManagerPageResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAskForImportPasswordMinVersion = 0,
    kAskForConfirmationMinVersion = 0,
    kTriggerReloadMinVersion = 0,
    kTriggerMetadataUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AskForImportPassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AskForConfirmation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerReload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerMetadataUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertificateManagerPage() = default;

  using AskForImportPasswordCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using AskForImportPasswordMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void AskForImportPassword(AskForImportPasswordCallback callback) = 0;

  using AskForConfirmationCallback = base::OnceCallback<void(bool)>;
  using AskForConfirmationMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AskForConfirmation(const std::string& title, const std::string& message, AskForConfirmationCallback callback) = 0;

  virtual void TriggerReload(const std::vector<CertificateSource>& sources) = 0;

  virtual void TriggerMetadataUpdate() = 0;
};



class  CertificateManagerPageHandlerFactoryProxy
    : public CertificateManagerPageHandlerFactory {
 public:
  using InterfaceType = CertificateManagerPageHandlerFactory;

  explicit CertificateManagerPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCertificateManagerPageHandler(::mojo::PendingRemote<CertificateManagerPage> page, ::mojo::PendingReceiver<CertificateManagerPageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertificateManagerPageHandlerProxy
    : public CertificateManagerPageHandler {
 public:
  using InterfaceType = CertificateManagerPageHandler;

  explicit CertificateManagerPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetCertificates(CertificateSource source, GetCertificatesCallback callback) final;
  
  void GetCertManagementMetadata(GetCertManagementMetadataCallback callback) final;
  
  void ViewCertificate(CertificateSource source, const std::string& sha256_hash_hex) final;
  
  void ExportCertificates(CertificateSource source) final;
  
  void ImportCertificate(CertificateSource source, ImportCertificateCallback callback) final;
  
  void ImportAndBindCertificate(CertificateSource source, ImportAndBindCertificateCallback callback) final;
  
  void DeleteCertificate(CertificateSource source, const std::string& display_name, const std::string& sha256_hash_hex, DeleteCertificateCallback callback) final;
  
  void ShowNativeManageCertificates() final;
  
  void SetIncludeSystemTrustStore(bool include) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertificateManagerPageProxy
    : public CertificateManagerPage {
 public:
  using InterfaceType = CertificateManagerPage;

  explicit CertificateManagerPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AskForImportPassword(AskForImportPasswordCallback callback) final;
  
  void AskForConfirmation(const std::string& title, const std::string& message, AskForConfirmationCallback callback) final;
  
  void TriggerReload(const std::vector<CertificateSource>& sources) final;
  
  void TriggerMetadataUpdate() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CertificateManagerPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(CertificateManagerPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertificateManagerPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertificateManagerPageHandlerFactory>>
class CertificateManagerPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertificateManagerPageHandlerFactoryStub() = default;
  ~CertificateManagerPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertificateManagerPageHandlerStubDispatch {
 public:
  static bool Accept(CertificateManagerPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertificateManagerPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertificateManagerPageHandler>>
class CertificateManagerPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertificateManagerPageHandlerStub() = default;
  ~CertificateManagerPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertificateManagerPageStubDispatch {
 public:
  static bool Accept(CertificateManagerPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertificateManagerPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertificateManagerPage>>
class CertificateManagerPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertificateManagerPageStub() = default;
  ~CertificateManagerPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertificateManagerPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertificateManagerPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertificateManagerPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertificateManagerPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertificateManagerPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertificateManagerPageResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  SummaryCertInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SummaryCertInfo, T>::value>;
  using DataView = SummaryCertInfoDataView;
  using Data_ = internal::SummaryCertInfo_Data;

  template <typename... Args>
  static SummaryCertInfoPtr New(Args&&... args) {
    return SummaryCertInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SummaryCertInfoPtr From(const U& u) {
    return mojo::TypeConverter<SummaryCertInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SummaryCertInfo>::Convert(*this);
  }


  SummaryCertInfo();

  SummaryCertInfo(
      const std::string& sha256hash_hex,
      const std::string& display_name,
      bool is_deletable);


  ~SummaryCertInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SummaryCertInfoPtr>
  SummaryCertInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SummaryCertInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SummaryCertInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SummaryCertInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SummaryCertInfo_UnserializedMessageContext<
            UserType, SummaryCertInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SummaryCertInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SummaryCertInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SummaryCertInfo_UnserializedMessageContext<
            UserType, SummaryCertInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SummaryCertInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string sha256hash_hex;
  
  std::string display_name;
  
  bool is_deletable;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SummaryCertInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ActionResult {
 public:
  using DataView = ActionResultDataView;
  using Data_ = internal::ActionResult_Data;
  using Tag = Data_::ActionResult_Tag;

  template <typename... Args>
  static ActionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error|.
  static ActionResultPtr NewError(
      const std::string& value);
  // Construct an instance holding |success|.
  static ActionResultPtr NewSuccess(
      SuccessResult value);

  template <typename U>
  static ActionResultPtr From(const U& u) {
    return mojo::TypeConverter<ActionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ActionResult>::Convert(*this);
  }
  ~ActionResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  ActionResult(const ActionResult& other) = delete;
  ActionResult& operator=(const ActionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = ActionResultPtr>
  ActionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ActionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, ActionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_error() const { return tag_ == Tag::kError; }
  const std::string& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  std::string& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(const std::string& error);

  bool is_success() const { return tag_ == Tag::kSuccess; }
  SuccessResult get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(SuccessResult success);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ActionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<ActionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        SuccessResult value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string error;
    SuccessResult success;
  };

  ActionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      const std::string& value);
  ActionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      SuccessResult value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  CertManagementMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertManagementMetadata, T>::value>;
  using DataView = CertManagementMetadataDataView;
  using Data_ = internal::CertManagementMetadata_Data;

  template <typename... Args>
  static CertManagementMetadataPtr New(Args&&... args) {
    return CertManagementMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertManagementMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CertManagementMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertManagementMetadata>::Convert(*this);
  }


  CertManagementMetadata();

  CertManagementMetadata(
      bool include_system_trust_store,
      uint8_t num_user_added_system_certs,
      bool is_include_system_trust_store_managed,
      uint8_t num_policy_certs,
      uint32_t num_user_certs,
      bool show_user_certs_ui);


  ~CertManagementMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertManagementMetadataPtr>
  CertManagementMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertManagementMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertManagementMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertManagementMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertManagementMetadata_UnserializedMessageContext<
            UserType, CertManagementMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertManagementMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertManagementMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertManagementMetadata_UnserializedMessageContext<
            UserType, CertManagementMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertManagementMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_system_trust_store;
  
  uint8_t num_user_added_system_certs;
  
  bool is_include_system_trust_store_managed;
  
  uint8_t num_policy_certs;
  
  uint32_t num_user_certs;
  
  bool show_user_certs_ui;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertManagementMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
ActionResultPtr ActionResult::Clone() const {
  switch (tag_) {
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ActionResult>::value>::type*>
bool ActionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
  }

  return false;
}
template <typename StructPtrType>
SummaryCertInfoPtr SummaryCertInfo::Clone() const {
  return New(
      mojo::Clone(sha256hash_hex),
      mojo::Clone(display_name),
      mojo::Clone(is_deletable)
  );
}

template <typename T, SummaryCertInfo::EnableIfSame<T>*>
bool SummaryCertInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sha256hash_hex, other_struct.sha256hash_hex))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->is_deletable, other_struct.is_deletable))
    return false;
  return true;
}

template <typename T, SummaryCertInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sha256hash_hex < rhs.sha256hash_hex)
    return true;
  if (rhs.sha256hash_hex < lhs.sha256hash_hex)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.is_deletable < rhs.is_deletable)
    return true;
  if (rhs.is_deletable < lhs.is_deletable)
    return false;
  return false;
}
template <typename StructPtrType>
CertManagementMetadataPtr CertManagementMetadata::Clone() const {
  return New(
      mojo::Clone(include_system_trust_store),
      mojo::Clone(num_user_added_system_certs),
      mojo::Clone(is_include_system_trust_store_managed),
      mojo::Clone(num_policy_certs),
      mojo::Clone(num_user_certs),
      mojo::Clone(show_user_certs_ui)
  );
}

template <typename T, CertManagementMetadata::EnableIfSame<T>*>
bool CertManagementMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_system_trust_store, other_struct.include_system_trust_store))
    return false;
  if (!mojo::Equals(this->num_user_added_system_certs, other_struct.num_user_added_system_certs))
    return false;
  if (!mojo::Equals(this->is_include_system_trust_store_managed, other_struct.is_include_system_trust_store_managed))
    return false;
  if (!mojo::Equals(this->num_policy_certs, other_struct.num_policy_certs))
    return false;
  if (!mojo::Equals(this->num_user_certs, other_struct.num_user_certs))
    return false;
  if (!mojo::Equals(this->show_user_certs_ui, other_struct.show_user_certs_ui))
    return false;
  return true;
}

template <typename T, CertManagementMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_system_trust_store < rhs.include_system_trust_store)
    return true;
  if (rhs.include_system_trust_store < lhs.include_system_trust_store)
    return false;
  if (lhs.num_user_added_system_certs < rhs.num_user_added_system_certs)
    return true;
  if (rhs.num_user_added_system_certs < lhs.num_user_added_system_certs)
    return false;
  if (lhs.is_include_system_trust_store_managed < rhs.is_include_system_trust_store_managed)
    return true;
  if (rhs.is_include_system_trust_store_managed < lhs.is_include_system_trust_store_managed)
    return false;
  if (lhs.num_policy_certs < rhs.num_policy_certs)
    return true;
  if (rhs.num_policy_certs < lhs.num_policy_certs)
    return false;
  if (lhs.num_user_certs < rhs.num_user_certs)
    return true;
  if (rhs.num_user_certs < lhs.num_user_certs)
    return false;
  if (lhs.show_user_certs_ui < rhs.show_user_certs_ui)
    return true;
  if (rhs.show_user_certs_ui < lhs.show_user_certs_ui)
    return false;
  return false;
}


}  // certificate_manager::mojom

namespace mojo {


template <>
struct  StructTraits<::certificate_manager::mojom::SummaryCertInfo::DataView,
                                         ::certificate_manager::mojom::SummaryCertInfoPtr> {
  static bool IsNull(const ::certificate_manager::mojom::SummaryCertInfoPtr& input) { return !input; }
  static void SetToNull(::certificate_manager::mojom::SummaryCertInfoPtr* output) { output->reset(); }

  static const decltype(::certificate_manager::mojom::SummaryCertInfo::sha256hash_hex)& sha256hash_hex(
      const ::certificate_manager::mojom::SummaryCertInfoPtr& input) {
    return input->sha256hash_hex;
  }

  static const decltype(::certificate_manager::mojom::SummaryCertInfo::display_name)& display_name(
      const ::certificate_manager::mojom::SummaryCertInfoPtr& input) {
    return input->display_name;
  }

  static decltype(::certificate_manager::mojom::SummaryCertInfo::is_deletable) is_deletable(
      const ::certificate_manager::mojom::SummaryCertInfoPtr& input) {
    return input->is_deletable;
  }

  static bool Read(::certificate_manager::mojom::SummaryCertInfo::DataView input, ::certificate_manager::mojom::SummaryCertInfoPtr* output);
};


template <>
struct  StructTraits<::certificate_manager::mojom::CertManagementMetadata::DataView,
                                         ::certificate_manager::mojom::CertManagementMetadataPtr> {
  static bool IsNull(const ::certificate_manager::mojom::CertManagementMetadataPtr& input) { return !input; }
  static void SetToNull(::certificate_manager::mojom::CertManagementMetadataPtr* output) { output->reset(); }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::include_system_trust_store) include_system_trust_store(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->include_system_trust_store;
  }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::num_user_added_system_certs) num_user_added_system_certs(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->num_user_added_system_certs;
  }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::is_include_system_trust_store_managed) is_include_system_trust_store_managed(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->is_include_system_trust_store_managed;
  }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::num_policy_certs) num_policy_certs(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->num_policy_certs;
  }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::num_user_certs) num_user_certs(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->num_user_certs;
  }

  static decltype(::certificate_manager::mojom::CertManagementMetadata::show_user_certs_ui) show_user_certs_ui(
      const ::certificate_manager::mojom::CertManagementMetadataPtr& input) {
    return input->show_user_certs_ui;
  }

  static bool Read(::certificate_manager::mojom::CertManagementMetadata::DataView input, ::certificate_manager::mojom::CertManagementMetadataPtr* output);
};


template <>
struct  UnionTraits<::certificate_manager::mojom::ActionResult::DataView,
                                        ::certificate_manager::mojom::ActionResultPtr> {
  static bool IsNull(const ::certificate_manager::mojom::ActionResultPtr& input) { return !input; }
  static void SetToNull(::certificate_manager::mojom::ActionResultPtr* output) { output->reset(); }

  static ::certificate_manager::mojom::ActionResult::Tag GetTag(const ::certificate_manager::mojom::ActionResultPtr& input) {
    return input->which();
  }

  static const std::string& error(const ::certificate_manager::mojom::ActionResultPtr& input) {
    return input->get_error();
  }

  static  ::certificate_manager::mojom::SuccessResult success(const ::certificate_manager::mojom::ActionResultPtr& input) {
    return input->get_success();
  }

  static bool Read(::certificate_manager::mojom::ActionResult::DataView input, ::certificate_manager::mojom::ActionResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_H_