// chrome/browser/resources/certificate_manager/certificate_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SEND_VALIDATION_H_
#define CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-shared-internal.h"

#include "chrome/browser/resources/certificate_manager/certificate_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::certificate_manager::mojom::CertificateSource, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::certificate_manager::mojom::SuccessResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::certificate_manager::mojom::SummaryCertInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::certificate_manager::mojom::SummaryCertInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::certificate_manager::mojom::internal::SummaryCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sha256hash_hex(input)) in_sha256hash_hex = Traits::sha256hash_hex(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sha256hash_hex)::BaseType> sha256hash_hex_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sha256hash_hex,
        sha256hash_hex_fragment);

      fragment->sha256hash_hex.Set(
          sha256hash_hex_fragment.is_null() ? nullptr : sha256hash_hex_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sha256hash_hex.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sha256hash_hex in SummaryCertInfo struct");

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in SummaryCertInfo struct");

      fragment->is_deletable = Traits::is_deletable(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::certificate_manager::mojom::CertManagementMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::certificate_manager::mojom::CertManagementMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::certificate_manager::mojom::internal::CertManagementMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->include_system_trust_store = Traits::include_system_trust_store(input);

      fragment->num_user_added_system_certs = Traits::num_user_added_system_certs(input);

      fragment->is_include_system_trust_store_managed = Traits::is_include_system_trust_store_managed(input);

      fragment->num_policy_certs = Traits::num_policy_certs(input);

      fragment->num_user_certs = Traits::num_user_certs(input);

      fragment->show_user_certs_ui = Traits::show_user_certs_ui(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::certificate_manager::mojom::ActionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::certificate_manager::mojom::ActionResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::certificate_manager::mojom::internal::ActionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::certificate_manager::mojom::ActionResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in ActionResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::certificate_manager::mojom::ActionResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::certificate_manager::mojom::SuccessResult, send_validation>(
  in_success,
  &fragment->data.f_success);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CHROME_BROWSER_RESOURCES_CERTIFICATE_MANAGER_CERTIFICATE_MANAGER_MOJOM_SEND_VALIDATION_H_