// components/browsing_topics/mojom/browsing_topics_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  String16Spec as mojoBase_mojom_String16Spec,
  String16 as mojoBase_mojom_String16
} from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';







export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'browsing_topics.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  getBrowsingTopicsConfiguration(): Promise<{
        config: WebUIBrowsingTopicsConfiguration, }>;
  getBrowsingTopicsState(calculateNow: boolean): Promise<{
        result: WebUIGetBrowsingTopicsStateResult, }>;
  getModelInfo(): Promise<{
        result: WebUIGetModelInfoResult, }>;
  classifyHosts(hosts: string[]): Promise<{
        topicsForHosts: WebUITopic[][], }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getBrowsingTopicsConfiguration(): Promise<{
        config: WebUIBrowsingTopicsConfiguration, }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getBrowsingTopicsState(
      calculateNow: boolean): Promise<{
        result: WebUIGetBrowsingTopicsStateResult, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetBrowsingTopicsState_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$,
        [
          calculateNow
        ],
        false);
  }

  getModelInfo(): Promise<{
        result: WebUIGetModelInfoResult, }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetModelInfo_ParamsSpec.$,
        PageHandler_GetModelInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  classifyHosts(
      hosts: string[]): Promise<{
        topicsForHosts: WebUITopic[][], }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_ClassifyHosts_ParamsSpec.$,
        PageHandler_ClassifyHosts_ResponseParamsSpec.$,
        [
          hosts
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$,
        impl.getBrowsingTopicsConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetBrowsingTopicsState_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$,
        impl.getBrowsingTopicsState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetModelInfo_ParamsSpec.$,
        PageHandler_GetModelInfo_ResponseParamsSpec.$,
        impl.getModelInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_ClassifyHosts_ParamsSpec.$,
        PageHandler_ClassifyHosts_ResponseParamsSpec.$,
        impl.classifyHosts.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "browsing_topics.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getBrowsingTopicsConfiguration: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getBrowsingTopicsState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getModelInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  classifyHosts: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getBrowsingTopicsConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$,
        this.getBrowsingTopicsConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getBrowsingTopicsState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetBrowsingTopicsState_ParamsSpec.$,
        PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$,
        this.getBrowsingTopicsState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getModelInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetModelInfo_ParamsSpec.$,
        PageHandler_GetModelInfo_ResponseParamsSpec.$,
        this.getModelInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    this.classifyHosts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_ClassifyHosts_ParamsSpec.$,
        PageHandler_ClassifyHosts_ResponseParamsSpec.$,
        this.classifyHosts.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const WebUIBrowsingTopicsConfigurationSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUITopicSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIEpochSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIBrowsingTopicsStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIModelInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBrowsingTopicsState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetBrowsingTopicsState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModelInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModelInfo_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClassifyHosts_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ClassifyHosts_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIGetBrowsingTopicsStateResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WebUIGetModelInfoResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface WebUIBrowsingTopicsConfigurationMojoType {
  browsingTopicsEnabled: boolean;
  privacySandboxAdsApisOverrideEnabled: boolean;
  overridePrivacySandboxSettingsLocalTestingEnabled: boolean;
  browsingTopicsBypassIpIsPubliclyRoutableCheckEnabled: boolean;
  browsingTopicsDocumentApiEnabled: boolean;
  browsingTopicsParametersEnabled: boolean;
  configVersion: number;
  numberOfEpochsToExpose: number;
  numberOfTopTopicsPerEpoch: number;
  timePeriodPerEpoch: mojoBase_mojom_TimeDelta;
  useRandomTopicProbabilityPercent: number;
  numberOfEpochsOfObservationDataToUseForFiltering: number;
  maxEpochIntroductionDelay: mojoBase_mojom_TimeDelta;
  maxNumberOfApiUsageContextDomainsToKeepPerTopic: number;
  maxNumberOfApiUsageContextEntriesToLoadPerEpoch: number;
  maxNumberOfApiUsageContextDomainsToStorePerPageLoad: number;
  taxonomyVersion: number;
  disabledTopicsList: string;
}


export type WebUIBrowsingTopicsConfiguration = WebUIBrowsingTopicsConfigurationMojoType;
mojo.internal.Struct<WebUIBrowsingTopicsConfigurationMojoType>(
    WebUIBrowsingTopicsConfigurationSpec.$,
    'WebUIBrowsingTopicsConfiguration',
    [
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'browsingTopicsEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'privacySandboxAdsApisOverrideEnabled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'overridePrivacySandboxSettingsLocalTestingEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'browsingTopicsBypassIpIsPubliclyRoutableCheckEnabled', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'browsingTopicsDocumentApiEnabled', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'configVersion', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, boolean>(
        'browsingTopicsParametersEnabled', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'numberOfEpochsToExpose', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, mojoBase_mojom_TimeDelta>(
        'timePeriodPerEpoch', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'numberOfTopTopicsPerEpoch', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'useRandomTopicProbabilityPercent', 24,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, mojoBase_mojom_TimeDelta>(
        'maxEpochIntroductionDelay', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'numberOfEpochsOfObservationDataToUseForFiltering', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'maxNumberOfApiUsageContextDomainsToKeepPerTopic', 40,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'maxNumberOfApiUsageContextEntriesToLoadPerEpoch', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'maxNumberOfApiUsageContextDomainsToStorePerPageLoad', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, number>(
        'taxonomyVersion', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsConfigurationMojoType, string>(
        'disabledTopicsList', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface WebUITopicMojoType {
  topicId: number;
  isRealTopic: boolean;
  topicName: mojoBase_mojom_String16;
  observedByDomains: string[];
}


export type WebUITopic = WebUITopicMojoType;
mojo.internal.Struct<WebUITopicMojoType>(
    WebUITopicSpec.$,
    'WebUITopic',
    [
      mojo.internal.StructField<WebUITopicMojoType, number>(
        'topicId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUITopicMojoType, mojoBase_mojom_String16>(
        'topicName', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUITopicMojoType, boolean>(
        'isRealTopic', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUITopicMojoType, string[]>(
        'observedByDomains', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface WebUIEpochMojoType {
  topics: WebUITopic[];
  calculationTime: mojoBase_mojom_Time;
  modelVersion: string;
  taxonomyVersion: string;
}


export type WebUIEpoch = WebUIEpochMojoType;
mojo.internal.Struct<WebUIEpochMojoType>(
    WebUIEpochSpec.$,
    'WebUIEpoch',
    [
      mojo.internal.StructField<WebUIEpochMojoType, WebUITopic[]>(
        'topics', 0,
        0,
        mojo.internal.Array(WebUITopicSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIEpochMojoType, mojoBase_mojom_Time>(
        'calculationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIEpochMojoType, string>(
        'modelVersion', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIEpochMojoType, string>(
        'taxonomyVersion', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface WebUIBrowsingTopicsStateMojoType {
  epochs: WebUIEpoch[];
  nextScheduledCalculationTime: mojoBase_mojom_Time;
}


export type WebUIBrowsingTopicsState = WebUIBrowsingTopicsStateMojoType;
mojo.internal.Struct<WebUIBrowsingTopicsStateMojoType>(
    WebUIBrowsingTopicsStateSpec.$,
    'WebUIBrowsingTopicsState',
    [
      mojo.internal.StructField<WebUIBrowsingTopicsStateMojoType, WebUIEpoch[]>(
        'epochs', 0,
        0,
        mojo.internal.Array(WebUIEpochSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIBrowsingTopicsStateMojoType, mojoBase_mojom_Time>(
        'nextScheduledCalculationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface WebUIModelInfoMojoType {
  modelVersion: string;
  modelFilePath: string;
}


export type WebUIModelInfo = WebUIModelInfoMojoType;
mojo.internal.Struct<WebUIModelInfoMojoType>(
    WebUIModelInfoSpec.$,
    'WebUIModelInfo',
    [
      mojo.internal.StructField<WebUIModelInfoMojoType, string>(
        'modelVersion', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WebUIModelInfoMojoType, string>(
        'modelFilePath', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetBrowsingTopicsConfiguration_ParamsMojoType {
}


export type PageHandler_GetBrowsingTopicsConfiguration_Params = PageHandler_GetBrowsingTopicsConfiguration_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetBrowsingTopicsConfiguration_ParamsMojoType>(
    PageHandler_GetBrowsingTopicsConfiguration_ParamsSpec.$,
    'PageHandler_GetBrowsingTopicsConfiguration_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsMojoType {
  config: WebUIBrowsingTopicsConfiguration;
}


export type PageHandler_GetBrowsingTopicsConfiguration_ResponseParams = PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsMojoType>(
    PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsSpec.$,
    'PageHandler_GetBrowsingTopicsConfiguration_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetBrowsingTopicsConfiguration_ResponseParamsMojoType, WebUIBrowsingTopicsConfiguration>(
        'config', 0,
        0,
        WebUIBrowsingTopicsConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetBrowsingTopicsState_ParamsMojoType {
  calculateNow: boolean;
}


export type PageHandler_GetBrowsingTopicsState_Params = PageHandler_GetBrowsingTopicsState_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetBrowsingTopicsState_ParamsMojoType>(
    PageHandler_GetBrowsingTopicsState_ParamsSpec.$,
    'PageHandler_GetBrowsingTopicsState_Params',
    [
      mojo.internal.StructField<PageHandler_GetBrowsingTopicsState_ParamsMojoType, boolean>(
        'calculateNow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetBrowsingTopicsState_ResponseParamsMojoType {
  result: WebUIGetBrowsingTopicsStateResult;
}


export type PageHandler_GetBrowsingTopicsState_ResponseParams = PageHandler_GetBrowsingTopicsState_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetBrowsingTopicsState_ResponseParamsMojoType>(
    PageHandler_GetBrowsingTopicsState_ResponseParamsSpec.$,
    'PageHandler_GetBrowsingTopicsState_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetBrowsingTopicsState_ResponseParamsMojoType, WebUIGetBrowsingTopicsStateResult>(
        'result', 0,
        0,
        WebUIGetBrowsingTopicsStateResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_GetModelInfo_ParamsMojoType {
}


export type PageHandler_GetModelInfo_Params = PageHandler_GetModelInfo_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetModelInfo_ParamsMojoType>(
    PageHandler_GetModelInfo_ParamsSpec.$,
    'PageHandler_GetModelInfo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetModelInfo_ResponseParamsMojoType {
  result: WebUIGetModelInfoResult;
}


export type PageHandler_GetModelInfo_ResponseParams = PageHandler_GetModelInfo_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetModelInfo_ResponseParamsMojoType>(
    PageHandler_GetModelInfo_ResponseParamsSpec.$,
    'PageHandler_GetModelInfo_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetModelInfo_ResponseParamsMojoType, WebUIGetModelInfoResult>(
        'result', 0,
        0,
        WebUIGetModelInfoResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ClassifyHosts_ParamsMojoType {
  hosts: string[];
}


export type PageHandler_ClassifyHosts_Params = PageHandler_ClassifyHosts_ParamsMojoType;
mojo.internal.Struct<PageHandler_ClassifyHosts_ParamsMojoType>(
    PageHandler_ClassifyHosts_ParamsSpec.$,
    'PageHandler_ClassifyHosts_Params',
    [
      mojo.internal.StructField<PageHandler_ClassifyHosts_ParamsMojoType, string[]>(
        'hosts', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ClassifyHosts_ResponseParamsMojoType {
  topicsForHosts: WebUITopic[][];
}


export type PageHandler_ClassifyHosts_ResponseParams = PageHandler_ClassifyHosts_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ClassifyHosts_ResponseParamsMojoType>(
    PageHandler_ClassifyHosts_ResponseParamsSpec.$,
    'PageHandler_ClassifyHosts_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ClassifyHosts_ResponseParamsMojoType, WebUITopic[][]>(
        'topicsForHosts', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(WebUITopicSpec.$, false), false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    WebUIGetBrowsingTopicsStateResultSpec.$, 'WebUIGetBrowsingTopicsStateResult',
    {
      'overrideStatusMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'browsingTopicsState': {
        'ordinal': 1,
        'type': WebUIBrowsingTopicsStateSpec.$,
      },
    });

export interface WebUIGetBrowsingTopicsStateResult {
  overrideStatusMessage?: string,
  browsingTopicsState?: WebUIBrowsingTopicsState,
}

export enum WebUIGetBrowsingTopicsStateResultFieldTags {
  OVERRIDE_STATUS_MESSAGE,
  BROWSING_TOPICS_STATE,
}

export function whichWebUIGetBrowsingTopicsStateResult(u: WebUIGetBrowsingTopicsStateResult): WebUIGetBrowsingTopicsStateResultFieldTags {
  if (u.overrideStatusMessage !== null && u.overrideStatusMessage !== undefined) {
    return WebUIGetBrowsingTopicsStateResultFieldTags.OVERRIDE_STATUS_MESSAGE;
  }
  if (u.browsingTopicsState !== null && u.browsingTopicsState !== undefined) {
    return WebUIGetBrowsingTopicsStateResultFieldTags.BROWSING_TOPICS_STATE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    WebUIGetModelInfoResultSpec.$, 'WebUIGetModelInfoResult',
    {
      'overrideStatusMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'modelInfo': {
        'ordinal': 1,
        'type': WebUIModelInfoSpec.$,
      },
    });

export interface WebUIGetModelInfoResult {
  overrideStatusMessage?: string,
  modelInfo?: WebUIModelInfo,
}

export enum WebUIGetModelInfoResultFieldTags {
  OVERRIDE_STATUS_MESSAGE,
  MODEL_INFO,
}

export function whichWebUIGetModelInfoResult(u: WebUIGetModelInfoResult): WebUIGetModelInfoResultFieldTags {
  if (u.overrideStatusMessage !== null && u.overrideStatusMessage !== undefined) {
    return WebUIGetModelInfoResultFieldTags.OVERRIDE_STATUS_MESSAGE;
  }
  if (u.modelInfo !== null && u.modelInfo !== undefined) {
    return WebUIGetModelInfoResultFieldTags.MODEL_INFO;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
