/**
 * @return {{current: ?BluetoothSnackbarElement, numPending: number}}
 */
export function getSnackbarStateForTest(): {
    current: BluetoothSnackbarElement | null;
    numPending: number;
};
/**
 * TODO(crbug.com/40498702): Add ability to specify parent element to Snackbar.
 * Creates a Snackbar and shows it if one is not showing already. If a
 * Snackbar is already active, the next Snackbar is queued.
 * @param {string} message The message to display in the Snackbar.
 * @param {string=} opt_type A string determining the Snackbar type: info,
 *     success, warning, error. If not provided, info type is used.
 * @param {string=} opt_actionText The text to display for the action link.
 * @param {function()=} opt_action A function to be called when the user
 *     presses the action link.
 * @return {!BluetoothSnackbarElement}
 */
export function showSnackbar(message: string, opt_type?: string | undefined, opt_actionText?: string | undefined, opt_action?: (() => any) | undefined): BluetoothSnackbarElement;
/**
 * Dismisses the Snackbar currently showing.
 * @param {boolean} clearQueue If true, clears the Snackbar queue before
 *     dismissing.
 * @return {!Promise}
 */
export function dismissSnackbar(clearQueue: boolean): Promise<any>;
/**
 * Enum of Snackbar types. Used by Snackbar to determine the styling for the
 * Snackbar.
 */
export type SnackbarType = string;
export namespace SnackbarType {
    let INFO: string;
    let SUCCESS: string;
    let WARNING: string;
    let ERROR: string;
}
/**
 * Notification bar for displaying a simple message with an action link.
 * This element should not be instantiated directly. Instead, users should
 * use the showSnackbar and dismissSnackbar functions to ensure proper
 * queuing of messages.
 */
declare class BluetoothSnackbarElement extends CustomElement {
    static get is(): string;
    /** @type {?Function} */
    boundStartTimeout_: Function | null;
    /** @type {?Function} */
    boundStopTimeout_: Function | null;
    /** @type {?number} */
    timeoutId_: number | null;
    /** @type {?SnackbarOptions} */
    options_: SnackbarOptions | null;
    connectedCallback(): void;
    /**
     * Initializes the content of the Snackbar with the given |options|
     * including the message, action link text, and click action of the link.
     * This must be called before the element is added to the DOM.
     * @param {!SnackbarOptions} options
     */
    initialize(options: SnackbarOptions): void;
    /**
     * Shows the Snackbar and dispatches the 'showed' event.
     */
    show(): void;
    /**
     * transitionend does not always fire (e.g. when animation is aborted
     * or when no paint happens during the animation). This function sets up
     * a timer and emulate the event if it is not fired when the timer expires.
     * @private
     */
    private ensureTransitionEndEvent_;
    /**
     * Dismisses the Snackbar. Once the Snackbar is completely hidden, the
     * 'dismissed' event is fired and the returned Promise is resolved. If the
     * snackbar is already hidden, a resolved Promise is returned.
     * @return {!Promise}
     */
    dismiss(): Promise<any>;
    /**
     * Starts the timeout for dismissing the Snackbar.
     * @private
     */
    private startTimeout_;
    /**
     * Stops the timeout for dismissing the Snackbar. Only clears the timeout
     * when the Snackbar is open.
     * @private
     */
    private stopTimeout_;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
type SnackbarOptions = {
    message: string;
    type: string;
    actionText: (string | undefined);
    action: ((() => any) | undefined);
};
/**
 * Javascript for Snackbar controls, served from chrome://bluetooth-internals/.
 */
/**
 * @typedef {{
 *    message: string,
 *    type: string,
 *    actionText: (string|undefined),
 *    action: (function()|undefined)
 *  }}
 */
declare let SnackbarOptions: any;
export {};
