/**
 * A list item that displays the data in a ServiceInfo object. The brief
 * section contains the UUID of the given |serviceInfo|. The expanded section
 * contains an ObjectFieldSetElement that displays all of the properties in the
 * given |serviceInfo|. Data is not loaded until the ServiceListItem is
 * expanded for the first time.
 */
export class ServiceListItemElement extends CustomElement {
    /** @type {?ServiceInfo} */
    info: ServiceInfo | null;
    /** @private {string} */
    private deviceAddress_;
    connectedCallback(): void;
    /**
     * @param {!ServiceInfo} serviceInfo
     * @param {string} deviceAddress
     */
    initialize(serviceInfo: ServiceInfo, deviceAddress: string): void;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
