/**
 * A fieldset that lists the properties of a given object. These properties
 * are displayed as a series of rows for each key-value pair.
 * Only the object's own properties are displayed. Boolean values are
 * displayed using images: a green check for 'true', and a red cancel 'x' for
 * 'false'. All other types are converted to their string representation for
 * display.
 */
export class ObjectFieldSetElement extends CustomElement {
    static get is(): string;
    static get observedAttributes(): string[];
    /** @return {boolean} */
    get showAll(): boolean;
    /** @return {Object} */
    get value(): Object;
    /**
     * Deletes and recreates the table structure with current object data if the
     * object data or "show-all" property have changed.
     */
    attributeChangedCallback(name: any, oldValue: any, newValue: any): void;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
