export class ExpandableListElement extends CustomElement {
    connectedCallback(): void;
    /**
     * Sets the data model of the list.
     * @param {Array} data
     */
    setData(data: any[]): void;
    createItem(itemData: any): void;
    /**
     * Sets the empty message text.
     * @param {string} message
     */
    setEmptyMessage(message: string): void;
    /**
     * Sets the spinner display state. If |showing| is true, the loading
     * spinner is dispayed.
     * @param {boolean} showing
     */
    setSpinnerShowing(showing: boolean): void;
    /**
     * Gets the spinner display state. Returns true if the spinner is showing.
     * @return {boolean}
     */
    isSpinnerShowing(): boolean;
    /**
     * Updates the display state of the empty message. If there are no items in
     * the data model, the empty message is displayed.
     * @param {boolean} empty Whether the list is empty.
     */
    updateMessageDisplay_(empty: boolean): void;
}
import { CustomElement } from 'chrome://resources/js/custom_element.js';
