// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{AdapterObserverReceiver,AdapterRemote,ConnectResult,DiscoverySessionRemote}from"./adapter.mojom-webui.js";import{BluetoothInternalsHandler,BluetoothInternalsHandlerRemote}from"./bluetooth_internals.mojom-webui.js";import{Device,DeviceRemote}from"./device.mojom-webui.js";const SCAN_CLIENT_NAME="Bluetooth Internals Page";export const AdapterProperty={DISCOVERABLE:"discoverable",DISCOVERING:"discovering",POWERED:"powered",PRESENT:"present"};export class AdapterBroker extends EventTarget{constructor(adapter){super();this.adapterObserverReceiver_=new AdapterObserverReceiver(this);this.adapter_=adapter;this.adapter_.addObserver(this.adapterObserverReceiver_.$.bindNewPipeAndPassRemote())}presentChanged(present){this.dispatchEvent(new CustomEvent("adapterchanged",{detail:{property:AdapterProperty.PRESENT,value:present}}))}poweredChanged(powered){this.dispatchEvent(new CustomEvent("adapterchanged",{detail:{property:AdapterProperty.POWERED,value:powered}}))}discoverableChanged(discoverable){this.dispatchEvent(new CustomEvent("adapterchanged",{detail:{property:AdapterProperty.DISCOVERABLE,value:discoverable}}))}discoveringChanged(discovering){this.dispatchEvent(new CustomEvent("adapterchanged",{detail:{property:AdapterProperty.DISCOVERING,value:discovering}}))}deviceAdded(device){this.dispatchEvent(new CustomEvent("deviceadded",{detail:{deviceInfo:device}}))}deviceChanged(device){this.dispatchEvent(new CustomEvent("devicechanged",{detail:{deviceInfo:device}}))}deviceRemoved(device){this.dispatchEvent(new CustomEvent("deviceremoved",{detail:{deviceInfo:device}}))}connectToDevice(address){return this.adapter_.connectToDevice(address).then((function(response){if(response.result!==ConnectResult.SUCCESS){const errorString=Object.keys(ConnectResult).find((function(key){return ConnectResult[key]===response.result}));throw new Error(errorString)}return response.device}))}getDevices(){return this.adapter_.getDevices()}getInfo(){return this.adapter_.getInfo()}startDiscoverySession(){return this.adapter_.startDiscoverySession(SCAN_CLIENT_NAME).then((function(response){if(!response.session){throw new Error("Discovery session failed to start")}return response.session}))}}let adapterBroker=null;export function getAdapterBroker(opt_bluetoothInternalsHandler){if(adapterBroker){return Promise.resolve(adapterBroker)}const bluetoothInternalsHandler=opt_bluetoothInternalsHandler?opt_bluetoothInternalsHandler:BluetoothInternalsHandler.getRemote();return bluetoothInternalsHandler.getAdapter().then((function(response){if(!response.adapter){throw new Error("Bluetooth Not Supported on this platform.")}adapterBroker=new AdapterBroker(response.adapter);return adapterBroker}))}