import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { AddSinkResultCode } from '../access_code_cast.mojom-webui.js';
import { RouteRequestResultCode } from '../route_request_result_code.mojom-webui.js';
declare enum ErrorMessage {
    NO_ERROR = 0,
    GENERIC = 1,
    ACCESS_CODE = 2,
    NETWORK = 3,
    PERMISSION = 4,
    TOO_MANY_REQUESTS = 5,
    PROFILE_SYNC_ERROR = 6,
    DIFFERENT_NETWORK = 7
}
export declare class ErrorMessageElement extends PolymerElement {
    private static readonly ADD_RESULT_MESSAGE_CODES;
    private static readonly CAST_RESULT_MESSAGE_CODES;
    private static readonly ADD_RESULT_MESSAGE_MAP;
    private static readonly CAST_RESULT_MESSAGE_MAP;
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        errorMessageEnum: {
            type: ObjectConstructor;
            value: typeof ErrorMessage;
        };
        messageCode: {
            type: NumberConstructor;
            value: ErrorMessage;
        };
    };
    private errorMessageEnum;
    private messageCode;
    setAddSinkError(resultCode: AddSinkResultCode): void;
    setCastError(resultCode: RouteRequestResultCode): void;
    setNoError(): void;
    getMessageCode(): any;
    isEqual(a: ErrorMessage, b: ErrorMessage): boolean;
    isNotEqual(a: ErrorMessage, b: ErrorMessage): boolean;
    private findErrorMessage;
}
declare global {
    interface HTMLElementTagNameMap {
        'c2c-error-message': ErrorMessageElement;
    }
}
export {};
