import './passcode_input/passcode_input.js';
import './error_message/error_message.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import 'chrome://resources/cr_elements/icons.html.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ErrorMessageElement } from './error_message/error_message.js';
import type { PasscodeInputElement } from './passcode_input/passcode_input.js';
export interface AccessCodeCastElement {
    $: {
        backButton: CrButtonElement;
        castButton: CrButtonElement;
        codeInputView: HTMLElement;
        codeInput: PasscodeInputElement;
        dialog: CrDialogElement;
        errorMessage: ErrorMessageElement;
        qrInputView: HTMLElement;
    };
}
declare const AccessCodeCastElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class AccessCodeCastElement extends AccessCodeCastElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        accessCode: {
            type: StringConstructor;
            value: string;
            observer: string;
        };
        canCast: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
        inputLabel: StringConstructor;
        isWin: BooleanConstructor;
        managedFootnote: StringConstructor;
        qrScannerEnabled: BooleanConstructor;
        rememberDevices: BooleanConstructor;
        submitDisabled: BooleanConstructor;
    };
    private listenerIds;
    private router;
    private static readonly ACCESS_CODE_LENGTH;
    private accessCode;
    private canCast;
    private inputEnabledStartTime;
    private inputLabel;
    private isWin;
    private managedFootnote;
    private qrScannerEnabled;
    private rememberDevices;
    private state;
    private submitDisabled;
    constructor();
    ready(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    cancelButtonPressed(): void;
    switchToCodeInput(): void;
    switchToQrInput(): void;
    addSinkAndCast(): Promise<void>;
    createManagedFootnote(duration: number): Promise<void>;
    setAccessCodeForTest(value: string): void;
    getManagedFootnoteForTest(): string;
    private afterFailedAddAndCast;
    private castStateChange;
    private setState;
    private handleCodeInput;
    private handleEnterPressed;
    private addSink;
    private cast;
    private makeFootnote;
}
declare global {
    interface HTMLElementTagNameMap {
        'access-code-cast-app': AccessCodeCastElement;
    }
}
export {};
