// chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/url_visit_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/url_visit_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/new_tab_page/modules/v2/most_relevant_tab_resumption/url_visit_types.mojom-params-data.h"
namespace ntp {
namespace most_relevant_tab_resumption {
namespace mojom {

NOINLINE static const char* FormFactorToStringHelper(FormFactor value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormFactor::kUnknown:
      return "kUnknown";
    case FormFactor::kDesktop:
      return "kDesktop";
    case FormFactor::kPhone:
      return "kPhone";
    case FormFactor::kTablet:
      return "kTablet";
    case FormFactor::kAutomotive:
      return "kAutomotive";
    case FormFactor::kWearable:
      return "kWearable";
    case FormFactor::kTv:
      return "kTv";
    default:
      return nullptr;
  }
}

std::string FormFactorToString(FormFactor value) {
  const char *str = FormFactorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormFactor value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormFactor value) {
  return os << FormFactorToString(value);
}

NOINLINE static const char* DecorationTypeToStringHelper(DecorationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DecorationType::kVisitedXAgo:
      return "kVisitedXAgo";
    case DecorationType::kMostRecent:
      return "kMostRecent";
    case DecorationType::kFrequentlyVisited:
      return "kFrequentlyVisited";
    case DecorationType::kFrequentlyVisitedAtTime:
      return "kFrequentlyVisitedAtTime";
    default:
      return nullptr;
  }
}

std::string DecorationTypeToString(DecorationType value) {
  const char *str = DecorationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DecorationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DecorationType value) {
  return os << DecorationTypeToString(value);
}

NOINLINE static const char* VisitSourceToStringHelper(VisitSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VisitSource::kTab:
      return "kTab";
    case VisitSource::kHistory:
      return "kHistory";
    default:
      return nullptr;
  }
}

std::string VisitSourceToString(VisitSource value) {
  const char *str = VisitSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VisitSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VisitSource value) {
  return os << VisitSourceToString(value);
}

namespace internal {


// static
bool Decoration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Decoration_Data* object =
      static_cast<const Decoration_Data*>(data);


  if (!::ntp::most_relevant_tab_resumption::mojom::internal::DecorationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_string, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_string, validation_context,
                                         &display_string_validate_params)) {
    return false;
  }

  return true;
}

Decoration_Data::Decoration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLVisit_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLVisit_Data* object =
      static_cast<const URLVisit_Data*>(data);


  if (!::ntp::most_relevant_tab_resumption::mojom::internal::FormFactor_Data
        ::Validate(object->form_factor, validation_context))
    return false;


  if (!::ntp::most_relevant_tab_resumption::mojom::internal::VisitSource_Data
        ::Validate(object->source, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& session_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_name, validation_context,
                                         &session_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decoration, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->decoration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_key, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_key, validation_context,
                                         &url_key_validate_params)) {
    return false;
  }

  return true;
}

URLVisit_Data::URLVisit_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace most_relevant_tab_resumption
}  // namespace ntp

namespace perfetto {

// static
void TraceFormatTraits<::ntp::most_relevant_tab_resumption::mojom::FormFactor>::WriteIntoTrace(
   perfetto::TracedValue context, ::ntp::most_relevant_tab_resumption::mojom::FormFactor value) {
  return std::move(context).WriteString(::ntp::most_relevant_tab_resumption::mojom::FormFactorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ntp::most_relevant_tab_resumption::mojom::DecorationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ntp::most_relevant_tab_resumption::mojom::DecorationType value) {
  return std::move(context).WriteString(::ntp::most_relevant_tab_resumption::mojom::DecorationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::ntp::most_relevant_tab_resumption::mojom::VisitSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::ntp::most_relevant_tab_resumption::mojom::VisitSource value) {
  return std::move(context).WriteString(::ntp::most_relevant_tab_resumption::mojom::VisitSourceToString(value));
}

} // namespace perfetto