// chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom-params-data.h"
#include "chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom-shared-message-ids.h"

#include "chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom-import-headers.h"
#include "chrome/browser/new_tab_page/modules/file_suggestion/drive_suggestion.mojom-test-utils.h"


namespace file_suggestion::mojom {
// The declaration includes the definition on other builds.

DriveSuggestionHandler::IPCStableHashFunction DriveSuggestionHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DriveSuggestionHandler>(message.name())) {
    case messages::DriveSuggestionHandler::kGetFiles: {
      return &DriveSuggestionHandler::GetFiles_Sym::IPCStableHash;
    }
    case messages::DriveSuggestionHandler::kDismissModule: {
      return &DriveSuggestionHandler::DismissModule_Sym::IPCStableHash;
    }
    case messages::DriveSuggestionHandler::kRestoreModule: {
      return &DriveSuggestionHandler::RestoreModule_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DriveSuggestionHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DriveSuggestionHandler>(message.name())) {
      case messages::DriveSuggestionHandler::kGetFiles:
            return "Receive file_suggestion::mojom::DriveSuggestionHandler::GetFiles";
      case messages::DriveSuggestionHandler::kDismissModule:
            return "Receive file_suggestion::mojom::DriveSuggestionHandler::DismissModule";
      case messages::DriveSuggestionHandler::kRestoreModule:
            return "Receive file_suggestion::mojom::DriveSuggestionHandler::RestoreModule";
    }
  } else {
    switch (static_cast<messages::DriveSuggestionHandler>(message.name())) {
      case messages::DriveSuggestionHandler::kGetFiles:
            return "Receive reply file_suggestion::mojom::DriveSuggestionHandler::GetFiles";
      case messages::DriveSuggestionHandler::kDismissModule:
            return "Receive reply file_suggestion::mojom::DriveSuggestionHandler::DismissModule";
      case messages::DriveSuggestionHandler::kRestoreModule:
            return "Receive reply file_suggestion::mojom::DriveSuggestionHandler::RestoreModule";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DriveSuggestionHandler::GetFiles_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5089a06;  // IPCStableHash for file_suggestion::mojom::DriveSuggestionHandler::GetFiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DriveSuggestionHandler::DismissModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1e8c77a;  // IPCStableHash for file_suggestion::mojom::DriveSuggestionHandler::DismissModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DriveSuggestionHandler::RestoreModule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62b87fa1;  // IPCStableHash for file_suggestion::mojom::DriveSuggestionHandler::RestoreModule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DriveSuggestionHandler_GetFiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DriveSuggestionHandler_GetFiles_ForwardToCallback(
      DriveSuggestionHandler::GetFilesCallback callback
      ) : callback_(std::move(callback)) {
  }

  DriveSuggestionHandler_GetFiles_ForwardToCallback(const DriveSuggestionHandler_GetFiles_ForwardToCallback&) = delete;
  DriveSuggestionHandler_GetFiles_ForwardToCallback& operator=(const DriveSuggestionHandler_GetFiles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DriveSuggestionHandler::GetFilesCallback callback_;
};

DriveSuggestionHandlerProxy::DriveSuggestionHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DriveSuggestionHandlerProxy::GetFiles(
    GetFilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send file_suggestion::mojom::DriveSuggestionHandler::GetFiles");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DriveSuggestionHandler::kGetFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::file_suggestion::mojom::internal::DriveSuggestionHandler_GetFiles_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DriveSuggestionHandler::Name_);
  message.set_method_name("GetFiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DriveSuggestionHandler_GetFiles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void DriveSuggestionHandlerProxy::DismissModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send file_suggestion::mojom::DriveSuggestionHandler::DismissModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DriveSuggestionHandler::kDismissModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::file_suggestion::mojom::internal::DriveSuggestionHandler_DismissModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DriveSuggestionHandler::Name_);
  message.set_method_name("DismissModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DriveSuggestionHandlerProxy::RestoreModule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send file_suggestion::mojom::DriveSuggestionHandler::RestoreModule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DriveSuggestionHandler::kRestoreModule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::file_suggestion::mojom::internal::DriveSuggestionHandler_RestoreModule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DriveSuggestionHandler::Name_);
  message.set_method_name("RestoreModule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class DriveSuggestionHandler_GetFiles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DriveSuggestionHandler::GetFilesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DriveSuggestionHandler_GetFiles_ProxyToResponder> proxy(
        new DriveSuggestionHandler_GetFiles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DriveSuggestionHandler_GetFiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DriveSuggestionHandler_GetFiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DriveSuggestionHandler_GetFiles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DriveSuggestionHandler::GetFilesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::file_suggestion::mojom::FilePtr> in_files);
};

bool DriveSuggestionHandler_GetFiles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DriveSuggestionHandler_GetFiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DriveSuggestionHandler_GetFiles_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DriveSuggestionHandler.0
  bool success = true;
  std::vector<::file_suggestion::mojom::FilePtr> p_files{};
  DriveSuggestionHandler_GetFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFiles(&p_files))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DriveSuggestionHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_files));
  }
  return true;
}

void DriveSuggestionHandler_GetFiles_ProxyToResponder::Run(
    std::vector<::file_suggestion::mojom::FilePtr> in_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply file_suggestion::mojom::DriveSuggestionHandler::GetFiles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type std::vector<::file_suggestion::mojom::FilePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DriveSuggestionHandler::kGetFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::file_suggestion::mojom::internal::DriveSuggestionHandler_GetFiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::file_suggestion::mojom::FileDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DriveSuggestionHandler::Name_);
  message.set_method_name("GetFiles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DriveSuggestionHandlerStubDispatch::Accept(
    DriveSuggestionHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DriveSuggestionHandler>(message->header()->name)) {
    case messages::DriveSuggestionHandler::kGetFiles: {
      break;
    }
    case messages::DriveSuggestionHandler::kDismissModule: {
      DCHECK(message->is_serialized());
      internal::DriveSuggestionHandler_DismissModule_Params_Data* params =
          reinterpret_cast<internal::DriveSuggestionHandler_DismissModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DriveSuggestionHandler.1
      bool success = true;
      DriveSuggestionHandler_DismissModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DriveSuggestionHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DismissModule(        );
      return true;
    }
    case messages::DriveSuggestionHandler::kRestoreModule: {
      DCHECK(message->is_serialized());
      internal::DriveSuggestionHandler_RestoreModule_Params_Data* params =
          reinterpret_cast<internal::DriveSuggestionHandler_RestoreModule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DriveSuggestionHandler.2
      bool success = true;
      DriveSuggestionHandler_RestoreModule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DriveSuggestionHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestoreModule(        );
      return true;
    }
  }
  return false;
}

// static
bool DriveSuggestionHandlerStubDispatch::AcceptWithResponder(
    DriveSuggestionHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DriveSuggestionHandler>(message->header()->name)) {
    case messages::DriveSuggestionHandler::kGetFiles: {
      internal::DriveSuggestionHandler_GetFiles_Params_Data* params =
          reinterpret_cast<
              internal::DriveSuggestionHandler_GetFiles_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DriveSuggestionHandler.0
      bool success = true;
      DriveSuggestionHandler_GetFiles_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DriveSuggestionHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          DriveSuggestionHandler_GetFiles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFiles(std::move(callback));
      return true;
    }
    case messages::DriveSuggestionHandler::kDismissModule: {
      break;
    }
    case messages::DriveSuggestionHandler::kRestoreModule: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDriveSuggestionHandlerValidationInfo[] = {
    { &internal::DriveSuggestionHandler_GetFiles_Params_Data::Validate,
     &internal::DriveSuggestionHandler_GetFiles_ResponseParams_Data::Validate},
    { &internal::DriveSuggestionHandler_DismissModule_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DriveSuggestionHandler_RestoreModule_Params_Data::Validate,
     nullptr /* no response */},
};

bool DriveSuggestionHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::file_suggestion::mojom::DriveSuggestionHandler::Name_,
    kDriveSuggestionHandlerValidationInfo);
}

bool DriveSuggestionHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::file_suggestion::mojom::DriveSuggestionHandler::Name_,
    kDriveSuggestionHandlerValidationInfo);
}


}  // file_suggestion::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace file_suggestion::mojom {


void DriveSuggestionHandlerInterceptorForTesting::GetFiles(GetFilesCallback callback) {
  GetForwardingInterface()->GetFiles(std::move(callback));
}
void DriveSuggestionHandlerInterceptorForTesting::DismissModule() {
  GetForwardingInterface()->DismissModule();
}
void DriveSuggestionHandlerInterceptorForTesting::RestoreModule() {
  GetForwardingInterface()->RestoreModule();
}
DriveSuggestionHandlerAsyncWaiter::DriveSuggestionHandlerAsyncWaiter(
    DriveSuggestionHandler* proxy) : proxy_(proxy) {}

DriveSuggestionHandlerAsyncWaiter::~DriveSuggestionHandlerAsyncWaiter() = default;


void DriveSuggestionHandlerAsyncWaiter::GetFiles(
    std::vector<::file_suggestion::mojom::FilePtr>* out_files) {
  base::RunLoop loop;
  proxy_->GetFiles(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::file_suggestion::mojom::FilePtr>* out_files
,
             std::vector<::file_suggestion::mojom::FilePtr> files) {*out_files = std::move(files);
            loop->Quit();
          },
          &loop,
          out_files));
  loop.Run();
}

std::vector<::file_suggestion::mojom::FilePtr> DriveSuggestionHandlerAsyncWaiter::GetFiles(
    ) {
  std::vector<::file_suggestion::mojom::FilePtr> async_wait_result;
  GetFiles(&async_wait_result);
  return async_wait_result;
}






}  // file_suggestion::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif