// chrome/browser/lens/core/mojom/text.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/lens/core/mojom/text.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/lens/core/mojom/text.mojom-params-data.h"
namespace lens {
namespace mojom {

NOINLINE static const char* WritingDirectionToStringHelper(WritingDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WritingDirection::kLeftToRight:
      return "kLeftToRight";
    case WritingDirection::kRightToLeft:
      return "kRightToLeft";
    case WritingDirection::kTopToBottom:
      return "kTopToBottom";
    default:
      return nullptr;
  }
}

std::string WritingDirectionToString(WritingDirection value) {
  const char *str = WritingDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WritingDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WritingDirection value) {
  return os << WritingDirectionToString(value);
}

NOINLINE static const char* AlignmentToStringHelper(Alignment value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Alignment::kDefaultLeftAlgined:
      return "kDefaultLeftAlgined";
    case Alignment::kRightAligned:
      return "kRightAligned";
    case Alignment::kCenterAligned:
      return "kCenterAligned";
    default:
      return nullptr;
  }
}

std::string AlignmentToString(Alignment value) {
  const char *str = AlignmentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Alignment value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Alignment value) {
  return os << AlignmentToString(value);
}

namespace internal {


// static
bool Text_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Text_Data* object =
      static_cast<const Text_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->text_layout, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  return true;
}

Text_Data::Text_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextLayout_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextLayout_Data* object =
      static_cast<const TextLayout_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->paragraphs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& paragraphs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->paragraphs, validation_context,
                                         &paragraphs_validate_params)) {
    return false;
  }

  return true;
}

TextLayout_Data::TextLayout_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Word_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Word_Data* object =
      static_cast<const Word_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->plain_text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& plain_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->plain_text, validation_context,
                                         &plain_text_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& text_separator_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_separator, validation_context,
                                         &text_separator_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;


  if (!::lens::mojom::internal::WritingDirection_Data
        ::Validate(object->writing_direction_$value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->formula_metadata, validation_context))
    return false;

  return true;
}

Word_Data::Word_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Line_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Line_Data* object =
      static_cast<const Line_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->words, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->words, validation_context,
                                         &words_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;

  return true;
}

Line_Data::Line_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundImageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundImageData_Data* object =
      static_cast<const BackgroundImageData_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->background_image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->background_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_size, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->text_mask, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->text_mask, validation_context))
    return false;

  return true;
}

BackgroundImageData_Data::BackgroundImageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslatedLine_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslatedLine_Data* object =
      static_cast<const TranslatedLine_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->words, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->words, validation_context,
                                         &words_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->translation, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& translation_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->translation, validation_context,
                                         &translation_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_color, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_primary_color, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_primary_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->background_image_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;

  return true;
}

TranslatedLine_Data::TranslatedLine_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TranslatedParagraph_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TranslatedParagraph_Data* object =
      static_cast<const TranslatedParagraph_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lines, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lines, validation_context,
                                         &lines_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resized_bitmap_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resized_bitmap_size, validation_context))
    return false;


  if (!::lens::mojom::internal::Alignment_Data
        ::Validate(object->alignment_$value, validation_context))
    return false;


  if (!::lens::mojom::internal::WritingDirection_Data
        ::Validate(object->writing_direction_$value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  return true;
}

TranslatedParagraph_Data::TranslatedParagraph_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Paragraph_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Paragraph_Data* object =
      static_cast<const Paragraph_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lines, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lines, validation_context,
                                         &lines_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->translation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;


  if (!::lens::mojom::internal::WritingDirection_Data
        ::Validate(object->writing_direction_$value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  return true;
}

Paragraph_Data::Paragraph_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FormulaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FormulaMetadata_Data* object =
      static_cast<const FormulaMetadata_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& latex_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->latex, validation_context,
                                         &latex_validate_params)) {
    return false;
  }

  return true;
}

FormulaMetadata_Data::FormulaMetadata_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace lens

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::WritingDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::WritingDirection value) {
  return std::move(context).WriteString(::lens::mojom::WritingDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::Alignment>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::Alignment value) {
  return std::move(context).WriteString(::lens::mojom::AlignmentToString(value));
}

} // namespace perfetto