// chrome/browser/lens/core/mojom/geometry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_H_
#define CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/lens/core/mojom/geometry.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/geometry.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/geometry.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/lens/core/mojom/polygon.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>








namespace lens::mojom {









class  CenterRotatedBox {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CenterRotatedBox, T>::value>;
  using DataView = CenterRotatedBoxDataView;
  using Data_ = internal::CenterRotatedBox_Data;
  using CoordinateType = CenterRotatedBox_CoordinateType;

  template <typename... Args>
  static CenterRotatedBoxPtr New(Args&&... args) {
    return CenterRotatedBoxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CenterRotatedBoxPtr From(const U& u) {
    return mojo::TypeConverter<CenterRotatedBoxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CenterRotatedBox>::Convert(*this);
  }


  CenterRotatedBox();

  CenterRotatedBox(
      const ::gfx::RectF& box,
      float rotation,
      CenterRotatedBox::CoordinateType coordinate_type);


  ~CenterRotatedBox();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CenterRotatedBoxPtr>
  CenterRotatedBoxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CenterRotatedBox::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CenterRotatedBox::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CenterRotatedBox::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CenterRotatedBox_UnserializedMessageContext<
            UserType, CenterRotatedBox::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CenterRotatedBox::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CenterRotatedBox::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CenterRotatedBox_UnserializedMessageContext<
            UserType, CenterRotatedBox::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CenterRotatedBox::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::RectF box;
  
  float rotation;
  
  CenterRotatedBox::CoordinateType coordinate_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CenterRotatedBox::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Geometry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Geometry, T>::value>;
  using DataView = GeometryDataView;
  using Data_ = internal::Geometry_Data;

  template <typename... Args>
  static GeometryPtr New(Args&&... args) {
    return GeometryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeometryPtr From(const U& u) {
    return mojo::TypeConverter<GeometryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Geometry>::Convert(*this);
  }


  Geometry();

  Geometry(
      CenterRotatedBoxPtr bounding_box,
      std::vector<::lens::mojom::PolygonPtr> segmentation_polygon);

Geometry(const Geometry&) = delete;
Geometry& operator=(const Geometry&) = delete;

  ~Geometry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeometryPtr>
  GeometryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Geometry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Geometry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Geometry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Geometry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Geometry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Geometry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Geometry_UnserializedMessageContext<
            UserType, Geometry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Geometry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Geometry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Geometry_UnserializedMessageContext<
            UserType, Geometry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Geometry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CenterRotatedBoxPtr bounding_box;
  
  std::vector<::lens::mojom::PolygonPtr> segmentation_polygon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Geometry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Geometry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Geometry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Geometry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CenterRotatedBoxPtr CenterRotatedBox::Clone() const {
  return New(
      mojo::Clone(box),
      mojo::Clone(rotation),
      mojo::Clone(coordinate_type)
  );
}

template <typename T, CenterRotatedBox::EnableIfSame<T>*>
bool CenterRotatedBox::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->box, other_struct.box))
    return false;
  if (!mojo::Equals(this->rotation, other_struct.rotation))
    return false;
  if (!mojo::Equals(this->coordinate_type, other_struct.coordinate_type))
    return false;
  return true;
}

template <typename T, CenterRotatedBox::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.box < rhs.box)
    return true;
  if (rhs.box < lhs.box)
    return false;
  if (lhs.rotation < rhs.rotation)
    return true;
  if (rhs.rotation < lhs.rotation)
    return false;
  if (lhs.coordinate_type < rhs.coordinate_type)
    return true;
  if (rhs.coordinate_type < lhs.coordinate_type)
    return false;
  return false;
}
template <typename StructPtrType>
GeometryPtr Geometry::Clone() const {
  return New(
      mojo::Clone(bounding_box),
      mojo::Clone(segmentation_polygon)
  );
}

template <typename T, Geometry::EnableIfSame<T>*>
bool Geometry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bounding_box, other_struct.bounding_box))
    return false;
  if (!mojo::Equals(this->segmentation_polygon, other_struct.segmentation_polygon))
    return false;
  return true;
}

template <typename T, Geometry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bounding_box < rhs.bounding_box)
    return true;
  if (rhs.bounding_box < lhs.bounding_box)
    return false;
  if (lhs.segmentation_polygon < rhs.segmentation_polygon)
    return true;
  if (rhs.segmentation_polygon < lhs.segmentation_polygon)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::CenterRotatedBox::DataView,
                                         ::lens::mojom::CenterRotatedBoxPtr> {
  static bool IsNull(const ::lens::mojom::CenterRotatedBoxPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::CenterRotatedBoxPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::CenterRotatedBox::box)& box(
      const ::lens::mojom::CenterRotatedBoxPtr& input) {
    return input->box;
  }

  static decltype(::lens::mojom::CenterRotatedBox::rotation) rotation(
      const ::lens::mojom::CenterRotatedBoxPtr& input) {
    return input->rotation;
  }

  static decltype(::lens::mojom::CenterRotatedBox::coordinate_type) coordinate_type(
      const ::lens::mojom::CenterRotatedBoxPtr& input) {
    return input->coordinate_type;
  }

  static bool Read(::lens::mojom::CenterRotatedBox::DataView input, ::lens::mojom::CenterRotatedBoxPtr* output);
};


template <>
struct  StructTraits<::lens::mojom::Geometry::DataView,
                                         ::lens::mojom::GeometryPtr> {
  static bool IsNull(const ::lens::mojom::GeometryPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::GeometryPtr* output) { output->reset(); }

  static const decltype(::lens::mojom::Geometry::bounding_box)& bounding_box(
      const ::lens::mojom::GeometryPtr& input) {
    return input->bounding_box;
  }

  static const decltype(::lens::mojom::Geometry::segmentation_polygon)& segmentation_polygon(
      const ::lens::mojom::GeometryPtr& input) {
    return input->segmentation_polygon;
  }

  static bool Read(::lens::mojom::Geometry::DataView input, ::lens::mojom::GeometryPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_LENS_CORE_MOJOM_GEOMETRY_MOJOM_H_