// chrome/browser/glic/host/glic.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SHARED_H_
#define CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/glic/host/glic.mojom-shared-internal.h"
#include "chrome/browser/glic/host/glic_features.mojom-shared.h"
#include "chrome/common/actor_webui.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/glic/host/glic.mojom-data-view.h"




namespace std {

template <>
struct hash<::glic::mojom::ProfileReadyState>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ProfileReadyState> {};

template <>
struct hash<::glic::mojom::WebUiState>
    : public mojo::internal::EnumHashImpl<::glic::mojom::WebUiState> {};

template <>
struct hash<::glic::mojom::MetricUserInputReactionType>
    : public mojo::internal::EnumHashImpl<::glic::mojom::MetricUserInputReactionType> {};

template <>
struct hash<::glic::mojom::PrepareForClientResult>
    : public mojo::internal::EnumHashImpl<::glic::mojom::PrepareForClientResult> {};

template <>
struct hash<::glic::mojom::PerformActionsErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::PerformActionsErrorReason> {};

template <>
struct hash<::glic::mojom::CreateTaskErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::CreateTaskErrorReason> {};

template <>
struct hash<::glic::mojom::ActorTaskState>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ActorTaskState> {};

template <>
struct hash<::glic::mojom::ActorTaskPauseReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ActorTaskPauseReason> {};

template <>
struct hash<::glic::mojom::ActorTaskStopReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ActorTaskStopReason> {};

template <>
struct hash<::glic::mojom::CaptureScreenshotErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::CaptureScreenshotErrorReason> {};

template <>
struct hash<::glic::mojom::ScrollToErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ScrollToErrorReason> {};

template <>
struct hash<::glic::mojom::SwitchConversationErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::SwitchConversationErrorReason> {};

template <>
struct hash<::glic::mojom::RegisterConversationErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::RegisterConversationErrorReason> {};

template <>
struct hash<::glic::mojom::PanelStateKind>
    : public mojo::internal::EnumHashImpl<::glic::mojom::PanelStateKind> {};

template <>
struct hash<::glic::mojom::InvocationSource>
    : public mojo::internal::EnumHashImpl<::glic::mojom::InvocationSource> {};

template <>
struct hash<::glic::mojom::WebClientMode>
    : public mojo::internal::EnumHashImpl<::glic::mojom::WebClientMode> {};

template <>
struct hash<::glic::mojom::WebClientModel>
    : public mojo::internal::EnumHashImpl<::glic::mojom::WebClientModel> {};

template <>
struct hash<::glic::mojom::WebUseCounter>
    : public mojo::internal::EnumHashImpl<::glic::mojom::WebUseCounter> {};

template <>
struct hash<::glic::mojom::ResponseStopCause>
    : public mojo::internal::EnumHashImpl<::glic::mojom::ResponseStopCause> {};

template <>
struct hash<::glic::mojom::CaptureRegionErrorReason>
    : public mojo::internal::EnumHashImpl<::glic::mojom::CaptureRegionErrorReason> {};

template <>
struct hash<::glic::mojom::SettingsPageField>
    : public mojo::internal::EnumHashImpl<::glic::mojom::SettingsPageField> {};

template <>
struct hash<::glic::mojom::HostCapability>
    : public mojo::internal::EnumHashImpl<::glic::mojom::HostCapability> {};

template <>
struct hash<::glic::mojom::CurrentView>
    : public mojo::internal::EnumHashImpl<::glic::mojom::CurrentView> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ProfileReadyState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ProfileReadyState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ProfileReadyState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebUiState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::WebUiState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::WebUiState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::MetricUserInputReactionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::MetricUserInputReactionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::MetricUserInputReactionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PrepareForClientResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::PrepareForClientResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::PrepareForClientResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PerformActionsErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::PerformActionsErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::PerformActionsErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CreateTaskErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::CreateTaskErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CreateTaskErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ActorTaskState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ActorTaskState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ActorTaskState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ActorTaskPauseReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ActorTaskPauseReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ActorTaskPauseReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ActorTaskStopReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ActorTaskStopReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ActorTaskStopReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CaptureScreenshotErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::CaptureScreenshotErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CaptureScreenshotErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ScrollToErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ScrollToErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::SwitchConversationErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::SwitchConversationErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::SwitchConversationErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::RegisterConversationErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::RegisterConversationErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::RegisterConversationErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PanelStateKind, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::PanelStateKind, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::PanelStateKind>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::InvocationSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::InvocationSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::InvocationSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebClientMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::WebClientMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::WebClientMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebClientModel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::WebClientModel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::WebClientModel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebUseCounter, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::WebUseCounter, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::WebUseCounter>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ResponseStopCause, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::ResponseStopCause, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::ResponseStopCause>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CaptureRegionErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::CaptureRegionErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CaptureRegionErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::SettingsPageField, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::SettingsPageField, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::SettingsPageField>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::HostCapability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::HostCapability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::HostCapability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CurrentView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::glic::mojom::CurrentView, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::glic::mojom::CurrentView>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::GetContextResultWithActionResultCodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::GetContextResultWithActionResultCodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::GetContextResultWithActionResultCode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::get_context_result(input)) in_get_context_result = Traits::get_context_result(input);
    mojo::internal::MessageFragment<decltype(fragment->get_context_result)>
        get_context_result_fragment(fragment.message());
    get_context_result_fragment.Claim(&fragment->get_context_result);
    
    mojo::internal::Serialize<::glic::mojom::GetContextResultDataView>(
      in_get_context_result,
      get_context_result_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->get_context_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null get_context_result in GetContextResultWithActionResultCode struct");
    fragment->action_result_$flag = Traits::action_result(input).has_value();
    if (Traits::action_result(input).has_value()) {
      fragment->action_result_$value = Traits::action_result(input).value();
    }
  }

  static bool Deserialize(::glic::mojom::internal::GetContextResultWithActionResultCode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::GetContextResultWithActionResultCodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::UserProfileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::UserProfileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::UserProfileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::avatar_icon(input)) in_avatar_icon = Traits::avatar_icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->avatar_icon)::BaseType> avatar_icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_avatar_icon,
      avatar_icon_fragment);

    fragment->avatar_icon.Set(
        avatar_icon_fragment.is_null() ? nullptr : avatar_icon_fragment.data());

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in UserProfileInfo struct");

    decltype(Traits::local_profile_name(input)) in_local_profile_name = Traits::local_profile_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_profile_name)::BaseType> local_profile_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_local_profile_name,
      local_profile_name_fragment);

    fragment->local_profile_name.Set(
        local_profile_name_fragment.is_null() ? nullptr : local_profile_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_profile_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_profile_name in UserProfileInfo struct");

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in UserProfileInfo struct");

    decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->given_name)::BaseType> given_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_given_name,
      given_name_fragment);

    fragment->given_name.Set(
        given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->given_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null given_name in UserProfileInfo struct");

    fragment->is_managed = Traits::is_managed(input);
  }

  static bool Deserialize(::glic::mojom::internal::UserProfileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::UserProfileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebClientInitialStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::WebClientInitialStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::WebClientInitialState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::panel_state(input)) in_panel_state = Traits::panel_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->panel_state)::BaseType> panel_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::PanelStateDataView>(
      in_panel_state,
      panel_state_fragment);

    fragment->panel_state.Set(
        panel_state_fragment.is_null() ? nullptr : panel_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->panel_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null panel_state in WebClientInitialState struct");

    decltype(Traits::focused_tab_data(input)) in_focused_tab_data = Traits::focused_tab_data(input);
    mojo::internal::MessageFragment<decltype(fragment->focused_tab_data)>
        focused_tab_data_fragment(fragment.message());
    focused_tab_data_fragment.Claim(&fragment->focused_tab_data);
    
    mojo::internal::Serialize<::glic::mojom::FocusedTabDataDataView>(
      in_focused_tab_data,
      focused_tab_data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->focused_tab_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null focused_tab_data in WebClientInitialState struct");

    fragment->microphone_permission_enabled = Traits::microphone_permission_enabled(input);

    fragment->location_permission_enabled = Traits::location_permission_enabled(input);

    fragment->tab_context_permission_enabled = Traits::tab_context_permission_enabled(input);

    fragment->os_location_permission_enabled = Traits::os_location_permission_enabled(input);

    decltype(Traits::hotkey(input)) in_hotkey = Traits::hotkey(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hotkey)::BaseType> hotkey_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_hotkey,
      hotkey_fragment);

    fragment->hotkey.Set(
        hotkey_fragment.is_null() ? nullptr : hotkey_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hotkey.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hotkey in WebClientInitialState struct");

    decltype(Traits::chrome_version(input)) in_chrome_version = Traits::chrome_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->chrome_version)::BaseType> chrome_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::VersionDataView>(
      in_chrome_version,
      chrome_version_fragment);

    fragment->chrome_version.Set(
        chrome_version_fragment.is_null() ? nullptr : chrome_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->chrome_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null chrome_version in WebClientInitialState struct");

    fragment->can_attach = Traits::can_attach(input);

    fragment->panel_is_active = Traits::panel_is_active(input);

    fragment->browser_is_open = Traits::browser_is_open(input);

    fragment->instance_is_active = Traits::instance_is_active(input);

    fragment->always_detached_mode = Traits::always_detached_mode(input);

    fragment->enable_zero_state_suggestions = Traits::enable_zero_state_suggestions(input);

    fragment->enable_act_in_focused_tab = Traits::enable_act_in_focused_tab(input);

    fragment->enable_scroll_to = Traits::enable_scroll_to(input);

    fragment->enable_default_tab_context_setting_feature = Traits::enable_default_tab_context_setting_feature(input);

    fragment->default_tab_context_setting_enabled = Traits::default_tab_context_setting_enabled(input);

    fragment->enable_closed_captioning_feature = Traits::enable_closed_captioning_feature(input);

    fragment->closed_captioning_setting_enabled = Traits::closed_captioning_setting_enabled(input);

    fragment->enable_maybe_refresh_user_status = Traits::enable_maybe_refresh_user_status(input);

    fragment->enable_multi_tab = Traits::enable_multi_tab(input);

    fragment->enable_get_context_actor = Traits::enable_get_context_actor(input);

    decltype(Traits::host_capabilities(input)) in_host_capabilities = Traits::host_capabilities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_capabilities)::BaseType>
        host_capabilities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& host_capabilities_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::glic::mojom::internal::HostCapability_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::HostCapability>>(
      in_host_capabilities,
      host_capabilities_fragment,
      &host_capabilities_validate_params);

    fragment->host_capabilities.Set(
        host_capabilities_fragment.is_null() ? nullptr : host_capabilities_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host_capabilities.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host_capabilities in WebClientInitialState struct");

    fragment->enable_get_page_metadata = Traits::enable_get_page_metadata(input);

    fragment->enable_api_activation_gating = Traits::enable_api_activation_gating(input);

    fragment->enable_capture_region = Traits::enable_capture_region(input);

    fragment->enable_web_actuation_setting_feature = Traits::enable_web_actuation_setting_feature(input);

    fragment->actuation_on_web_setting_enabled = Traits::actuation_on_web_setting_enabled(input);

    fragment->can_act_on_web = Traits::can_act_on_web(input);

    fragment->enable_activate_tab = Traits::enable_activate_tab(input);

    fragment->enable_get_tab_by_id = Traits::enable_get_tab_by_id(input);

    fragment->enable_open_password_manager_settings_page = Traits::enable_open_password_manager_settings_page(input);
  }

  static bool Deserialize(::glic::mojom::internal::WebClientInitialState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::WebClientInitialStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::GetTabContextOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::GetTabContextOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::GetTabContextOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->include_inner_text = Traits::include_inner_text(input);

    fragment->inner_text_bytes_limit = Traits::inner_text_bytes_limit(input);

    fragment->include_viewport_screenshot = Traits::include_viewport_screenshot(input);

    fragment->include_annotated_page_content = Traits::include_annotated_page_content(input);

    fragment->max_meta_tags = Traits::max_meta_tags(input);

    fragment->include_pdf = Traits::include_pdf(input);

    fragment->pdf_size_limit = Traits::pdf_size_limit(input);

    fragment->annotated_page_content_mode = Traits::annotated_page_content_mode(input);
  }

  static bool Deserialize(::glic::mojom::internal::GetTabContextOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::GetTabContextOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::GetPinCandidatesOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::GetPinCandidatesOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::GetPinCandidatesOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_candidates = Traits::max_candidates(input);

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());
  }

  static bool Deserialize(::glic::mojom::internal::GetPinCandidatesOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::GetPinCandidatesOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::selector(input)) in_selector = Traits::selector(input);
    mojo::internal::MessageFragment<decltype(fragment->selector)>
        selector_fragment(fragment.message());
    selector_fragment.Claim(&fragment->selector);
    
    mojo::internal::Serialize<::glic::mojom::ScrollToSelectorDataView>(
      in_selector,
      selector_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selector.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selector in ScrollToParams struct");

    fragment->highlight = Traits::highlight(input);

    decltype(Traits::document_id(input)) in_document_id = Traits::document_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_id)::BaseType> document_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_document_id,
      document_id_fragment);

    fragment->document_id.Set(
        document_id_fragment.is_null() ? nullptr : document_id_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
  }

  static bool Deserialize(::glic::mojom::internal::ScrollToParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScrollToParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToTextSelectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToTextSelectorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToTextSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in ScrollToTextSelector struct");
    fragment->search_range_start_node_id_$flag = Traits::search_range_start_node_id(input).has_value();
    if (Traits::search_range_start_node_id(input).has_value()) {
      fragment->search_range_start_node_id_$value = Traits::search_range_start_node_id(input).value();
    }
  }

  static bool Deserialize(::glic::mojom::internal::ScrollToTextSelector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScrollToTextSelectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToTextFragmentSelectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToTextFragmentSelectorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToTextFragmentSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text_start(input)) in_text_start = Traits::text_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_start)::BaseType> text_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_start,
      text_start_fragment);

    fragment->text_start.Set(
        text_start_fragment.is_null() ? nullptr : text_start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_start in ScrollToTextFragmentSelector struct");

    decltype(Traits::text_end(input)) in_text_end = Traits::text_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_end)::BaseType> text_end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text_end,
      text_end_fragment);

    fragment->text_end.Set(
        text_end_fragment.is_null() ? nullptr : text_end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_end in ScrollToTextFragmentSelector struct");
    fragment->search_range_start_node_id_$flag = Traits::search_range_start_node_id(input).has_value();
    if (Traits::search_range_start_node_id(input).has_value()) {
      fragment->search_range_start_node_id_$value = Traits::search_range_start_node_id(input).value();
    }
  }

  static bool Deserialize(::glic::mojom::internal::ScrollToTextFragmentSelector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScrollToTextFragmentSelectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToNodeSelectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScrollToNodeSelectorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ScrollToNodeSelector_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->node_id = Traits::node_id(input);
  }

  static bool Deserialize(::glic::mojom::internal::ScrollToNodeSelector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScrollToNodeSelectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::SuggestionContentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::SuggestionContentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::SuggestionContent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::suggestion(input)) in_suggestion = Traits::suggestion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestion)::BaseType> suggestion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suggestion,
      suggestion_fragment);

    fragment->suggestion.Set(
        suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestion in SuggestionContent struct");
  }

  static bool Deserialize(::glic::mojom::internal::SuggestionContent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::SuggestionContentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ZeroStateSuggestionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestions)::BaseType>
        suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>>(
      in_suggestions,
      suggestions_fragment,
      &suggestions_validate_params);

    fragment->suggestions.Set(
        suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in ZeroStateSuggestions struct");

    fragment->tab_id = Traits::tab_id(input);

    decltype(Traits::tab_url(input)) in_tab_url = Traits::tab_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_url)::BaseType> tab_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_tab_url,
      tab_url_fragment);

    fragment->tab_url.Set(
        tab_url_fragment.is_null() ? nullptr : tab_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_url in ZeroStateSuggestions struct");
  }

  static bool Deserialize(::glic::mojom::internal::ZeroStateSuggestions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ZeroStateSuggestionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ZeroStateSuggestionsV2DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsV2DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestionsV2_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::suggestions(input)) in_suggestions = Traits::suggestions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestions)::BaseType>
        suggestions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::SuggestionContentDataView>>(
      in_suggestions,
      suggestions_fragment,
      &suggestions_validate_params);

    fragment->suggestions.Set(
        suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestions in ZeroStateSuggestionsV2 struct");

    fragment->is_pending = Traits::is_pending(input);
  }

  static bool Deserialize(::glic::mojom::internal::ZeroStateSuggestionsV2_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ZeroStateSuggestionsV2DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ZeroStateSuggestionsOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ZeroStateSuggestionsOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ZeroStateSuggestionsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_first_run = Traits::is_first_run(input);

    decltype(Traits::supported_tools(input)) in_supported_tools = Traits::supported_tools(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_tools)::BaseType>
        supported_tools_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_tools_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_supported_tools,
      supported_tools_fragment,
      &supported_tools_validate_params);

    fragment->supported_tools.Set(
        supported_tools_fragment.is_null() ? nullptr : supported_tools_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_tools.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_tools in ZeroStateSuggestionsOptions struct");
  }

  static bool Deserialize(::glic::mojom::internal::ZeroStateSuggestionsOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ZeroStateSuggestionsOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PinCandidateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PinCandidateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PinCandidate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab_data(input)) in_tab_data = Traits::tab_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_data)::BaseType> tab_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
      in_tab_data,
      tab_data_fragment);

    fragment->tab_data.Set(
        tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_data in PinCandidate struct");
  }

  static bool Deserialize(::glic::mojom::internal::PinCandidate_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::PinCandidateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ConversationInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ConversationInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ConversationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::conversation_id(input)) in_conversation_id = Traits::conversation_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->conversation_id)::BaseType> conversation_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_conversation_id,
      conversation_id_fragment);

    fragment->conversation_id.Set(
        conversation_id_fragment.is_null() ? nullptr : conversation_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->conversation_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null conversation_id in ConversationInfo struct");

    decltype(Traits::conversation_title(input)) in_conversation_title = Traits::conversation_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->conversation_title)::BaseType> conversation_title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_conversation_title,
      conversation_title_fragment);

    fragment->conversation_title.Set(
        conversation_title_fragment.is_null() ? nullptr : conversation_title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->conversation_title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null conversation_title in ConversationInfo struct");
  }

  static bool Deserialize(::glic::mojom::internal::ConversationInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ConversationInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PanelOpeningDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PanelOpeningDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PanelOpeningData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::panel_state(input)) in_panel_state = Traits::panel_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->panel_state)::BaseType> panel_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::PanelStateDataView>(
      in_panel_state,
      panel_state_fragment);

    fragment->panel_state.Set(
        panel_state_fragment.is_null() ? nullptr : panel_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->panel_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null panel_state in PanelOpeningData struct");

    
    mojo::internal::Serialize<::glic::mojom::InvocationSource>(
      Traits::invocation_source(input),
      &fragment->invocation_source);

    decltype(Traits::conversation_id(input)) in_conversation_id = Traits::conversation_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->conversation_id)::BaseType> conversation_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_conversation_id,
      conversation_id_fragment);

    fragment->conversation_id.Set(
        conversation_id_fragment.is_null() ? nullptr : conversation_id_fragment.data());

    decltype(Traits::prompt_suggestion(input)) in_prompt_suggestion = Traits::prompt_suggestion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prompt_suggestion)::BaseType> prompt_suggestion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_prompt_suggestion,
      prompt_suggestion_fragment);

    fragment->prompt_suggestion.Set(
        prompt_suggestion_fragment.is_null() ? nullptr : prompt_suggestion_fragment.data());

    decltype(Traits::recently_active_conversations(input)) in_recently_active_conversations = Traits::recently_active_conversations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recently_active_conversations)::BaseType>
        recently_active_conversations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& recently_active_conversations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::ConversationInfoDataView>>(
      in_recently_active_conversations,
      recently_active_conversations_fragment,
      &recently_active_conversations_validate_params);

    fragment->recently_active_conversations.Set(
        recently_active_conversations_fragment.is_null() ? nullptr : recently_active_conversations_fragment.data());
  }

  static bool Deserialize(::glic::mojom::internal::PanelOpeningData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::PanelOpeningDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PanelStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PanelStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PanelState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::glic::mojom::PanelStateKind>(
      Traits::kind(input),
      &fragment->kind);
    fragment->window_id_$flag = Traits::window_id(input).has_value();
    if (Traits::window_id(input).has_value()) {
      fragment->window_id_$value = Traits::window_id(input).value();
    }
  }

  static bool Deserialize(::glic::mojom::internal::PanelState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::PanelStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::OnResponseStoppedDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OnResponseStoppedDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OnResponseStoppedDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::glic::mojom::ResponseStopCause>(
      Traits::cause(input),
      &fragment->cause);
  }

  static bool Deserialize(::glic::mojom::internal::OnResponseStoppedDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::OnResponseStoppedDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::OpenPanelInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OpenPanelInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OpenPanelInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::glic::mojom::WebClientMode>(
      Traits::web_client_mode(input),
      &fragment->web_client_mode);

    decltype(Traits::panelSize(input)) in_panelSize = Traits::panelSize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->panelSize)::BaseType> panelSize_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_panelSize,
      panelSize_fragment);

    fragment->panelSize.Set(
        panelSize_fragment.is_null() ? nullptr : panelSize_fragment.data());

    decltype(Traits::resizeDuration(input)) in_resizeDuration = Traits::resizeDuration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resizeDuration)::BaseType> resizeDuration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_resizeDuration,
      resizeDuration_fragment);

    fragment->resizeDuration.Set(
        resizeDuration_fragment.is_null() ? nullptr : resizeDuration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resizeDuration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resizeDuration in OpenPanelInfo struct");

    fragment->can_user_resize = Traits::can_user_resize(input);
  }

  static bool Deserialize(::glic::mojom::internal::OpenPanelInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::OpenPanelInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ContextDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ContextDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ContextData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in ContextData struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ContextData struct");
  }

  static bool Deserialize(::glic::mojom::internal::ContextData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ContextDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::AdditionalContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::AdditionalContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::AdditionalContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    fragment->tab_id_$flag = Traits::tab_id(input).has_value();
    if (Traits::tab_id(input).has_value()) {
      fragment->tab_id_$value = Traits::tab_id(input).value();
    }

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    decltype(Traits::frameUrl(input)) in_frameUrl = Traits::frameUrl(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frameUrl)::BaseType> frameUrl_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_frameUrl,
      frameUrl_fragment);

    fragment->frameUrl.Set(
        frameUrl_fragment.is_null() ? nullptr : frameUrl_fragment.data());

    decltype(Traits::parts(input)) in_parts = Traits::parts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parts)::BaseType>
        parts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::glic::mojom::AdditionalContextPartDataView>>(
      in_parts,
      parts_fragment,
      &parts_validate_params);

    fragment->parts.Set(
        parts_fragment.is_null() ? nullptr : parts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parts in AdditionalContext struct");
  }

  static bool Deserialize(::glic::mojom::internal::AdditionalContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::AdditionalContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::TabContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::TabContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::TabContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab_data(input)) in_tab_data = Traits::tab_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_data)::BaseType> tab_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
      in_tab_data,
      tab_data_fragment);

    fragment->tab_data.Set(
        tab_data_fragment.is_null() ? nullptr : tab_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_data in TabContext struct");

    decltype(Traits::web_page_data(input)) in_web_page_data = Traits::web_page_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_page_data)::BaseType> web_page_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::WebPageDataDataView>(
      in_web_page_data,
      web_page_data_fragment);

    fragment->web_page_data.Set(
        web_page_data_fragment.is_null() ? nullptr : web_page_data_fragment.data());

    decltype(Traits::viewport_screenshot(input)) in_viewport_screenshot = Traits::viewport_screenshot(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_screenshot)::BaseType> viewport_screenshot_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::ScreenshotDataView>(
      in_viewport_screenshot,
      viewport_screenshot_fragment);

    fragment->viewport_screenshot.Set(
        viewport_screenshot_fragment.is_null() ? nullptr : viewport_screenshot_fragment.data());

    decltype(Traits::pdf_document_data(input)) in_pdf_document_data = Traits::pdf_document_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pdf_document_data)::BaseType> pdf_document_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::PdfDocumentDataDataView>(
      in_pdf_document_data,
      pdf_document_data_fragment);

    fragment->pdf_document_data.Set(
        pdf_document_data_fragment.is_null() ? nullptr : pdf_document_data_fragment.data());

    decltype(Traits::annotated_page_data(input)) in_annotated_page_data = Traits::annotated_page_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->annotated_page_data)::BaseType> annotated_page_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::AnnotatedPageDataDataView>(
      in_annotated_page_data,
      annotated_page_data_fragment);

    fragment->annotated_page_data.Set(
        annotated_page_data_fragment.is_null() ? nullptr : annotated_page_data_fragment.data());
  }

  static bool Deserialize(::glic::mojom::internal::TabContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::TabContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebPageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::WebPageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::WebPageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::main_document(input)) in_main_document = Traits::main_document(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_document)::BaseType> main_document_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::DocumentDataDataView>(
      in_main_document,
      main_document_fragment);

    fragment->main_document.Set(
        main_document_fragment.is_null() ? nullptr : main_document_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_document.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_document in WebPageData struct");
  }

  static bool Deserialize(::glic::mojom::internal::WebPageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::WebPageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::DocumentDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::DocumentDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::DocumentData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in DocumentData struct");

    decltype(Traits::inner_text(input)) in_inner_text = Traits::inner_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inner_text)::BaseType> inner_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_inner_text,
      inner_text_fragment);

    fragment->inner_text.Set(
        inner_text_fragment.is_null() ? nullptr : inner_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inner_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_text in DocumentData struct");

    fragment->inner_text_truncated = Traits::inner_text_truncated(input);
  }

  static bool Deserialize(::glic::mojom::internal::DocumentData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::DocumentDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::PdfDocumentDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::PdfDocumentDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::PdfDocumentData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in PdfDocumentData struct");

    decltype(Traits::pdf_data(input)) in_pdf_data = Traits::pdf_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pdf_data)::BaseType>
        pdf_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pdf_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_pdf_data,
      pdf_data_fragment,
      &pdf_data_validate_params);

    fragment->pdf_data.Set(
        pdf_data_fragment.is_null() ? nullptr : pdf_data_fragment.data());

    fragment->size_limit_exceeded = Traits::size_limit_exceeded(input);
  }

  static bool Deserialize(::glic::mojom::internal::PdfDocumentData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::PdfDocumentDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::TabDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::TabDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::TabData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->tab_id = Traits::tab_id(input);

    fragment->window_id = Traits::window_id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in TabData struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    decltype(Traits::favicon(input)) in_favicon = Traits::favicon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon)::BaseType> favicon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_favicon,
      favicon_fragment);

    fragment->favicon.Set(
        favicon_fragment.is_null() ? nullptr : favicon_fragment.data());

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    decltype(Traits::document_mime_type(input)) in_document_mime_type = Traits::document_mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_mime_type)::BaseType> document_mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_document_mime_type,
      document_mime_type_fragment);

    fragment->document_mime_type.Set(
        document_mime_type_fragment.is_null() ? nullptr : document_mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_mime_type in TabData struct");
    fragment->is_observable_$flag = Traits::is_observable(input).has_value();
    if (Traits::is_observable(input).has_value()) {
      fragment->is_observable_$value = Traits::is_observable(input).value();
    }
    fragment->is_media_active_$flag = Traits::is_media_active(input).has_value();
    if (Traits::is_media_active(input).has_value()) {
      fragment->is_media_active_$value = Traits::is_media_active(input).value();
    }
    fragment->is_tab_content_captured_$flag = Traits::is_tab_content_captured(input).has_value();
    if (Traits::is_tab_content_captured(input).has_value()) {
      fragment->is_tab_content_captured_$value = Traits::is_tab_content_captured(input).value();
    }
    fragment->is_active_in_window_$flag = Traits::is_active_in_window(input).has_value();
    if (Traits::is_active_in_window(input).has_value()) {
      fragment->is_active_in_window_$value = Traits::is_active_in_window(input).value();
    }
    fragment->is_window_active_$flag = Traits::is_window_active(input).has_value();
    if (Traits::is_window_active(input).has_value()) {
      fragment->is_window_active_$value = Traits::is_window_active(input).value();
    }
  }

  static bool Deserialize(::glic::mojom::internal::TabData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::TabDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::NoFocusedTabDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::NoFocusedTabDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::NoFocusedTabData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::active_tab_data(input)) in_active_tab_data = Traits::active_tab_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->active_tab_data)::BaseType> active_tab_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
      in_active_tab_data,
      active_tab_data_fragment);

    fragment->active_tab_data.Set(
        active_tab_data_fragment.is_null() ? nullptr : active_tab_data_fragment.data());

    decltype(Traits::no_focus_reason(input)) in_no_focus_reason = Traits::no_focus_reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->no_focus_reason)::BaseType> no_focus_reason_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_no_focus_reason,
      no_focus_reason_fragment);

    fragment->no_focus_reason.Set(
        no_focus_reason_fragment.is_null() ? nullptr : no_focus_reason_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->no_focus_reason.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null no_focus_reason in NoFocusedTabData struct");
  }

  static bool Deserialize(::glic::mojom::internal::NoFocusedTabData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::NoFocusedTabDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::AnnotatedPageDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::AnnotatedPageDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::AnnotatedPageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::annotated_page_content(input)) in_annotated_page_content = Traits::annotated_page_content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->annotated_page_content)::BaseType> annotated_page_content_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_annotated_page_content,
      annotated_page_content_fragment);

    fragment->annotated_page_content.Set(
        annotated_page_content_fragment.is_null() ? nullptr : annotated_page_content_fragment.data());

    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PageMetadataDataView>(
      in_metadata,
      metadata_fragment);

    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  }

  static bool Deserialize(::glic::mojom::internal::AnnotatedPageData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::AnnotatedPageDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ImageOriginAnnotationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ImageOriginAnnotationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ImageOriginAnnotations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::glic::mojom::internal::ImageOriginAnnotations_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ImageOriginAnnotationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::JournalDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::JournalDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::Journal_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Journal struct");
  }

  static bool Deserialize(::glic::mojom::internal::Journal_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::JournalDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CaptureRegionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::CaptureRegionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::CaptureRegionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->tab_id = Traits::tab_id(input);

    decltype(Traits::region(input)) in_region = Traits::region(input);
    mojo::internal::MessageFragment<decltype(fragment->region)>
        region_fragment(fragment.message());
    region_fragment.Claim(&fragment->region);
    
    mojo::internal::Serialize<::glic::mojom::CapturedRegionDataView>(
      in_region,
      region_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->region.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in CaptureRegionResult struct");
  }

  static bool Deserialize(::glic::mojom::internal::CaptureRegionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::CaptureRegionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScreenshotDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ScreenshotDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::Screenshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->width_pixels = Traits::width_pixels(input);

    fragment->height_pixels = Traits::height_pixels(input);

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Screenshot struct");

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in Screenshot struct");

    decltype(Traits::origin_annotations(input)) in_origin_annotations = Traits::origin_annotations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_annotations)::BaseType> origin_annotations_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::glic::mojom::ImageOriginAnnotationsDataView>(
      in_origin_annotations,
      origin_annotations_fragment);

    fragment->origin_annotations.Set(
        origin_annotations_fragment.is_null() ? nullptr : origin_annotations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin_annotations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_annotations in Screenshot struct");
  }

  static bool Deserialize(::glic::mojom::internal::Screenshot_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScreenshotDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::OpenSettingsOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::OpenSettingsOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::OpenSettingsOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::glic::mojom::SettingsPageField>(
      Traits::highlightField(input),
      &fragment->highlightField);
  }

  static bool Deserialize(::glic::mojom::internal::OpenSettingsOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::OpenSettingsOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ViewChangeRequestActuationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestActuationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequestActuation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::glic::mojom::internal::ViewChangeRequestActuation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ViewChangeRequestActuationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ViewChangeRequestConversationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestConversationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequestConversation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::glic::mojom::internal::ViewChangeRequestConversation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ViewChangeRequestConversationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ViewChangeRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangeRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangeRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<decltype(fragment->details)>
        details_fragment(fragment.message());
    details_fragment.Claim(&fragment->details);
    
    mojo::internal::Serialize<::glic::mojom::ViewChangeRequestDetailsDataView>(
      in_details,
      details_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in ViewChangeRequest struct");
  }

  static bool Deserialize(::glic::mojom::internal::ViewChangeRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ViewChangeRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ViewChangedNotificationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::glic::mojom::ViewChangedNotificationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::glic::mojom::internal::ViewChangedNotification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::glic::mojom::CurrentView>(
      Traits::current_view(input),
      &fragment->current_view);
  }

  static bool Deserialize(::glic::mojom::internal::ViewChangedNotification_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ViewChangedNotificationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::GetContextResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::GetContextResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::GetContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::GetContextResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_reason)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error_reason,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_reason in GetContextResult union");
    fragment->data.f_error_reason.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::GetContextResultDataView::Tag::kTabContext: {
    decltype(Traits::tab_context(input))
    in_tab_context = Traits::tab_context(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_context)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::TabContextDataView>(
  in_tab_context,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_context in GetContextResult union");
    fragment->data.f_tab_context.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::GetContextResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::GetContextResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CaptureScreenshotResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::CaptureScreenshotResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::CaptureScreenshotResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::CaptureScreenshotResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::glic::mojom::CaptureScreenshotErrorReason>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
  case ::glic::mojom::CaptureScreenshotResultDataView::Tag::kScreenshot: {
    decltype(Traits::screenshot(input))
    in_screenshot = Traits::screenshot(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_screenshot)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScreenshotDataView>(
  in_screenshot,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null screenshot in CaptureScreenshotResult union");
    fragment->data.f_screenshot.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::CaptureScreenshotResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::CaptureScreenshotResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ScrollToSelectorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::ScrollToSelectorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::ScrollToSelector_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kExactTextSelector: {
    decltype(Traits::exact_text_selector(input))
    in_exact_text_selector = Traits::exact_text_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_exact_text_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToTextSelectorDataView>(
  in_exact_text_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null exact_text_selector in ScrollToSelector union");
    fragment->data.f_exact_text_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kTextFragmentSelector: {
    decltype(Traits::text_fragment_selector(input))
    in_text_fragment_selector = Traits::text_fragment_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text_fragment_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToTextFragmentSelectorDataView>(
  in_text_fragment_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text_fragment_selector in ScrollToSelector union");
    fragment->data.f_text_fragment_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ScrollToSelectorDataView::Tag::kNodeSelector: {
    decltype(Traits::node_selector(input))
    in_node_selector = Traits::node_selector(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_node_selector)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScrollToNodeSelectorDataView>(
  in_node_selector,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null node_selector in ScrollToSelector union");
    fragment->data.f_node_selector.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::ScrollToSelector_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ScrollToSelectorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::AdditionalContextPartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::AdditionalContextPartDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::AdditionalContextPart_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ContextDataDataView>(
  in_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in AdditionalContextPart union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kScreenshot: {
    decltype(Traits::screenshot(input))
    in_screenshot = Traits::screenshot(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_screenshot)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ScreenshotDataView>(
  in_screenshot,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null screenshot in AdditionalContextPart union");
    fragment->data.f_screenshot.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kWebPageData: {
    decltype(Traits::web_page_data(input))
    in_web_page_data = Traits::web_page_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_web_page_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::WebPageDataDataView>(
  in_web_page_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null web_page_data in AdditionalContextPart union");
    fragment->data.f_web_page_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kAnnotatedPageData: {
    decltype(Traits::annotated_page_data(input))
    in_annotated_page_data = Traits::annotated_page_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_annotated_page_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::AnnotatedPageDataDataView>(
  in_annotated_page_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null annotated_page_data in AdditionalContextPart union");
    fragment->data.f_annotated_page_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kPdfDocumentData: {
    decltype(Traits::pdf_document_data(input))
    in_pdf_document_data = Traits::pdf_document_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pdf_document_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::PdfDocumentDataDataView>(
  in_pdf_document_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pdf_document_data in AdditionalContextPart union");
    fragment->data.f_pdf_document_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::AdditionalContextPartDataView::Tag::kTabContext: {
    decltype(Traits::tab_context(input))
    in_tab_context = Traits::tab_context(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_context)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::TabContextDataView>(
  in_tab_context,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_context in AdditionalContextPart union");
    fragment->data.f_tab_context.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::AdditionalContextPart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::AdditionalContextPartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::FocusedTabDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::FocusedTabDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::FocusedTabData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::FocusedTabDataDataView::Tag::kFocusedTab: {
    decltype(Traits::focused_tab(input))
    in_focused_tab = Traits::focused_tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_focused_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::TabDataDataView>(
  in_focused_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null focused_tab in FocusedTabData union");
    fragment->data.f_focused_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::FocusedTabDataDataView::Tag::kNoFocusedTabData: {
    decltype(Traits::no_focused_tab_data(input))
    in_no_focused_tab_data = Traits::no_focused_tab_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_no_focused_tab_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::NoFocusedTabDataDataView>(
  in_no_focused_tab_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null no_focused_tab_data in FocusedTabData union");
    fragment->data.f_no_focused_tab_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::FocusedTabData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::FocusedTabDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::CapturedRegionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::CapturedRegionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::CapturedRegion_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::CapturedRegionDataView::Tag::kRect: {
    decltype(Traits::rect(input))
    in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_rect)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::RectDataView>(
  in_rect,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null rect in CapturedRegion union");
    fragment->data.f_rect.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::CapturedRegion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::CapturedRegionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::ViewChangeRequestDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::ViewChangeRequestDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::ViewChangeRequestDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::ViewChangeRequestDetailsDataView::Tag::kActuation: {
    decltype(Traits::actuation(input))
    in_actuation = Traits::actuation(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_actuation)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ViewChangeRequestActuationDataView>(
  in_actuation,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null actuation in ViewChangeRequestDetails union");
    fragment->data.f_actuation.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::ViewChangeRequestDetailsDataView::Tag::kConversation: {
    decltype(Traits::conversation(input))
    in_conversation = Traits::conversation(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_conversation)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::glic::mojom::ViewChangeRequestConversationDataView>(
  in_conversation,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null conversation in ViewChangeRequestDetails union");
    fragment->data.f_conversation.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::ViewChangeRequestDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::ViewChangeRequestDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::WebClientHandler_CreateTask_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    fragment->data.f_success = in_success;
    break;
  }
  case ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::glic::mojom::CreateTaskErrorReason>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::WebClientHandler_CreateTask_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::WebClientHandler_CreateTask_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::glic::mojom::internal::WebClientHandler_PerformActions_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in WebClientHandler_PerformActions_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::glic::mojom::PerformActionsErrorReason>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::glic::mojom::internal::WebClientHandler_PerformActions_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::glic::mojom::WebClientHandler_PerformActions_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace glic::mojom {

inline void GetContextResultWithActionResultCodeDataView::GetGetContextResultDataView(
    GetContextResultDataView* output) {
  auto pointer = &data_->get_context_result;
  *output = GetContextResultDataView(pointer, message_);
}


inline void UserProfileInfoDataView::GetAvatarIconDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->avatar_icon.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void UserProfileInfoDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserProfileInfoDataView::GetLocalProfileNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->local_profile_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserProfileInfoDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserProfileInfoDataView::GetGivenNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->given_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void WebClientInitialStateDataView::GetPanelStateDataView(
    PanelStateDataView* output) {
  auto pointer = data_->panel_state.Get();
  *output = PanelStateDataView(pointer, message_);
}
inline void WebClientInitialStateDataView::GetFocusedTabDataDataView(
    FocusedTabDataDataView* output) {
  auto pointer = &data_->focused_tab_data;
  *output = FocusedTabDataDataView(pointer, message_);
}
inline void WebClientInitialStateDataView::GetHotkeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->hotkey.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebClientInitialStateDataView::GetChromeVersionDataView(
    ::mojo_base::mojom::VersionDataView* output) {
  auto pointer = data_->chrome_version.Get();
  *output = ::mojo_base::mojom::VersionDataView(pointer, message_);
}
inline void WebClientInitialStateDataView::GetHostCapabilitiesDataView(
    mojo::ArrayDataView<HostCapability>* output) {
  auto pointer = data_->host_capabilities.Get();
  *output = mojo::ArrayDataView<HostCapability>(pointer, message_);
}




inline void GetPinCandidatesOptionsDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ScrollToParamsDataView::GetSelectorDataView(
    ScrollToSelectorDataView* output) {
  auto pointer = &data_->selector;
  *output = ScrollToSelectorDataView(pointer, message_);
}
inline void ScrollToParamsDataView::GetDocumentIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->document_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void ScrollToParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ScrollToTextSelectorDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ScrollToTextFragmentSelectorDataView::GetTextStartDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_start.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScrollToTextFragmentSelectorDataView::GetTextEndDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text_end.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void SuggestionContentDataView::GetSuggestionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suggestion.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ZeroStateSuggestionsDataView::GetSuggestionsDataView(
    mojo::ArrayDataView<SuggestionContentDataView>* output) {
  auto pointer = data_->suggestions.Get();
  *output = mojo::ArrayDataView<SuggestionContentDataView>(pointer, message_);
}
inline void ZeroStateSuggestionsDataView::GetTabUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->tab_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void ZeroStateSuggestionsV2DataView::GetSuggestionsDataView(
    mojo::ArrayDataView<SuggestionContentDataView>* output) {
  auto pointer = data_->suggestions.Get();
  *output = mojo::ArrayDataView<SuggestionContentDataView>(pointer, message_);
}


inline void ZeroStateSuggestionsOptionsDataView::GetSupportedToolsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->supported_tools.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void PinCandidateDataView::GetTabDataDataView(
    TabDataDataView* output) {
  auto pointer = data_->tab_data.Get();
  *output = TabDataDataView(pointer, message_);
}


inline void ConversationInfoDataView::GetConversationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->conversation_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ConversationInfoDataView::GetConversationTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->conversation_title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PanelOpeningDataDataView::GetPanelStateDataView(
    PanelStateDataView* output) {
  auto pointer = data_->panel_state.Get();
  *output = PanelStateDataView(pointer, message_);
}
inline void PanelOpeningDataDataView::GetConversationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->conversation_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PanelOpeningDataDataView::GetPromptSuggestionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prompt_suggestion.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PanelOpeningDataDataView::GetRecentlyActiveConversationsDataView(
    mojo::ArrayDataView<ConversationInfoDataView>* output) {
  auto pointer = data_->recently_active_conversations.Get();
  *output = mojo::ArrayDataView<ConversationInfoDataView>(pointer, message_);
}






inline void OpenPanelInfoDataView::GetPanelSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->panelSize.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void OpenPanelInfoDataView::GetResizeDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->resizeDuration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void ContextDataDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContextDataDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void AdditionalContextDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AdditionalContextDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void AdditionalContextDataView::GetFrameUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->frameUrl.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AdditionalContextDataView::GetPartsDataView(
    mojo::ArrayDataView<AdditionalContextPartDataView>* output) {
  auto pointer = data_->parts.Get();
  *output = mojo::ArrayDataView<AdditionalContextPartDataView>(pointer, message_);
}


inline void TabContextDataView::GetTabDataDataView(
    TabDataDataView* output) {
  auto pointer = data_->tab_data.Get();
  *output = TabDataDataView(pointer, message_);
}
inline void TabContextDataView::GetWebPageDataDataView(
    WebPageDataDataView* output) {
  auto pointer = data_->web_page_data.Get();
  *output = WebPageDataDataView(pointer, message_);
}
inline void TabContextDataView::GetViewportScreenshotDataView(
    ScreenshotDataView* output) {
  auto pointer = data_->viewport_screenshot.Get();
  *output = ScreenshotDataView(pointer, message_);
}
inline void TabContextDataView::GetPdfDocumentDataDataView(
    PdfDocumentDataDataView* output) {
  auto pointer = data_->pdf_document_data.Get();
  *output = PdfDocumentDataDataView(pointer, message_);
}
inline void TabContextDataView::GetAnnotatedPageDataDataView(
    AnnotatedPageDataDataView* output) {
  auto pointer = data_->annotated_page_data.Get();
  *output = AnnotatedPageDataDataView(pointer, message_);
}


inline void WebPageDataDataView::GetMainDocumentDataView(
    DocumentDataDataView* output) {
  auto pointer = data_->main_document.Get();
  *output = DocumentDataDataView(pointer, message_);
}


inline void DocumentDataDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void DocumentDataDataView::GetInnerTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inner_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PdfDocumentDataDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PdfDocumentDataDataView::GetPdfDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pdf_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void TabDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataDataView::GetFaviconDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->favicon.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void TabDataDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataDataView::GetDocumentMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->document_mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void NoFocusedTabDataDataView::GetActiveTabDataDataView(
    TabDataDataView* output) {
  auto pointer = data_->active_tab_data.Get();
  *output = TabDataDataView(pointer, message_);
}
inline void NoFocusedTabDataDataView::GetNoFocusReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->no_focus_reason.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AnnotatedPageDataDataView::GetAnnotatedPageContentDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->annotated_page_content.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}
inline void AnnotatedPageDataDataView::GetMetadataDataView(
    ::blink::mojom::PageMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::blink::mojom::PageMetadataDataView(pointer, message_);
}




inline void JournalDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void CaptureRegionResultDataView::GetRegionDataView(
    CapturedRegionDataView* output) {
  auto pointer = &data_->region;
  *output = CapturedRegionDataView(pointer, message_);
}


inline void ScreenshotDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ScreenshotDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScreenshotDataView::GetOriginAnnotationsDataView(
    ImageOriginAnnotationsDataView* output) {
  auto pointer = data_->origin_annotations.Get();
  *output = ImageOriginAnnotationsDataView(pointer, message_);
}








inline void ViewChangeRequestDataView::GetDetailsDataView(
    ViewChangeRequestDetailsDataView* output) {
  auto pointer = &data_->details;
  *output = ViewChangeRequestDetailsDataView(pointer, message_);
}




inline void GetContextResultDataView::GetErrorReasonDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error_reason());
  *output = mojo::StringDataView(data_->data.f_error_reason.Get(), message_);
}
inline void GetContextResultDataView::GetTabContextDataView(
    TabContextDataView* output) const {
  CHECK(is_tab_context());
  *output = TabContextDataView(data_->data.f_tab_context.Get(), message_);
}

inline void CaptureScreenshotResultDataView::GetScreenshotDataView(
    ScreenshotDataView* output) const {
  CHECK(is_screenshot());
  *output = ScreenshotDataView(data_->data.f_screenshot.Get(), message_);
}

inline void ScrollToSelectorDataView::GetExactTextSelectorDataView(
    ScrollToTextSelectorDataView* output) const {
  CHECK(is_exact_text_selector());
  *output = ScrollToTextSelectorDataView(data_->data.f_exact_text_selector.Get(), message_);
}
inline void ScrollToSelectorDataView::GetTextFragmentSelectorDataView(
    ScrollToTextFragmentSelectorDataView* output) const {
  CHECK(is_text_fragment_selector());
  *output = ScrollToTextFragmentSelectorDataView(data_->data.f_text_fragment_selector.Get(), message_);
}
inline void ScrollToSelectorDataView::GetNodeSelectorDataView(
    ScrollToNodeSelectorDataView* output) const {
  CHECK(is_node_selector());
  *output = ScrollToNodeSelectorDataView(data_->data.f_node_selector.Get(), message_);
}

inline void AdditionalContextPartDataView::GetDataDataView(
    ContextDataDataView* output) const {
  CHECK(is_data());
  *output = ContextDataDataView(data_->data.f_data.Get(), message_);
}
inline void AdditionalContextPartDataView::GetScreenshotDataView(
    ScreenshotDataView* output) const {
  CHECK(is_screenshot());
  *output = ScreenshotDataView(data_->data.f_screenshot.Get(), message_);
}
inline void AdditionalContextPartDataView::GetWebPageDataDataView(
    WebPageDataDataView* output) const {
  CHECK(is_web_page_data());
  *output = WebPageDataDataView(data_->data.f_web_page_data.Get(), message_);
}
inline void AdditionalContextPartDataView::GetAnnotatedPageDataDataView(
    AnnotatedPageDataDataView* output) const {
  CHECK(is_annotated_page_data());
  *output = AnnotatedPageDataDataView(data_->data.f_annotated_page_data.Get(), message_);
}
inline void AdditionalContextPartDataView::GetPdfDocumentDataDataView(
    PdfDocumentDataDataView* output) const {
  CHECK(is_pdf_document_data());
  *output = PdfDocumentDataDataView(data_->data.f_pdf_document_data.Get(), message_);
}
inline void AdditionalContextPartDataView::GetTabContextDataView(
    TabContextDataView* output) const {
  CHECK(is_tab_context());
  *output = TabContextDataView(data_->data.f_tab_context.Get(), message_);
}

inline void FocusedTabDataDataView::GetFocusedTabDataView(
    TabDataDataView* output) const {
  CHECK(is_focused_tab());
  *output = TabDataDataView(data_->data.f_focused_tab.Get(), message_);
}
inline void FocusedTabDataDataView::GetNoFocusedTabDataDataView(
    NoFocusedTabDataDataView* output) const {
  CHECK(is_no_focused_tab_data());
  *output = NoFocusedTabDataDataView(data_->data.f_no_focused_tab_data.Get(), message_);
}

inline void CapturedRegionDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) const {
  CHECK(is_rect());
  *output = ::gfx::mojom::RectDataView(data_->data.f_rect.Get(), message_);
}

inline void ViewChangeRequestDetailsDataView::GetActuationDataView(
    ViewChangeRequestActuationDataView* output) const {
  CHECK(is_actuation());
  *output = ViewChangeRequestActuationDataView(data_->data.f_actuation.Get(), message_);
}
inline void ViewChangeRequestDetailsDataView::GetConversationDataView(
    ViewChangeRequestConversationDataView* output) const {
  CHECK(is_conversation());
  *output = ViewChangeRequestConversationDataView(data_->data.f_conversation.Get(), message_);
}


inline void WebClientHandler_PerformActions_ResponseParam_ResultDataView::GetSuccessDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) const {
  CHECK(is_success());
  *output = ::mojo_base::mojom::ProtoWrapperDataView(data_->data.f_success.Get(), message_);
}


}  // glic::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ProfileReadyState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ProfileReadyState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::WebUiState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::WebUiState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::MetricUserInputReactionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::MetricUserInputReactionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::PrepareForClientResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::PrepareForClientResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::PerformActionsErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::PerformActionsErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::CreateTaskErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::CreateTaskErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ActorTaskState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ActorTaskState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ActorTaskPauseReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ActorTaskPauseReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ActorTaskStopReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ActorTaskStopReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::CaptureScreenshotErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::CaptureScreenshotErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ScrollToErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ScrollToErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::SwitchConversationErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::SwitchConversationErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::RegisterConversationErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::RegisterConversationErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::PanelStateKind> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::PanelStateKind value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::InvocationSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::InvocationSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::WebClientMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::WebClientMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::WebClientModel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::WebClientModel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::WebUseCounter> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::WebUseCounter value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::ResponseStopCause> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::ResponseStopCause value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::CaptureRegionErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::CaptureRegionErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::SettingsPageField> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::SettingsPageField value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::HostCapability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::HostCapability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::glic::mojom::CurrentView> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::glic::mojom::CurrentView value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_GLIC_HOST_GLIC_MOJOM_SHARED_H_