// chrome/browser/glic/host/glic.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/glic/host/glic.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/glic/host/glic.mojom-params-data.h"
namespace glic {
namespace mojom {

NOINLINE static const char* ProfileReadyStateToStringHelper(ProfileReadyState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProfileReadyState::kUnknownError:
      return "kUnknownError";
    case ProfileReadyState::kSignInRequired:
      return "kSignInRequired";
    case ProfileReadyState::kReady:
      return "kReady";
    case ProfileReadyState::kIneligible:
      return "kIneligible";
    case ProfileReadyState::kDisabledByAdmin:
      return "kDisabledByAdmin";
    default:
      return nullptr;
  }
}

std::string ProfileReadyStateToString(ProfileReadyState value) {
  const char *str = ProfileReadyStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProfileReadyState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProfileReadyState value) {
  return os << ProfileReadyStateToString(value);
}

NOINLINE static const char* WebUiStateToStringHelper(WebUiState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebUiState::kUninitialized:
      return "kUninitialized";
    case WebUiState::kBeginLoad:
      return "kBeginLoad";
    case WebUiState::kShowLoading:
      return "kShowLoading";
    case WebUiState::kHoldLoading:
      return "kHoldLoading";
    case WebUiState::kFinishLoading:
      return "kFinishLoading";
    case WebUiState::kError:
      return "kError";
    case WebUiState::kOffline:
      return "kOffline";
    case WebUiState::kUnavailable:
      return "kUnavailable";
    case WebUiState::kReady:
      return "kReady";
    case WebUiState::kUnresponsive:
      return "kUnresponsive";
    case WebUiState::kSignIn:
      return "kSignIn";
    case WebUiState::kGuestError:
      return "kGuestError";
    case WebUiState::kDisabledByAdmin:
      return "kDisabledByAdmin";
    default:
      return nullptr;
  }
}

std::string WebUiStateToString(WebUiState value) {
  const char *str = WebUiStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebUiState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebUiState value) {
  return os << WebUiStateToString(value);
}

NOINLINE static const char* MetricUserInputReactionTypeToStringHelper(MetricUserInputReactionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MetricUserInputReactionType::kUnknown:
      return "kUnknown";
    case MetricUserInputReactionType::kCanned:
      return "kCanned";
    case MetricUserInputReactionType::kModel:
      return "kModel";
    default:
      return nullptr;
  }
}

std::string MetricUserInputReactionTypeToString(MetricUserInputReactionType value) {
  const char *str = MetricUserInputReactionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MetricUserInputReactionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MetricUserInputReactionType value) {
  return os << MetricUserInputReactionTypeToString(value);
}

NOINLINE static const char* PrepareForClientResultToStringHelper(PrepareForClientResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrepareForClientResult::kSuccess:
      return "kSuccess";
    case PrepareForClientResult::kErrorResyncingCookies:
      return "kErrorResyncingCookies";
    case PrepareForClientResult::kRequiresSignIn:
      return "kRequiresSignIn";
    default:
      return nullptr;
  }
}

std::string PrepareForClientResultToString(PrepareForClientResult value) {
  const char *str = PrepareForClientResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrepareForClientResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrepareForClientResult value) {
  return os << PrepareForClientResultToString(value);
}

NOINLINE static const char* PerformActionsErrorReasonToStringHelper(PerformActionsErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PerformActionsErrorReason::kUnknown:
      return "kUnknown";
    case PerformActionsErrorReason::kInvalidProto:
      return "kInvalidProto";
    case PerformActionsErrorReason::kMissingTaskId:
      return "kMissingTaskId";
    default:
      return nullptr;
  }
}

std::string PerformActionsErrorReasonToString(PerformActionsErrorReason value) {
  const char *str = PerformActionsErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PerformActionsErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PerformActionsErrorReason value) {
  return os << PerformActionsErrorReasonToString(value);
}

NOINLINE static const char* CreateTaskErrorReasonToStringHelper(CreateTaskErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateTaskErrorReason::kUnknown:
      return "kUnknown";
    case CreateTaskErrorReason::kTaskSystemUnavailable:
      return "kTaskSystemUnavailable";
    default:
      return nullptr;
  }
}

std::string CreateTaskErrorReasonToString(CreateTaskErrorReason value) {
  const char *str = CreateTaskErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateTaskErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateTaskErrorReason value) {
  return os << CreateTaskErrorReasonToString(value);
}

NOINLINE static const char* ActorTaskStateToStringHelper(ActorTaskState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActorTaskState::kUnknown:
      return "kUnknown";
    case ActorTaskState::kIdle:
      return "kIdle";
    case ActorTaskState::kActing:
      return "kActing";
    case ActorTaskState::kPaused:
      return "kPaused";
    case ActorTaskState::kStopped:
      return "kStopped";
    default:
      return nullptr;
  }
}

std::string ActorTaskStateToString(ActorTaskState value) {
  const char *str = ActorTaskStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActorTaskState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActorTaskState value) {
  return os << ActorTaskStateToString(value);
}

NOINLINE static const char* ActorTaskPauseReasonToStringHelper(ActorTaskPauseReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActorTaskPauseReason::kPausedByModel:
      return "kPausedByModel";
    case ActorTaskPauseReason::kPausedByUser:
      return "kPausedByUser";
    default:
      return nullptr;
  }
}

std::string ActorTaskPauseReasonToString(ActorTaskPauseReason value) {
  const char *str = ActorTaskPauseReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActorTaskPauseReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActorTaskPauseReason value) {
  return os << ActorTaskPauseReasonToString(value);
}

NOINLINE static const char* ActorTaskStopReasonToStringHelper(ActorTaskStopReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActorTaskStopReason::kTaskComplete:
      return "kTaskComplete";
    case ActorTaskStopReason::kStoppedByUser:
      return "kStoppedByUser";
    case ActorTaskStopReason::kModelError:
      return "kModelError";
    case ActorTaskStopReason::kUserStartedNewChat:
      return "kUserStartedNewChat";
    case ActorTaskStopReason::kUserLoadedPreviousChat:
      return "kUserLoadedPreviousChat";
    default:
      return nullptr;
  }
}

std::string ActorTaskStopReasonToString(ActorTaskStopReason value) {
  const char *str = ActorTaskStopReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActorTaskStopReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActorTaskStopReason value) {
  return os << ActorTaskStopReasonToString(value);
}

NOINLINE static const char* CaptureScreenshotErrorReasonToStringHelper(CaptureScreenshotErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CaptureScreenshotErrorReason::kUnknown:
      return "kUnknown";
    case CaptureScreenshotErrorReason::kScreenCaptureRequestThrottled:
      return "kScreenCaptureRequestThrottled";
    case CaptureScreenshotErrorReason::kUserCancelledScreenPickerDialog:
      return "kUserCancelledScreenPickerDialog";
    default:
      return nullptr;
  }
}

std::string CaptureScreenshotErrorReasonToString(CaptureScreenshotErrorReason value) {
  const char *str = CaptureScreenshotErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CaptureScreenshotErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CaptureScreenshotErrorReason value) {
  return os << CaptureScreenshotErrorReasonToString(value);
}

NOINLINE static const char* ScrollToErrorReasonToStringHelper(ScrollToErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollToErrorReason::kNotSupported:
      return "kNotSupported";
    case ScrollToErrorReason::kNewerScrollToCall:
      return "kNewerScrollToCall";
    case ScrollToErrorReason::kNoFocusedTab:
      return "kNoFocusedTab";
    case ScrollToErrorReason::kNoMatchFound:
      return "kNoMatchFound";
    case ScrollToErrorReason::kFocusedTabChangedOrNavigated:
      return "kFocusedTabChangedOrNavigated";
    case ScrollToErrorReason::kNoMatchingDocument:
      return "kNoMatchingDocument";
    case ScrollToErrorReason::kSearchRangeInvalid:
      return "kSearchRangeInvalid";
    case ScrollToErrorReason::kTabContextPermissionDisabled:
      return "kTabContextPermissionDisabled";
    case ScrollToErrorReason::kDroppedByWebClient:
      return "kDroppedByWebClient";
    default:
      return nullptr;
  }
}

std::string ScrollToErrorReasonToString(ScrollToErrorReason value) {
  const char *str = ScrollToErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollToErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollToErrorReason value) {
  return os << ScrollToErrorReasonToString(value);
}

NOINLINE static const char* SwitchConversationErrorReasonToStringHelper(SwitchConversationErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SwitchConversationErrorReason::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string SwitchConversationErrorReasonToString(SwitchConversationErrorReason value) {
  const char *str = SwitchConversationErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SwitchConversationErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SwitchConversationErrorReason value) {
  return os << SwitchConversationErrorReasonToString(value);
}

NOINLINE static const char* RegisterConversationErrorReasonToStringHelper(RegisterConversationErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RegisterConversationErrorReason::kUnknown:
      return "kUnknown";
    case RegisterConversationErrorReason::kInstanceAlreadyHasConversationId:
      return "kInstanceAlreadyHasConversationId";
    default:
      return nullptr;
  }
}

std::string RegisterConversationErrorReasonToString(RegisterConversationErrorReason value) {
  const char *str = RegisterConversationErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RegisterConversationErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RegisterConversationErrorReason value) {
  return os << RegisterConversationErrorReasonToString(value);
}

NOINLINE static const char* PanelStateKindToStringHelper(PanelStateKind value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PanelStateKind::kHidden:
      return "kHidden";
    case PanelStateKind::kDetached:
      return "kDetached";
    case PanelStateKind::kAttached:
      return "kAttached";
    default:
      return nullptr;
  }
}

std::string PanelStateKindToString(PanelStateKind value) {
  const char *str = PanelStateKindToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PanelStateKind value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PanelStateKind value) {
  return os << PanelStateKindToString(value);
}

NOINLINE static const char* InvocationSourceToStringHelper(InvocationSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InvocationSource::kOsButton:
      return "kOsButton";
    case InvocationSource::kOsButtonMenu:
      return "kOsButtonMenu";
    case InvocationSource::kOsHotkey:
      return "kOsHotkey";
    case InvocationSource::kTopChromeButton:
      return "kTopChromeButton";
    case InvocationSource::kFre:
      return "kFre";
    case InvocationSource::kProfilePicker:
      return "kProfilePicker";
    case InvocationSource::kNudge:
      return "kNudge";
    case InvocationSource::kThreeDotsMenu:
      return "kThreeDotsMenu";
    case InvocationSource::kUnsupported:
      return "kUnsupported";
    case InvocationSource::kWhatsNew:
      return "kWhatsNew";
    case InvocationSource::kAfterSignIn:
      return "kAfterSignIn";
    case InvocationSource::kSharedTab:
      return "kSharedTab";
    case InvocationSource::kActorTaskIcon:
      return "kActorTaskIcon";
    case InvocationSource::kSharedImage:
      return "kSharedImage";
    case InvocationSource::kHandoffButton:
      return "kHandoffButton";
    default:
      return nullptr;
  }
}

std::string InvocationSourceToString(InvocationSource value) {
  const char *str = InvocationSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InvocationSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InvocationSource value) {
  return os << InvocationSourceToString(value);
}

NOINLINE static const char* WebClientModeToStringHelper(WebClientMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebClientMode::kText:
      return "kText";
    case WebClientMode::kAudio:
      return "kAudio";
    case WebClientMode::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string WebClientModeToString(WebClientMode value) {
  const char *str = WebClientModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebClientMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebClientMode value) {
  return os << WebClientModeToString(value);
}

NOINLINE static const char* WebClientModelToStringHelper(WebClientModel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebClientModel::kDefault:
      return "kDefault";
    case WebClientModel::kActor:
      return "kActor";
    default:
      return nullptr;
  }
}

std::string WebClientModelToString(WebClientModel value) {
  const char *str = WebClientModelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebClientModel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebClientModel value) {
  return os << WebClientModelToString(value);
}

NOINLINE static const char* WebUseCounterToStringHelper(WebUseCounter value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebUseCounter::kDefault:
      return "kDefault";
    case WebUseCounter::kSubmitPromptWithAutoMode:
      return "kSubmitPromptWithAutoMode";
    default:
      return nullptr;
  }
}

std::string WebUseCounterToString(WebUseCounter value) {
  const char *str = WebUseCounterToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebUseCounter value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebUseCounter value) {
  return os << WebUseCounterToString(value);
}

NOINLINE static const char* ResponseStopCauseToStringHelper(ResponseStopCause value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ResponseStopCause::kUnknown:
      return "kUnknown";
    case ResponseStopCause::kUser:
      return "kUser";
    case ResponseStopCause::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string ResponseStopCauseToString(ResponseStopCause value) {
  const char *str = ResponseStopCauseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ResponseStopCause value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ResponseStopCause value) {
  return os << ResponseStopCauseToString(value);
}

NOINLINE static const char* CaptureRegionErrorReasonToStringHelper(CaptureRegionErrorReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CaptureRegionErrorReason::kUnknown:
      return "kUnknown";
    case CaptureRegionErrorReason::kNoFocusableTab:
      return "kNoFocusableTab";
    default:
      return nullptr;
  }
}

std::string CaptureRegionErrorReasonToString(CaptureRegionErrorReason value) {
  const char *str = CaptureRegionErrorReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CaptureRegionErrorReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CaptureRegionErrorReason value) {
  return os << CaptureRegionErrorReasonToString(value);
}

NOINLINE static const char* SettingsPageFieldToStringHelper(SettingsPageField value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SettingsPageField::kNone:
      return "kNone";
    case SettingsPageField::kOsHotkey:
      return "kOsHotkey";
    case SettingsPageField::kOsEntrypointToggle:
      return "kOsEntrypointToggle";
    default:
      return nullptr;
  }
}

std::string SettingsPageFieldToString(SettingsPageField value) {
  const char *str = SettingsPageFieldToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SettingsPageField value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SettingsPageField value) {
  return os << SettingsPageFieldToString(value);
}

NOINLINE static const char* HostCapabilityToStringHelper(HostCapability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HostCapability::kScrollToPdf:
      return "kScrollToPdf";
    case HostCapability::kResetSizeAndLocationOnOpen:
      return "kResetSizeAndLocationOnOpen";
    case HostCapability::kGetModelQualityClientId:
      return "kGetModelQualityClientId";
    case HostCapability::kMultiInstance:
      return "kMultiInstance";
    default:
      return nullptr;
  }
}

std::string HostCapabilityToString(HostCapability value) {
  const char *str = HostCapabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HostCapability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HostCapability value) {
  return os << HostCapabilityToString(value);
}

NOINLINE static const char* CurrentViewToStringHelper(CurrentView value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CurrentView::kConversation:
      return "kConversation";
    case CurrentView::kActuation:
      return "kActuation";
    default:
      return nullptr;
  }
}

std::string CurrentViewToString(CurrentView value) {
  const char *str = CurrentViewToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CurrentView value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CurrentView value) {
  return os << CurrentViewToString(value);
}

namespace internal {
// static
bool GetContextResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetContextResult_Data* object = static_cast<const GetContextResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetContextResult_Tag::kErrorReason: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_reason, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_reason_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error_reason, validation_context,
                                             &error_reason_validate_params)) {
        return false;
      }
      return true;
    }
    case GetContextResult_Tag::kTabContext: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_context, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_context, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetContextResult");
      return false;
    }
  }
}
// static
bool CaptureScreenshotResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CaptureScreenshotResult_Data* object = static_cast<const CaptureScreenshotResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CaptureScreenshotResult_Tag::kErrorReason: {


      if (!::glic::mojom::internal::CaptureScreenshotErrorReason_Data
            ::Validate(object->data.f_error_reason, validation_context))
        return false;
      return true;
    }
    case CaptureScreenshotResult_Tag::kScreenshot: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_screenshot, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_screenshot, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CaptureScreenshotResult");
      return false;
    }
  }
}
// static
bool ScrollToSelector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ScrollToSelector_Data* object = static_cast<const ScrollToSelector_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ScrollToSelector_Tag::kExactTextSelector: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_exact_text_selector, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_exact_text_selector, validation_context))
        return false;
      return true;
    }
    case ScrollToSelector_Tag::kTextFragmentSelector: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_text_fragment_selector, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_text_fragment_selector, validation_context))
        return false;
      return true;
    }
    case ScrollToSelector_Tag::kNodeSelector: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_node_selector, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_node_selector, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ScrollToSelector");
      return false;
    }
  }
}
// static
bool AdditionalContextPart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AdditionalContextPart_Data* object = static_cast<const AdditionalContextPart_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AdditionalContextPart_Tag::kData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data, validation_context))
        return false;
      return true;
    }
    case AdditionalContextPart_Tag::kScreenshot: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_screenshot, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_screenshot, validation_context))
        return false;
      return true;
    }
    case AdditionalContextPart_Tag::kWebPageData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_web_page_data, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_web_page_data, validation_context))
        return false;
      return true;
    }
    case AdditionalContextPart_Tag::kAnnotatedPageData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_annotated_page_data, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_annotated_page_data, validation_context))
        return false;
      return true;
    }
    case AdditionalContextPart_Tag::kPdfDocumentData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pdf_document_data, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pdf_document_data, validation_context))
        return false;
      return true;
    }
    case AdditionalContextPart_Tag::kTabContext: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tab_context, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tab_context, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AdditionalContextPart");
      return false;
    }
  }
}
// static
bool FocusedTabData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FocusedTabData_Data* object = static_cast<const FocusedTabData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FocusedTabData_Tag::kFocusedTab: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_focused_tab, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_focused_tab, validation_context))
        return false;
      return true;
    }
    case FocusedTabData_Tag::kNoFocusedTabData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_no_focused_tab_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_no_focused_tab_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FocusedTabData");
      return false;
    }
  }
}
// static
bool CapturedRegion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CapturedRegion_Data* object = static_cast<const CapturedRegion_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CapturedRegion_Tag::kRect: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_rect, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_rect, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CapturedRegion");
      return false;
    }
  }
}
// static
bool ViewChangeRequestDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ViewChangeRequestDetails_Data* object = static_cast<const ViewChangeRequestDetails_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ViewChangeRequestDetails_Tag::kActuation: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_actuation, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_actuation, validation_context))
        return false;
      return true;
    }
    case ViewChangeRequestDetails_Tag::kConversation: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_conversation, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_conversation, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ViewChangeRequestDetails");
      return false;
    }
  }
}
// static
bool WebClientHandler_CreateTask_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebClientHandler_CreateTask_ResponseParam_Result_Data* object = static_cast<const WebClientHandler_CreateTask_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebClientHandler_CreateTask_ResponseParam_Result_Tag::kSuccess: {

      return true;
    }
    case WebClientHandler_CreateTask_ResponseParam_Result_Tag::kFailure: {


      if (!::glic::mojom::internal::CreateTaskErrorReason_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebClientHandler_CreateTask_ResponseParam_Result");
      return false;
    }
  }
}
// static
bool WebClientHandler_PerformActions_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebClientHandler_PerformActions_ResponseParam_Result_Data* object = static_cast<const WebClientHandler_PerformActions_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebClientHandler_PerformActions_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case WebClientHandler_PerformActions_ResponseParam_Result_Tag::kFailure: {


      if (!::glic::mojom::internal::PerformActionsErrorReason_Data
            ::Validate(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebClientHandler_PerformActions_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool GetContextResultWithActionResultCode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetContextResultWithActionResultCode_Data* object =
      static_cast<const GetContextResultWithActionResultCode_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->get_context_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->get_context_result, validation_context))
    return false;

  return true;
}

GetContextResultWithActionResultCode_Data::GetContextResultWithActionResultCode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UserProfileInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UserProfileInfo_Data* object =
      static_cast<const UserProfileInfo_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->avatar_icon, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_profile_name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& local_profile_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->local_profile_name, validation_context,
                                         &local_profile_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->email, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& email_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->email, validation_context,
                                         &email_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->given_name, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& given_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->given_name, validation_context,
                                         &given_name_validate_params)) {
    return false;
  }

  return true;
}

UserProfileInfo_Data::UserProfileInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientInitialState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientInitialState_Data* object =
      static_cast<const WebClientInitialState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->panel_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->panel_state, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->focused_tab_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->focused_tab_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hotkey, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hotkey_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hotkey, validation_context,
                                         &hotkey_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->chrome_version, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->chrome_version, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_capabilities, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_capabilities_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::glic::mojom::internal::HostCapability_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->host_capabilities, validation_context,
                                         &host_capabilities_validate_params)) {
    return false;
  }

  return true;
}

WebClientInitialState_Data::WebClientInitialState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetTabContextOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetTabContextOptions_Data* object =
      static_cast<const GetTabContextOptions_Data*>(data);

  return true;
}

GetTabContextOptions_Data::GetTabContextOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GetPinCandidatesOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GetPinCandidatesOptions_Data* object =
      static_cast<const GetPinCandidatesOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  return true;
}

GetPinCandidatesOptions_Data::GetPinCandidatesOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollToParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollToParams_Data* object =
      static_cast<const ScrollToParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->selector, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->selector, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->document_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ScrollToParams_Data::ScrollToParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollToTextSelector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollToTextSelector_Data* object =
      static_cast<const ScrollToTextSelector_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

ScrollToTextSelector_Data::ScrollToTextSelector_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollToTextFragmentSelector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollToTextFragmentSelector_Data* object =
      static_cast<const ScrollToTextFragmentSelector_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_start, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_start_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_start, validation_context,
                                         &text_start_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_end, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_end_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_end, validation_context,
                                         &text_end_validate_params)) {
    return false;
  }

  return true;
}

ScrollToTextFragmentSelector_Data::ScrollToTextFragmentSelector_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollToNodeSelector_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollToNodeSelector_Data* object =
      static_cast<const ScrollToNodeSelector_Data*>(data);

  return true;
}

ScrollToNodeSelector_Data::ScrollToNodeSelector_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SuggestionContent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SuggestionContent_Data* object =
      static_cast<const SuggestionContent_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestion, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestion_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestion, validation_context,
                                         &suggestion_validate_params)) {
    return false;
  }

  return true;
}

SuggestionContent_Data::SuggestionContent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ZeroStateSuggestions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ZeroStateSuggestions_Data* object =
      static_cast<const ZeroStateSuggestions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_url, validation_context))
    return false;

  return true;
}

ZeroStateSuggestions_Data::ZeroStateSuggestions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ZeroStateSuggestionsV2_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ZeroStateSuggestionsV2_Data* object =
      static_cast<const ZeroStateSuggestionsV2_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suggestions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suggestions, validation_context,
                                         &suggestions_validate_params)) {
    return false;
  }

  return true;
}

ZeroStateSuggestionsV2_Data::ZeroStateSuggestionsV2_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ZeroStateSuggestionsOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ZeroStateSuggestionsOptions_Data* object =
      static_cast<const ZeroStateSuggestionsOptions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supported_tools, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supported_tools_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->supported_tools, validation_context,
                                         &supported_tools_validate_params)) {
    return false;
  }

  return true;
}

ZeroStateSuggestionsOptions_Data::ZeroStateSuggestionsOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinCandidate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinCandidate_Data* object =
      static_cast<const PinCandidate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  return true;
}

PinCandidate_Data::PinCandidate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConversationInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConversationInfo_Data* object =
      static_cast<const ConversationInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversation_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& conversation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->conversation_id, validation_context,
                                         &conversation_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conversation_title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& conversation_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->conversation_title, validation_context,
                                         &conversation_title_validate_params)) {
    return false;
  }

  return true;
}

ConversationInfo_Data::ConversationInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PanelOpeningData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PanelOpeningData_Data* object =
      static_cast<const PanelOpeningData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->panel_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->panel_state, validation_context))
    return false;


  if (!::glic::mojom::internal::InvocationSource_Data
        ::Validate(object->invocation_source, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& conversation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->conversation_id, validation_context,
                                         &conversation_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& prompt_suggestion_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prompt_suggestion, validation_context,
                                         &prompt_suggestion_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& recently_active_conversations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->recently_active_conversations, validation_context,
                                         &recently_active_conversations_validate_params)) {
    return false;
  }

  return true;
}

PanelOpeningData_Data::PanelOpeningData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PanelState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PanelState_Data* object =
      static_cast<const PanelState_Data*>(data);


  if (!::glic::mojom::internal::PanelStateKind_Data
        ::Validate(object->kind, validation_context))
    return false;

  return true;
}

PanelState_Data::PanelState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnResponseStoppedDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnResponseStoppedDetails_Data* object =
      static_cast<const OnResponseStoppedDetails_Data*>(data);


  if (!::glic::mojom::internal::ResponseStopCause_Data
        ::Validate(object->cause, validation_context))
    return false;

  return true;
}

OnResponseStoppedDetails_Data::OnResponseStoppedDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenPanelInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpenPanelInfo_Data* object =
      static_cast<const OpenPanelInfo_Data*>(data);


  if (!::glic::mojom::internal::WebClientMode_Data
        ::Validate(object->web_client_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->panelSize, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resizeDuration, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resizeDuration, validation_context))
    return false;

  return true;
}

OpenPanelInfo_Data::OpenPanelInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextData_Data* object =
      static_cast<const ContextData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

ContextData_Data::ContextData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdditionalContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdditionalContext_Data* object =
      static_cast<const AdditionalContext_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frameUrl, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parts, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parts, validation_context,
                                         &parts_validate_params)) {
    return false;
  }

  return true;
}

AdditionalContext_Data::AdditionalContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabContext_Data* object =
      static_cast<const TabContext_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->web_page_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->viewport_screenshot, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_document_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->annotated_page_data, validation_context))
    return false;

  return true;
}

TabContext_Data::TabContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebPageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebPageData_Data* object =
      static_cast<const WebPageData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_document, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_document, validation_context))
    return false;

  return true;
}

WebPageData_Data::WebPageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentData_Data* object =
      static_cast<const DocumentData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inner_text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& inner_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->inner_text, validation_context,
                                         &inner_text_validate_params)) {
    return false;
  }

  return true;
}

DocumentData_Data::DocumentData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfDocumentData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfDocumentData_Data* object =
      static_cast<const PdfDocumentData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& pdf_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pdf_data, validation_context,
                                         &pdf_data_validate_params)) {
    return false;
  }

  return true;
}

PdfDocumentData_Data::PdfDocumentData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabData_Data* object =
      static_cast<const TabData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->favicon, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_mime_type, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& document_mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->document_mime_type, validation_context,
                                         &document_mime_type_validate_params)) {
    return false;
  }

  return true;
}

TabData_Data::TabData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NoFocusedTabData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NoFocusedTabData_Data* object =
      static_cast<const NoFocusedTabData_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->active_tab_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->no_focus_reason, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& no_focus_reason_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->no_focus_reason, validation_context,
                                         &no_focus_reason_validate_params)) {
    return false;
  }

  return true;
}

NoFocusedTabData_Data::NoFocusedTabData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnnotatedPageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnnotatedPageData_Data* object =
      static_cast<const AnnotatedPageData_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->annotated_page_content, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

AnnotatedPageData_Data::AnnotatedPageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageOriginAnnotations_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageOriginAnnotations_Data* object =
      static_cast<const ImageOriginAnnotations_Data*>(data);

  return true;
}

ImageOriginAnnotations_Data::ImageOriginAnnotations_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Journal_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Journal_Data* object =
      static_cast<const Journal_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

Journal_Data::Journal_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CaptureRegionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CaptureRegionResult_Data* object =
      static_cast<const CaptureRegionResult_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->region, validation_context))
    return false;

  return true;
}

CaptureRegionResult_Data::CaptureRegionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screenshot_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screenshot_Data* object =
      static_cast<const Screenshot_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_annotations, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_annotations, validation_context))
    return false;

  return true;
}

Screenshot_Data::Screenshot_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpenSettingsOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpenSettingsOptions_Data* object =
      static_cast<const OpenSettingsOptions_Data*>(data);


  if (!::glic::mojom::internal::SettingsPageField_Data
        ::Validate(object->highlightField, validation_context))
    return false;

  return true;
}

OpenSettingsOptions_Data::OpenSettingsOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewChangeRequestActuation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewChangeRequestActuation_Data* object =
      static_cast<const ViewChangeRequestActuation_Data*>(data);

  return true;
}

ViewChangeRequestActuation_Data::ViewChangeRequestActuation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewChangeRequestConversation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewChangeRequestConversation_Data* object =
      static_cast<const ViewChangeRequestConversation_Data*>(data);

  return true;
}

ViewChangeRequestConversation_Data::ViewChangeRequestConversation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewChangeRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewChangeRequest_Data* object =
      static_cast<const ViewChangeRequest_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->details, validation_context))
    return false;

  return true;
}

ViewChangeRequest_Data::ViewChangeRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewChangedNotification_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewChangedNotification_Data* object =
      static_cast<const ViewChangedNotification_Data*>(data);


  if (!::glic::mojom::internal::CurrentView_Data
        ::Validate(object->current_view, validation_context))
    return false;

  return true;
}

ViewChangedNotification_Data::ViewChangedNotification_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_IntentToShow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_IntentToShow_Params_Data* object =
      static_cast<const Page_IntentToShow_Params_Data*>(data);

  return true;
}

Page_IntentToShow_Params_Data::Page_IntentToShow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetProfileReadyState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetProfileReadyState_Params_Data* object =
      static_cast<const Page_SetProfileReadyState_Params_Data*>(data);


  if (!::glic::mojom::internal::ProfileReadyState_Data
        ::Validate(object->ready_state, validation_context))
    return false;

  return true;
}

Page_SetProfileReadyState_Params_Data::Page_SetProfileReadyState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_UpdatePageState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_UpdatePageState_Params_Data* object =
      static_cast<const Page_UpdatePageState_Params_Data*>(data);


  if (!::glic::mojom::internal::PanelStateKind_Data
        ::Validate(object->panelStateKind, validation_context))
    return false;

  return true;
}

Page_UpdatePageState_Params_Data::Page_UpdatePageState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_CreateWebClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_CreateWebClient_Params_Data* object =
      static_cast<const PageHandler_CreateWebClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_client_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_CreateWebClient_Params_Data::PageHandler_CreateWebClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_PrepareForClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_PrepareForClient_Params_Data* object =
      static_cast<const PageHandler_PrepareForClient_Params_Data*>(data);

  return true;
}

PageHandler_PrepareForClient_Params_Data::PageHandler_PrepareForClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_PrepareForClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_PrepareForClient_ResponseParams_Data* object =
      static_cast<const PageHandler_PrepareForClient_ResponseParams_Data*>(data);


  if (!::glic::mojom::internal::PrepareForClientResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

PageHandler_PrepareForClient_ResponseParams_Data::PageHandler_PrepareForClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_WebviewCommitted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_WebviewCommitted_Params_Data* object =
      static_cast<const PageHandler_WebviewCommitted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PageHandler_WebviewCommitted_Params_Data::PageHandler_WebviewCommitted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClosePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClosePanel_Params_Data* object =
      static_cast<const PageHandler_ClosePanel_Params_Data*>(data);

  return true;
}

PageHandler_ClosePanel_Params_Data::PageHandler_ClosePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClosePanel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClosePanel_ResponseParams_Data* object =
      static_cast<const PageHandler_ClosePanel_ResponseParams_Data*>(data);

  return true;
}

PageHandler_ClosePanel_ResponseParams_Data::PageHandler_ClosePanel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenProfilePickerAndClosePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenProfilePickerAndClosePanel_Params_Data* object =
      static_cast<const PageHandler_OpenProfilePickerAndClosePanel_Params_Data*>(data);

  return true;
}

PageHandler_OpenProfilePickerAndClosePanel_Params_Data::PageHandler_OpenProfilePickerAndClosePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data* object =
      static_cast<const PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data*>(data);

  return true;
}

PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data::PageHandler_OpenDisabledByAdminLinkAndClosePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SignInAndClosePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SignInAndClosePanel_Params_Data* object =
      static_cast<const PageHandler_SignInAndClosePanel_Params_Data*>(data);

  return true;
}

PageHandler_SignInAndClosePanel_Params_Data::PageHandler_SignInAndClosePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ResizeWidget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ResizeWidget_Params_Data* object =
      static_cast<const PageHandler_ResizeWidget_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

PageHandler_ResizeWidget_Params_Data::PageHandler_ResizeWidget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ResizeWidget_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ResizeWidget_ResponseParams_Data* object =
      static_cast<const PageHandler_ResizeWidget_ResponseParams_Data*>(data);

  return true;
}

PageHandler_ResizeWidget_ResponseParams_Data::PageHandler_ResizeWidget_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_EnableDragResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_EnableDragResize_Params_Data* object =
      static_cast<const PageHandler_EnableDragResize_Params_Data*>(data);

  return true;
}

PageHandler_EnableDragResize_Params_Data::PageHandler_EnableDragResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_WebUiStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_WebUiStateChanged_Params_Data* object =
      static_cast<const PageHandler_WebUiStateChanged_Params_Data*>(data);


  if (!::glic::mojom::internal::WebUiState_Data
        ::Validate(object->new_state, validation_context))
    return false;

  return true;
}

PageHandler_WebUiStateChanged_Params_Data::PageHandler_WebUiStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PinCandidatesObserver_OnPinCandidatesChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PinCandidatesObserver_OnPinCandidatesChanged_Params_Data* object =
      static_cast<const PinCandidatesObserver_OnPinCandidatesChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->candidates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& candidates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->candidates, validation_context,
                                         &candidates_validate_params)) {
    return false;
  }

  return true;
}

PinCandidatesObserver_OnPinCandidatesChanged_Params_Data::PinCandidatesObserver_OnPinCandidatesChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_WebClientCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_WebClientCreated_Params_Data* object =
      static_cast<const WebClientHandler_WebClientCreated_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebClientHandler_WebClientCreated_Params_Data::WebClientHandler_WebClientCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_WebClientCreated_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_WebClientCreated_ResponseParams_Data* object =
      static_cast<const WebClientHandler_WebClientCreated_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initial_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initial_state, validation_context))
    return false;

  return true;
}

WebClientHandler_WebClientCreated_ResponseParams_Data::WebClientHandler_WebClientCreated_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_WebClientInitialized_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_WebClientInitialized_Params_Data* object =
      static_cast<const WebClientHandler_WebClientInitialized_Params_Data*>(data);

  return true;
}

WebClientHandler_WebClientInitialized_Params_Data::WebClientHandler_WebClientInitialized_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_WebClientInitializeFailed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_WebClientInitializeFailed_Params_Data* object =
      static_cast<const WebClientHandler_WebClientInitializeFailed_Params_Data*>(data);

  return true;
}

WebClientHandler_WebClientInitializeFailed_Params_Data::WebClientHandler_WebClientInitializeFailed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateTab_Params_Data* object =
      static_cast<const WebClientHandler_CreateTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebClientHandler_CreateTab_Params_Data::WebClientHandler_CreateTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_CreateTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  return true;
}

WebClientHandler_CreateTab_ResponseParams_Data::WebClientHandler_CreateTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OpenLinkInPopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OpenLinkInPopup_Params_Data* object =
      static_cast<const WebClientHandler_OpenLinkInPopup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebClientHandler_OpenLinkInPopup_Params_Data::WebClientHandler_OpenLinkInPopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OpenGlicSettingsPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OpenGlicSettingsPage_Params_Data* object =
      static_cast<const WebClientHandler_OpenGlicSettingsPage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClientHandler_OpenGlicSettingsPage_Params_Data::WebClientHandler_OpenGlicSettingsPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OpenPasswordManagerSettingsPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OpenPasswordManagerSettingsPage_Params_Data* object =
      static_cast<const WebClientHandler_OpenPasswordManagerSettingsPage_Params_Data*>(data);

  return true;
}

WebClientHandler_OpenPasswordManagerSettingsPage_Params_Data::WebClientHandler_OpenPasswordManagerSettingsPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ClosePanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ClosePanel_Params_Data* object =
      static_cast<const WebClientHandler_ClosePanel_Params_Data*>(data);

  return true;
}

WebClientHandler_ClosePanel_Params_Data::WebClientHandler_ClosePanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ClosePanelAndShutdown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ClosePanelAndShutdown_Params_Data* object =
      static_cast<const WebClientHandler_ClosePanelAndShutdown_Params_Data*>(data);

  return true;
}

WebClientHandler_ClosePanelAndShutdown_Params_Data::WebClientHandler_ClosePanelAndShutdown_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_AttachPanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_AttachPanel_Params_Data* object =
      static_cast<const WebClientHandler_AttachPanel_Params_Data*>(data);

  return true;
}

WebClientHandler_AttachPanel_Params_Data::WebClientHandler_AttachPanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_DetachPanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_DetachPanel_Params_Data* object =
      static_cast<const WebClientHandler_DetachPanel_Params_Data*>(data);

  return true;
}

WebClientHandler_DetachPanel_Params_Data::WebClientHandler_DetachPanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnModeChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnModeChange_Params_Data* object =
      static_cast<const WebClientHandler_OnModeChange_Params_Data*>(data);


  if (!::glic::mojom::internal::WebClientMode_Data
        ::Validate(object->new_mode, validation_context))
    return false;

  return true;
}

WebClientHandler_OnModeChange_Params_Data::WebClientHandler_OnModeChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ShowProfilePicker_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ShowProfilePicker_Params_Data* object =
      static_cast<const WebClientHandler_ShowProfilePicker_Params_Data*>(data);

  return true;
}

WebClientHandler_ShowProfilePicker_Params_Data::WebClientHandler_ShowProfilePicker_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetModelQualityClientId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetModelQualityClientId_Params_Data* object =
      static_cast<const WebClientHandler_GetModelQualityClientId_Params_Data*>(data);

  return true;
}

WebClientHandler_GetModelQualityClientId_Params_Data::WebClientHandler_GetModelQualityClientId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetModelQualityClientId_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetModelQualityClientId_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetModelQualityClientId_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_quality_client_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_quality_client_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_quality_client_id, validation_context,
                                         &model_quality_client_id_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_GetModelQualityClientId_ResponseParams_Data::WebClientHandler_GetModelQualityClientId_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextFromFocusedTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextFromFocusedTab_Params_Data* object =
      static_cast<const WebClientHandler_GetContextFromFocusedTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextFromFocusedTab_Params_Data::WebClientHandler_GetContextFromFocusedTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data::WebClientHandler_GetContextFromFocusedTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextFromTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextFromTab_Params_Data* object =
      static_cast<const WebClientHandler_GetContextFromTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextFromTab_Params_Data::WebClientHandler_GetContextFromTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextFromTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextFromTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetContextFromTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextFromTab_ResponseParams_Data::WebClientHandler_GetContextFromTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextForActorFromTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextForActorFromTab_Params_Data* object =
      static_cast<const WebClientHandler_GetContextForActorFromTab_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextForActorFromTab_Params_Data::WebClientHandler_GetContextForActorFromTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetContextForActorFromTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetContextForActorFromTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetContextForActorFromTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_GetContextForActorFromTab_ResponseParams_Data::WebClientHandler_GetContextForActorFromTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data* object =
      static_cast<const WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data*>(data);

  return true;
}

WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data::WebClientHandler_SetMaximumNumberOfPinnedTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data::WebClientHandler_SetMaximumNumberOfPinnedTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_PinTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_PinTabs_Params_Data* object =
      static_cast<const WebClientHandler_PinTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_ids, validation_context,
                                         &tab_ids_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_PinTabs_Params_Data::WebClientHandler_PinTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_PinTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_PinTabs_ResponseParams_Data* object =
      static_cast<const WebClientHandler_PinTabs_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_PinTabs_ResponseParams_Data::WebClientHandler_PinTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_UnpinTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_UnpinTabs_Params_Data* object =
      static_cast<const WebClientHandler_UnpinTabs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_ids, validation_context,
                                         &tab_ids_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_UnpinTabs_Params_Data::WebClientHandler_UnpinTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_UnpinTabs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_UnpinTabs_ResponseParams_Data* object =
      static_cast<const WebClientHandler_UnpinTabs_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_UnpinTabs_ResponseParams_Data::WebClientHandler_UnpinTabs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_UnpinAllTabs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_UnpinAllTabs_Params_Data* object =
      static_cast<const WebClientHandler_UnpinAllTabs_Params_Data*>(data);

  return true;
}

WebClientHandler_UnpinAllTabs_Params_Data::WebClientHandler_UnpinAllTabs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SubscribeToPinCandidates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SubscribeToPinCandidates_Params_Data* object =
      static_cast<const WebClientHandler_SubscribeToPinCandidates_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebClientHandler_SubscribeToPinCandidates_Params_Data::WebClientHandler_SubscribeToPinCandidates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateTask_Params_Data* object =
      static_cast<const WebClientHandler_CreateTask_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->task_options, validation_context))
    return false;

  return true;
}

WebClientHandler_CreateTask_Params_Data::WebClientHandler_CreateTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateTask_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateTask_ResponseParams_Data* object =
      static_cast<const WebClientHandler_CreateTask_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_CreateTask_ResponseParams_Data::WebClientHandler_CreateTask_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_PerformActions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_PerformActions_Params_Data* object =
      static_cast<const WebClientHandler_PerformActions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actions_proto, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actions_proto_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actions_proto, validation_context,
                                         &actions_proto_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_PerformActions_Params_Data::WebClientHandler_PerformActions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_PerformActions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_PerformActions_ResponseParams_Data* object =
      static_cast<const WebClientHandler_PerformActions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_PerformActions_ResponseParams_Data::WebClientHandler_PerformActions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_StopActorTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_StopActorTask_Params_Data* object =
      static_cast<const WebClientHandler_StopActorTask_Params_Data*>(data);


  if (!::glic::mojom::internal::ActorTaskStopReason_Data
        ::Validate(object->stop_reason, validation_context))
    return false;

  return true;
}

WebClientHandler_StopActorTask_Params_Data::WebClientHandler_StopActorTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_PauseActorTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_PauseActorTask_Params_Data* object =
      static_cast<const WebClientHandler_PauseActorTask_Params_Data*>(data);


  if (!::glic::mojom::internal::ActorTaskPauseReason_Data
        ::Validate(object->pause_reason, validation_context))
    return false;

  return true;
}

WebClientHandler_PauseActorTask_Params_Data::WebClientHandler_PauseActorTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ResumeActorTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ResumeActorTask_Params_Data* object =
      static_cast<const WebClientHandler_ResumeActorTask_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_options, validation_context))
    return false;

  return true;
}

WebClientHandler_ResumeActorTask_Params_Data::WebClientHandler_ResumeActorTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ResumeActorTask_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ResumeActorTask_ResponseParams_Data* object =
      static_cast<const WebClientHandler_ResumeActorTask_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_ResumeActorTask_ResponseParams_Data::WebClientHandler_ResumeActorTask_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_InterruptActorTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_InterruptActorTask_Params_Data* object =
      static_cast<const WebClientHandler_InterruptActorTask_Params_Data*>(data);

  return true;
}

WebClientHandler_InterruptActorTask_Params_Data::WebClientHandler_InterruptActorTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_UninterruptActorTask_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_UninterruptActorTask_Params_Data* object =
      static_cast<const WebClientHandler_UninterruptActorTask_Params_Data*>(data);

  return true;
}

WebClientHandler_UninterruptActorTask_Params_Data::WebClientHandler_UninterruptActorTask_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateActorTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateActorTab_Params_Data* object =
      static_cast<const WebClientHandler_CreateActorTab_Params_Data*>(data);

  return true;
}

WebClientHandler_CreateActorTab_Params_Data::WebClientHandler_CreateActorTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CreateActorTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CreateActorTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_CreateActorTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  return true;
}

WebClientHandler_CreateActorTab_ResponseParams_Data::WebClientHandler_CreateActorTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ActivateTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ActivateTab_Params_Data* object =
      static_cast<const WebClientHandler_ActivateTab_Params_Data*>(data);

  return true;
}

WebClientHandler_ActivateTab_Params_Data::WebClientHandler_ActivateTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ResizeWidget_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ResizeWidget_Params_Data* object =
      static_cast<const WebClientHandler_ResizeWidget_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

WebClientHandler_ResizeWidget_Params_Data::WebClientHandler_ResizeWidget_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ResizeWidget_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ResizeWidget_ResponseParams_Data* object =
      static_cast<const WebClientHandler_ResizeWidget_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_ResizeWidget_ResponseParams_Data::WebClientHandler_ResizeWidget_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CaptureScreenshot_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CaptureScreenshot_Params_Data* object =
      static_cast<const WebClientHandler_CaptureScreenshot_Params_Data*>(data);

  return true;
}

WebClientHandler_CaptureScreenshot_Params_Data::WebClientHandler_CaptureScreenshot_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CaptureScreenshot_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CaptureScreenshot_ResponseParams_Data* object =
      static_cast<const WebClientHandler_CaptureScreenshot_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebClientHandler_CaptureScreenshot_ResponseParams_Data::WebClientHandler_CaptureScreenshot_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_CaptureRegion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_CaptureRegion_Params_Data* object =
      static_cast<const WebClientHandler_CaptureRegion_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebClientHandler_CaptureRegion_Params_Data::WebClientHandler_CaptureRegion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetAudioDucking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetAudioDucking_Params_Data* object =
      static_cast<const WebClientHandler_SetAudioDucking_Params_Data*>(data);

  return true;
}

WebClientHandler_SetAudioDucking_Params_Data::WebClientHandler_SetAudioDucking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetAudioDucking_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetAudioDucking_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetAudioDucking_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetAudioDucking_ResponseParams_Data::WebClientHandler_SetAudioDucking_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetPanelDraggableAreas_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetPanelDraggableAreas_Params_Data* object =
      static_cast<const WebClientHandler_SetPanelDraggableAreas_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->draggable_areas, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& draggable_areas_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->draggable_areas, validation_context,
                                         &draggable_areas_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_SetPanelDraggableAreas_Params_Data::WebClientHandler_SetPanelDraggableAreas_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data::WebClientHandler_SetPanelDraggableAreas_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetMinimumPanelSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetMinimumPanelSize_Params_Data* object =
      static_cast<const WebClientHandler_SetMinimumPanelSize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

WebClientHandler_SetMinimumPanelSize_Params_Data::WebClientHandler_SetMinimumPanelSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetMicrophonePermissionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetMicrophonePermissionState_Params_Data* object =
      static_cast<const WebClientHandler_SetMicrophonePermissionState_Params_Data*>(data);

  return true;
}

WebClientHandler_SetMicrophonePermissionState_Params_Data::WebClientHandler_SetMicrophonePermissionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data::WebClientHandler_SetMicrophonePermissionState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetLocationPermissionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetLocationPermissionState_Params_Data* object =
      static_cast<const WebClientHandler_SetLocationPermissionState_Params_Data*>(data);

  return true;
}

WebClientHandler_SetLocationPermissionState_Params_Data::WebClientHandler_SetLocationPermissionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetLocationPermissionState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetLocationPermissionState_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetLocationPermissionState_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetLocationPermissionState_ResponseParams_Data::WebClientHandler_SetLocationPermissionState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetTabContextPermissionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetTabContextPermissionState_Params_Data* object =
      static_cast<const WebClientHandler_SetTabContextPermissionState_Params_Data*>(data);

  return true;
}

WebClientHandler_SetTabContextPermissionState_Params_Data::WebClientHandler_SetTabContextPermissionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetTabContextPermissionState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetTabContextPermissionState_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetTabContextPermissionState_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetTabContextPermissionState_ResponseParams_Data::WebClientHandler_SetTabContextPermissionState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetClosedCaptioningSetting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetClosedCaptioningSetting_Params_Data* object =
      static_cast<const WebClientHandler_SetClosedCaptioningSetting_Params_Data*>(data);

  return true;
}

WebClientHandler_SetClosedCaptioningSetting_Params_Data::WebClientHandler_SetClosedCaptioningSetting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data::WebClientHandler_SetClosedCaptioningSetting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetActuationOnWebSetting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetActuationOnWebSetting_Params_Data* object =
      static_cast<const WebClientHandler_SetActuationOnWebSetting_Params_Data*>(data);

  return true;
}

WebClientHandler_SetActuationOnWebSetting_Params_Data::WebClientHandler_SetActuationOnWebSetting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetActuationOnWebSetting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetActuationOnWebSetting_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SetActuationOnWebSetting_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SetActuationOnWebSetting_ResponseParams_Data::WebClientHandler_SetActuationOnWebSetting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data* object =
      static_cast<const WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data*>(data);

  return true;
}

WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data::WebClientHandler_ShouldAllowMediaPermissionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data* object =
      static_cast<const WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data::WebClientHandler_ShouldAllowMediaPermissionRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data* object =
      static_cast<const WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data*>(data);

  return true;
}

WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data::WebClientHandler_ShouldAllowGeolocationPermissionRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data* object =
      static_cast<const WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data::WebClientHandler_ShouldAllowGeolocationPermissionRequest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetContextAccessIndicator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetContextAccessIndicator_Params_Data* object =
      static_cast<const WebClientHandler_SetContextAccessIndicator_Params_Data*>(data);

  return true;
}

WebClientHandler_SetContextAccessIndicator_Params_Data::WebClientHandler_SetContextAccessIndicator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetUserProfileInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetUserProfileInfo_Params_Data* object =
      static_cast<const WebClientHandler_GetUserProfileInfo_Params_Data*>(data);

  return true;
}

WebClientHandler_GetUserProfileInfo_Params_Data::WebClientHandler_GetUserProfileInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetUserProfileInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetUserProfileInfo_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetUserProfileInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->profile_info, validation_context))
    return false;

  return true;
}

WebClientHandler_GetUserProfileInfo_ResponseParams_Data::WebClientHandler_GetUserProfileInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SyncCookies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SyncCookies_Params_Data* object =
      static_cast<const WebClientHandler_SyncCookies_Params_Data*>(data);

  return true;
}

WebClientHandler_SyncCookies_Params_Data::WebClientHandler_SyncCookies_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SyncCookies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SyncCookies_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SyncCookies_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SyncCookies_ResponseParams_Data::WebClientHandler_SyncCookies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_LogBeginAsyncEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_LogBeginAsyncEvent_Params_Data* object =
      static_cast<const WebClientHandler_LogBeginAsyncEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event, validation_context,
                                         &event_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_LogBeginAsyncEvent_Params_Data::WebClientHandler_LogBeginAsyncEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_LogEndAsyncEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_LogEndAsyncEvent_Params_Data* object =
      static_cast<const WebClientHandler_LogEndAsyncEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_LogEndAsyncEvent_Params_Data::WebClientHandler_LogEndAsyncEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_LogInstantEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_LogInstantEvent_Params_Data* object =
      static_cast<const WebClientHandler_LogInstantEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event, validation_context,
                                         &event_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_LogInstantEvent_Params_Data::WebClientHandler_LogInstantEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalClear_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalClear_Params_Data* object =
      static_cast<const WebClientHandler_JournalClear_Params_Data*>(data);

  return true;
}

WebClientHandler_JournalClear_Params_Data::WebClientHandler_JournalClear_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalSnapshot_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalSnapshot_Params_Data* object =
      static_cast<const WebClientHandler_JournalSnapshot_Params_Data*>(data);

  return true;
}

WebClientHandler_JournalSnapshot_Params_Data::WebClientHandler_JournalSnapshot_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalSnapshot_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalSnapshot_ResponseParams_Data* object =
      static_cast<const WebClientHandler_JournalSnapshot_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->journal, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->journal, validation_context))
    return false;

  return true;
}

WebClientHandler_JournalSnapshot_ResponseParams_Data::WebClientHandler_JournalSnapshot_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalStart_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalStart_Params_Data* object =
      static_cast<const WebClientHandler_JournalStart_Params_Data*>(data);

  return true;
}

WebClientHandler_JournalStart_Params_Data::WebClientHandler_JournalStart_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalStop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalStop_Params_Data* object =
      static_cast<const WebClientHandler_JournalStop_Params_Data*>(data);

  return true;
}

WebClientHandler_JournalStop_Params_Data::WebClientHandler_JournalStop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_JournalRecordFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_JournalRecordFeedback_Params_Data* object =
      static_cast<const WebClientHandler_JournalRecordFeedback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reason, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reason_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reason, validation_context,
                                         &reason_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_JournalRecordFeedback_Params_Data::WebClientHandler_JournalRecordFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnUserInputSubmitted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnUserInputSubmitted_Params_Data* object =
      static_cast<const WebClientHandler_OnUserInputSubmitted_Params_Data*>(data);


  if (!::glic::mojom::internal::WebClientMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

WebClientHandler_OnUserInputSubmitted_Params_Data::WebClientHandler_OnUserInputSubmitted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnContextUploadStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnContextUploadStarted_Params_Data* object =
      static_cast<const WebClientHandler_OnContextUploadStarted_Params_Data*>(data);

  return true;
}

WebClientHandler_OnContextUploadStarted_Params_Data::WebClientHandler_OnContextUploadStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnContextUploadCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnContextUploadCompleted_Params_Data* object =
      static_cast<const WebClientHandler_OnContextUploadCompleted_Params_Data*>(data);

  return true;
}

WebClientHandler_OnContextUploadCompleted_Params_Data::WebClientHandler_OnContextUploadCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnReaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnReaction_Params_Data* object =
      static_cast<const WebClientHandler_OnReaction_Params_Data*>(data);


  if (!::glic::mojom::internal::MetricUserInputReactionType_Data
        ::Validate(object->reactionType, validation_context))
    return false;

  return true;
}

WebClientHandler_OnReaction_Params_Data::WebClientHandler_OnReaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnResponseStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnResponseStarted_Params_Data* object =
      static_cast<const WebClientHandler_OnResponseStarted_Params_Data*>(data);

  return true;
}

WebClientHandler_OnResponseStarted_Params_Data::WebClientHandler_OnResponseStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnResponseStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnResponseStopped_Params_Data* object =
      static_cast<const WebClientHandler_OnResponseStopped_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

WebClientHandler_OnResponseStopped_Params_Data::WebClientHandler_OnResponseStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnSessionTerminated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnSessionTerminated_Params_Data* object =
      static_cast<const WebClientHandler_OnSessionTerminated_Params_Data*>(data);

  return true;
}

WebClientHandler_OnSessionTerminated_Params_Data::WebClientHandler_OnSessionTerminated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnTurnCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnTurnCompleted_Params_Data* object =
      static_cast<const WebClientHandler_OnTurnCompleted_Params_Data*>(data);


  if (!::glic::mojom::internal::WebClientModel_Data
        ::Validate(object->model, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

WebClientHandler_OnTurnCompleted_Params_Data::WebClientHandler_OnTurnCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnModelChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnModelChanged_Params_Data* object =
      static_cast<const WebClientHandler_OnModelChanged_Params_Data*>(data);


  if (!::glic::mojom::internal::WebClientModel_Data
        ::Validate(object->model, validation_context))
    return false;

  return true;
}

WebClientHandler_OnModelChanged_Params_Data::WebClientHandler_OnModelChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnRecordUseCounter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnRecordUseCounter_Params_Data* object =
      static_cast<const WebClientHandler_OnRecordUseCounter_Params_Data*>(data);

  return true;
}

WebClientHandler_OnRecordUseCounter_Params_Data::WebClientHandler_OnRecordUseCounter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnResponseRated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnResponseRated_Params_Data* object =
      static_cast<const WebClientHandler_OnResponseRated_Params_Data*>(data);

  return true;
}

WebClientHandler_OnResponseRated_Params_Data::WebClientHandler_OnResponseRated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnClosedCaptionsShown_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnClosedCaptionsShown_Params_Data* object =
      static_cast<const WebClientHandler_OnClosedCaptionsShown_Params_Data*>(data);

  return true;
}

WebClientHandler_OnClosedCaptionsShown_Params_Data::WebClientHandler_OnClosedCaptionsShown_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ScrollTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ScrollTo_Params_Data* object =
      static_cast<const WebClientHandler_ScrollTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebClientHandler_ScrollTo_Params_Data::WebClientHandler_ScrollTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_ScrollTo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_ScrollTo_ResponseParams_Data* object =
      static_cast<const WebClientHandler_ScrollTo_ResponseParams_Data*>(data);


  if (!::glic::mojom::internal::ScrollToErrorReason_Data
        ::Validate(object->error_reason_$value, validation_context))
    return false;

  return true;
}

WebClientHandler_ScrollTo_ResponseParams_Data::WebClientHandler_ScrollTo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_DropScrollToHighlight_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_DropScrollToHighlight_Params_Data* object =
      static_cast<const WebClientHandler_DropScrollToHighlight_Params_Data*>(data);

  return true;
}

WebClientHandler_DropScrollToHighlight_Params_Data::WebClientHandler_DropScrollToHighlight_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SetSyntheticExperimentState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SetSyntheticExperimentState_Params_Data* object =
      static_cast<const WebClientHandler_SetSyntheticExperimentState_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->trial_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& trial_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->trial_name, validation_context,
                                         &trial_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_name, validation_context,
                                         &group_name_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_SetSyntheticExperimentState_Params_Data::WebClientHandler_SetSyntheticExperimentState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data* object =
      static_cast<const WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data*>(data);


  if (!::content_settings::mojom::internal::ContentSettingsType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data::WebClientHandler_OpenOsPermissionSettingsMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data* object =
      static_cast<const WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data*>(data);

  return true;
}

WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data::WebClientHandler_GetOsMicrophonePermissionStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data::WebClientHandler_GetOsMicrophonePermissionStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data* object =
      static_cast<const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->zero_state_suggestions, validation_context))
    return false;

  return true;
}

WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data::WebClientHandler_GetZeroStateSuggestionsAndSubscribe_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data* object =
      static_cast<const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data*>(data);

  return true;
}

WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data* object =
      static_cast<const WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->suggestions, validation_context))
    return false;

  return true;
}

WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data::WebClientHandler_GetZeroStateSuggestionsForFocusedTab_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_MaybeRefreshUserStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_MaybeRefreshUserStatus_Params_Data* object =
      static_cast<const WebClientHandler_MaybeRefreshUserStatus_Params_Data*>(data);

  return true;
}

WebClientHandler_MaybeRefreshUserStatus_Params_Data::WebClientHandler_MaybeRefreshUserStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_IsDebuggerAttached_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_IsDebuggerAttached_Params_Data* object =
      static_cast<const WebClientHandler_IsDebuggerAttached_Params_Data*>(data);

  return true;
}

WebClientHandler_IsDebuggerAttached_Params_Data::WebClientHandler_IsDebuggerAttached_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_IsDebuggerAttached_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_IsDebuggerAttached_ResponseParams_Data* object =
      static_cast<const WebClientHandler_IsDebuggerAttached_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_IsDebuggerAttached_ResponseParams_Data::WebClientHandler_IsDebuggerAttached_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_OnViewChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_OnViewChanged_Params_Data* object =
      static_cast<const WebClientHandler_OnViewChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->notification, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->notification, validation_context))
    return false;

  return true;
}

WebClientHandler_OnViewChanged_Params_Data::WebClientHandler_OnViewChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SubscribeToPageMetadata_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SubscribeToPageMetadata_Params_Data* object =
      static_cast<const WebClientHandler_SubscribeToPageMetadata_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->names, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& names_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->names, validation_context,
                                         &names_validate_params)) {
    return false;
  }

  return true;
}

WebClientHandler_SubscribeToPageMetadata_Params_Data::WebClientHandler_SubscribeToPageMetadata_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data*>(data);

  return true;
}

WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data::WebClientHandler_SubscribeToPageMetadata_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SwitchConversation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SwitchConversation_Params_Data* object =
      static_cast<const WebClientHandler_SwitchConversation_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

WebClientHandler_SwitchConversation_Params_Data::WebClientHandler_SwitchConversation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_SwitchConversation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_SwitchConversation_ResponseParams_Data* object =
      static_cast<const WebClientHandler_SwitchConversation_ResponseParams_Data*>(data);


  if (!::glic::mojom::internal::SwitchConversationErrorReason_Data
        ::Validate(object->error_reason_$value, validation_context))
    return false;

  return true;
}

WebClientHandler_SwitchConversation_ResponseParams_Data::WebClientHandler_SwitchConversation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_RegisterConversation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_RegisterConversation_Params_Data* object =
      static_cast<const WebClientHandler_RegisterConversation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

WebClientHandler_RegisterConversation_Params_Data::WebClientHandler_RegisterConversation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClientHandler_RegisterConversation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClientHandler_RegisterConversation_ResponseParams_Data* object =
      static_cast<const WebClientHandler_RegisterConversation_ResponseParams_Data*>(data);


  if (!::glic::mojom::internal::RegisterConversationErrorReason_Data
        ::Validate(object->error_reason_$value, validation_context))
    return false;

  return true;
}

WebClientHandler_RegisterConversation_ResponseParams_Data::WebClientHandler_RegisterConversation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelWillOpen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelWillOpen_Params_Data* object =
      static_cast<const WebClient_NotifyPanelWillOpen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->panel_opening_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->panel_opening_data, validation_context))
    return false;

  return true;
}

WebClient_NotifyPanelWillOpen_Params_Data::WebClient_NotifyPanelWillOpen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelWillOpen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelWillOpen_ResponseParams_Data* object =
      static_cast<const WebClient_NotifyPanelWillOpen_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->openPanelInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->openPanelInfo, validation_context))
    return false;

  return true;
}

WebClient_NotifyPanelWillOpen_ResponseParams_Data::WebClient_NotifyPanelWillOpen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelWasClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelWasClosed_Params_Data* object =
      static_cast<const WebClient_NotifyPanelWasClosed_Params_Data*>(data);

  return true;
}

WebClient_NotifyPanelWasClosed_Params_Data::WebClient_NotifyPanelWasClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelWasClosed_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelWasClosed_ResponseParams_Data* object =
      static_cast<const WebClient_NotifyPanelWasClosed_ResponseParams_Data*>(data);

  return true;
}

WebClient_NotifyPanelWasClosed_ResponseParams_Data::WebClient_NotifyPanelWasClosed_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelStateChange_Params_Data* object =
      static_cast<const WebClient_NotifyPanelStateChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->panel_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->panel_state, validation_context))
    return false;

  return true;
}

WebClient_NotifyPanelStateChange_Params_Data::WebClient_NotifyPanelStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelActiveChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelActiveChange_Params_Data* object =
      static_cast<const WebClient_NotifyPanelActiveChange_Params_Data*>(data);

  return true;
}

WebClient_NotifyPanelActiveChange_Params_Data::WebClient_NotifyPanelActiveChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPanelCanAttachChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPanelCanAttachChange_Params_Data* object =
      static_cast<const WebClient_NotifyPanelCanAttachChange_Params_Data*>(data);

  return true;
}

WebClient_NotifyPanelCanAttachChange_Params_Data::WebClient_NotifyPanelCanAttachChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyMicrophonePermissionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyMicrophonePermissionStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyMicrophonePermissionStateChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyMicrophonePermissionStateChanged_Params_Data::WebClient_NotifyMicrophonePermissionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyLocationPermissionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyLocationPermissionStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyLocationPermissionStateChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyLocationPermissionStateChanged_Params_Data::WebClient_NotifyLocationPermissionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyTabContextPermissionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyTabContextPermissionStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyTabContextPermissionStateChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyTabContextPermissionStateChanged_Params_Data::WebClient_NotifyTabContextPermissionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyOsLocationPermissionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyOsLocationPermissionStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyOsLocationPermissionStateChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyOsLocationPermissionStateChanged_Params_Data::WebClient_NotifyOsLocationPermissionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyFocusedTabChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyFocusedTabChanged_Params_Data* object =
      static_cast<const WebClient_NotifyFocusedTabChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->focused_tab_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->focused_tab_data, validation_context))
    return false;

  return true;
}

WebClient_NotifyFocusedTabChanged_Params_Data::WebClient_NotifyFocusedTabChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyManualResizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyManualResizeChanged_Params_Data* object =
      static_cast<const WebClient_NotifyManualResizeChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyManualResizeChanged_Params_Data::WebClient_NotifyManualResizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyOsHotkeyStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyOsHotkeyStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyOsHotkeyStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hotkey, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hotkey_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hotkey, validation_context,
                                         &hotkey_validate_params)) {
    return false;
  }

  return true;
}

WebClient_NotifyOsHotkeyStateChanged_Params_Data::WebClient_NotifyOsHotkeyStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyBrowserIsOpenChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyBrowserIsOpenChanged_Params_Data* object =
      static_cast<const WebClient_NotifyBrowserIsOpenChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyBrowserIsOpenChanged_Params_Data::WebClient_NotifyBrowserIsOpenChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyInstanceActivationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyInstanceActivationChanged_Params_Data* object =
      static_cast<const WebClient_NotifyInstanceActivationChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyInstanceActivationChanged_Params_Data::WebClient_NotifyInstanceActivationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyClosedCaptioningSettingChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyClosedCaptioningSettingChanged_Params_Data* object =
      static_cast<const WebClient_NotifyClosedCaptioningSettingChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyClosedCaptioningSettingChanged_Params_Data::WebClient_NotifyClosedCaptioningSettingChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPinnedTabsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPinnedTabsChanged_Params_Data* object =
      static_cast<const WebClient_NotifyPinnedTabsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tab_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tab_data, validation_context,
                                         &tab_data_validate_params)) {
    return false;
  }

  return true;
}

WebClient_NotifyPinnedTabsChanged_Params_Data::WebClient_NotifyPinnedTabsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPinnedTabDataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPinnedTabDataChanged_Params_Data* object =
      static_cast<const WebClient_NotifyPinnedTabDataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  return true;
}

WebClient_NotifyPinnedTabDataChanged_Params_Data::WebClient_NotifyPinnedTabDataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyZeroStateSuggestionsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyZeroStateSuggestionsChanged_Params_Data* object =
      static_cast<const WebClient_NotifyZeroStateSuggestionsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->suggestions, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebClient_NotifyZeroStateSuggestionsChanged_Params_Data::WebClient_NotifyZeroStateSuggestionsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyActorTaskStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyActorTaskStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyActorTaskStateChanged_Params_Data*>(data);


  if (!::glic::mojom::internal::ActorTaskState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

WebClient_NotifyActorTaskStateChanged_Params_Data::WebClient_NotifyActorTaskStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyTabDataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyTabDataChanged_Params_Data* object =
      static_cast<const WebClient_NotifyTabDataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab_data, validation_context))
    return false;

  return true;
}

WebClient_NotifyTabDataChanged_Params_Data::WebClient_NotifyTabDataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestViewChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestViewChange_Params_Data* object =
      static_cast<const WebClient_RequestViewChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebClient_RequestViewChange_Params_Data::WebClient_RequestViewChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyPageMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyPageMetadataChanged_Params_Data* object =
      static_cast<const WebClient_NotifyPageMetadataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

WebClient_NotifyPageMetadataChanged_Params_Data::WebClient_NotifyPageMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data* object =
      static_cast<const WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data::WebClient_NotifyDefaultTabContextPermissionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowCredentialSelectionDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowCredentialSelectionDialog_Params_Data* object =
      static_cast<const WebClient_RequestToShowCredentialSelectionDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowCredentialSelectionDialog_Params_Data::WebClient_RequestToShowCredentialSelectionDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data* object =
      static_cast<const WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data::WebClient_RequestToShowCredentialSelectionDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowAutofillSuggestionsDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowAutofillSuggestionsDialog_Params_Data* object =
      static_cast<const WebClient_RequestToShowAutofillSuggestionsDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowAutofillSuggestionsDialog_Params_Data::WebClient_RequestToShowAutofillSuggestionsDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams_Data* object =
      static_cast<const WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams_Data::WebClient_RequestToShowAutofillSuggestionsDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowUserConfirmationDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowUserConfirmationDialog_Params_Data* object =
      static_cast<const WebClient_RequestToShowUserConfirmationDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowUserConfirmationDialog_Params_Data::WebClient_RequestToShowUserConfirmationDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data* object =
      static_cast<const WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data::WebClient_RequestToShowUserConfirmationDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToConfirmNavigation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToConfirmNavigation_Params_Data* object =
      static_cast<const WebClient_RequestToConfirmNavigation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

WebClient_RequestToConfirmNavigation_Params_Data::WebClient_RequestToConfirmNavigation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_RequestToConfirmNavigation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_RequestToConfirmNavigation_ResponseParams_Data* object =
      static_cast<const WebClient_RequestToConfirmNavigation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response, validation_context))
    return false;

  return true;
}

WebClient_RequestToConfirmNavigation_ResponseParams_Data::WebClient_RequestToConfirmNavigation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyAdditionalContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyAdditionalContext_Params_Data* object =
      static_cast<const WebClient_NotifyAdditionalContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context, validation_context))
    return false;

  return true;
}

WebClient_NotifyAdditionalContext_Params_Data::WebClient_NotifyAdditionalContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyActuationOnWebSettingChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyActuationOnWebSettingChanged_Params_Data* object =
      static_cast<const WebClient_NotifyActuationOnWebSettingChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyActuationOnWebSettingChanged_Params_Data::WebClient_NotifyActuationOnWebSettingChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebClient_NotifyActOnWebCapabilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebClient_NotifyActOnWebCapabilityChanged_Params_Data* object =
      static_cast<const WebClient_NotifyActOnWebCapabilityChanged_Params_Data*>(data);

  return true;
}

WebClient_NotifyActOnWebCapabilityChanged_Params_Data::WebClient_NotifyActOnWebCapabilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CaptureRegionObserver_OnUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CaptureRegionObserver_OnUpdate_Params_Data* object =
      static_cast<const CaptureRegionObserver_OnUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;


  if (!::glic::mojom::internal::CaptureRegionErrorReason_Data
        ::Validate(object->reason_$value, validation_context))
    return false;

  return true;
}

CaptureRegionObserver_OnUpdate_Params_Data::CaptureRegionObserver_OnUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace glic

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ProfileReadyState>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ProfileReadyState value) {
  return std::move(context).WriteString(::glic::mojom::ProfileReadyStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::WebUiState>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::WebUiState value) {
  return std::move(context).WriteString(::glic::mojom::WebUiStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::MetricUserInputReactionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::MetricUserInputReactionType value) {
  return std::move(context).WriteString(::glic::mojom::MetricUserInputReactionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::PrepareForClientResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::PrepareForClientResult value) {
  return std::move(context).WriteString(::glic::mojom::PrepareForClientResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::PerformActionsErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::PerformActionsErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::PerformActionsErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::CreateTaskErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::CreateTaskErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::CreateTaskErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ActorTaskState>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ActorTaskState value) {
  return std::move(context).WriteString(::glic::mojom::ActorTaskStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ActorTaskPauseReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ActorTaskPauseReason value) {
  return std::move(context).WriteString(::glic::mojom::ActorTaskPauseReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ActorTaskStopReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ActorTaskStopReason value) {
  return std::move(context).WriteString(::glic::mojom::ActorTaskStopReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::CaptureScreenshotErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::CaptureScreenshotErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::CaptureScreenshotErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ScrollToErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ScrollToErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::ScrollToErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::SwitchConversationErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::SwitchConversationErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::SwitchConversationErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::RegisterConversationErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::RegisterConversationErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::RegisterConversationErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::PanelStateKind>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::PanelStateKind value) {
  return std::move(context).WriteString(::glic::mojom::PanelStateKindToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::InvocationSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::InvocationSource value) {
  return std::move(context).WriteString(::glic::mojom::InvocationSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::WebClientMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::WebClientMode value) {
  return std::move(context).WriteString(::glic::mojom::WebClientModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::WebClientModel>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::WebClientModel value) {
  return std::move(context).WriteString(::glic::mojom::WebClientModelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::WebUseCounter>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::WebUseCounter value) {
  return std::move(context).WriteString(::glic::mojom::WebUseCounterToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::ResponseStopCause>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::ResponseStopCause value) {
  return std::move(context).WriteString(::glic::mojom::ResponseStopCauseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::CaptureRegionErrorReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::CaptureRegionErrorReason value) {
  return std::move(context).WriteString(::glic::mojom::CaptureRegionErrorReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::SettingsPageField>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::SettingsPageField value) {
  return std::move(context).WriteString(::glic::mojom::SettingsPageFieldToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::HostCapability>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::HostCapability value) {
  return std::move(context).WriteString(::glic::mojom::HostCapabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::glic::mojom::CurrentView>::WriteIntoTrace(
   perfetto::TracedValue context, ::glic::mojom::CurrentView value) {
  return std::move(context).WriteString(::glic::mojom::CurrentViewToString(value));
}

} // namespace perfetto