// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef protocol_Security_h
#define protocol_Security_h

#include "chrome/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace protocol {
namespace Security {
using SecurityState = String;
class CertificateSecurityState;
using SafetyTipStatus = String;
class SafetyTipInfo;
class VisibleSecurityState;

// ------------- Forward and enum declarations.

namespace SecurityStateEnum {
 extern const char Unknown[];
 extern const char Neutral[];
 extern const char Insecure[];
 extern const char Secure[];
 extern const char Info[];
 extern const char InsecureBroken[];
} // namespace SecurityStateEnum

namespace SafetyTipStatusEnum {
 extern const char BadReputation[];
 extern const char Lookalike[];
} // namespace SafetyTipStatusEnum

// ------------- Type and builder declarations.

class  CertificateSecurityState : public ::crdtp::ProtocolObject<CertificateSecurityState> {
public:
    ~CertificateSecurityState() override;  // Defined below

    String GetProtocol() { return m_protocol; }
    void SetProtocol(const String& value);  // Defined below

    String GetKeyExchange() { return m_keyExchange; }
    void SetKeyExchange(const String& value);  // Defined below

    bool HasKeyExchangeGroup() { return !!m_keyExchangeGroup; }
    String GetKeyExchangeGroup(const String& defaultValue) const {
       return m_keyExchangeGroup.value_or(defaultValue);
    }
    const std::optional<String>& GetKeyExchangeGroup() const {
       return m_keyExchangeGroup;
    }
    void SetKeyExchangeGroup(const String& value);  // Defined below

    String GetCipher() { return m_cipher; }
    void SetCipher(const String& value);  // Defined below

    bool HasMac() { return !!m_mac; }
    String GetMac(const String& defaultValue) const {
       return m_mac.value_or(defaultValue);
    }
    const std::optional<String>& GetMac() const {
       return m_mac;
    }
    void SetMac(const String& value);  // Defined below

    protocol::Array<String>* GetCertificate() { return m_certificate.get(); }
    void SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    String GetSubjectName() { return m_subjectName; }
    void SetSubjectName(const String& value);  // Defined below

    String GetIssuer() { return m_issuer; }
    void SetIssuer(const String& value);  // Defined below

    double GetValidFrom() { return m_validFrom; }
    void SetValidFrom(double value);  // Defined below

    double GetValidTo() { return m_validTo; }
    void SetValidTo(double value);  // Defined below

    bool HasCertificateNetworkError() { return !!m_certificateNetworkError; }
    String GetCertificateNetworkError(const String& defaultValue) const {
       return m_certificateNetworkError.value_or(defaultValue);
    }
    const std::optional<String>& GetCertificateNetworkError() const {
       return m_certificateNetworkError;
    }
    void SetCertificateNetworkError(const String& value);  // Defined below

    bool GetCertificateHasWeakSignature() { return m_certificateHasWeakSignature; }
    void SetCertificateHasWeakSignature(bool value);  // Defined below

    bool GetCertificateHasSha1Signature() { return m_certificateHasSha1Signature; }
    void SetCertificateHasSha1Signature(bool value);  // Defined below

    bool GetModernSSL() { return m_modernSSL; }
    void SetModernSSL(bool value);  // Defined below

    bool GetObsoleteSslProtocol() { return m_obsoleteSslProtocol; }
    void SetObsoleteSslProtocol(bool value);  // Defined below

    bool GetObsoleteSslKeyExchange() { return m_obsoleteSslKeyExchange; }
    void SetObsoleteSslKeyExchange(bool value);  // Defined below

    bool GetObsoleteSslCipher() { return m_obsoleteSslCipher; }
    void SetObsoleteSslCipher(bool value);  // Defined below

    bool GetObsoleteSslSignature() { return m_obsoleteSslSignature; }
    void SetObsoleteSslSignature(bool value);  // Defined below

    template<int STATE>
    class CertificateSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            ProtocolSet = 1 << 1,
            KeyExchangeSet = 1 << 2,
            CipherSet = 1 << 3,
            CertificateSet = 1 << 4,
            SubjectNameSet = 1 << 5,
            IssuerSet = 1 << 6,
            ValidFromSet = 1 << 7,
            ValidToSet = 1 << 8,
            CertificateHasWeakSignatureSet = 1 << 9,
            CertificateHasSha1SignatureSet = 1 << 10,
            ModernSSLSet = 1 << 11,
            ObsoleteSslProtocolSet = 1 << 12,
            ObsoleteSslKeyExchangeSet = 1 << 13,
            ObsoleteSslCipherSet = 1 << 14,
            ObsoleteSslSignatureSet = 1 << 15,
            AllFieldsSet = (ProtocolSet | KeyExchangeSet | CipherSet | CertificateSet | SubjectNameSet | IssuerSet | ValidFromSet | ValidToSet | CertificateHasWeakSignatureSet | CertificateHasSha1SignatureSet | ModernSSLSet | ObsoleteSslProtocolSet | ObsoleteSslKeyExchangeSet | ObsoleteSslCipherSet | ObsoleteSslSignatureSet | 0)};


        CertificateSecurityStateBuilder<STATE | ProtocolSet>& SetProtocol(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | KeyExchangeSet>& SetKeyExchange(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetKeyExchangeGroup(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CipherSet>& SetCipher(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetMac(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateSet>& SetCertificate(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        CertificateSecurityStateBuilder<STATE | SubjectNameSet>& SetSubjectName(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | IssuerSet>& SetIssuer(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidFromSet>& SetValidFrom(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ValidToSet>& SetValidTo(double value);  // Defined below

        CertificateSecurityStateBuilder<STATE>& SetCertificateNetworkError(const String& value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasWeakSignatureSet>& SetCertificateHasWeakSignature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | CertificateHasSha1SignatureSet>& SetCertificateHasSha1Signature(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ModernSSLSet>& SetModernSSL(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslProtocolSet>& SetObsoleteSslProtocol(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslKeyExchangeSet>& SetObsoleteSslKeyExchange(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslCipherSet>& SetObsoleteSslCipher(bool value);  // Defined below

        CertificateSecurityStateBuilder<STATE | ObsoleteSslSignatureSet>& SetObsoleteSslSignature(bool value);  // Defined below

        std::unique_ptr<CertificateSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class CertificateSecurityState;
        CertificateSecurityStateBuilder() : m_result(new CertificateSecurityState()) { }

        template<int STEP> CertificateSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<CertificateSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::CertificateSecurityState> m_result;
    };

    static CertificateSecurityStateBuilder<0> Create()
    {
        return CertificateSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    CertificateSecurityState();  // Defined below

    String m_protocol;
    String m_keyExchange;
    std::optional<String> m_keyExchangeGroup;
    String m_cipher;
    std::optional<String> m_mac;
    std::unique_ptr<protocol::Array<String>> m_certificate;
    String m_subjectName;
    String m_issuer;
    double m_validFrom;
    double m_validTo;
    std::optional<String> m_certificateNetworkError;
    bool m_certificateHasWeakSignature;
    bool m_certificateHasSha1Signature;
    bool m_modernSSL;
    bool m_obsoleteSslProtocol;
    bool m_obsoleteSslKeyExchange;
    bool m_obsoleteSslCipher;
    bool m_obsoleteSslSignature;
};


class  SafetyTipInfo : public ::crdtp::ProtocolObject<SafetyTipInfo> {
public:
    ~SafetyTipInfo() override;  // Defined below

    String GetSafetyTipStatus() { return m_safetyTipStatus; }
    void SetSafetyTipStatus(const String& value);  // Defined below

    bool HasSafeUrl() { return !!m_safeUrl; }
    String GetSafeUrl(const String& defaultValue) const {
       return m_safeUrl.value_or(defaultValue);
    }
    const std::optional<String>& GetSafeUrl() const {
       return m_safeUrl;
    }
    void SetSafeUrl(const String& value);  // Defined below

    template<int STATE>
    class SafetyTipInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SafetyTipStatusSet = 1 << 1,
            AllFieldsSet = (SafetyTipStatusSet | 0)};


        SafetyTipInfoBuilder<STATE | SafetyTipStatusSet>& SetSafetyTipStatus(const String& value);  // Defined below

        SafetyTipInfoBuilder<STATE>& SetSafeUrl(const String& value);  // Defined below

        std::unique_ptr<SafetyTipInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class SafetyTipInfo;
        SafetyTipInfoBuilder() : m_result(new SafetyTipInfo()) { }

        template<int STEP> SafetyTipInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<SafetyTipInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::SafetyTipInfo> m_result;
    };

    static SafetyTipInfoBuilder<0> Create()
    {
        return SafetyTipInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    SafetyTipInfo();  // Defined below

    String m_safetyTipStatus;
    std::optional<String> m_safeUrl;
};


class  VisibleSecurityState : public ::crdtp::ProtocolObject<VisibleSecurityState> {
public:
    ~VisibleSecurityState() override;  // Defined below

    String GetSecurityState() { return m_securityState; }
    void SetSecurityState(const String& value);  // Defined below

    bool HasCertificateSecurityState() { return !!m_certificateSecurityState; }
    protocol::Security::CertificateSecurityState* GetCertificateSecurityState(protocol::Security::CertificateSecurityState* defaultValue) {
       return m_certificateSecurityState ? m_certificateSecurityState.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::CertificateSecurityState>& GetCertificateSecurityState() const {
       return m_certificateSecurityState;
    }
    void SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

    bool HasSafetyTipInfo() { return !!m_safetyTipInfo; }
    protocol::Security::SafetyTipInfo* GetSafetyTipInfo(protocol::Security::SafetyTipInfo* defaultValue) {
       return m_safetyTipInfo ? m_safetyTipInfo.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Security::SafetyTipInfo>& GetSafetyTipInfo() const {
       return m_safetyTipInfo;
    }
    void SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

    protocol::Array<String>* GetSecurityStateIssueIds() { return m_securityStateIssueIds.get(); }
    void SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class VisibleSecurityStateBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SecurityStateSet = 1 << 1,
            SecurityStateIssueIdsSet = 1 << 2,
            AllFieldsSet = (SecurityStateSet | SecurityStateIssueIdsSet | 0)};


        VisibleSecurityStateBuilder<STATE | SecurityStateSet>& SetSecurityState(const String& value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value);  // Defined below

        VisibleSecurityStateBuilder<STATE>& SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value);  // Defined below

        VisibleSecurityStateBuilder<STATE | SecurityStateIssueIdsSet>& SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<VisibleSecurityState> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class VisibleSecurityState;
        VisibleSecurityStateBuilder() : m_result(new VisibleSecurityState()) { }

        template<int STEP> VisibleSecurityStateBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<VisibleSecurityStateBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Security::VisibleSecurityState> m_result;
    };

    static VisibleSecurityStateBuilder<0> Create()
    {
        return VisibleSecurityStateBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    VisibleSecurityState();  // Defined below

    String m_securityState;
    std::unique_ptr<protocol::Security::CertificateSecurityState> m_certificateSecurityState;
    std::unique_ptr<protocol::Security::SafetyTipInfo> m_safetyTipInfo;
    std::unique_ptr<protocol::Array<String>> m_securityStateIssueIds;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline CertificateSecurityState::~CertificateSecurityState() = default;
inline void CertificateSecurityState::SetProtocol(const String& value) { m_protocol = value; }
inline void CertificateSecurityState::SetKeyExchange(const String& value) { m_keyExchange = value; }
inline void CertificateSecurityState::SetKeyExchangeGroup(const String& value) { m_keyExchangeGroup = value; }
inline void CertificateSecurityState::SetCipher(const String& value) { m_cipher = value; }
inline void CertificateSecurityState::SetMac(const String& value) { m_mac = value; }
inline void CertificateSecurityState::SetCertificate(std::unique_ptr<protocol::Array<String>> value) { m_certificate = std::move(value); }
inline void CertificateSecurityState::SetSubjectName(const String& value) { m_subjectName = value; }
inline void CertificateSecurityState::SetIssuer(const String& value) { m_issuer = value; }
inline void CertificateSecurityState::SetValidFrom(double value) { m_validFrom = value; }
inline void CertificateSecurityState::SetValidTo(double value) { m_validTo = value; }
inline void CertificateSecurityState::SetCertificateNetworkError(const String& value) { m_certificateNetworkError = value; }
inline void CertificateSecurityState::SetCertificateHasWeakSignature(bool value) { m_certificateHasWeakSignature = value; }
inline void CertificateSecurityState::SetCertificateHasSha1Signature(bool value) { m_certificateHasSha1Signature = value; }
inline void CertificateSecurityState::SetModernSSL(bool value) { m_modernSSL = value; }
inline void CertificateSecurityState::SetObsoleteSslProtocol(bool value) { m_obsoleteSslProtocol = value; }
inline void CertificateSecurityState::SetObsoleteSslKeyExchange(bool value) { m_obsoleteSslKeyExchange = value; }
inline void CertificateSecurityState::SetObsoleteSslCipher(bool value) { m_obsoleteSslCipher = value; }
inline void CertificateSecurityState::SetObsoleteSslSignature(bool value) { m_obsoleteSslSignature = value; }

template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetProtocol(const String& value) {
  static_assert(!(STATE & ProtocolSet), "property protocol should not be set yet");
  m_result->SetProtocol(value);
  return castState<ProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::KeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetKeyExchange(const String& value) {
  static_assert(!(STATE & KeyExchangeSet), "property keyExchange should not be set yet");
  m_result->SetKeyExchange(value);
  return castState<KeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetKeyExchangeGroup(const String& value) {
  m_result->SetKeyExchangeGroup(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCipher(const String& value) {
  static_assert(!(STATE & CipherSet), "property cipher should not be set yet");
  m_result->SetCipher(value);
  return castState<CipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetMac(const String& value) {
  m_result->SetMac(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificate(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & CertificateSet), "property certificate should not be set yet");
  m_result->SetCertificate(std::move(value));
  return castState<CertificateSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SubjectNameSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetSubjectName(const String& value) {
  static_assert(!(STATE & SubjectNameSet), "property subjectName should not be set yet");
  m_result->SetSubjectName(value);
  return castState<SubjectNameSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::IssuerSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetIssuer(const String& value) {
  static_assert(!(STATE & IssuerSet), "property issuer should not be set yet");
  m_result->SetIssuer(value);
  return castState<IssuerSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidFromSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetValidFrom(double value) {
  static_assert(!(STATE & ValidFromSet), "property validFrom should not be set yet");
  m_result->SetValidFrom(value);
  return castState<ValidFromSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ValidToSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetValidTo(double value) {
  static_assert(!(STATE & ValidToSet), "property validTo should not be set yet");
  m_result->SetValidTo(value);
  return castState<ValidToSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE>& CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateNetworkError(const String& value) {
  m_result->SetCertificateNetworkError(value);
  return *this;
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasWeakSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateHasWeakSignature(bool value) {
  static_assert(!(STATE & CertificateHasWeakSignatureSet), "property certificateHasWeakSignature should not be set yet");
  m_result->SetCertificateHasWeakSignature(value);
  return castState<CertificateHasWeakSignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::CertificateHasSha1SignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetCertificateHasSha1Signature(bool value) {
  static_assert(!(STATE & CertificateHasSha1SignatureSet), "property certificateHasSha1Signature should not be set yet");
  m_result->SetCertificateHasSha1Signature(value);
  return castState<CertificateHasSha1SignatureSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ModernSSLSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetModernSSL(bool value) {
  static_assert(!(STATE & ModernSSLSet), "property modernSSL should not be set yet");
  m_result->SetModernSSL(value);
  return castState<ModernSSLSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslProtocolSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslProtocol(bool value) {
  static_assert(!(STATE & ObsoleteSslProtocolSet), "property obsoleteSslProtocol should not be set yet");
  m_result->SetObsoleteSslProtocol(value);
  return castState<ObsoleteSslProtocolSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslKeyExchangeSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslKeyExchange(bool value) {
  static_assert(!(STATE & ObsoleteSslKeyExchangeSet), "property obsoleteSslKeyExchange should not be set yet");
  m_result->SetObsoleteSslKeyExchange(value);
  return castState<ObsoleteSslKeyExchangeSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslCipherSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslCipher(bool value) {
  static_assert(!(STATE & ObsoleteSslCipherSet), "property obsoleteSslCipher should not be set yet");
  m_result->SetObsoleteSslCipher(value);
  return castState<ObsoleteSslCipherSet>();
}
template<int STATE>
inline CertificateSecurityState::CertificateSecurityStateBuilder<STATE | CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::ObsoleteSslSignatureSet>&
CertificateSecurityState::CertificateSecurityStateBuilder<STATE>::SetObsoleteSslSignature(bool value) {
  static_assert(!(STATE & ObsoleteSslSignatureSet), "property obsoleteSslSignature should not be set yet");
  m_result->SetObsoleteSslSignature(value);
  return castState<ObsoleteSslSignatureSet>();
}

inline CertificateSecurityState::CertificateSecurityState() {
  m_validFrom = 0;
  m_validTo = 0;
  m_certificateHasWeakSignature = false;
  m_certificateHasSha1Signature = false;
  m_modernSSL = false;
  m_obsoleteSslProtocol = false;
  m_obsoleteSslKeyExchange = false;
  m_obsoleteSslCipher = false;
  m_obsoleteSslSignature = false;
}
inline SafetyTipInfo::~SafetyTipInfo() = default;
inline void SafetyTipInfo::SetSafetyTipStatus(const String& value) { m_safetyTipStatus = value; }
inline void SafetyTipInfo::SetSafeUrl(const String& value) { m_safeUrl = value; }

template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE | SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SafetyTipStatusSet>&
SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SetSafetyTipStatus(const String& value) {
  static_assert(!(STATE & SafetyTipStatusSet), "property safetyTipStatus should not be set yet");
  m_result->SetSafetyTipStatus(value);
  return castState<SafetyTipStatusSet>();
}
template<int STATE>
inline SafetyTipInfo::SafetyTipInfoBuilder<STATE>& SafetyTipInfo::SafetyTipInfoBuilder<STATE>::SetSafeUrl(const String& value) {
  m_result->SetSafeUrl(value);
  return *this;
}

inline SafetyTipInfo::SafetyTipInfo() {
}
inline VisibleSecurityState::~VisibleSecurityState() = default;
inline void VisibleSecurityState::SetSecurityState(const String& value) { m_securityState = value; }
inline void VisibleSecurityState::SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) { m_certificateSecurityState = std::move(value); }
inline void VisibleSecurityState::SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) { m_safetyTipInfo = std::move(value); }
inline void VisibleSecurityState::SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) { m_securityStateIssueIds = std::move(value); }

template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSecurityState(const String& value) {
  static_assert(!(STATE & SecurityStateSet), "property securityState should not be set yet");
  m_result->SetSecurityState(value);
  return castState<SecurityStateSet>();
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetCertificateSecurityState(std::unique_ptr<protocol::Security::CertificateSecurityState> value) {
  m_result->SetCertificateSecurityState(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE>& VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSafetyTipInfo(std::unique_ptr<protocol::Security::SafetyTipInfo> value) {
  m_result->SetSafetyTipInfo(std::move(value));
  return *this;
}
template<int STATE>
inline VisibleSecurityState::VisibleSecurityStateBuilder<STATE | VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SecurityStateIssueIdsSet>&
VisibleSecurityState::VisibleSecurityStateBuilder<STATE>::SetSecurityStateIssueIds(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & SecurityStateIssueIdsSet), "property securityStateIssueIds should not be set yet");
  m_result->SetSecurityStateIssueIds(std::move(value));
  return castState<SecurityStateIssueIdsSet>();
}

inline VisibleSecurityState::VisibleSecurityState() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Disable() = 0;
    virtual DispatchResponse Enable() = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void VisibleSecurityStateChanged(std::unique_ptr<protocol::Security::VisibleSecurityState> visibleSecurityState);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Security
} // namespace protocol

#endif // !defined(protocol_Security_h)
