// cc/mojom/paint_flags.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/paint_flags.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');


  var FilterQuality = {};
  FilterQuality.kNone = 0;
  FilterQuality.kLow = 1;
  FilterQuality.kMedium = 2;
  FilterQuality.kHigh = 3;
  FilterQuality.MIN_VALUE = 0;
  FilterQuality.MAX_VALUE = 3;

  FilterQuality.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  FilterQuality.toKnownEnumValue = function(value) {
    return value;
  };

  FilterQuality.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DynamicRangeLimit(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DynamicRangeLimit.prototype.initDefaults_ = function() {
    this.standardMix = 0;
    this.constrainedHighMix = 0;
  };
  DynamicRangeLimit.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DynamicRangeLimit.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  DynamicRangeLimit.encodedSize = codec.kStructHeaderSize + 8;

  DynamicRangeLimit.decode = function(decoder) {
    var packed;
    var val = new DynamicRangeLimit();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.standardMix =
        decoder.decodeStruct(codec.Float);
    val.constrainedHighMix =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  DynamicRangeLimit.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DynamicRangeLimit.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.standardMix);
    encoder.encodeStruct(codec.Float, val.constrainedHighMix);
  };
  exports.FilterQuality = FilterQuality;
  exports.DynamicRangeLimit = DynamicRangeLimit;
})();