// cc/mojom/layer_tree_debug_state.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/layer_tree_debug_state.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');



  function LayerTreeDebugState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerTreeDebugState.prototype.initDefaults_ = function() {
    this.debuggerPaused = false;
    this.showFpsCounter = false;
    this.showRenderPassBorders = false;
    this.showSurfaceBorders = false;
    this.showLayerBorders = false;
    this.showLayoutShiftRegions = false;
    this.showPaintRects = false;
    this.showPropertyChangedRects = false;
    this.showSurfaceDamageRects = false;
    this.showScreenSpaceRects = false;
    this.showTouchEventHandlerRects = false;
    this.showWheelEventHandlerRects = false;
    this.showScrollEventHandlerRects = false;
    this.showMainThreadScrollHitTestRects = false;
    this.showMainThreadScrollRepaintRects = false;
    this.showRasterInducingScrollRects = false;
    this.showLayerAnimationBoundsRects = false;
    this.rasterizeOnlyVisibleContent = false;
    this.highlightNonLcdTextLayers = false;
    this.recordRenderingStats = false;
    this.slowDownRasterScaleFactor = 0;
  };
  LayerTreeDebugState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerTreeDebugState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






















    return validator.validationError.NONE;
  };

  LayerTreeDebugState.encodedSize = codec.kStructHeaderSize + 8;

  LayerTreeDebugState.decode = function(decoder) {
    var packed;
    var val = new LayerTreeDebugState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.debuggerPaused = (packed >> 0) & 1 ? true : false;
    val.showFpsCounter = (packed >> 1) & 1 ? true : false;
    val.showRenderPassBorders = (packed >> 2) & 1 ? true : false;
    val.showSurfaceBorders = (packed >> 3) & 1 ? true : false;
    val.showLayerBorders = (packed >> 4) & 1 ? true : false;
    val.showLayoutShiftRegions = (packed >> 5) & 1 ? true : false;
    val.showPaintRects = (packed >> 6) & 1 ? true : false;
    val.showPropertyChangedRects = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.showSurfaceDamageRects = (packed >> 0) & 1 ? true : false;
    val.showScreenSpaceRects = (packed >> 1) & 1 ? true : false;
    val.showTouchEventHandlerRects = (packed >> 2) & 1 ? true : false;
    val.showWheelEventHandlerRects = (packed >> 3) & 1 ? true : false;
    val.showScrollEventHandlerRects = (packed >> 4) & 1 ? true : false;
    val.showMainThreadScrollHitTestRects = (packed >> 5) & 1 ? true : false;
    val.showMainThreadScrollRepaintRects = (packed >> 6) & 1 ? true : false;
    val.showRasterInducingScrollRects = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.showLayerAnimationBoundsRects = (packed >> 0) & 1 ? true : false;
    val.rasterizeOnlyVisibleContent = (packed >> 1) & 1 ? true : false;
    val.highlightNonLcdTextLayers = (packed >> 2) & 1 ? true : false;
    val.recordRenderingStats = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    val.slowDownRasterScaleFactor =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  LayerTreeDebugState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerTreeDebugState.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.debuggerPaused & 1) << 0
    packed |= (val.showFpsCounter & 1) << 1
    packed |= (val.showRenderPassBorders & 1) << 2
    packed |= (val.showSurfaceBorders & 1) << 3
    packed |= (val.showLayerBorders & 1) << 4
    packed |= (val.showLayoutShiftRegions & 1) << 5
    packed |= (val.showPaintRects & 1) << 6
    packed |= (val.showPropertyChangedRects & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.showSurfaceDamageRects & 1) << 0
    packed |= (val.showScreenSpaceRects & 1) << 1
    packed |= (val.showTouchEventHandlerRects & 1) << 2
    packed |= (val.showWheelEventHandlerRects & 1) << 3
    packed |= (val.showScrollEventHandlerRects & 1) << 4
    packed |= (val.showMainThreadScrollHitTestRects & 1) << 5
    packed |= (val.showMainThreadScrollRepaintRects & 1) << 6
    packed |= (val.showRasterInducingScrollRects & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.showLayerAnimationBoundsRects & 1) << 0
    packed |= (val.rasterizeOnlyVisibleContent & 1) << 1
    packed |= (val.highlightNonLcdTextLayers & 1) << 2
    packed |= (val.recordRenderingStats & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.slowDownRasterScaleFactor);
  };
  exports.LayerTreeDebugState = LayerTreeDebugState;
})();