// cc/mojom/browser_controls_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'cc/mojom/browser_controls_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('cc.mojom');



  function BrowserControlsParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BrowserControlsParams.prototype.initDefaults_ = function() {
    this.topControlsHeight = 0.0;
    this.topControlsMinHeight = 0.0;
    this.bottomControlsHeight = 0.0;
    this.bottomControlsMinHeight = 0.0;
    this.animateBrowserControlsHeightChanges = false;
    this.browserControlsShrinkBlinkSize = false;
    this.onlyExpandTopControlsAtPageTop = false;
  };
  BrowserControlsParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BrowserControlsParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;








    return validator.validationError.NONE;
  };

  BrowserControlsParams.encodedSize = codec.kStructHeaderSize + 24;

  BrowserControlsParams.decode = function(decoder) {
    var packed;
    var val = new BrowserControlsParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.topControlsHeight =
        decoder.decodeStruct(codec.Float);
    val.topControlsMinHeight =
        decoder.decodeStruct(codec.Float);
    val.bottomControlsHeight =
        decoder.decodeStruct(codec.Float);
    val.bottomControlsMinHeight =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.animateBrowserControlsHeightChanges = (packed >> 0) & 1 ? true : false;
    val.browserControlsShrinkBlinkSize = (packed >> 1) & 1 ? true : false;
    val.onlyExpandTopControlsAtPageTop = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BrowserControlsParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BrowserControlsParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.topControlsHeight);
    encoder.encodeStruct(codec.Float, val.topControlsMinHeight);
    encoder.encodeStruct(codec.Float, val.bottomControlsHeight);
    encoder.encodeStruct(codec.Float, val.bottomControlsMinHeight);
    packed = 0;
    packed |= (val.animateBrowserControlsHeightChanges & 1) << 0
    packed |= (val.browserControlsShrinkBlinkSize & 1) << 1
    packed |= (val.onlyExpandTopControlsAtPageTop & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.BrowserControlsParams = BrowserControlsParams;
})();