// cc/mojom/browser_controls_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "cc/mojom/browser_controls_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "cc/mojom/browser_controls_params.mojom-params-data.h"
#include "cc/mojom/browser_controls_params.mojom-shared-message-ids.h"

#include "cc/mojom/browser_controls_params.mojom-import-headers.h"
#include "cc/mojom/browser_controls_params.mojom-test-utils.h"


namespace cc::mojom {
BrowserControlsParams::BrowserControlsParams()
    : top_controls_height(0.0f),
      top_controls_min_height(0.0f),
      bottom_controls_height(0.0f),
      bottom_controls_min_height(0.0f),
      animate_browser_controls_height_changes(false),
      browser_controls_shrink_blink_size(false),
      only_expand_top_controls_at_page_top(false) {}

BrowserControlsParams::BrowserControlsParams(
    float top_controls_height_in,
    float top_controls_min_height_in,
    float bottom_controls_height_in,
    float bottom_controls_min_height_in,
    bool animate_browser_controls_height_changes_in,
    bool browser_controls_shrink_blink_size_in,
    bool only_expand_top_controls_at_page_top_in)
    : top_controls_height(std::move(top_controls_height_in)),
      top_controls_min_height(std::move(top_controls_min_height_in)),
      bottom_controls_height(std::move(bottom_controls_height_in)),
      bottom_controls_min_height(std::move(bottom_controls_min_height_in)),
      animate_browser_controls_height_changes(std::move(animate_browser_controls_height_changes_in)),
      browser_controls_shrink_blink_size(std::move(browser_controls_shrink_blink_size_in)),
      only_expand_top_controls_at_page_top(std::move(only_expand_top_controls_at_page_top_in)) {}

BrowserControlsParams::~BrowserControlsParams() = default;

void BrowserControlsParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_height"), this->top_controls_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_min_height"), this->top_controls_min_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_height"), this->bottom_controls_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bottom_controls_min_height"), this->bottom_controls_min_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "animate_browser_controls_height_changes"), this->animate_browser_controls_height_changes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_controls_shrink_blink_size"), this->browser_controls_shrink_blink_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "only_expand_top_controls_at_page_top"), this->only_expand_top_controls_at_page_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BrowserControlsParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // cc::mojom


namespace mojo {


// static
bool StructTraits<::cc::mojom::BrowserControlsParams::DataView, ::cc::mojom::BrowserControlsParamsPtr>::Read(
    ::cc::mojom::BrowserControlsParams::DataView input,
    ::cc::mojom::BrowserControlsParamsPtr* output) {
  bool success = true;
  ::cc::mojom::BrowserControlsParamsPtr result(::cc::mojom::BrowserControlsParams::New());
  
      if (success)
        result->top_controls_height = input.top_controls_height();
      if (success)
        result->top_controls_min_height = input.top_controls_min_height();
      if (success)
        result->bottom_controls_height = input.bottom_controls_height();
      if (success)
        result->bottom_controls_min_height = input.bottom_controls_min_height();
      if (success)
        result->animate_browser_controls_height_changes = input.animate_browser_controls_height_changes();
      if (success)
        result->browser_controls_shrink_blink_size = input.browser_controls_shrink_blink_size();
      if (success)
        result->only_expand_top_controls_at_page_top = input.only_expand_top_controls_at_page_top();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cc::mojom {




}  // cc::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif