# Relinking Guide

This folder contains the machine-readable object code and source snapshots that correspond to the Atlas Chromium distribution. It allows downstream developers to replace LGPL-covered objects with their own builds and relink the Atlas framework.

## Directory layout
- `SOURCES/` – matching source trees for each LGPL component bundled with Atlas.
- `OBJECTS/` – the GN output payload (objects, response files, `link.ninja`).
- `DOCS/` – documentation and license material shipped with the kit.

## Rebuild workflow
1. Fetch Chromium at version **143.0.7499.110** (see the `CHROMIUM_VERSION` file included with this kit) and install the toolchain described in the Chromium mac build instructions.
2. (Optional) overlay the source snapshot from this kit onto your Chromium tree to ensure you are rebuilding the exact revisions shipped by Atlas:
   ```
   rsync -a SOURCES/ path/to/your/chromium/src/
   ```
3. Apply your modifications to the desired LGPL component within that checkout.
4. Populate a fresh GN output directory using the kit contents (no `gn gen` step is required):
   ```
   rsync -a OBJECTS/ path/to/chromium/src/out/owl-official/
   ```
5. Create the expected macOS SDK symlink inside that output:
   ```
   python3 build/config/apple/sdk_info.py          --get_sdk_info          --create_symlink_at out/owl-official/sdk/xcode_links          macosx
   ```
6. Rebuild the LGPL object files with the self-contained wrapper:
   ```
   ninja -C out/owl-official -f lgpl_objects.ninja
   ```
7. Relink the Atlas framework from the same output directory:
   ```
   ninja -C out/owl-official -f link.ninja chrome_framework_shared_library
   ```
   When this finishes, `ChatGPT Atlas Framework.framework` contains your rebuilt LGPL objects.
8. Drop the resulting framework into Atlas (or another consumer) and distribute it alongside the unmodified Atlas application.
