// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef v8_inspector_protocol_Schema_h
#define v8_inspector_protocol_Schema_h

#include "src/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "include/inspector/Schema.h"

namespace v8_inspector {
namespace protocol {
namespace Schema {
class Domain;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class  Domain : public ::v8_crdtp::ProtocolObject<Domain>,
    public API::Domain {
public:
    ~Domain() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    String getVersion() { return m_version; }
    void setVersion(const String& value);  // Defined below

    template<int STATE>
    class DomainBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            VersionSet = 1 << 2,
            AllFieldsSet = (NameSet | VersionSet | 0)};


        DomainBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        DomainBuilder<STATE | VersionSet>& setVersion(const String& value);  // Defined below

        std::unique_ptr<Domain> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Domain;
        DomainBuilder() : m_result(new Domain()) { }

        template<int STEP> DomainBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DomainBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Schema::Domain> m_result;
    };

    static DomainBuilder<0> create()
    {
        return DomainBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Domain();  // Defined below

    String m_name;
    String m_version;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline Domain::~Domain() = default;
inline void Domain::setName(const String& value) { m_name = value; }
inline void Domain::setVersion(const String& value) { m_version = value; }

template<int STATE>
inline Domain::DomainBuilder<STATE | Domain::DomainBuilder<STATE>::NameSet>&
Domain::DomainBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Domain::DomainBuilder<STATE | Domain::DomainBuilder<STATE>::VersionSet>&
Domain::DomainBuilder<STATE>::setVersion(const String& value) {
  static_assert(!(STATE & VersionSet), "property version should not be set yet");
  m_result->setVersion(value);
  return castState<VersionSet>();
}

inline Domain::Domain() {
}

// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getDomains(std::unique_ptr<protocol::Array<protocol::Schema::Domain>>* out_domains) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Schema
} // namespace v8_inspector
} // namespace protocol

#endif // !defined(v8_inspector_protocol_Schema_h)
