import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { BigBuffer as mojoBase_mojom_BigBuffer } from '../../../mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { String16 as mojoBase_mojom_String16 } from '../../../mojo/public/mojom/base/string16.mojom-webui.js';
import { JSTime as mojoBase_mojom_JSTime, TimeDelta as mojoBase_mojom_TimeDelta, TimeTicks as mojoBase_mojom_TimeTicks } from '../../../mojo/public/mojom/base/time.mojom-webui.js';
import { UnguessableToken as mojoBase_mojom_UnguessableToken } from '../../../mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import { Point as gfx_mojom_Point } from '../../../ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import { Url as url_mojom_Url } from '../../../url/mojom/url.mojom-webui.js';
import { FileUploadErrorType as composeboxQuery_mojom_FileUploadErrorType, FileUploadStatus as composeboxQuery_mojom_FileUploadStatus } from '../composebox/composebox_query.mojom-webui.js';
import { NavigationPredictor as omnibox_mojom_NavigationPredictor } from './omnibox.mojom-webui.js';
export declare const ToolModeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum ToolMode {
    MIN_VALUE = 0,
    MAX_VALUE = 4,
    kDefault = 0,
    kDeepSearch = 1,
    kCreateImage = 4
}
export declare const SideTypeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SideType {
    MIN_VALUE = 0,
    MAX_VALUE = 1,
    kDefaultPrimary = 0,
    kSecondary = 1
}
export declare const RenderTypeSpec: {
    $: mojo.internal.MojomType;
};
export declare enum RenderType {
    MIN_VALUE = 0,
    MAX_VALUE = 2,
    kDefaultVertical = 0,
    kHorizontal = 1,
    kGrid = 2
}
export declare const SelectionLineStateSpec: {
    $: mojo.internal.MojomType;
};
export declare enum SelectionLineState {
    MIN_VALUE = 1,
    MAX_VALUE = 4,
    kNormal = 1,
    kKeywordMode = 2,
    kFocusedButtonAction = 3,
    kFocusedButtonRemoveSuggestion = 4
}
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    setPage(page: PageRemote): void;
    onFocusChanged(focused: boolean): void;
    queryAutocomplete(input: mojoBase_mojom_String16, preventInlineAutocomplete: boolean): void;
    stopAutocomplete(clearResult: boolean): void;
    openAutocompleteMatch(line: number, url: url_mojom_Url, areMatchesShowing: boolean, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
    onNavigationLikely(line: number, url: url_mojom_Url, navigationPredictor: omnibox_mojom_NavigationPredictor): void;
    deleteAutocompleteMatch(line: number, url: url_mojom_Url): void;
    activateKeyword(line: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, isMouseEvent: boolean): void;
    showContextMenu(point: gfx_mojom_Point): void;
    executeAction(line: number, actionIndex: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
    onThumbnailRemoved(): void;
    getPlaceholderConfig(): Promise<{
        config: PlaceholderConfig;
    }>;
    getRecentTabs(): Promise<{
        tabs: TabInfo[];
    }>;
    getTabPreview(tabId: number): Promise<{
        previewDataUrl: (string | null);
    }>;
    notifySessionStarted(): void;
    notifySessionAbandoned(): void;
    addFileContext(fileInfo: SelectedFileInfo, fileBytes: mojoBase_mojom_BigBuffer): Promise<{
        token: mojoBase_mojom_UnguessableToken;
    }>;
    addTabContext(tabId: number, delayUpload: boolean): Promise<{
        token: (mojoBase_mojom_UnguessableToken | null);
    }>;
    deleteContext(token: mojoBase_mojom_UnguessableToken): void;
    clearFiles(): void;
    submitQuery(queryText: string, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    setPage(page: PageRemote): void;
    onFocusChanged(focused: boolean): void;
    queryAutocomplete(input: mojoBase_mojom_String16, preventInlineAutocomplete: boolean): void;
    stopAutocomplete(clearResult: boolean): void;
    openAutocompleteMatch(line: number, url: url_mojom_Url, areMatchesShowing: boolean, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
    onNavigationLikely(line: number, url: url_mojom_Url, navigationPredictor: omnibox_mojom_NavigationPredictor): void;
    deleteAutocompleteMatch(line: number, url: url_mojom_Url): void;
    activateKeyword(line: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, isMouseEvent: boolean): void;
    showContextMenu(point: gfx_mojom_Point): void;
    executeAction(line: number, actionIndex: number, url: url_mojom_Url, matchSelectionTimestamp: mojoBase_mojom_TimeTicks, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
    onThumbnailRemoved(): void;
    getPlaceholderConfig(): Promise<{
        config: PlaceholderConfig;
    }>;
    getRecentTabs(): Promise<{
        tabs: TabInfo[];
    }>;
    getTabPreview(tabId: number): Promise<{
        previewDataUrl: (string | null);
    }>;
    notifySessionStarted(): void;
    notifySessionAbandoned(): void;
    addFileContext(fileInfo: SelectedFileInfo, fileBytes: mojoBase_mojom_BigBuffer): Promise<{
        token: mojoBase_mojom_UnguessableToken;
    }>;
    addTabContext(tabId: number, delayUpload: boolean): Promise<{
        token: (mojoBase_mojom_UnguessableToken | null);
    }>;
    deleteContext(token: mojoBase_mojom_UnguessableToken): void;
    clearFiles(): void;
    submitQuery(queryText: string, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onFocusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    queryAutocomplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    stopAutocomplete: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    openAutocompleteMatch: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onNavigationLikely: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    deleteAutocompleteMatch: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    activateKeyword: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    showContextMenu: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    executeAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onThumbnailRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getPlaceholderConfig: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getRecentTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTabPreview: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifySessionStarted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    notifySessionAbandoned: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    addFileContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    addTabContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    deleteContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    clearFiles: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    submitQuery: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
    autocompleteResultChanged(result: AutocompleteResult): void;
    updateSelection(oldSelection: OmniboxPopupSelection, selection: OmniboxPopupSelection): void;
    setKeywordSelected(isKeywordSelected: boolean): void;
    setInputText(input: string): void;
    setThumbnail(thumbnailUrl: string, isDeletable: boolean): void;
    onContextualInputStatusChanged(token: mojoBase_mojom_UnguessableToken, status: composeboxQuery_mojom_FileUploadStatus, errorType: (composeboxQuery_mojom_FileUploadErrorType | null)): void;
    onTabStripChanged(): void;
    addFileContext(token: mojoBase_mojom_UnguessableToken, fileInfo: SelectedFileInfo): void;
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
    autocompleteResultChanged(result: AutocompleteResult): void;
    updateSelection(oldSelection: OmniboxPopupSelection, selection: OmniboxPopupSelection): void;
    setKeywordSelected(isKeywordSelected: boolean): void;
    setInputText(input: string): void;
    setThumbnail(thumbnailUrl: string, isDeletable: boolean): void;
    onContextualInputStatusChanged(token: mojoBase_mojom_UnguessableToken, status: composeboxQuery_mojom_FileUploadStatus, errorType: (composeboxQuery_mojom_FileUploadErrorType | null)): void;
    onTabStripChanged(): void;
    addFileContext(token: mojoBase_mojom_UnguessableToken, fileInfo: SelectedFileInfo): void;
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    autocompleteResultChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    updateSelection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setKeywordSelected: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setInputText: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    setThumbnail: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onContextualInputStatusChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onTabStripChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    addFileContext: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const ACMatchClassificationSpec: {
    $: mojo.internal.MojomType;
};
export declare const ActionSpec: {
    $: mojo.internal.MojomType;
};
export declare const SuggestionAnswerSpec: {
    $: mojo.internal.MojomType;
};
export declare const AutocompleteMatchSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const FileAttachmentStubSpec: {
    $: mojo.internal.MojomType;
};
export declare const TabAttachmentStubSpec: {
    $: mojo.internal.MojomType;
};
export declare const SearchContextStubSpec: {
    $: mojo.internal.MojomType;
};
export declare const SelectedFileInfoSpec: {
    $: mojo.internal.MojomType;
};
export declare const SuggestionGroupSpec: {
    $: mojo.internal.MojomType;
};
export declare const AutocompleteResultSpec: {
    $: mojo.internal.MojomType;
};
export declare const OmniboxPopupSelectionSpec: {
    $: mojo.internal.MojomType;
};
export declare const PlaceholderConfigSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SetPage_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnFocusChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_QueryAutocomplete_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_StopAutocomplete_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OpenAutocompleteMatch_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnNavigationLikely_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_DeleteAutocompleteMatch_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ActivateKeyword_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ShowContextMenu_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ExecuteAction_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_OnThumbnailRemoved_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetPlaceholderConfig_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetPlaceholderConfig_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetRecentTabs_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetRecentTabs_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabPreview_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTabPreview_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_NotifySessionStarted_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_NotifySessionAbandoned_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_AddFileContext_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_AddFileContext_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_AddTabContext_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_AddTabContext_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_DeleteContext_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ClearFiles_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_SubmitQuery_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_AutocompleteResultChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_UpdateSelection_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetKeywordSelected_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetInputText_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_SetThumbnail_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnContextualInputStatusChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_OnTabStripChanged_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const Page_AddFileContext_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const SearchContextAttachmentStubSpec: {
    $: mojo.internal.MojomType;
};
export interface ACMatchClassificationMojoType {
    offset: number;
    style: number;
}
export type ACMatchClassification = ACMatchClassificationMojoType;
export interface ActionMojoType {
    hint: string;
    suggestionContents: string;
    iconPath: string;
    a11yLabel: string;
}
export type Action = ActionMojoType;
export interface SuggestionAnswerMojoType {
    firstLine: mojoBase_mojom_String16;
    secondLine: mojoBase_mojom_String16;
}
export type SuggestionAnswer = SuggestionAnswerMojoType;
export interface AutocompleteMatchMojoType {
    isHidden: boolean;
    allowedToBeDefaultMatch: boolean;
    isWeatherAnswerSuggestion: (boolean | null);
    isNoncannedAimSuggestion: boolean;
    isRichSuggestion: boolean;
    isSearchType: boolean;
    isEnterpriseSearchAggregatorPeopleType: boolean;
    swapContentsAndDescription: boolean;
    supportsDeletion: boolean;
    hasInstantKeyword: boolean;
    suggestionGroupId: number;
    a11yLabel: mojoBase_mojom_String16;
    actions: Action[];
    answer: (SuggestionAnswer | null);
    contents: mojoBase_mojom_String16;
    contentsClass: ACMatchClassification[];
    description: mojoBase_mojom_String16;
    descriptionClass: ACMatchClassification[];
    destinationUrl: url_mojom_Url;
    inlineAutocompletion: mojoBase_mojom_String16;
    fillIntoEdit: mojoBase_mojom_String16;
    iconPath: string;
    iconUrl: url_mojom_Url;
    imageDominantColor: string;
    imageUrl: string;
    type: string;
    removeButtonA11yLabel: mojoBase_mojom_String16;
    tailSuggestCommonPrefix: (mojoBase_mojom_String16 | null);
    keywordChipHint: string;
    keywordChipA11y: string;
}
export type AutocompleteMatch = AutocompleteMatchMojoType;
export interface TabInfoMojoType {
    tabId: number;
    showInRecentTabChip: boolean;
    title: string;
    url: url_mojom_Url;
    lastActive: mojoBase_mojom_TimeTicks;
}
export type TabInfo = TabInfoMojoType;
export interface FileAttachmentStubMojoType {
    uuid: mojoBase_mojom_UnguessableToken;
    name: string;
    mimeType: string;
    imageDataUrl: (string | null);
}
export type FileAttachmentStub = FileAttachmentStubMojoType;
export interface TabAttachmentStubMojoType {
    tabId: number;
    title: string;
    url: url_mojom_Url;
}
export type TabAttachmentStub = TabAttachmentStubMojoType;
export interface SearchContextStubMojoType {
    input: string;
    attachments: SearchContextAttachmentStub[];
    toolMode: ToolMode;
}
export type SearchContextStub = SearchContextStubMojoType;
export interface SelectedFileInfoMojoType {
    fileName: string;
    mimeType: string;
    imageDataUrl: (string | null);
    isDeletable: boolean;
    selectionTime: mojoBase_mojom_JSTime;
}
export type SelectedFileInfo = SelectedFileInfoMojoType;
export interface SuggestionGroupMojoType {
    header: mojoBase_mojom_String16;
    renderType: RenderType;
    sideType: SideType;
}
export type SuggestionGroup = SuggestionGroupMojoType;
export interface AutocompleteResultMojoType {
    input: mojoBase_mojom_String16;
    suggestionGroupsMap: {
        [key: number]: SuggestionGroup;
    };
    matches: AutocompleteMatch[];
    smartComposeInlineHint: (mojoBase_mojom_String16 | null);
}
export type AutocompleteResult = AutocompleteResultMojoType;
export interface OmniboxPopupSelectionMojoType {
    line: number;
    actionIndex: number;
    state: SelectionLineState;
}
export type OmniboxPopupSelection = OmniboxPopupSelectionMojoType;
export interface PlaceholderConfigMojoType {
    texts: mojoBase_mojom_String16[];
    changeTextAnimationInterval: mojoBase_mojom_TimeDelta;
    fadeTextAnimationDuration: mojoBase_mojom_TimeDelta;
}
export type PlaceholderConfig = PlaceholderConfigMojoType;
export interface PageHandler_SetPage_ParamsMojoType {
    page: PageRemote;
}
export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
export interface PageHandler_OnFocusChanged_ParamsMojoType {
    focused: boolean;
}
export type PageHandler_OnFocusChanged_Params = PageHandler_OnFocusChanged_ParamsMojoType;
export interface PageHandler_QueryAutocomplete_ParamsMojoType {
    input: mojoBase_mojom_String16;
    preventInlineAutocomplete: boolean;
}
export type PageHandler_QueryAutocomplete_Params = PageHandler_QueryAutocomplete_ParamsMojoType;
export interface PageHandler_StopAutocomplete_ParamsMojoType {
    clearResult: boolean;
}
export type PageHandler_StopAutocomplete_Params = PageHandler_StopAutocomplete_ParamsMojoType;
export interface PageHandler_OpenAutocompleteMatch_ParamsMojoType {
    line: number;
    areMatchesShowing: boolean;
    altKey: boolean;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
    mouseButton: number;
    url: url_mojom_Url;
}
export type PageHandler_OpenAutocompleteMatch_Params = PageHandler_OpenAutocompleteMatch_ParamsMojoType;
export interface PageHandler_OnNavigationLikely_ParamsMojoType {
    line: number;
    navigationPredictor: omnibox_mojom_NavigationPredictor;
    url: url_mojom_Url;
}
export type PageHandler_OnNavigationLikely_Params = PageHandler_OnNavigationLikely_ParamsMojoType;
export interface PageHandler_DeleteAutocompleteMatch_ParamsMojoType {
    line: number;
    url: url_mojom_Url;
}
export type PageHandler_DeleteAutocompleteMatch_Params = PageHandler_DeleteAutocompleteMatch_ParamsMojoType;
export interface PageHandler_ActivateKeyword_ParamsMojoType {
    line: number;
    isMouseEvent: boolean;
    url: url_mojom_Url;
    matchSelectionTimestamp: mojoBase_mojom_TimeTicks;
}
export type PageHandler_ActivateKeyword_Params = PageHandler_ActivateKeyword_ParamsMojoType;
export interface PageHandler_ShowContextMenu_ParamsMojoType {
    point: gfx_mojom_Point;
}
export type PageHandler_ShowContextMenu_Params = PageHandler_ShowContextMenu_ParamsMojoType;
export interface PageHandler_ExecuteAction_ParamsMojoType {
    line: number;
    actionIndex: number;
    mouseButton: number;
    altKey: boolean;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
    url: url_mojom_Url;
    matchSelectionTimestamp: mojoBase_mojom_TimeTicks;
}
export type PageHandler_ExecuteAction_Params = PageHandler_ExecuteAction_ParamsMojoType;
export interface PageHandler_OnThumbnailRemoved_ParamsMojoType {
}
export type PageHandler_OnThumbnailRemoved_Params = PageHandler_OnThumbnailRemoved_ParamsMojoType;
export interface PageHandler_GetPlaceholderConfig_ParamsMojoType {
}
export type PageHandler_GetPlaceholderConfig_Params = PageHandler_GetPlaceholderConfig_ParamsMojoType;
export interface PageHandler_GetPlaceholderConfig_ResponseParamsMojoType {
    config: PlaceholderConfig;
}
export type PageHandler_GetPlaceholderConfig_ResponseParams = PageHandler_GetPlaceholderConfig_ResponseParamsMojoType;
export interface PageHandler_GetRecentTabs_ParamsMojoType {
}
export type PageHandler_GetRecentTabs_Params = PageHandler_GetRecentTabs_ParamsMojoType;
export interface PageHandler_GetRecentTabs_ResponseParamsMojoType {
    tabs: TabInfo[];
}
export type PageHandler_GetRecentTabs_ResponseParams = PageHandler_GetRecentTabs_ResponseParamsMojoType;
export interface PageHandler_GetTabPreview_ParamsMojoType {
    tabId: number;
}
export type PageHandler_GetTabPreview_Params = PageHandler_GetTabPreview_ParamsMojoType;
export interface PageHandler_GetTabPreview_ResponseParamsMojoType {
    previewDataUrl: (string | null);
}
export type PageHandler_GetTabPreview_ResponseParams = PageHandler_GetTabPreview_ResponseParamsMojoType;
export interface PageHandler_NotifySessionStarted_ParamsMojoType {
}
export type PageHandler_NotifySessionStarted_Params = PageHandler_NotifySessionStarted_ParamsMojoType;
export interface PageHandler_NotifySessionAbandoned_ParamsMojoType {
}
export type PageHandler_NotifySessionAbandoned_Params = PageHandler_NotifySessionAbandoned_ParamsMojoType;
export interface PageHandler_AddFileContext_ParamsMojoType {
    fileInfo: SelectedFileInfo;
    fileBytes: mojoBase_mojom_BigBuffer;
}
export type PageHandler_AddFileContext_Params = PageHandler_AddFileContext_ParamsMojoType;
export interface PageHandler_AddFileContext_ResponseParamsMojoType {
    token: mojoBase_mojom_UnguessableToken;
}
export type PageHandler_AddFileContext_ResponseParams = PageHandler_AddFileContext_ResponseParamsMojoType;
export interface PageHandler_AddTabContext_ParamsMojoType {
    tabId: number;
    delayUpload: boolean;
}
export type PageHandler_AddTabContext_Params = PageHandler_AddTabContext_ParamsMojoType;
export interface PageHandler_AddTabContext_ResponseParamsMojoType {
    token: (mojoBase_mojom_UnguessableToken | null);
}
export type PageHandler_AddTabContext_ResponseParams = PageHandler_AddTabContext_ResponseParamsMojoType;
export interface PageHandler_DeleteContext_ParamsMojoType {
    token: mojoBase_mojom_UnguessableToken;
}
export type PageHandler_DeleteContext_Params = PageHandler_DeleteContext_ParamsMojoType;
export interface PageHandler_ClearFiles_ParamsMojoType {
}
export type PageHandler_ClearFiles_Params = PageHandler_ClearFiles_ParamsMojoType;
export interface PageHandler_SubmitQuery_ParamsMojoType {
    queryText: string;
    mouseButton: number;
    altKey: boolean;
    ctrlKey: boolean;
    metaKey: boolean;
    shiftKey: boolean;
}
export type PageHandler_SubmitQuery_Params = PageHandler_SubmitQuery_ParamsMojoType;
export interface Page_AutocompleteResultChanged_ParamsMojoType {
    result: AutocompleteResult;
}
export type Page_AutocompleteResultChanged_Params = Page_AutocompleteResultChanged_ParamsMojoType;
export interface Page_UpdateSelection_ParamsMojoType {
    oldSelection: OmniboxPopupSelection;
    selection: OmniboxPopupSelection;
}
export type Page_UpdateSelection_Params = Page_UpdateSelection_ParamsMojoType;
export interface Page_SetKeywordSelected_ParamsMojoType {
    isKeywordSelected: boolean;
}
export type Page_SetKeywordSelected_Params = Page_SetKeywordSelected_ParamsMojoType;
export interface Page_SetInputText_ParamsMojoType {
    input: string;
}
export type Page_SetInputText_Params = Page_SetInputText_ParamsMojoType;
export interface Page_SetThumbnail_ParamsMojoType {
    thumbnailUrl: string;
    isDeletable: boolean;
}
export type Page_SetThumbnail_Params = Page_SetThumbnail_ParamsMojoType;
export interface Page_OnContextualInputStatusChanged_ParamsMojoType {
    token: mojoBase_mojom_UnguessableToken;
    status: composeboxQuery_mojom_FileUploadStatus;
    errorType: (composeboxQuery_mojom_FileUploadErrorType | null);
}
export type Page_OnContextualInputStatusChanged_Params = Page_OnContextualInputStatusChanged_ParamsMojoType;
export interface Page_OnTabStripChanged_ParamsMojoType {
}
export type Page_OnTabStripChanged_Params = Page_OnTabStripChanged_ParamsMojoType;
export interface Page_AddFileContext_ParamsMojoType {
    token: mojoBase_mojom_UnguessableToken;
    fileInfo: SelectedFileInfo;
}
export type Page_AddFileContext_Params = Page_AddFileContext_ParamsMojoType;
export interface SearchContextAttachmentStub {
    fileAttachment?: FileAttachmentStub;
    tabAttachment?: TabAttachmentStub;
}
export declare enum SearchContextAttachmentStubFieldTags {
    FILE_ATTACHMENT = 0,
    TAB_ATTACHMENT = 1
}
export declare function whichSearchContextAttachmentStub(u: SearchContextAttachmentStub): SearchContextAttachmentStubFieldTags;
