// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { SkColorSpec as skia_mojom_SkColorSpec } from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import { BrowserColorVariantSpec as ui_mojom_BrowserColorVariantSpec } from '//resources/mojo/ui/base/mojom/themes.mojom-webui.js';
export class ThemeColorPickerHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'theme_color_picker.mojom.ThemeColorPickerHandlerFactory', scope);
    }
}
export class ThemeColorPickerHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createThemeColorPickerHandler(handler, client) {
        this.proxy.sendMessage(0, ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$, null, [
            handler,
            client
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ThemeColorPickerHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$, null, impl.createThemeColorPickerHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ThemeColorPickerHandlerFactory {
    static get $interfaceName() {
        return "theme_color_picker.mojom.ThemeColorPickerHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeColorPickerHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeColorPickerHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createThemeColorPickerHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createThemeColorPickerHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$, null, this.createThemeColorPickerHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ThemeColorPickerHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'theme_color_picker.mojom.ThemeColorPickerHandler', scope);
    }
}
export class ThemeColorPickerHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getChromeColors(isDarkMode) {
        return this.proxy.sendMessage(0, ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$, ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$, [
            isDarkMode
        ], false);
    }
    updateTheme() {
        this.proxy.sendMessage(1, ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$, null, [], false);
    }
    setDefaultColor() {
        this.proxy.sendMessage(2, ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$, null, [], false);
    }
    setGreyDefaultColor() {
        this.proxy.sendMessage(3, ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$, null, [], false);
    }
    setSeedColor(seedColor, variant) {
        this.proxy.sendMessage(4, ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$, null, [
            seedColor,
            variant
        ], false);
    }
    setSeedColorFromHue(hue) {
        this.proxy.sendMessage(5, ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$, null, [
            hue
        ], false);
    }
    removeBackgroundImage() {
        this.proxy.sendMessage(6, ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the ThemeColorPickerHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$, ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$, impl.getChromeColors.bind(impl), false);
        this.helper_internal_.registerHandler(1, ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$, null, impl.updateTheme.bind(impl), false);
        this.helper_internal_.registerHandler(2, ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$, null, impl.setDefaultColor.bind(impl), false);
        this.helper_internal_.registerHandler(3, ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$, null, impl.setGreyDefaultColor.bind(impl), false);
        this.helper_internal_.registerHandler(4, ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$, null, impl.setSeedColor.bind(impl), false);
        this.helper_internal_.registerHandler(5, ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$, null, impl.setSeedColorFromHue.bind(impl), false);
        this.helper_internal_.registerHandler(6, ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$, null, impl.removeBackgroundImage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ThemeColorPickerHandler {
    static get $interfaceName() {
        return "theme_color_picker.mojom.ThemeColorPickerHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeColorPickerHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeColorPickerHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getChromeColors;
    updateTheme;
    setDefaultColor;
    setGreyDefaultColor;
    setSeedColor;
    setSeedColorFromHue;
    removeBackgroundImage;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getChromeColors =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$, ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$, this.getChromeColors.createReceiverHandler(true /* expectsResponse */), false);
        this.updateTheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$, null, this.updateTheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setDefaultColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$, null, this.setDefaultColor.createReceiverHandler(false /* expectsResponse */), false);
        this.setGreyDefaultColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$, null, this.setGreyDefaultColor.createReceiverHandler(false /* expectsResponse */), false);
        this.setSeedColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$, null, this.setSeedColor.createReceiverHandler(false /* expectsResponse */), false);
        this.setSeedColorFromHue =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$, null, this.setSeedColorFromHue.createReceiverHandler(false /* expectsResponse */), false);
        this.removeBackgroundImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$, null, this.removeBackgroundImage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ThemeColorPickerClientPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'theme_color_picker.mojom.ThemeColorPickerClient', scope);
    }
}
export class ThemeColorPickerClientRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setTheme(theme) {
        this.proxy.sendMessage(0, ThemeColorPickerClient_SetTheme_ParamsSpec.$, null, [
            theme
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ThemeColorPickerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeColorPickerClientReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerClient_SetTheme_ParamsSpec.$, null, impl.setTheme.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ThemeColorPickerClient {
    static get $interfaceName() {
        return "theme_color_picker.mojom.ThemeColorPickerClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeColorPickerClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeColorPickerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeColorPickerClientCallbackRouter {
    helper_internal_;
    $;
    router_;
    setTheme;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setTheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeColorPickerClient_SetTheme_ParamsSpec.$, null, this.setTheme.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ThemeSpec = { $: {} };
export const ChromeColorSpec = { $: {} };
export const ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_GetChromeColors_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec = { $: {} };
export const ThemeColorPickerHandler_UpdateTheme_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_SetDefaultColor_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_SetSeedColor_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec = { $: {} };
export const ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec = { $: {} };
export const ThemeColorPickerClient_SetTheme_ParamsSpec = { $: {} };
mojo.internal.Struct(ThemeSpec.$, 'Theme', [
    mojo.internal.StructField('hasBackgroundImage', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('hasThirdPartyTheme', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundImageMainColor', 8, 0, skia_mojom_SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDarkMode', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seedColor', 16, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seedColorHue', 4, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backgroundColor', 24, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('foregroundColor', 32, 0, skia_mojom_SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorPickerIconColor', 40, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('colorsManagedByPolicy', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isGreyBaseline', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('browserColorVariant', 48, 0, ui_mojom_BrowserColorVariantSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('followDeviceTheme', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(ChromeColorSpec.$, 'ChromeColor', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 8, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('background', 16, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('foreground', 24, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('base', 32, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('variant', 40, 0, ui_mojom_BrowserColorVariantSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$, 'ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(ThemeColorPickerHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('client', 4, 0, mojo.internal.InterfaceProxy(ThemeColorPickerClientRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$, 'ThemeColorPickerHandler_GetChromeColors_Params', [
    mojo.internal.StructField('isDarkMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$, 'ThemeColorPickerHandler_GetChromeColors_ResponseParams', [
    mojo.internal.StructField('colors', 0, 0, mojo.internal.Array(ChromeColorSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$, 'ThemeColorPickerHandler_UpdateTheme_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$, 'ThemeColorPickerHandler_SetDefaultColor_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$, 'ThemeColorPickerHandler_SetGreyDefaultColor_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$, 'ThemeColorPickerHandler_SetSeedColor_Params', [
    mojo.internal.StructField('seedColor', 0, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('variant', 8, 0, ui_mojom_BrowserColorVariantSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$, 'ThemeColorPickerHandler_SetSeedColorFromHue_Params', [
    mojo.internal.StructField('hue', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$, 'ThemeColorPickerHandler_RemoveBackgroundImage_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeColorPickerClient_SetTheme_ParamsSpec.$, 'ThemeColorPickerClient_SetTheme_Params', [
    mojo.internal.StructField('theme', 0, 0, ThemeSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
