import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
export declare const blurredRectUrl = "//resources/images/eclipse_wave_blurred_rect.png";
export interface AudioWaveElement {
    $: {
        'eclipse-svg-wrapper': HTMLElement;
        'mask': SVGMaskElement;
        'thin-path': SVGPathElement;
        'lower-glow-path': SVGPathElement;
        'clip-path-shape': SVGPathElement;
    };
}
/**
 * Voice input visualizer.
 */
export declare class AudioWaveElement extends CrLitElement {
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        isListening: {
            reflect: boolean;
            type: BooleanConstructor;
        };
        isExpanding_: {
            reflect: boolean;
            type: BooleanConstructor;
        };
    };
    accessor isListening: boolean;
    protected accessor isExpanding_: boolean;
    private eclipseSvgWrapperEl?;
    private maskEl?;
    private thinPathEl?;
    private lowerGlowPathEl?;
    private clipPathEl?;
    private containerWidth;
    private animationFrameId;
    private decayingAmplitude;
    private frame;
    private lastUpdateTime;
    firstUpdated(): void;
    updated(changedProperties: PropertyValues<this>): void;
    disconnectedCallback(): void;
    protected onStartListen(): void;
    protected onStopListen(): void;
    private processFrame;
    protected drawEclipseWavePath(rawInputLevel: number, startRamp: number): void;
    protected shouldUseSimulatedAudio(): boolean;
}
declare global {
    interface HTMLElementTagNameMap {
        'audio-wave': AudioWaveElement;
    }
}
