// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { PageCallbackRouter, PageHandler } from './history_embeddings.mojom-webui.js';
export class HistoryEmbeddingsBrowserProxyImpl {
    static instance = null;
    handler;
    callbackRouter;
    constructor(handler, callbackRouter) {
        this.handler = handler;
        this.callbackRouter = callbackRouter || new PageCallbackRouter();
    }
    static getInstance() {
        if (HistoryEmbeddingsBrowserProxyImpl.instance) {
            return HistoryEmbeddingsBrowserProxyImpl.instance;
        }
        const handler = PageHandler.getRemote();
        const callbackRouter = new PageCallbackRouter();
        handler.setPage(callbackRouter.$.bindNewPipeAndPassRemote());
        HistoryEmbeddingsBrowserProxyImpl.instance =
            new HistoryEmbeddingsBrowserProxyImpl(handler, callbackRouter);
        return HistoryEmbeddingsBrowserProxyImpl.instance;
    }
    static setInstance(newInstance) {
        HistoryEmbeddingsBrowserProxyImpl.instance = newInstance;
    }
    search(query) {
        this.handler.search(query);
    }
    sendQualityLog(selectedIndices, numCharsForQuery) {
        return this.handler.sendQualityLog(selectedIndices, numCharsForQuery);
    }
    recordSearchResultsMetrics(nonEmptyResults, userClickedResult, answerShown, answerCitationClicked, otherHistoryResultClicked, queryWordCount) {
        this.handler.recordSearchResultsMetrics(nonEmptyResults, userClickedResult, answerShown, answerCitationClicked, otherHistoryResultClicked, queryWordCount);
    }
    setUserFeedback(userFeedback) {
        this.handler.setUserFeedback(userFeedback);
    }
    maybeShowFeaturePromo() {
        this.handler.maybeShowFeaturePromo();
    }
    openSettingsPage() {
        this.handler.openSettingsPage();
    }
}
