import type { Uuid } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
import type { ProductInfo, ProductSpecificationsSet } from './shared.mojom-webui.js';
import type { PriceInsightsInfo, ProductSpecifications, ProductSpecificationsFeatureState, UrlInfo, UserFeedback } from './shopping_service.mojom-webui.js';
import { ShoppingServiceHandlerRemote } from './shopping_service.mojom-webui.js';
export interface ShoppingServiceBrowserProxy {
    getProductInfoForCurrentUrl(): Promise<{
        productInfo: ProductInfo;
    }>;
    getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    isShoppingListEligible(): Promise<{
        eligible: boolean;
    }>;
    getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean;
    }>;
    openUrlInNewTab(url: Url): void;
    switchToOrOpenTab(url: Url): void;
    getPriceInsightsInfoForUrl(url: Url): Promise<{
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getProductInfoForUrl(url: Url): Promise<{
        productInfo: ProductInfo;
    }>;
    getProductInfoForUrls(urls: Url[]): Promise<{
        productInfos: ProductInfo[];
    }>;
    getProductSpecificationsForUrls(urls: Url[]): Promise<{
        productSpecs: ProductSpecifications;
    }>;
    getAllProductSpecificationsSets(): Promise<{
        sets: ProductSpecificationsSet[];
    }>;
    getProductSpecificationsSetByUuid(uuid: Uuid): Promise<{
        set: ProductSpecificationsSet | null;
    }>;
    addProductSpecificationsSet(name: string, urls: Url[]): Promise<{
        createdSet: ProductSpecificationsSet | null;
    }>;
    deleteProductSpecificationsSet(uuid: Uuid): void;
    setNameForProductSpecificationsSet(uuid: Uuid, name: string): Promise<{
        updatedSet: ProductSpecificationsSet | null;
    }>;
    setUrlsForProductSpecificationsSet(uuid: Uuid, urls: Url[]): Promise<{
        updatedSet: ProductSpecificationsSet | null;
    }>;
    setProductSpecificationsUserFeedback(feedback: UserFeedback): void;
    getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState | null;
    }>;
}
export declare class ShoppingServiceBrowserProxyImpl implements ShoppingServiceBrowserProxy {
    handler: ShoppingServiceHandlerRemote;
    constructor();
    getProductInfoForCurrentUrl(): Promise<{
        productInfo: ProductInfo;
    }>;
    getProductInfoForUrl(url: Url): Promise<{
        url: Url;
        productInfo: ProductInfo;
    }>;
    getProductInfoForUrls(urls: Url[]): Promise<{
        productInfos: ProductInfo[];
    }>;
    getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getPriceInsightsInfoForUrl(url: Url): Promise<{
        url: Url;
        priceInsightsInfo: PriceInsightsInfo;
    }>;
    getProductSpecificationsForUrls(urls: Url[]): Promise<{
        productSpecs: ProductSpecifications;
    }>;
    getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[];
    }>;
    isShoppingListEligible(): Promise<{
        eligible: boolean;
    }>;
    getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean;
    }>;
    openUrlInNewTab(url: Url): void;
    switchToOrOpenTab(url: Url): void;
    getAllProductSpecificationsSets(): Promise<{
        sets: ProductSpecificationsSet[];
    }>;
    getProductSpecificationsSetByUuid(uuid: Uuid): Promise<{
        set: (ProductSpecificationsSet | null);
    }>;
    addProductSpecificationsSet(name: string, urls: Url[]): Promise<{
        createdSet: (ProductSpecificationsSet | null);
    }>;
    deleteProductSpecificationsSet(uuid: Uuid): void;
    setNameForProductSpecificationsSet(uuid: Uuid, name: string): Promise<{
        updatedSet: (ProductSpecificationsSet | null);
    }>;
    setUrlsForProductSpecificationsSet(uuid: Uuid, urls: Url[]): Promise<{
        updatedSet: (ProductSpecificationsSet | null);
    }>;
    setProductSpecificationsUserFeedback(feedback: UserFeedback): void;
    getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState;
    }>;
    static getInstance(): ShoppingServiceBrowserProxy;
    static setInstance(obj: ShoppingServiceBrowserProxy): void;
}
